//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: paranoid
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of products that can be stored in the inventory
#define MAX_PRODUCTS 100

// Define the structure for a product
typedef struct {
    char name[50];
    int quantity;
    float price;
} Product;

// Function to add a product to the inventory
void addProduct(Product* inventory, int size, char* name, int quantity, float price) {
    // Check if there is space in the inventory
    if (size >= MAX_PRODUCTS) {
        printf("Error: Inventory is full.\n");
        return;
    }

    // Add the product to the inventory
    strcpy(inventory[size].name, name);
    inventory[size].quantity = quantity;
    inventory[size].price = price;

    // Increment the size of the inventory
    size++;
}

// Function to remove a product from the inventory
void removeProduct(Product* inventory, int size, char* name) {
    // Search for the product in the inventory
    int i;
    for (i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            // Remove the product from the inventory
            inventory[i] = inventory[size - 1];

            // Decrement the size of the inventory
            size--;

            // Move all products after the removed product one position to the left
            for (int j = i; j < size; j++) {
                inventory[j] = inventory[j + 1];
            }

            // Return true to indicate that the product was found and removed
            return;
        }
    }

    // Return false to indicate that the product was not found
    return;
}

// Function to update the quantity of a product in the inventory
void updateProductQuantity(Product* inventory, int size, char* name, int quantity) {
    // Search for the product in the inventory
    int i;
    for (i = 0; i < size; i++) {
        if (strcmp(inventory[i].name, name) == 0) {
            // Update the quantity of the product
            inventory[i].quantity = quantity;

            // Return true to indicate that the product was found and updated
            return;
        }
    }

    // Return false to indicate that the product was not found
    return;
}

// Function to display the inventory
void displayInventory(Product* inventory, int size) {
    // Loop through the inventory and display each product
    printf("Inventory:\n");
    for (int i = 0; i < size; i++) {
        printf("%s - %d units - $%.2f\n", inventory[i].name, inventory[i].quantity, inventory[i].price);
    }
}

int main() {
    // Initialize the inventory with some products
    Product inventory[MAX_PRODUCTS];
    int size = 0;
    addProduct(inventory, size, "Apple", 10, 1.00);
    addProduct(inventory, size, "Banana", 20, 0.50);
    addProduct(inventory, size, "Cherry", 5, 2.00);

    // Display the initial inventory
    displayInventory(inventory, size);

    // Remove a product from the inventory
    removeProduct(inventory, size, "Banana");

    // Display the updated inventory
    displayInventory(inventory, size);

    // Update the quantity of a product in the inventory
    updateProductQuantity(inventory, size, "Apple", 5);

    // Display the updated inventory
    displayInventory(inventory, size);

    return 0;
}