//Falcon-180B DATASET v1.0 Category: Internet Speed Test Application ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <curl/curl.h>
#include <string.h>

#define SPEEDTEST_SERVER "speedtest.net"
#define SPEEDTEST_PORT 80
#define SPEEDTEST_PATH "/speedtest.php"

typedef struct speedtest_result {
    double download_speed;
    double upload_speed;
    double ping;
} speedtest_result_t;

size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
    ((char*)userp)[size * nmemb] = '\0';
    return size * nmemb;
}

speedtest_result_t SpeedTest(const char* server, int port)
{
    CURL *curl;
    CURLcode res;
    char readBuffer[1024];
    speedtest_result_t result;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if(curl) {
        sprintf(readBuffer, "http://%s:%d%s", server, port, SPEEDTEST_PATH);
        curl_easy_setopt(curl, CURLOPT_URL, readBuffer);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_WRITEDATA, &result.download_speed);
        res = curl_easy_perform(curl);

        if(res!= CURLE_OK)
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();

    return result;
}

void main()
{
    speedtest_result_t result = SpeedTest(SPEEDTEST_SERVER, SPEEDTEST_PORT);

    printf("Download Speed: %.2f Mbps\n", result.download_speed / (1024 * 1024));
    printf("Upload Speed: %.2f Mbps\n", result.upload_speed / (1024 * 1024));
    printf("Ping: %.2f ms\n", result.ping);
}