//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LENGTH 50
#define MAX_DESCRIPTION_LENGTH 100
#define MAX_QUANTITY 1000

typedef struct {
    char name[MAX_NAME_LENGTH];
    char description[MAX_DESCRIPTION_LENGTH];
    int quantity;
} Product;

Product products[MAX_PRODUCTS];
int num_products = 0;

void add_product(Product* product) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Maximum number of products reached.\n");
        return;
    }
    memcpy(&products[num_products], product, sizeof(Product));
    num_products++;
}

void remove_product(int index) {
    if (index < 0 || index >= num_products) {
        printf("Error: Invalid product index.\n");
        return;
    }
    num_products--;
    memmove(&products[index], &products[index+1], sizeof(Product)*(num_products-index));
}

void update_product(int index, Product* product) {
    if (index < 0 || index >= num_products) {
        printf("Error: Invalid product index.\n");
        return;
    }
    memcpy(&products[index], product, sizeof(Product));
}

void print_products() {
    for (int i = 0; i < num_products; i++) {
        printf("Product %d:\n", i);
        printf("Name: %s\n", products[i].name);
        printf("Description: %s\n", products[i].description);
        printf("Quantity: %d\n\n", products[i].quantity);
    }
}

int main() {
    add_product(&(Product){.name="Apple",.description="Red and juicy",.quantity=100});
    add_product(&(Product){.name="Banana",.description="Yellow and sweet",.quantity=50});
    add_product(&(Product){.name="Orange",.description="Orange and tangy",.quantity=25});
    print_products();

    remove_product(1);
    print_products();

    update_product(0, &(Product){.name="Granny Smith Apple",.description="Green and sour",.quantity=75});
    print_products();

    return 0;
}