//GPT-4o-mini DATASET v1.0 Category: Performance-Critical Component ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#define NUM_SPOONS 10
#define NUM_CHICKENS 5
#define NUM_DREAMS 15

typedef struct {
    int id;
    char *color;
} Spoon;

typedef struct {
    int id;
    char *mood;
} Chicken;

typedef struct {
    int id;
    char *vision;
} Dream;

void initialize_spoons(Spoon *spoons) {
    const char *colors[] = {"red", "blue", "green", "yellow", "purple", 
                             "orange", "cyan", "magenta", "black", "white"};
    for (int i = 0; i < NUM_SPOONS; i++) {
        spoons[i].id = i + 1;
        spoons[i].color = (char *)colors[rand() % 10];
    }
}

void initialize_chickens(Chicken *chickens) {
    const char *moods[] = {"happy", "sad", "angry", "curious", "dreamy"};
    for (int i = 0; i < NUM_CHICKENS; i++) {
        chickens[i].id = i + 1;
        chickens[i].mood = (char *)moods[rand() % 5];
    }
}

void initialize_dreams(Dream *dreams) {
    const char *visions[] = {"flying on rainbows", "swimming in clouds", "dancing with shadows", 
                             "conversing with colors", "singing with silence",
                             "eating the sun", "exploring the mind's corners", 
                             "racing with whispers", "painting with time", 
                             "hugging the void", "kissing the unknown", 
                             "laughing with stars", "crying in reverse", 
                             "running through dreams", "sleeping awake",  
                             "floating through the air"};
    for (int i = 0; i < NUM_DREAMS; i++) {
        dreams[i].id = i + 1;
        dreams[i].vision = (char *)visions[rand() % 15];
    }
}

void showcase(Spoon *spoons, Chicken *chickens, Dream *dreams) {
    printf("In a world where dreams blend with reality...\n\n");
    
    for (int i = 0; i < NUM_SPOONS; i++) {
        printf("A %s spoon with id %d stirs the silence.\n", spoons[i].color, spoons[i].id);
        usleep(500000); // sleep for half a second
    }
    
    printf("\nChickens roam freely, their moods coloring the panorama...\n\n");
    for (int i = 0; i < NUM_CHICKENS; i++) {
        printf("A chicken of mood '%s' clucks gently at the wind.\n", chickens[i].mood);
        usleep(500000); // sleep for half a second
    }
    
    printf("\nVisions that dance in the corners of our minds...\n\n");
    for (int i = 0; i < NUM_DREAMS; i++) {
        printf("A dream of id %d whispers: '%s'.\n", dreams[i].id, dreams[i].vision);
        usleep(500000); // sleep for half a second
    }

    printf("\nAnd as the spoon spins, the chicken leaps into the void!\n");
}

int main() {
    srand(time(NULL));
    
    Spoon spoons[NUM_SPOONS];
    Chicken chickens[NUM_CHICKENS];
    Dream dreams[NUM_DREAMS];
    
    initialize_spoons(spoons);
    initialize_chickens(chickens);
    initialize_dreams(dreams);
    
    showcase(spoons, chickens, dreams);

    return 0;
}