//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        return EXIT_FAILURE;
    }

    // Bind the socket to an address
    struct sockaddr_in addr;
    memset(&addr, 0, sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(8080);
    if (bind(sockfd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
        perror("bind");
        return EXIT_FAILURE;
    }

    // Listen for connections
    if (listen(sockfd, 5) == -1) {
        perror("listen");
        return EXIT_FAILURE;
    }

    // Accept a connection
    int clientfd = accept(sockfd, NULL, NULL);
    if (clientfd == -1) {
        perror("accept");
        return EXIT_FAILURE;
    }

    // Read from the client
    char buffer[1024];
    int nbytes = read(clientfd, buffer, sizeof(buffer));
    if (nbytes == -1) {
        perror("read");
        return EXIT_FAILURE;
    }

    // Write to the client
    char *response = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\n\r\nHello, world!\n";
    if (write(clientfd, response, strlen(response)) == -1) {
        perror("write");
        return EXIT_FAILURE;
    }

    // Close the client connection
    close(clientfd);

    // Close the socket
    close(sockfd);

    return EXIT_SUCCESS;
}