//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: enthusiastic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Constants
#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Data structures
typedef struct {
    char name[50];
    int votes;
} Candidate;

typedef struct {
    int id;
    char name[50];
    int voted;
} Voter;

// Global variables
Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];
int num_candidates = 0;
int num_voters = 0;

// Function declarations
void add_candidate(char *name);
void add_voter(int id, char *name);
void vote(int voter_id, int candidate_id);
void print_results();

// Main function
int main() {
    // Add candidates
    add_candidate("John Doe");
    add_candidate("Jane Smith");
    add_candidate("Bob Jones");

    // Add voters
    add_voter(1, "Alice");
    add_voter(2, "Bob");
    add_voter(3, "Carol");

    // Vote
    vote(1, 1);
    vote(2, 2);
    vote(3, 3);

    // Print results
    print_results();

    return 0;
}

// Function definitions
void add_candidate(char *name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(int id, char *name) {
    voters[num_voters].id = id;
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voted = 0;
    num_voters++;
}

void vote(int voter_id, int candidate_id) {
    if (voter_id <= 0 || voter_id > num_voters) {
        printf("Invalid voter ID.\n");
        return;
    }

    if (candidate_id <= 0 || candidate_id > num_candidates) {
        printf("Invalid candidate ID.\n");
        return;
    }

    if (voters[voter_id - 1].voted) {
        printf("Voter has already voted.\n");
        return;
    }

    candidates[candidate_id - 1].votes++;
    voters[voter_id - 1].voted = 1;
}

void print_results() {
    printf("Election results:\n");

    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}