//GEMINI-pro DATASET v1.0 Category: Digital Auction System ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_BIDS 10
#define MAX_BID_PRICE 1000000

typedef struct {
  int id;
  char *name;
  char *description;
  int starting_price;
} item_t;

typedef struct {
  int id;
  char *bidder_name;
  int bid_price;
} bid_t;

item_t items[MAX_ITEMS];
bid_t bids[MAX_BIDS];

int num_items = 0;
int num_bids = 0;

void add_item(item_t item) {
  items[num_items] = item;
  num_items++;
}

void add_bid(bid_t bid) {
  bids[num_bids] = bid;
  num_bids++;
}

void print_items() {
  for (int i = 0; i < num_items; i++) {
    printf("Item %d:\n", items[i].id);
    printf("  Name: %s\n", items[i].name);
    printf("  Description: %s\n", items[i].description);
    printf("  Starting price: %d\n", items[i].starting_price);
  }
}

void print_bids() {
  for (int i = 0; i < num_bids; i++) {
    printf("Bid %d:\n", bids[i].id);
    printf("  Bidder name: %s\n", bids[i].bidder_name);
    printf("  Bid price: %d\n", bids[i].bid_price);
  }
}

int main() {
  // Create a few items
  item_t item1 = {1, "Mona Lisa", "A famous painting by Leonardo da Vinci", 100000};
  item_t item2 = {2, "Starry Night", "A famous painting by Vincent van Gogh", 50000};
  item_t item3 = {3, "The Scream", "A famous painting by Edvard Munch", 20000};
  add_item(item1);
  add_item(item2);
  add_item(item3);

  // Create a few bids
  bid_t bid1 = {1, "John", 110000};
  bid_t bid2 = {2, "Mary", 55000};
  bid_t bid3 = {3, "Bob", 21000};
  add_bid(bid1);
  add_bid(bid2);
  add_bid(bid3);

  // Print the items and bids
  print_items();
  print_bids();

  return 0;
}