//GEMINI-pro DATASET v1.0 Category: Smart home light control ; Style: imaginative
// Welcome to the Enchanted Realm of Lights!

#include <stdio.h>
#include <stdlib.h>

// Our magical cast of characters
typedef struct {
    char* name;
    int brightness;
    int hue;
    int saturation;
} Light;

// The ethereal realm where our lights reside
#define NUM_LIGHTS 5
Light lights[NUM_LIGHTS] = {
    {"Celestial Candle", 50, 0, 0},
    {"Moonlit Lantern", 20, 120, 0},
    {"Aurora's Embrace", 100, 180, 255},
    {"Starry Night", 40, 300, 100},
    {"Rainbow's End", 70, 0, 255}
};

// The enchantments to control our lights
void illuminate(Light* l, int brightness) {
    l->brightness = brightness;
    printf("%s glows with intensity %d\n", l->name, brightness);
}

void colorize(Light* l, int hue, int saturation) {
    l->hue = hue;
    l->saturation = saturation;
    printf("%s takes on the ethereal hues of h:%d, s:%d\n", l->name, hue, saturation);
}

// The grand unveiling
int main() {
    printf("Behold, the Enchanted Realm of Lights!\n\n");

    // Summon the celestial candle
    Light* candle = &lights[0];
    illuminate(candle, 75);

    // Paint the moonlit lantern in ethereal hues
    Light* lantern = &lights[1];
    colorize(lantern, 150, 50);

    // Bathe the aurora in celestial splendor
    Light* aurora = &lights[2];
    illuminate(aurora, 100);
    colorize(aurora, 210, 255);

    // Sprinkle starlight across the night
    Light* stars = &lights[3];
    illuminate(stars, 60);
    colorize(stars, 340, 150);

    // Summon the rainbow's end
    Light* rainbow = &lights[4];
    illuminate(rainbow, 80);
    colorize(rainbow, 0, 255);

    // Bask in the enchanting illumination
    printf("\nThe realm now shimmers with a symphony of lights, enchanting the senses and inspiring wonder.\n");
    
    return 0;
}