//Falcon-180B DATASET v1.0 Category: Graph representation ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 1000
#define MAX_EDGES 10000

typedef struct {
    int id;
    char name[20];
} Node;

typedef struct {
    int id;
    int start;
    int end;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int num_nodes;
int num_edges;

void add_node(int id, char* name) {
    nodes[num_nodes].id = id;
    strcpy(nodes[num_nodes].name, name);
    num_nodes++;
}

void add_edge(int id, int start, int end, int weight) {
    edges[num_edges].id = id;
    edges[num_edges].start = start;
    edges[num_edges].end = end;
    edges[num_edges].weight = weight;
    num_edges++;
}

int find_node(char* name) {
    for (int i = 0; i < num_nodes; i++) {
        if (strcmp(nodes[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

void print_graph() {
    for (int i = 0; i < num_nodes; i++) {
        printf("Node %d: %s\n", nodes[i].id, nodes[i].name);
    }
    for (int i = 0; i < num_edges; i++) {
        printf("Edge %d: %d -> %d (weight: %d)\n", edges[i].id, edges[i].start, edges[i].end, edges[i].weight);
    }
}

int main() {
    add_node(1, "Alice");
    add_node(2, "Bob");
    add_node(3, "Charlie");
    add_node(4, "Dave");
    add_node(5, "Eve");
    add_edge(1, 1, 2, 10);
    add_edge(2, 2, 3, 20);
    add_edge(3, 3, 4, 30);
    add_edge(4, 4, 5, 40);
    add_edge(5, 5, 1, 50);
    print_graph();
    return 0;
}