//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Constants
#define NUM_DAYS 30
#define MIN_TEMP 0
#define MAX_TEMP 100
#define MIN_HUMIDITY 0
#define MAX_HUMIDITY 100
#define MIN_WIND_SPEED 0
#define MAX_WIND_SPEED 100
#define MIN_PRECIPITATION 0
#define MAX_PRECIPITATION 100

// Weather data structure
typedef struct {
  int day;
  int temperature;
  int humidity;
  int wind_speed;
  int precipitation;
} WeatherData;

// Function to generate random weather data
WeatherData generate_weather_data(int day) {
  WeatherData weather_data;

  // Set the day
  weather_data.day = day;

  // Generate random temperature
  weather_data.temperature = rand() % (MAX_TEMP - MIN_TEMP + 1) + MIN_TEMP;

  // Generate random humidity
  weather_data.humidity = rand() % (MAX_HUMIDITY - MIN_HUMIDITY + 1) + MIN_HUMIDITY;

  // Generate random wind speed
  weather_data.wind_speed = rand() % (MAX_WIND_SPEED - MIN_WIND_SPEED + 1) + MIN_WIND_SPEED;

  // Generate random precipitation
  weather_data.precipitation = rand() % (MAX_PRECIPITATION - MIN_PRECIPITATION + 1) + MIN_PRECIPITATION;

  return weather_data;
}

// Function to print weather data
void print_weather_data(WeatherData weather_data) {
  printf("Day: %d\n", weather_data.day);
  printf("Temperature: %d\n", weather_data.temperature);
  printf("Humidity: %d\n", weather_data.humidity);
  printf("Wind speed: %d\n", weather_data.wind_speed);
  printf("Precipitation: %d\n\n", weather_data.precipitation);
}

// Main function
int main() {
  // Initialize random number generator
  srand(time(NULL));

  // Generate weather data for each day
  WeatherData weather_data[NUM_DAYS];
  for (int i = 0; i < NUM_DAYS; i++) {
    weather_data[i] = generate_weather_data(i + 1);
  }

  // Print weather data for each day
  for (int i = 0; i < NUM_DAYS; i++) {
    print_weather_data(weather_data[i]);
  }

  return 0;
}