//MISTRAL-7B DATASET v1.0 Category: Product Inventory System ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100

typedef struct {
    char name[50];
    int stock;
    float price;
} InventoryItem;

InventoryItem inventory[MAX_ITEMS];
int num_items = 0;

void add_item(const char* name, int stock, float price) {
    if (num_items >= MAX_ITEMS) {
        printf("Inventory is full.\n");
        return;
    }
    strcpy(inventory[num_items].name, name);
    inventory[num_items].stock = stock;
    inventory[num_items].price = price;
    num_items++;
}

void update_item(int index, int new_stock) {
    if (index < 0 || index >= num_items) {
        printf("Invalid index.\n");
        return;
    }
    inventory[index].stock = new_stock;
}

void display_inventory() {
    printf("\nCurrent Inventory:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%s: %d units, $%.2f each\n", inventory[i].name, inventory[i].stock, inventory[i].price);
    }
}

int main() {
    add_item("Apples", 50, 0.5);
    add_item("Bananas", 30, 0.6);
    add_item("Oranges", 20, 0.7);

    display_inventory();

    update_item(0, 75);

    display_inventory();

    return 0;
}