//GPT-4o-mini DATASET v1.0 Category: System boot optimizer ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Data structure to represent a service
typedef struct {
    char name[50];
    int priority;
    int is_active;
} Service;

// Function prototypes
void display_services(Service *services, int size);
void optimize_boot(Service *services, int size);
void load_default_services(Service *services);

int main() {
    // Initialize a list of services for boot optimization
    Service services[5] = {
        {"Network Service", 1, 1},
        {"File System", 2, 1},
        {"Graphics Driver", 3, 1},
        {"Logging Service", 1, 1},
        {"Background Update", 2, 0}
    };

    printf("System Boot Optimization Starting...\n");
    
    // Load the default services
    load_default_services(services);
    
    // Display current services
    printf("Current Services:\n");
    display_services(services, 5);
    
    // Optimize the boot process
    optimize_boot(services, 5);
    
    // Display optimized services
    printf("Optimized Services:\n");
    display_services(services, 5);

    printf("System Boot Optimization Completed!\n");
    return 0;
}

void load_default_services(Service *services) {
    // A simple initialization to preset the services
    for (int i = 0; i < 5; i++) {
        services[i].is_active = 1;
    }
}

void display_services(Service *services, int size) {
    printf("%-20s %-10s %-10s\n", "Service Name", "Priority", "Active");
    for (int i = 0; i < size; i++) {
        printf("%-20s %-10d %-10s\n", services[i].name, services[i].priority,
               services[i].is_active ? "Yes" : "No");
    }
}

void optimize_boot(Service *services, int size) {
    // Apply a simple optimization: deactivate low-priority services
    for (int i = 0; i < size; i++) {
        if (services[i].priority > 2) {
            services[i].is_active = 0; // Deactivate based on priority
            printf("Deactivating service: %s (Priority %d)\n", services[i].name, services[i].priority);
        }
    }
}