//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <sys/socket.h>
#include <netdb.h>
#include <unistd.h>

#define MAX_FRAME_SIZE 65535
#define MAX_SNAPLEN 65535
#define MAX_PACKETS 1000

pcap_t *handle;
char errbuf[PCAP_ERRBUF_SIZE];
char *dev;

struct packet_data {
    u_char *packet;
    size_t size;
};

void packet_handler(u_char *user, const struct pcap_pkthdr *h, const u_char *sp) {
    struct packet_data *packet_data = (struct packet_data *) user;
    packet_data->size = h->caplen;
    packet_data->packet = malloc(h->caplen);
    memcpy(packet_data->packet, sp, h->caplen);
}

int open_pcap(char *interface) {
    dev = interface;
    handle = pcap_open_live(dev, MAX_SNAPLEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error opening %s: %s\n", dev, errbuf);
        exit(1);
    }
    pcap_set_snaplen(handle, MAX_SNAPLEN);
    pcap_set_promisc(handle, 0);
    pcap_set_timeout(handle, 1000);
    pcap_set_buffer_size(handle, MAX_PACKETS);
    return 0;
}

int capture_packets(void) {
    pcap_loop(handle, -1, packet_handler, NULL);
    return 0;
}

int main(int argc, char *argv[]) {
    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        exit(1);
    }
    open_pcap(argv[1]);
    capture_packets();
    pcap_close(handle);
    return 0;
}