//MISTRAL-7B DATASET v1.0 Category: Searching algorithm ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ARRAY_SIZE 10
#define TARGET_VALUE 5
#define ELEMENT_SIZE 20

typedef struct Element {
    int key;
    char data[ELEMENT_SIZE];
} Element;

Element array[ARRAY_SIZE];

int binarySearch(int* arr, int l, int r, int x) {
    while (l <= r) {
        int m = l + (r - l) / 2;

        // Check if x is present at mid
        if (arr[m] == x)
            return m;

        // If x greater, ignore left half
        if (arr[m] < x)
            l = m + 1;

        // If x is smaller, ignore right half
        else
            r = m - 1;
    }

    // if we reach here, then the element was not present
    return -1;
}

int linearSearchString(Element* arr, int size, char* target) {
    for (int i = 0; i < size; i++) {
        if (strcmp(arr[i].data, target) == 0) {
            return i;
        }
    }
    return -1;
}

int linearSearchInt(int* arr, int size, int target) {
    for (int i = 0; i < size; i++) {
        if (arr[i] == target) {
            return i;
        }
    }
    return -1;
}

int cSearch(Element* arr, int size, int key, char* data) {
    int index = -1;

    // Binary search for the key
    int binaryIndex = binarySearch((&arr[0].key), 0, size - 1, key);

    // If key is not found, return -1
    if (binaryIndex == -1) {
        return index;
    }

    // If key is found, perform linear search for the data
    index = linearSearchString(&arr[binaryIndex], 1, data);

    return index;
}

int main() {
    // Initialize the array
    for (int i = 0; i < ARRAY_SIZE; i++) {
        strcpy(array[i].data, "Data");
        array[i].key = i;
    }

    // Perform C search
    int result = cSearch(array, ARRAY_SIZE, TARGET_VALUE, "Target");

    if (result == -1) {
        printf("Target not found.\n");
    } else {
        printf("Target found at index %d.\n", result);
    }

    return 0;
}