//Falcon2-11B DATASET v1.0 Category: File Encyptor ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>

#define BUF_SIZE 4096

// Global variables
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
char buffer[BUF_SIZE];

// Thread function
void* encrypt_file(void* arg) {
    char* filename = (char*)arg;
    
    // Lock the mutex
    pthread_mutex_lock(&mutex);
    
    // Open the file in read mode
    FILE* file = fopen(filename, "r");
    
    // If file cannot be opened
    if (file == NULL) {
        fprintf(stderr, "Error: File '%s' cannot be opened.\n", filename);
        pthread_exit(NULL);
    }
    
    // Read file contents into buffer
    size_t bytes_read = fread(buffer, sizeof(char), BUF_SIZE, file);
    
    // Close the file
    fclose(file);
    
    // Unlock the mutex
    pthread_mutex_unlock(&mutex);
    
    // Encrypt the buffer
    for (int i = 0; i < bytes_read; i++) {
        buffer[i] = (buffer[i] ^ 0x1A) ^ 0x3B;
    }
    
    // Unlock the mutex
    pthread_mutex_unlock(&mutex);
    
    // Return the encrypted buffer
    return buffer;
}

// Main function
int main(int argc, char* argv[]) {
    // Check if file argument is provided
    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <filename>\n", argv[0]);
        return 1;
    }
    
    // Create a thread to encrypt the file
    pthread_t thread;
    pthread_create(&thread, NULL, encrypt_file, argv[1]);
    
    // Wait for the thread to finish
    pthread_join(thread, NULL);
    
    // Print the encrypted buffer
    printf("Encrypted file contents:\n");
    for (int i = 0; i < strlen(buffer); i++) {
        printf("%c", buffer[i]);
    }
    
    // Return 0
    return 0;
}