//MISTRAL-7B DATASET v1.0 Category: Word Frequency Counter ; Style: shocked
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAX_WORDS 10000
#define WORD_LENGTH 50

typedef struct Word {
    char str[WORD_LENGTH];
    int count;
} Word;

void toLowerCase(char *str) {
    for (int i = 0; str[i]; i++) {
        str[i] = tolower(str[i]);
    }
}

int isDelimiter(char c) {
    return (c == ' ' || c == '\n' || c == '\t');
}

int main() {
    Word words[MAX_WORDS];
    int numWords = 0;

    char line[1024];

    while (fgets(line, sizeof(line), stdin) != NULL) {
        toLowerCase(line);
        char *token = strtok(line, " \t\n");
        if (!token) continue;

        int found = 0;
        for (int i = 0; i < numWords; i++) {
            if (strcmp(token, words[i].str) == 0) {
                words[i].count++;
                found = 1;
                break;
            }
        }

        if (!found) {
            strncpy(words[numWords].str, token, WORD_LENGTH);
            words[numWords].count = 1;
            numWords++;
        }
    }

    printf("\nSHOCKED: YOUR INPUT HAS %d UNIQUE WORDS!\n\n", numWords);
    for (int i = 0; i < numWords; i++) {
        printf("%s: %d\n", words[i].str, words[i].count);
    }

    return 0;
}