//GEMINI-pro DATASET v1.0 Category: Drone Remote Control ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define DEFAULT_PORT 5556
#define DEFAULT_IP "192.168.1.1"
#define DEFAULT_DRONE_NAME "MyDrone"

int main(int argc, char *argv[]) {
    int opt;
    int sockfd;
    struct sockaddr_in servaddr;
    char drone_name[256];
    char command[256];

    // Parse command-line arguments
    while ((opt = getopt(argc, argv, "p:i:n:")) != -1) {
        switch (opt) {
            case 'p':
                servaddr.sin_port = htons(atoi(optarg));
                break;
            case 'i':
                strcpy(servaddr.sin_addr.s_addr, optarg);
                break;
            case 'n':
                strcpy(drone_name, optarg);
                break;
            default:
                fprintf(stderr, "Usage: %s [-p port] [-i ip] [-n drone_name]\n", argv[0]);
                exit(EXIT_FAILURE);
        }
    }

    // Create a socket
    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Set the server address
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(DEFAULT_PORT);
    if (inet_pton(AF_INET, DEFAULT_IP, &servaddr.sin_addr) <= 0) {
        perror("inet_pton");
        exit(EXIT_FAILURE);
    }

    // Set the drone name
    strcpy(command, "name ");
    strcat(command, drone_name);
    strcat(command, "\n");
    if (sendto(sockfd, command, strlen(command), 0, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("sendto");
        exit(EXIT_FAILURE);
    }

    // Main loop
    while (1) {
        // Get a command from the user
        printf("> ");
        fgets(command, sizeof(command), stdin);

        // Send the command to the drone
        if (sendto(sockfd, command, strlen(command), 0, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
            perror("sendto");
            exit(EXIT_FAILURE);
        }
    }

    // Close the socket
    close(sockfd);

    return 0;
}