//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>

int debug = 0;

size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    if (debug) {
        printf("%.*s\n", (int)size * nmemb, (char*)contents);
    }
    return size * nmemb;
}

void http_client(const char* url, const char* method, const char* headers, const char* data) {
    CURL* curl;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);
    curl = curl_easy_init();

    if (curl) {
        curl_easy_setopt(curl, CURLOPT_URL, url);
        curl_easy_setopt(curl, CURLOPT_CUSTOMREQUEST, method);
        curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);
        curl_easy_setopt(curl, CURLOPT_POSTFIELDS, data);
        curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
        curl_easy_setopt(curl, CURLOPT_VERBOSE, debug);

        res = curl_easy_perform(curl);

        if (res!= CURLE_OK)
            fprintf(stderr, "curl_easy_perform() failed: %s\n",
                    curl_easy_strerror(res));

        curl_easy_cleanup(curl);
    }

    curl_global_cleanup();
}

int main(int argc, char** argv) {
    if (argc < 4) {
        printf("Usage: %s [URL] [METHOD] [HEADERS]\n", argv[0]);
        return 1;
    }

    const char* url = argv[1];
    const char* method = argv[2];
    const char* headers = argv[3];

    http_client(url, method, headers, NULL);

    return 0;
}