//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: excited
// A unique C TCP/IP Programming example program

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define MAX_CLIENTS 5
#define BUF_SIZE 1024
#define PORT 8080

int main(int argc, char *argv[]) {
  int server_fd, client_fd;
  struct sockaddr_in server_addr, client_addr;
  socklen_t client_len = sizeof(client_addr);
  char buffer[BUF_SIZE];

  // Create a socket
  if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
    perror("socket failed");
    exit(EXIT_FAILURE);
  }

  // Set address and port
  server_addr.sin_family = AF_INET;
  server_addr.sin_addr.s_addr = INADDR_ANY;
  server_addr.sin_port = htons(PORT);

  // Bind the socket
  if (bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("bind failed");
    exit(EXIT_FAILURE);
  }

  // Listen for incoming connections
  if (listen(server_fd, MAX_CLIENTS) < 0) {
    perror("listen failed");
    exit(EXIT_FAILURE);
  }

  // Accept an incoming connection
  if ((client_fd = accept(server_fd, (struct sockaddr *)&client_addr, &client_len)) < 0) {
    perror("accept failed");
    exit(EXIT_FAILURE);
  }

  // Receive data from the client
  if (recv(client_fd, buffer, BUF_SIZE, 0) < 0) {
    perror("recv failed");
    exit(EXIT_FAILURE);
  }

  // Print the received data
  printf("Received data: %s\n", buffer);

  // Close the socket
  if (close(server_fd) < 0) {
    perror("close failed");
    exit(EXIT_FAILURE);
  }

  return 0;
}