//GEMINI-pro DATASET v1.0 Category: Educational ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#define NUMBER_OF_ELEMENTS(x) (sizeof(x) / sizeof(x[0]))

int main(void) {
  int bitmask = (1 << 5) | (1 << 7);

  // Check if bit 5 and bit 7 are set in bitmask
  if (bitmask & (1 << 5)) {
    printf("Bit 5 is set.\n");
  }

  if (bitmask & (1 << 7)) {
    printf("Bit 7 is set.\n");
  }

  // Unset bit 5 in bitmask
  bitmask &= ~(1 << 5);

  // Check if bit 5 is still set in bitmask
  if (bitmask & (1 << 5)) {
    printf("Bit 5 is still set.\n");
  } else {
    printf("Bit 5 is now unset.\n");
  }

  int array[] = {1, 2, 3, 4, 5};

  // Find the maximum element in the array using bit manipulation
  int max_element = 0;
  for (int i = 0; i < NUMBER_OF_ELEMENTS(array); i++) {
    if ((array[i] > max_element) && (array[i] & 1)) {
      max_element = array[i];
    }
  }

  printf("Maximum element in the array is: %d\n", max_element);

  // Find the sum of the even elements in the array using bit manipulation
  int sum_of_even_elements = 0;
  for (int i = 0; i < NUMBER_OF_ELEMENTS(array); i++) {
    if (!(array[i] & 1)) {
      sum_of_even_elements += array[i];
    }
  }

  printf("Sum of the even elements in the array is: %d\n", sum_of_even_elements);

  return 0;
}