//GPT-4o-mini DATASET v1.0 Category: Maze Route Finder ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>

#define N 5 // Size of the maze

// Function declarations
void printMaze(int maze[N][N]);
int solveMaze(int maze[N][N], int x, int y, int sol[N][N]);

// Function to check if x and y are valid indexes for N*N maze
int isSafe(int maze[N][N], int x, int y) {
    return (x >= 0 && x < N && y >= 0 && y < N && maze[x][y] == 1);
}

// Function to print the solution
void printSolution(int sol[N][N]) {
    printf("Solution to the Maze:\n");
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf(" %d ", sol[i][j]);
        }
        printf("\n");
    }
}

// Function to solve the maze using recursion
int solveMaze(int maze[N][N], int x, int y, int sol[N][N]) {
    // If (x,y) is the bottom-right corner, we have reached the goal
    if (x == N - 1 && y == N - 1) {
        sol[x][y] = 1;
        return 1;
    }

    // Check if maze[x][y] is valid
    if (isSafe(maze, x, y) == 1) {
        // Mark x,y as part of the solution path
        sol[x][y] = 1;

        // Move forward in x direction
        if (solveMaze(maze, x + 1, y, sol) == 1) {
            return 1;
        }

        // If moving in x direction doesn't give a solution then move down in y direction
        if (solveMaze(maze, x, y + 1, sol) == 1) {
            return 1;
        }

        // If none of the above movements work then BACKTRACK: unmark x,y as part of solution path
        sol[x][y] = 0;
        return 0;
    }

    return 0;
}

// Function to print the maze
void printMaze(int maze[N][N]) {
    printf("Maze:\n");
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            printf(" %d ", maze[i][j]);
        }
        printf("\n");
    }
}

int main() {
    int maze[N][N] = {
        { 1, 0, 0, 0, 0 },
        { 1, 1, 0, 1, 0 },
        { 0, 1, 0, 0, 0 },
        { 0, 1, 1, 1, 0 },
        { 0, 0, 0, 1, 1 }
    };

    int sol[N][N] = { { 0 } };

    printMaze(maze);

    if (solveMaze(maze, 0, 0, sol) == 0) {
        printf("No solution exists\n");
    } else {
        printSolution(sol);
    }

    return 0;
}