//Gemma-7B DATASET v1.0 Category: Tic Tac Toe AI ; Style: shocked
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3

int main()
{
    char board[BOARD_SIZE][BOARD_SIZE] = {{' ', ' ', ' '},
                                {' ', ' ', ' '},
                                {' ', ' ', ' '}};

    int player = 1;
    int move_count = 0;

    // Seed the random number generator
    srand(time(NULL));

    // Loop until the game is over
    while (!board[BOARD_SIZE - 1][BOARD_SIZE - 1] && move_count < 9)
    {
        // Get the move of the AI
        int move = rand() % 9;

        // If the move is valid, make it
        if (board[move / BOARD_SIZE][move % BOARD_SIZE] == ' ')
        {
            board[move / BOARD_SIZE][move % BOARD_SIZE] = 'O';
            move_count++;
        }
    }

    // Print the board
    for (int i = 0; i < BOARD_SIZE; i++)
    {
        for (int j = 0; j < BOARD_SIZE; j++)
        {
            printf("%c ", board[i][j]);
        }
        printf("\n");
    }

    // Check if the AI won or if it was a draw
    if (board[BOARD_SIZE - 1][BOARD_SIZE - 1] == 'O')
    {
        printf("The AI won!");
    }
    else if (move_count == 9)
    {
        printf("It's a draw!");
    }
    else
    {
        printf("The human won!");
    }

    return 0;
}