//GEMINI-pro DATASET v1.0 Category: Bingo Simulator ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Constants
#define NUM_ROWS 5
#define NUM_COLS 5
#define WINNING_NUMBERS 5

// Function prototypes
void print_grid(int grid[NUM_ROWS][NUM_COLS]);
int check_for_win(int grid[NUM_ROWS][NUM_COLS], int drawn_numbers[WINNING_NUMBERS]);
void draw_numbers(int drawn_numbers[WINNING_NUMBERS]);

// Main function
int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Declare the grid
    int grid[NUM_ROWS][NUM_COLS];

    // Fill the grid with random numbers
    for (int i = 0; i < NUM_ROWS; i++) {
        for (int j = 0; j < NUM_COLS; j++) {
            grid[i][j] = rand() % 100 + 1;
        }
    }

    // Print the grid
    print_grid(grid);

    // Draw the winning numbers
    int drawn_numbers[WINNING_NUMBERS];
    draw_numbers(drawn_numbers);

    // Check for a winner
    int winner = check_for_win(grid, drawn_numbers);

    // Print the result
    if (winner) {
        printf("You win!\n");
    } else {
        printf("You lose!\n");
    }

    return 0;
}

// Function to print the grid
void print_grid(int grid[NUM_ROWS][NUM_COLS]) {
    for (int i = 0; i < NUM_ROWS; i++) {
        for (int j = 0; j < NUM_COLS; j++) {
            printf("%d ", grid[i][j]);
        }
        printf("\n");
    }
}

// Function to check for a winner
int check_for_win(int grid[NUM_ROWS][NUM_COLS], int drawn_numbers[WINNING_NUMBERS]) {
    // Check each row
    for (int i = 0; i < NUM_ROWS; i++) {
        int count = 0;
        for (int j = 0; j < NUM_COLS; j++) {
            for (int k = 0; k < WINNING_NUMBERS; k++) {
                if (grid[i][j] == drawn_numbers[k]) {
                    count++;
                    break;
                }
            }
        }
        if (count == WINNING_NUMBERS) {
            return 1;
        }
    }

    // Check each column
    for (int j = 0; j < NUM_COLS; j++) {
        int count = 0;
        for (int i = 0; i < NUM_ROWS; i++) {
            for (int k = 0; k < WINNING_NUMBERS; k++) {
                if (grid[i][j] == drawn_numbers[k]) {
                    count++;
                    break;
                }
            }
        }
        if (count == WINNING_NUMBERS) {
            return 1;
        }
    }

    // Check each diagonal
    int count = 0;
    for (int i = 0; i < NUM_ROWS; i++) {
        for (int k = 0; k < WINNING_NUMBERS; k++) {
            if (grid[i][i] == drawn_numbers[k]) {
                count++;
                break;
            }
        }
    }
    if (count == WINNING_NUMBERS) {
        return 1;
    }

    count = 0;
    for (int i = 0; i < NUM_ROWS; i++) {
        for (int k = 0; k < WINNING_NUMBERS; k++) {
            if (grid[i][NUM_COLS - i - 1] == drawn_numbers[k]) {
                count++;
                break;
            }
        }
    }
    if (count == WINNING_NUMBERS) {
        return 1;
    }

    // No winner
    return 0;
}

// Function to draw the winning numbers
void draw_numbers(int drawn_numbers[WINNING_NUMBERS]) {
    for (int i = 0; i < WINNING_NUMBERS; i++) {
        drawn_numbers[i] = rand() % 100 + 1;
    }
}