//Code Llama-13B DATASET v1.0 Category: Medical Store Management System ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct Product {
  char name[50];
  int price;
};

struct Customer {
  char name[50];
  int balance;
  struct Product products[10];
};

struct Order {
  struct Product product;
  int quantity;
};

struct OrderHistory {
  struct Order order;
  int timestamp;
};

void printProduct(struct Product product) {
  printf("%s - $%d\n", product.name, product.price);
}

void printCustomer(struct Customer customer) {
  printf("Customer: %s\n", customer.name);
  printf("Balance: $%d\n", customer.balance);
  printf("Products:\n");
  for (int i = 0; i < 10; i++) {
    if (customer.products[i].name[0] != '\0') {
      printProduct(customer.products[i]);
    }
  }
}

void printOrder(struct Order order) {
  printf("Order: %s x %d\n", order.product.name, order.quantity);
}

void printOrderHistory(struct OrderHistory orderHistory) {
  printf("Order: %s\n", orderHistory.order.product.name);
  printf("Quantity: %d\n", orderHistory.order.quantity);
  printf("Time: %d\n", orderHistory.timestamp);
}

int main() {
  struct Customer customer1 = {"John", 1000, {{}, {}}};
  struct Product product1 = {"Pen", 10};
  struct Product product2 = {"Paper", 5};
  customer1.products[0] = product1;
  customer1.products[1] = product2;

  struct Order order1 = {product1, 2};
  struct Order order2 = {product2, 3};
  struct OrderHistory orderHistory1 = {order1, 1643232323};
  struct OrderHistory orderHistory2 = {order2, 1643232323};

  printCustomer(customer1);
  printOrder(order1);
  printOrder(order2);
  printOrderHistory(orderHistory1);
  printOrderHistory(orderHistory2);

  return 0;
}