//Falcon2-11B DATASET v1.0 Category: Game of Life ; Style: protected
// Game of Life example program
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main() {
    // Generate random initial state
    int board[8][8] = {
        {0, 1, 0, 0, 0, 0, 0, 0},
        {0, 1, 0, 0, 0, 0, 0, 0},
        {0, 1, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0},
        {0, 0, 0, 0, 0, 0, 0, 0}
    };

    // Initialize random seed for board generation
    srand(time(NULL));

    // Print initial state
    for (int i = 0; i < 8; i++) {
        for (int j = 0; j < 8; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }

    // Run Game of Life rules for a few generations
    for (int i = 0; i < 3; i++) {
        // Clear the board
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                board[i][j] = 0;
            }
        }

        // Apply Game of Life rules
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                int liveNeighbors = 0;

                // Count live neighbors
                if (i > 0 && board[i - 1][j] == 1) liveNeighbors++;
                if (i < 7 && board[i + 1][j] == 1) liveNeighbors++;
                if (j > 0 && board[i][j - 1] == 1) liveNeighbors++;
                if (j < 7 && board[i][j + 1] == 1) liveNeighbors++;

                if (board[i][j] == 1 && (liveNeighbors == 2 || liveNeighbors == 3)) {
                    board[i][j] = 1;
                } else if (board[i][j] == 1 && liveNeighbors < 2 || liveNeighbors > 3) {
                    board[i][j] = 0;
                }
            }
        }

        // Print current state
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < 8; j++) {
                printf("%d ", board[i][j]);
            }
            printf("\n");
        }
    }

    return 0;
}