void AllocateDataSet(cmsIT8* ly)
{
    TABLE* t = GetTable(ly);

    if (t -> Data) return;    // Already allocated

    t-> nSamples   = atoi(cmsIT8GetProperty(ly, "NUMBER_OF_FIELDS"));
    t-> nPatches   = atoi(cmsIT8GetProperty(ly, "NUMBER_OF_SETS"));

    if (t -> nSamples < 0 || t->nSamples > 0x7ffe || t->nPatches < 0 || t->nPatches > 0x7ffe)
    {
        SynError(ly, "AllocateDataSet: too much data");
    }
    else {
        t->Data = (char**)AllocChunk(ly, ((cmsUInt32Number)t->nSamples + 1) * ((cmsUInt32Number)t->nPatches + 1) * sizeof(char*));
        if (t->Data == NULL) {

            SynError(ly, "AllocateDataSet: Unable to allocate data array");
        }
    }

}