int blk_rq_map_user_iov(struct request_queue *gs, struct request *zs,
			struct rq_map_data *ka,
			const struct iov_iter *qu, gfp_t vv)
{
	bool copy = false;
	unsigned long align = gs->dma_pad_mask | queue_dma_alignment(gs);
	struct bio *bio = NULL;
	struct iov_iter i;
	int ret;

	if (!iter_is_iovec(qu))
		goto fail;

	if (ka)
		copy = true;
	else if (iov_iter_alignment(qu) & align)
		copy = true;
	else if (queue_virt_boundary(gs))
		copy = queue_virt_boundary(gs) & iov_iter_gap_alignment(qu);

	i = *qu;
	do {
		ret =__blk_rq_map_user_iov(zs, ka, &i, vv, copy);
		if (ret)
			goto unmap_rq;
		if (!bio)
			bio = zs->bio;
	} while (iov_iter_count(&i));

	if (!bio_flagged(bio, BIO_USER_MAPPED))
		rq->cmd_flags |= REQ_COPY_USER;
	return 0;

unmap_rq:
	__blk_rq_unmap_user(bio);
fail:
	rq->bio = NULL;
	return -EINVAL;
}