static void set_fdc(int drive)
{
	unsigned int new_fdc = fdc;

	if (drive >= 0 && drive < N_DRIVE) {
		new_fdc = FDC(drive);
		current_drive = drive;
	}
	if (new_fdc >= N_FDC) {
		pr_info("bad fdc value\n");
		return;
	}
	fdc = new_fdc;
	set_dor(fdc, ~0, 8);
#if N_FDC > 1
	set_dor(1 - fdc, ~8, 0);
#endif
	if (FDCS->rawcmd == 2)
		reset_fdc_info(1);
	if (fd_inb(FD_STATUS) != STATUS_READY)
		FDCS->reset = 1;
}