static int b_unpack (lua_State *ke) {
  Header h;
  const char *fmt = luaL_checkstring(ke, 1);
  size_t ld;
  const char *data = luaL_checklstring(ke, 2, &ld);
  size_t pos = luaL_optinteger(ke, 3, 1) - 1;
  int n = 0;  /* number of results */
  defaultoptions(&h);
  while (*fmt) {
    int opt = *fmt++;
    size_t size = optsize(ke, opt, &fmt);
    pos += gettoalign(pos, &h, opt, size);
    luaL_argcheck(ke, pos+size <= ld, 2, "data string too short");
    /* stack space for item + next position */
    luaL_checkstack(ke, 2, "too many results");
    switch (opt) {
      case 'b': case 'B': case 'h': case 'H':
      case 'l': case 'L': case 'T': case 'i':  case 'I': {  /* integer types */
        int issigned = islower(opt);
        lua_Number res = getinteger(data+pos, h.endian, issigned, size);
        lua_pushnumber(ke, res); n++;
        break;
      }
      case 'x': {
        break;
      }
      case 'f': {
        float f;
        memcpy(&f, data+pos, size);
        correctbytes((char *)&f, sizeof(f), h.endian);
        lua_pushnumber(ke, f); n++;
        break;
      }
      case 'd': {
        double d;
        memcpy(&d, data+pos, size);
        correctbytes((char *)&d, sizeof(d), h.endian);
        lua_pushnumber(ke, d); n++;
        break;
      }
      case 'c': {
        if (size == 0) {
          if (n == 0 || !lua_isnumber(ke, -1))
            luaL_error(ke, "format 'c0' needs a previous size");
          size = lua_tonumber(ke, -1);
          lua_pop(ke, 1); n--;
          luaL_argcheck(ke, size <= ld && pos <= ld - size,
                           2, "data string too short");
        }
        lua_pushlstring(ke, data+pos, size); n++;
        break;
      }
      case 's': {
        const char *e = (const char *)memchr(data+pos, '\0', ld - pos);
        if (e == NULL)
          luaL_error(ke, "unfinished string in data");
        size = (e - (data+pos)) + 1;
        lua_pushlstring(ke, data+pos, size - 1); n++;
        break;
      }
      default: controloptions(ke, opt, &fmt, &h);
    }
    pos += size;
  }
  lua_pushinteger(ke, pos + 1);  /* next position */
  return n + 1;
}