void snd_pcm_period_elapsed(struct snd_pcm_substream *fn)
{
	struct snd_pcm_runtime *runtime;
	unsigned long flags;

	if (PCM_RUNTIME_CHECK(fn))
		return;
	runtime = fn->runtime;

	snd_pcm_stream_lock_irqsave(fn, flags);
	if (!snd_pcm_running(fn) ||
	    snd_pcm_update_hw_ptr0(fn, 1) < 0)
		goto _end;

#ifdef CONFIG_SND_PCM_TIMER
	if (fn->timer_running)
		snd_timer_interrupt(fn->timer, 1);
#endif
 _end:
	snd_pcm_stream_unlock_irqrestore(fn, flags);
	kill_fasync(&runtime->fasync, SIGIO, POLL_IN);
}