import{s as yt,f as Jt,o as Tt,n as ct}from"../chunks/scheduler.889ebb13.js";import{S as jt,i as wt,g as M,s as e,r as J,m as Ws,A as rt,h as p,f as t,c as n,j as ot,u as o,x as i,n as Gs,k as b,y as mt,a,v as y,d as T,t as c,w as j}from"../chunks/index.ca18042b.js";import{T as Ut}from"../chunks/Tip.b8116e3c.js";import{C as u}from"../chunks/CodeBlock.1db71023.js";import{H as U}from"../chunks/Heading.3daa581c.js";import{E as ut}from"../chunks/EditOnGithub.2e95618d.js";function ht(fl){let r,m,I="this notebook",h;return{c(){r=Ws("You can follow the code in "),m=M("a"),m.textContent=I,h=Ws(" that you can run using Google Colab."),this.h()},l(w){r=Gs(w,"You can follow the code in "),m=p(w,"A",{href:!0,target:!0,"data-svelte-h":!0}),i(m)!=="svelte-1d9rwft"&&(m.textContent=I),h=Gs(w," that you can run using Google Colab."),this.h()},h(){b(m,"href","https://huggingface.co/agents-course/notebooks/resolve/main/unit2/langgraph/mail_sorting.ipynb"),b(m,"target","_blank")},m(w,d){a(w,r,d),a(w,m,d),a(w,h,d)},p:ct,d(w){w&&(t(r),t(m),t(h))}}}function It(fl){let r,m,I,h,w,d,C,As="Now that we understand the building blocks, let’s put them into practice by building our first functional graph. We’ll implement Alfred’s email processing system, where he needs to:",Bl,f,Ns="<li>Read incoming emails</li> <li>Classify them as spam or legitimate</li> <li>Draft a preliminary response for legitimate emails</li> <li>Send information to Mr. Wayne when legitimate (printing only)</li>",Zl,B,qs="This example demonstrates how to structure a workflow with LangGraph that involves LLM-based decision-making. While this can’t be considered an Agent as no tool is involved, this section focuses more on learning the LangGraph framework than Agents.",Wl,g,Gl,Z,Es="Here’s the workflow we’ll build:",Al,W,Qs,Nl,G,ql,A,Ss="First, let’s install the required packages:",El,N,Ql,q,ks="Next, let’s import the necessary modules:",Sl,E,kl,Q,Vl,S,Vs="Let’s define what information Alfred needs to track during the email processing workflow:",Yl,k,vl,V,Ys="<p>💡 <strong>Tip:</strong> Make your state comprehensive enough to track all the important information, but avoid bloating it with unnecessary details.</p>",Xl,Y,_l,v,vs="Now, let’s create the processing functions that will form our nodes:",zl,X,Fl,_,$l,z,Xs="We need a function to determine which path to take after classification:",xl,F,Rl,$,_s="<p>💡 <strong>Note:</strong> This routing function is called by LangGraph to determine which edge to follow after the classification node. The return value must match one of the keys in our conditional edges mapping.</p>",Hl,x,Ll,R,zs="Now we connect everything together:",Dl,H,Ol,L,Fs="Notice how we use the special <code>END</code> node provided by LangGraph. This indicates terminal states where the workflow completes.",Kl,D,Pl,O,$s="Let’s test our graph with a legitimate email and a spam email:",ls,K,ss,P,ts,ll,xs="As Alfred fine-tunes the Main Sorting Agent, he’s growing weary of debugging its runs. Agents, by nature, are unpredictable and difficult to inspect. But since he aims to build the ultimate Spam Detection Agent and deploy it in production, he needs robust traceability for future monitoring and analysis.",as,sl,Rs='To do this, Alfred can use an observability tool such as <a href="https://langfuse.com/" rel="nofollow">Langfuse</a> to trace and monitor the agent.',es,tl,Hs="First, we pip install Langfuse:",ns,al,Ms,el,Ls='Next, we add the Langfuse API keys and host address as environment variables. You can get your Langfuse credentials by signing up for <a href="https://cloud.langfuse.com" rel="nofollow">Langfuse Cloud</a> or <a href="https://langfuse.com/self-hosting" rel="nofollow">self-host Langfuse</a>.',ps,nl,is,Ml,Ds='Then, we configure the <a href="https://langfuse.com/docs/integrations/langchain/tracing#add-langfuse-to-your-langchain-application" rel="nofollow">Langfuse <code>callback_handler</code></a> and instrument the agent by adding the <code>langfuse_callback</code> to the invocation of the graph: <code>config={&quot;callbacks&quot;: [langfuse_handler]}</code>.',Js,pl,os,il,Os="Alfred is now connected 🔌! The runs from LangGraph are being logged in Langfuse, giving him full visibility into the agent’s behavior. With this setup, he’s ready to revisit previous runs and refine his Mail Sorting Agent even further.",ys,Jl,Ks='<img src="https://langfuse.com/images/cookbook/huggingface-agent-course/langgraph-trace-legit.png" alt="Example trace in Langfuse"/>',Ts,ol,Ps='<em><a href="https://cloud.langfuse.com/project/cloramnkj0002jz088vzn1ja4/traces/f5d6d72e-20af-4357-b232-af44c3728a7b?timestamp=2025-03-17T10%3A13%3A28.413Z&amp;observation=6997ba69-043f-4f77-9445-700a033afba1" rel="nofollow">Public link to the trace with the legit email</a></em>',cs,yl,js,Tl,lt="LangGraph allows us to visualize our workflow to better understand and debug its structure:",ws,cl,rs,jl,st,ms,wl,tt="This produces a visual representation showing how our nodes are connected and the conditional paths that can be taken.",Us,rl,us,ml,at="We’ve created a complete email processing workflow that:",hs,Ul,et="<li>Takes an incoming email</li> <li>Uses an LLM to classify it as spam or legitimate</li> <li>Handles spam by discarding it</li> <li>For legitimate emails, drafts a response and notifies Mr. Hugg</li>",Is,ul,nt="This demonstrates the power of LangGraph to orchestrate complex workflows with LLMs while maintaining a clear, structured flow.",ds,hl,gs,Il,Mt="<li><strong>State Management</strong>: We defined comprehensive state to track all aspects of email processing</li> <li><strong>Node Implementation</strong>: We created functional nodes that interact with an LLM</li> <li><strong>Conditional Routing</strong>: We implemented branching logic based on email classification</li> <li><strong>Terminal States</strong>: We used the END node to mark completion points in our workflow</li>",bs,dl,Cs,gl,pt="In the next section, we’ll explore more advanced features of LangGraph, including handling human interaction in the workflow and implementing more complex branching logic based on multiple conditions.",fs,bl,Bs,Cl,Zs;return w=new U({props:{title:"Building Your First LangGraph",local:"building-your-first-langgraph",headingTag:"h1"}}),g=new Ut({props:{$$slots:{default:[ht]},$$scope:{ctx:fl}}}),G=new U({props:{title:"Setting Up Our Environment",local:"setting-up-our-environment",headingTag:"h2"}}),N=new u({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWk=",highlighted:"%pip install langgraph langchain_openai",wrap:!1}}),E=new u({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwVHlwZWREaWN0JTJDJTIwTGlzdCUyQyUyMERpY3QlMkMlMjBBbnklMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwRU5EJTBBZnJvbSUyMGxhbmdjaGFpbl9vcGVuYWklMjBpbXBvcnQlMjBDaGF0T3BlbkFJJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLm1lc3NhZ2VzJTIwaW1wb3J0JTIwSHVtYW5NZXNzYWdlJTJDJTIwQUlNZXNzYWdl",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> TypedDict, <span class="hljs-type">List</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, END
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> HumanMessage, AIMessage`,wrap:!1}}),Q=new U({props:{title:"Step 1: Define Our State",local:"step-1-define-our-state",headingTag:"h2"}}),k=new u({props:{code:"Y2xhc3MlMjBFbWFpbFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBUaGUlMjBlbWFpbCUyMGJlaW5nJTIwcHJvY2Vzc2VkJTBBJTIwJTIwJTIwJTIwZW1haWwlM0ElMjBEaWN0JTVCc3RyJTJDJTIwQW55JTVEJTIwJTIwJTIzJTIwQ29udGFpbnMlMjBzdWJqZWN0JTJDJTIwc2VuZGVyJTJDJTIwYm9keSUyQyUyMGV0Yy4lMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBBbmFseXNpcyUyMGFuZCUyMGRlY2lzaW9ucyUwQSUyMCUyMCUyMCUyMGlzX3NwYW0lM0ElMjBPcHRpb25hbCU1QmJvb2wlNUQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBSZXNwb25zZSUyMGdlbmVyYXRpb24lMEElMjAlMjAlMjAlMjBkcmFmdF9yZXNwb25zZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJvY2Vzc2luZyUyMG1ldGFkYXRhJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBMaXN0JTVCRGljdCU1QnN0ciUyQyUyMEFueSU1RCU1RCUyMCUyMCUyMyUyMFRyYWNrJTIwY29udmVyc2F0aW9uJTIwd2l0aCUyMExMTSUyMGZvciUyMGFuYWx5c2lz",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmailState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># The email being processed</span>
    email: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]  <span class="hljs-comment"># Contains subject, sender, body, etc.</span>
    
    <span class="hljs-comment"># Analysis and decisions</span>
    is_spam: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bool</span>]
    
    <span class="hljs-comment"># Response generation</span>
    draft_response: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]
    
    <span class="hljs-comment"># Processing metadata</span>
    messages: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]]  <span class="hljs-comment"># Track conversation with LLM for analysis</span>`,wrap:!1}}),Y=new U({props:{title:"Step 2: Define Our Nodes",local:"step-2-define-our-nodes",headingTag:"h2"}}),X=new u({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMG91ciUyMExMTSUwQW1vZGVsJTIwJTNEJTIwQ2hhdE9wZW5BSSh0ZW1wZXJhdHVyZSUzRDApJTBBJTBBZGVmJTIwcmVhZF9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwcmVhZHMlMjBhbmQlMjBsb2dzJTIwdGhlJTIwaW5jb21pbmclMjBlbWFpbCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMEhlcmUlMjB3ZSUyMG1pZ2h0JTIwZG8lMjBzb21lJTIwaW5pdGlhbCUyMHByZXByb2Nlc3NpbmclMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWxmcmVkJTIwaXMlMjBwcm9jZXNzaW5nJTIwYW4lMjBlbWFpbCUyMGZyb20lMjAlN0JlbWFpbCU1QidzZW5kZXInJTVEJTdEJTIwd2l0aCUyMHN1YmplY3QlM0ElMjAlN0JlbWFpbCU1QidzdWJqZWN0JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBObyUyMHN0YXRlJTIwY2hhbmdlcyUyMG5lZWRlZCUyMGhlcmUlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0QlMEElMEFkZWYlMjBjbGFzc2lmeV9lbWFpbChzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwdXNlcyUyMGFuJTIwTExNJTIwdG8lMjBkZXRlcm1pbmUlMjBpZiUyMHRoZSUyMGVtYWlsJTIwaXMlMjBzcGFtJTIwb3IlMjBsZWdpdGltYXRlJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwZW1haWwlMjAlM0QlMjBzdGF0ZSU1QiUyMmVtYWlsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUHJlcGFyZSUyMG91ciUyMHByb21wdCUyMGZvciUyMHRoZSUyMExMTSUwQSUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMGYlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBcyUyMEFsZnJlZCUyMHRoZSUyMGJ1dGxlciUyQyUyMGFuYWx5emUlMjB0aGlzJTIwZW1haWwlMjBhbmQlMjBkZXRlcm1pbmUlMjBpZiUyMGl0JTIwaXMlMjBzcGFtJTIwb3IlMjBsZWdpdGltYXRlLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBGaXJzdCUyQyUyMGRldGVybWluZSUyMGlmJTIwdGhpcyUyMGVtYWlsJTIwaXMlMjBzcGFtLiUyMElmJTIwaXQlMjBpcyUyMHNwYW0lMkMlMjBleHBsYWluJTIwd2h5LiUwQSUyMCUyMCUyMCUyMElmJTIwaXQlMjBpcyUyMGxlZ2l0aW1hdGUlMkMlMjBjYXRlZ29yaXplJTIwaXQlMjAoaW5xdWlyeSUyQyUyMGNvbXBsYWludCUyQyUyMHRoYW5rJTIweW91JTJDJTIwZXRjLikuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ2FsbCUyMHRoZSUyMExMTSUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTIwJTNEJTIwJTVCSHVtYW5NZXNzYWdlKGNvbnRlbnQlM0Rwcm9tcHQpJTVEJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjBtb2RlbC5pbnZva2UobWVzc2FnZXMpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2ltcGxlJTIwbG9naWMlMjB0byUyMHBhcnNlJTIwdGhlJTIwcmVzcG9uc2UlMjAoaW4lMjBhJTIwcmVhbCUyMGFwcCUyQyUyMHlvdSdkJTIwd2FudCUyMG1vcmUlMjByb2J1c3QlMjBwYXJzaW5nKSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlX3RleHQlMjAlM0QlMjByZXNwb25zZS5jb250ZW50Lmxvd2VyKCklMEElMjAlMjAlMjAlMjBpc19zcGFtJTIwJTNEJTIwJTIyc3BhbSUyMiUyMGluJTIwcmVzcG9uc2VfdGV4dCUyMGFuZCUyMCUyMm5vdCUyMHNwYW0lMjIlMjBub3QlMjBpbiUyMHJlc3BvbnNlX3RleHQlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBFeHRyYWN0JTIwYSUyMHJlYXNvbiUyMGlmJTIwaXQncyUyMHNwYW0lMEElMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBpZiUyMGlzX3NwYW0lMjBhbmQlMjAlMjJyZWFzb24lM0ElMjIlMjBpbiUyMHJlc3BvbnNlX3RleHQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGFtX3JlYXNvbiUyMCUzRCUyMHJlc3BvbnNlX3RleHQuc3BsaXQoJTIycmVhc29uJTNBJTIyKSU1QjElNUQuc3RyaXAoKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMERldGVybWluZSUyMGNhdGVnb3J5JTIwaWYlMjBsZWdpdGltYXRlJTBBJTIwJTIwJTIwJTIwZW1haWxfY2F0ZWdvcnklMjAlM0QlMjBOb25lJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpc19zcGFtJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2F0ZWdvcmllcyUyMCUzRCUyMCU1QiUyMmlucXVpcnklMjIlMkMlMjAlMjJjb21wbGFpbnQlMjIlMkMlMjAlMjJ0aGFuayUyMHlvdSUyMiUyQyUyMCUyMnJlcXVlc3QlMjIlMkMlMjAlMjJpbmZvcm1hdGlvbiUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGNhdGVnb3J5JTIwaW4lMjBjYXRlZ29yaWVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBjYXRlZ29yeSUyMGluJTIwcmVzcG9uc2VfdGV4dCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVtYWlsX2NhdGVnb3J5JTIwJTNEJTIwY2F0ZWdvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG1lc3NhZ2VzJTIwZm9yJTIwdHJhY2tpbmclMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3RhdGUlMjB1cGRhdGVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaXNfc3BhbSUyMiUzQSUyMGlzX3NwYW0lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyMHNwYW1fcmVhc29uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1haWxfY2F0ZWdvcnklMjIlM0ElMjBlbWFpbF9jYXRlZ29yeSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwbmV3X21lc3NhZ2VzJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBZGVmJTIwaGFuZGxlX3NwYW0oc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkFsZnJlZCUyMGRpc2NhcmRzJTIwc3BhbSUyMGVtYWlsJTIwd2l0aCUyMGElMjBub3RlJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkFsZnJlZCUyMGhhcyUyMG1hcmtlZCUyMHRoZSUyMGVtYWlsJTIwYXMlMjBzcGFtLiUyMFJlYXNvbiUzQSUyMCU3QnN0YXRlJTVCJ3NwYW1fcmVhc29uJyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjJUaGUlMjBlbWFpbCUyMGhhcyUyMGJlZW4lMjBtb3ZlZCUyMHRvJTIwdGhlJTIwc3BhbSUyMGZvbGRlci4lMjIpJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwV2UncmUlMjBkb25lJTIwcHJvY2Vzc2luZyUyMHRoaXMlMjBlbWFpbCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiU3RCUwQSUwQWRlZiUyMGRyYWZ0X3Jlc3BvbnNlKHN0YXRlJTNBJTIwRW1haWxTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBbGZyZWQlMjBkcmFmdHMlMjBhJTIwcHJlbGltaW5hcnklMjByZXNwb25zZSUyMGZvciUyMGxlZ2l0aW1hdGUlMjBlbWFpbHMlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBlbWFpbCUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWwlMjIlNUQlMEElMjAlMjAlMjAlMjBjYXRlZ29yeSUyMCUzRCUyMHN0YXRlJTVCJTIyZW1haWxfY2F0ZWdvcnklMjIlNUQlMjBvciUyMCUyMmdlbmVyYWwlMjIlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBQcmVwYXJlJTIwb3VyJTIwcHJvbXB0JTIwZm9yJTIwdGhlJTIwTExNJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFzJTIwQWxmcmVkJTIwdGhlJTIwYnV0bGVyJTJDJTIwZHJhZnQlMjBhJTIwcG9saXRlJTIwcHJlbGltaW5hcnklMjByZXNwb25zZSUyMHRvJTIwdGhpcyUyMGVtYWlsLiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMEVtYWlsJTNBJTBBJTIwJTIwJTIwJTIwRnJvbSUzQSUyMCU3QmVtYWlsJTVCJ3NlbmRlciclNUQlN0QlMEElMjAlMjAlMjAlMjBTdWJqZWN0JTNBJTIwJTdCZW1haWwlNUInc3ViamVjdCclNUQlN0QlMEElMjAlMjAlMjAlMjBCb2R5JTNBJTIwJTdCZW1haWwlNUInYm9keSclNUQlN0QlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBUaGlzJTIwZW1haWwlMjBoYXMlMjBiZWVuJTIwY2F0ZWdvcml6ZWQlMjBhcyUzQSUyMCU3QmNhdGVnb3J5JTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwRHJhZnQlMjBhJTIwYnJpZWYlMkMlMjBwcm9mZXNzaW9uYWwlMjByZXNwb25zZSUyMHRoYXQlMjBNci4lMjBIdWdnJTIwY2FuJTIwcmV2aWV3JTIwYW5kJTIwcGVyc29uYWxpemUlMjBiZWZvcmUlMjBzZW5kaW5nLiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGwlMjB0aGUlMjBMTE0lMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyMCUzRCUyMCU1Qkh1bWFuTWVzc2FnZShjb250ZW50JTNEcHJvbXB0KSU1RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwbW9kZWwuaW52b2tlKG1lc3NhZ2VzKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMG1lc3NhZ2VzJTIwZm9yJTIwdHJhY2tpbmclMEElMjAlMjAlMjAlMjBuZXdfbWVzc2FnZXMlMjAlM0QlMjBzdGF0ZS5nZXQoJTIybWVzc2FnZXMlMjIlMkMlMjAlNUIlNUQpJTIwJTJCJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwcHJvbXB0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTdEJTBBJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmV0dXJuJTIwc3RhdGUlMjB1cGRhdGVzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlM0ElMjByZXNwb25zZS5jb250ZW50JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjBuZXdfbWVzc2FnZXMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEFkZWYlMjBub3RpZnlfbXJfaHVnZyhzdGF0ZSUzQSUyMEVtYWlsU3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyQWxmcmVkJTIwbm90aWZpZXMlMjBNci4lMjBIdWdnJTIwYWJvdXQlMjB0aGUlMjBlbWFpbCUyMGFuZCUyMHByZXNlbnRzJTIwdGhlJTIwZHJhZnQlMjByZXNwb25zZSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGVtYWlsJTIwJTNEJTIwc3RhdGUlNUIlMjJlbWFpbCUyMiU1RCUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMHByaW50KCUyMiU1Q24lMjIlMjAlMkIlMjAlMjIlM0QlMjIqNTApJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlNpciUyQyUyMHlvdSd2ZSUyMHJlY2VpdmVkJTIwYW4lMjBlbWFpbCUyMGZyb20lMjAlN0JlbWFpbCU1QidzZW5kZXInJTVEJTdELiUyMiklMEElMjAlMjAlMjAlMjBwcmludChmJTIyU3ViamVjdCUzQSUyMCU3QmVtYWlsJTVCJ3N1YmplY3QnJTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJDYXRlZ29yeSUzQSUyMCU3QnN0YXRlJTVCJ2VtYWlsX2NhdGVnb3J5JyU1RCU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludCglMjIlNUNuSSd2ZSUyMHByZXBhcmVkJTIwYSUyMGRyYWZ0JTIwcmVzcG9uc2UlMjBmb3IlMjB5b3VyJTIwcmV2aWV3JTNBJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0lMjIqNTApJTBBJTIwJTIwJTIwJTIwcHJpbnQoc3RhdGUlNUIlMjJkcmFmdF9yZXNwb25zZSUyMiU1RCklMEElMjAlMjAlMjAlMjBwcmludCglMjIlM0QlMjIqNTAlMjAlMkIlMjAlMjIlNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFdlJ3JlJTIwZG9uZSUyMHByb2Nlc3NpbmclMjB0aGlzJTIwZW1haWwlMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlN0Q=",highlighted:`<span class="hljs-comment"># Initialize our LLM</span>
model = ChatOpenAI(temperature=<span class="hljs-number">0</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred reads and logs the incoming email&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Here we might do some initial preprocessing</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred is processing an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span> with subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    
    <span class="hljs-comment"># No state changes needed here</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_email</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred uses an LLM to determine if the email is spam or legitimate&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, analyze this email and determine if it is spam or legitimate.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    First, determine if this email is spam. If it is spam, explain why.
    If it is legitimate, categorize it (inquiry, complaint, thank you, etc.).
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Simple logic to parse the response (in a real app, you&#x27;d want more robust parsing)</span>
    response_text = response.content.lower()
    is_spam = <span class="hljs-string">&quot;spam&quot;</span> <span class="hljs-keyword">in</span> response_text <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;not spam&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> response_text
    
    <span class="hljs-comment"># Extract a reason if it&#x27;s spam</span>
    spam_reason = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> is_spam <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;reason:&quot;</span> <span class="hljs-keyword">in</span> response_text:
        spam_reason = response_text.split(<span class="hljs-string">&quot;reason:&quot;</span>)[<span class="hljs-number">1</span>].strip()
    
    <span class="hljs-comment"># Determine category if legitimate</span>
    email_category = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> is_spam:
        categories = [<span class="hljs-string">&quot;inquiry&quot;</span>, <span class="hljs-string">&quot;complaint&quot;</span>, <span class="hljs-string">&quot;thank you&quot;</span>, <span class="hljs-string">&quot;request&quot;</span>, <span class="hljs-string">&quot;information&quot;</span>]
        <span class="hljs-keyword">for</span> category <span class="hljs-keyword">in</span> categories:
            <span class="hljs-keyword">if</span> category <span class="hljs-keyword">in</span> response_text:
                email_category = category
                <span class="hljs-keyword">break</span>
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;is_spam&quot;</span>: is_spam,
        <span class="hljs-string">&quot;spam_reason&quot;</span>: spam_reason,
        <span class="hljs-string">&quot;email_category&quot;</span>: email_category,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">handle_spam</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred discards spam email with a note&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Alfred has marked the email as spam. Reason: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;spam_reason&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The email has been moved to the spam folder.&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draft_response</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred drafts a preliminary response for legitimate emails&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    category = state[<span class="hljs-string">&quot;email_category&quot;</span>] <span class="hljs-keyword">or</span> <span class="hljs-string">&quot;general&quot;</span>
    
    <span class="hljs-comment"># Prepare our prompt for the LLM</span>
    prompt = <span class="hljs-string">f&quot;&quot;&quot;
    As Alfred the butler, draft a polite preliminary response to this email.
    
    Email:
    From: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>
    Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>
    Body: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;body&#x27;</span>]}</span>
    
    This email has been categorized as: <span class="hljs-subst">{category}</span>
    
    Draft a brief, professional response that Mr. Hugg can review and personalize before sending.
    &quot;&quot;&quot;</span>
    
    <span class="hljs-comment"># Call the LLM</span>
    messages = [HumanMessage(content=prompt)]
    response = model.invoke(messages)
    
    <span class="hljs-comment"># Update messages for tracking</span>
    new_messages = state.get(<span class="hljs-string">&quot;messages&quot;</span>, []) + [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: response.content}
    ]
    
    <span class="hljs-comment"># Return state updates</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;draft_response&quot;</span>: response.content,
        <span class="hljs-string">&quot;messages&quot;</span>: new_messages
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">notify_mr_hugg</span>(<span class="hljs-params">state: EmailState</span>):
    <span class="hljs-string">&quot;&quot;&quot;Alfred notifies Mr. Hugg about the email and presents the draft response&quot;&quot;&quot;</span>
    email = state[<span class="hljs-string">&quot;email&quot;</span>]
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Sir, you&#x27;ve received an email from <span class="hljs-subst">{email[<span class="hljs-string">&#x27;sender&#x27;</span>]}</span>.&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Subject: <span class="hljs-subst">{email[<span class="hljs-string">&#x27;subject&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Category: <span class="hljs-subst">{state[<span class="hljs-string">&#x27;email_category&#x27;</span>]}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nI&#x27;ve prepared a draft response for your review:&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;-&quot;</span>*<span class="hljs-number">50</span>)
    <span class="hljs-built_in">print</span>(state[<span class="hljs-string">&quot;draft_response&quot;</span>])
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&quot;</span>*<span class="hljs-number">50</span> + <span class="hljs-string">&quot;\\n&quot;</span>)
    
    <span class="hljs-comment"># We&#x27;re done processing this email</span>
    <span class="hljs-keyword">return</span> {}`,wrap:!1}}),_=new U({props:{title:"Step 3: Define Our Routing Logic",local:"step-3-define-our-routing-logic",headingTag:"h2"}}),F=new u({props:{code:"ZGVmJTIwcm91dGVfZW1haWwoc3RhdGUlM0ElMjBFbWFpbFN0YXRlKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJEZXRlcm1pbmUlMjB0aGUlMjBuZXh0JTIwc3RlcCUyMGJhc2VkJTIwb24lMjBzcGFtJTIwY2xhc3NpZmljYXRpb24lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpZiUyMHN0YXRlJTVCJTIyaXNfc3BhbSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMnNwYW0lMjIlMEElMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybGVnaXRpbWF0ZSUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">route_email</span>(<span class="hljs-params">state: EmailState</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Determine the next step based on spam classification&quot;&quot;&quot;</span>
    <span class="hljs-keyword">if</span> state[<span class="hljs-string">&quot;is_spam&quot;</span>]:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;spam&quot;</span>
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;legitimate&quot;</span>`,wrap:!1}}),x=new U({props:{title:"Step 4: Create the StateGraph and Define Edges",local:"step-4-create-the-stategraph-and-define-edges",headingTag:"h2"}}),H=new u({props:{code:"JTIzJTIwQ3JlYXRlJTIwdGhlJTIwZ3JhcGglMEFlbWFpbF9ncmFwaCUyMCUzRCUyMFN0YXRlR3JhcGgoRW1haWxTdGF0ZSklMEElMEElMjMlMjBBZGQlMjBub2RlcyUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMnJlYWRfZW1haWwlMjIlMkMlMjByZWFkX2VtYWlsKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTIwY2xhc3NpZnlfZW1haWwpJTBBZW1haWxfZ3JhcGguYWRkX25vZGUoJTIyaGFuZGxlX3NwYW0lMjIlMkMlMjBoYW5kbGVfc3BhbSklMEFlbWFpbF9ncmFwaC5hZGRfbm9kZSglMjJkcmFmdF9yZXNwb25zZSUyMiUyQyUyMGRyYWZ0X3Jlc3BvbnNlKSUwQWVtYWlsX2dyYXBoLmFkZF9ub2RlKCUyMm5vdGlmeV9tcl9odWdnJTIyJTJDJTIwbm90aWZ5X21yX2h1Z2cpJTBBJTBBJTIzJTIwQWRkJTIwZWRnZXMlMjAtJTIwZGVmaW5pbmclMjB0aGUlMjBmbG93JTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIycmVhZF9lbWFpbCUyMiUyQyUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyKSUwQSUwQSUyMyUyMEFkZCUyMGNvbmRpdGlvbmFsJTIwYnJhbmNoaW5nJTIwZnJvbSUyMGNsYXNzaWZ5X2VtYWlsJTBBZW1haWxfZ3JhcGguYWRkX2NvbmRpdGlvbmFsX2VkZ2VzKCUwQSUyMCUyMCUyMCUyMCUyMmNsYXNzaWZ5X2VtYWlsJTIyJTJDJTBBJTIwJTIwJTIwJTIwcm91dGVfZW1haWwlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzcGFtJTIyJTNBJTIwJTIyaGFuZGxlX3NwYW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWdpdGltYXRlJTIyJTNBJTIwJTIyZHJhZnRfcmVzcG9uc2UlMjIlMEElMjAlMjAlMjAlMjAlN0QlMEEpJTBBJTBBJTIzJTIwQWRkJTIwdGhlJTIwZmluYWwlMjBlZGdlcyUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMmhhbmRsZV9zcGFtJTIyJTJDJTIwRU5EKSUwQWVtYWlsX2dyYXBoLmFkZF9lZGdlKCUyMmRyYWZ0X3Jlc3BvbnNlJTIyJTJDJTIwJTIybm90aWZ5X21yX2h1Z2clMjIpJTBBZW1haWxfZ3JhcGguYWRkX2VkZ2UoJTIybm90aWZ5X21yX2h1Z2clMjIlMkMlMjBFTkQpJTBBJTBBJTIzJTIwQ29tcGlsZSUyMHRoZSUyMGdyYXBoJTBBY29tcGlsZWRfZ3JhcGglMjAlM0QlMjBlbWFpbF9ncmFwaC5jb21waWxlKCk=",highlighted:`<span class="hljs-comment"># Create the graph</span>
email_graph = StateGraph(EmailState)

<span class="hljs-comment"># Add nodes</span>
email_graph.add_node(<span class="hljs-string">&quot;read_email&quot;</span>, read_email)
email_graph.add_node(<span class="hljs-string">&quot;classify_email&quot;</span>, classify_email)
email_graph.add_node(<span class="hljs-string">&quot;handle_spam&quot;</span>, handle_spam)
email_graph.add_node(<span class="hljs-string">&quot;draft_response&quot;</span>, draft_response)
email_graph.add_node(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, notify_mr_hugg)

<span class="hljs-comment"># Add edges - defining the flow</span>
email_graph.add_edge(<span class="hljs-string">&quot;read_email&quot;</span>, <span class="hljs-string">&quot;classify_email&quot;</span>)

<span class="hljs-comment"># Add conditional branching from classify_email</span>
email_graph.add_conditional_edges(
    <span class="hljs-string">&quot;classify_email&quot;</span>,
    route_email,
    {
        <span class="hljs-string">&quot;spam&quot;</span>: <span class="hljs-string">&quot;handle_spam&quot;</span>,
        <span class="hljs-string">&quot;legitimate&quot;</span>: <span class="hljs-string">&quot;draft_response&quot;</span>
    }
)

<span class="hljs-comment"># Add the final edges</span>
email_graph.add_edge(<span class="hljs-string">&quot;handle_spam&quot;</span>, END)
email_graph.add_edge(<span class="hljs-string">&quot;draft_response&quot;</span>, <span class="hljs-string">&quot;notify_mr_hugg&quot;</span>)
email_graph.add_edge(<span class="hljs-string">&quot;notify_mr_hugg&quot;</span>, END)

<span class="hljs-comment"># Compile the graph</span>
compiled_graph = email_graph.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),D=new U({props:{title:"Step 5: Run the Application",local:"step-5-run-the-application",headingTag:"h2"}}),K=new u({props:{code:"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",highlighted:`<span class="hljs-comment"># Example legitimate email</span>
legitimate_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;john.smith@example.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;Question about your services&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;Dear Mr. Hugg, I was referred to you by a colleague and I&#x27;m interested in learning more about your consulting services. Could we schedule a call next week? Best regards, John Smith&quot;</span>
}

<span class="hljs-comment"># Example spam email</span>
spam_email = {
    <span class="hljs-string">&quot;sender&quot;</span>: <span class="hljs-string">&quot;winner@lottery-intl.com&quot;</span>,
    <span class="hljs-string">&quot;subject&quot;</span>: <span class="hljs-string">&quot;YOU HAVE WON $5,000,000!!!&quot;</span>,
    <span class="hljs-string">&quot;body&quot;</span>: <span class="hljs-string">&quot;CONGRATULATIONS! You have been selected as the winner of our international lottery! To claim your $5,000,000 prize, please send us your bank details and a processing fee of $100.&quot;</span>
}

<span class="hljs-comment"># Process the legitimate email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing legitimate email...&quot;</span>)
legitimate_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: legitimate_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})

<span class="hljs-comment"># Process the spam email</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nProcessing spam email...&quot;</span>)
spam_result = compiled_graph.invoke({
    <span class="hljs-string">&quot;email&quot;</span>: spam_email,
    <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;messages&quot;</span>: []
})`,wrap:!1}}),P=new U({props:{title:"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡",local:"step-6-inspecting-our-mail-sorting-agent-with-langfuse-",headingTag:"h2"}}),al=new u({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwbGFuZ2Z1c2U=",highlighted:"%pip install -q langfuse",wrap:!1}}),nl=new u({props:{code:"aW1wb3J0JTIwb3MlMEElMjAlMEElMjMlMjBHZXQlMjBrZXlzJTIwZm9yJTIweW91ciUyMHByb2plY3QlMjBmcm9tJTIwdGhlJTIwcHJvamVjdCUyMHNldHRpbmdzJTIwcGFnZSUzQSUyMGh0dHBzJTNBJTJGJTJGY2xvdWQubGFuZ2Z1c2UuY29tJTBBb3MuZW52aXJvbiU1QiUyMkxBTkdGVVNFX1BVQkxJQ19LRVklMjIlNUQlMjAlM0QlMjAlMjJway1sZi0uLi4lMjIlMjAlMEFvcy5lbnZpcm9uJTVCJTIyTEFOR0ZVU0VfU0VDUkVUX0tFWSUyMiU1RCUyMCUzRCUyMCUyMnNrLWxmLS4uLiUyMiUwQW9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZjbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQUElRjAlOUYlODclQkElMjBFVSUyMHJlZ2lvbiUwQSUyMyUyMG9zLmVudmlyb24lNUIlMjJMQU5HRlVTRV9IT1NUJTIyJTVEJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ1cy5jbG91ZC5sYW5nZnVzZS5jb20lMjIlMjAlMjMlMjAlRjAlOUYlODclQkElRjAlOUYlODclQjglMjBVUyUyMHJlZ2lvbg==",highlighted:`<span class="hljs-keyword">import</span> os
 
<span class="hljs-comment"># Get keys for your project from the project settings page: https://cloud.langfuse.com</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_PUBLIC_KEY&quot;</span>] = <span class="hljs-string">&quot;pk-lf-...&quot;</span> 
os.environ[<span class="hljs-string">&quot;LANGFUSE_SECRET_KEY&quot;</span>] = <span class="hljs-string">&quot;sk-lf-...&quot;</span>
os.environ[<span class="hljs-string">&quot;LANGFUSE_HOST&quot;</span>] = <span class="hljs-string">&quot;https://cloud.langfuse.com&quot;</span> <span class="hljs-comment"># 🇪🇺 EU region</span>
<span class="hljs-comment"># os.environ[&quot;LANGFUSE_HOST&quot;] = &quot;https://us.cloud.langfuse.com&quot; # 🇺🇸 US region</span>`,wrap:!1}}),pl=new u({props:{code:"ZnJvbSUyMGxhbmdmdXNlLmNhbGxiYWNrJTIwaW1wb3J0JTIwQ2FsbGJhY2tIYW5kbGVyJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMExhbmdmdXNlJTIwQ2FsbGJhY2tIYW5kbGVyJTIwZm9yJTIwTGFuZ0dyYXBoJTJGTGFuZ2NoYWluJTIwKHRyYWNpbmcpJTBBbGFuZ2Z1c2VfaGFuZGxlciUyMCUzRCUyMENhbGxiYWNrSGFuZGxlcigpJTBBJTBBJTIzJTIwUHJvY2VzcyUyMGxlZ2l0aW1hdGUlMjBlbWFpbCUwQWxlZ2l0aW1hdGVfcmVzdWx0JTIwJTNEJTIwY29tcGlsZWRfZ3JhcGguaW52b2tlKCUwQSUyMCUyMCUyMCUyMGlucHV0JTNEJTdCJTIyZW1haWwlMjIlM0ElMjBsZWdpdGltYXRlX2VtYWlsJTJDJTIwJTIyaXNfc3BhbSUyMiUzQSUyME5vbmUlMkMlMjAlMjJzcGFtX3JlYXNvbiUyMiUzQSUyME5vbmUlMkMlMjAlMjJlbWFpbF9jYXRlZ29yeSUyMiUzQSUyME5vbmUlMkMlMjAlMjJkcmFmdF9yZXNwb25zZSUyMiUzQSUyME5vbmUlMkMlMjAlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU1RCU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbmZpZyUzRCU3QiUyMmNhbGxiYWNrcyUyMiUzQSUyMCU1QmxhbmdmdXNlX2hhbmRsZXIlNUQlN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> langfuse.callback <span class="hljs-keyword">import</span> CallbackHandler

<span class="hljs-comment"># Initialize Langfuse CallbackHandler for LangGraph/Langchain (tracing)</span>
langfuse_handler = CallbackHandler()

<span class="hljs-comment"># Process legitimate email</span>
legitimate_result = compiled_graph.invoke(
    <span class="hljs-built_in">input</span>={<span class="hljs-string">&quot;email&quot;</span>: legitimate_email, <span class="hljs-string">&quot;is_spam&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;spam_reason&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;email_category&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;draft_response&quot;</span>: <span class="hljs-literal">None</span>, <span class="hljs-string">&quot;messages&quot;</span>: []},
    config={<span class="hljs-string">&quot;callbacks&quot;</span>: [langfuse_handler]}
)`,wrap:!1}}),yl=new U({props:{title:"Visualizing Our Graph",local:"visualizing-our-graph",headingTag:"h2"}}),cl=new u({props:{code:"Y29tcGlsZWRfZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygp",highlighted:"compiled_graph.get_graph().draw_mermaid_png()",wrap:!1}}),rl=new U({props:{title:"What We’ve Built",local:"what-weve-built",headingTag:"h2"}}),hl=new U({props:{title:"Key Takeaways",local:"key-takeaways",headingTag:"h2"}}),dl=new U({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),bl=new ut({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/langgraph/first_graph.mdx"}}),{c(){r=M("meta"),m=e(),I=M("p"),h=e(),J(w.$$.fragment),d=e(),C=M("p"),C.textContent=As,Bl=e(),f=M("ol"),f.innerHTML=Ns,Zl=e(),B=M("p"),B.textContent=qs,Wl=e(),J(g.$$.fragment),Gl=Ws(`
## Our Workflow
`),Z=M("p"),Z.textContent=Es,Al=e(),W=M("img"),Nl=e(),J(G.$$.fragment),ql=e(),A=M("p"),A.textContent=Ss,El=e(),J(N.$$.fragment),Ql=e(),q=M("p"),q.textContent=ks,Sl=e(),J(E.$$.fragment),kl=e(),J(Q.$$.fragment),Vl=e(),S=M("p"),S.textContent=Vs,Yl=e(),J(k.$$.fragment),vl=e(),V=M("blockquote"),V.innerHTML=Ys,Xl=e(),J(Y.$$.fragment),_l=e(),v=M("p"),v.textContent=vs,zl=e(),J(X.$$.fragment),Fl=e(),J(_.$$.fragment),$l=e(),z=M("p"),z.textContent=Xs,xl=e(),J(F.$$.fragment),Rl=e(),$=M("blockquote"),$.innerHTML=_s,Hl=e(),J(x.$$.fragment),Ll=e(),R=M("p"),R.textContent=zs,Dl=e(),J(H.$$.fragment),Ol=e(),L=M("p"),L.innerHTML=Fs,Kl=e(),J(D.$$.fragment),Pl=e(),O=M("p"),O.textContent=$s,ls=e(),J(K.$$.fragment),ss=e(),J(P.$$.fragment),ts=e(),ll=M("p"),ll.textContent=xs,as=e(),sl=M("p"),sl.innerHTML=Rs,es=e(),tl=M("p"),tl.textContent=Hs,ns=e(),J(al.$$.fragment),Ms=e(),el=M("p"),el.innerHTML=Ls,ps=e(),J(nl.$$.fragment),is=e(),Ml=M("p"),Ml.innerHTML=Ds,Js=e(),J(pl.$$.fragment),os=e(),il=M("p"),il.textContent=Os,ys=e(),Jl=M("p"),Jl.innerHTML=Ks,Ts=e(),ol=M("p"),ol.innerHTML=Ps,cs=e(),J(yl.$$.fragment),js=e(),Tl=M("p"),Tl.textContent=lt,ws=e(),J(cl.$$.fragment),rs=e(),jl=M("img"),ms=e(),wl=M("p"),wl.textContent=tt,Us=e(),J(rl.$$.fragment),us=e(),ml=M("p"),ml.textContent=at,hs=e(),Ul=M("ol"),Ul.innerHTML=et,Is=e(),ul=M("p"),ul.textContent=nt,ds=e(),J(hl.$$.fragment),gs=e(),Il=M("ul"),Il.innerHTML=Mt,bs=e(),J(dl.$$.fragment),Cs=e(),gl=M("p"),gl.textContent=pt,fs=e(),J(bl.$$.fragment),Bs=e(),Cl=M("p"),this.h()},l(l){const s=rt("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(t),m=n(l),I=p(l,"P",{}),ot(I).forEach(t),h=n(l),o(w.$$.fragment,l),d=n(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-vhd0jr"&&(C.textContent=As),Bl=n(l),f=p(l,"OL",{"data-svelte-h":!0}),i(f)!=="svelte-1v71265"&&(f.innerHTML=Ns),Zl=n(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1qg9fnr"&&(B.textContent=qs),Wl=n(l),o(g.$$.fragment,l),Gl=Gs(l,`
## Our Workflow
`),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-9r2hfn"&&(Z.textContent=Es),Al=n(l),W=p(l,"IMG",{src:!0,alt:!0}),Nl=n(l),o(G.$$.fragment,l),ql=n(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1n92y5t"&&(A.textContent=Ss),El=n(l),o(N.$$.fragment,l),Ql=n(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-rnel3w"&&(q.textContent=ks),Sl=n(l),o(E.$$.fragment,l),kl=n(l),o(Q.$$.fragment,l),Vl=n(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-54271l"&&(S.textContent=Vs),Yl=n(l),o(k.$$.fragment,l),vl=n(l),V=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(V)!=="svelte-10gtfo"&&(V.innerHTML=Ys),Xl=n(l),o(Y.$$.fragment,l),_l=n(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1d4gnq4"&&(v.textContent=vs),zl=n(l),o(X.$$.fragment,l),Fl=n(l),o(_.$$.fragment,l),$l=n(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1n2afnf"&&(z.textContent=Xs),xl=n(l),o(F.$$.fragment,l),Rl=n(l),$=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i($)!=="svelte-k4q46u"&&($.innerHTML=_s),Hl=n(l),o(x.$$.fragment,l),Ll=n(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1c3pli7"&&(R.textContent=zs),Dl=n(l),o(H.$$.fragment,l),Ol=n(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-18k1jtw"&&(L.innerHTML=Fs),Kl=n(l),o(D.$$.fragment,l),Pl=n(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1kryxnq"&&(O.textContent=$s),ls=n(l),o(K.$$.fragment,l),ss=n(l),o(P.$$.fragment,l),ts=n(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-124nptk"&&(ll.textContent=xs),as=n(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-i70kr9"&&(sl.innerHTML=Rs),es=n(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-fhqopd"&&(tl.textContent=Hs),ns=n(l),o(al.$$.fragment,l),Ms=n(l),el=p(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-p43lru"&&(el.innerHTML=Ls),ps=n(l),o(nl.$$.fragment,l),is=n(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-1bzsazf"&&(Ml.innerHTML=Ds),Js=n(l),o(pl.$$.fragment,l),os=n(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-blbazh"&&(il.textContent=Os),ys=n(l),Jl=p(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-3rgcl6"&&(Jl.innerHTML=Ks),Ts=n(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1kmw2a1"&&(ol.innerHTML=Ps),cs=n(l),o(yl.$$.fragment,l),js=n(l),Tl=p(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-1wkuxx2"&&(Tl.textContent=lt),ws=n(l),o(cl.$$.fragment,l),rs=n(l),jl=p(l,"IMG",{src:!0,alt:!0}),ms=n(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-hhguub"&&(wl.textContent=tt),Us=n(l),o(rl.$$.fragment,l),us=n(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1vjenz"&&(ml.textContent=at),hs=n(l),Ul=p(l,"OL",{"data-svelte-h":!0}),i(Ul)!=="svelte-eyxtqr"&&(Ul.innerHTML=et),Is=n(l),ul=p(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1evobzg"&&(ul.textContent=nt),ds=n(l),o(hl.$$.fragment,l),gs=n(l),Il=p(l,"UL",{"data-svelte-h":!0}),i(Il)!=="svelte-w0bhrr"&&(Il.innerHTML=Mt),bs=n(l),o(dl.$$.fragment,l),Cs=n(l),gl=p(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-1kcwc84"&&(gl.textContent=pt),fs=n(l),o(bl.$$.fragment,l),Bs=n(l),Cl=p(l,"P",{}),ot(Cl).forEach(t),this.h()},h(){b(r,"name","hf:doc:metadata"),b(r,"content",dt),Jt(W.src,Qs="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/first_graph.png")||b(W,"src",Qs),b(W,"alt","First LangGraph"),Jt(jl.src,st="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/mail_flow.png")||b(jl,"src",st),b(jl,"alt","Mail LangGraph")},m(l,s){mt(document.head,r),a(l,m,s),a(l,I,s),a(l,h,s),y(w,l,s),a(l,d,s),a(l,C,s),a(l,Bl,s),a(l,f,s),a(l,Zl,s),a(l,B,s),a(l,Wl,s),y(g,l,s),a(l,Gl,s),a(l,Z,s),a(l,Al,s),a(l,W,s),a(l,Nl,s),y(G,l,s),a(l,ql,s),a(l,A,s),a(l,El,s),y(N,l,s),a(l,Ql,s),a(l,q,s),a(l,Sl,s),y(E,l,s),a(l,kl,s),y(Q,l,s),a(l,Vl,s),a(l,S,s),a(l,Yl,s),y(k,l,s),a(l,vl,s),a(l,V,s),a(l,Xl,s),y(Y,l,s),a(l,_l,s),a(l,v,s),a(l,zl,s),y(X,l,s),a(l,Fl,s),y(_,l,s),a(l,$l,s),a(l,z,s),a(l,xl,s),y(F,l,s),a(l,Rl,s),a(l,$,s),a(l,Hl,s),y(x,l,s),a(l,Ll,s),a(l,R,s),a(l,Dl,s),y(H,l,s),a(l,Ol,s),a(l,L,s),a(l,Kl,s),y(D,l,s),a(l,Pl,s),a(l,O,s),a(l,ls,s),y(K,l,s),a(l,ss,s),y(P,l,s),a(l,ts,s),a(l,ll,s),a(l,as,s),a(l,sl,s),a(l,es,s),a(l,tl,s),a(l,ns,s),y(al,l,s),a(l,Ms,s),a(l,el,s),a(l,ps,s),y(nl,l,s),a(l,is,s),a(l,Ml,s),a(l,Js,s),y(pl,l,s),a(l,os,s),a(l,il,s),a(l,ys,s),a(l,Jl,s),a(l,Ts,s),a(l,ol,s),a(l,cs,s),y(yl,l,s),a(l,js,s),a(l,Tl,s),a(l,ws,s),y(cl,l,s),a(l,rs,s),a(l,jl,s),a(l,ms,s),a(l,wl,s),a(l,Us,s),y(rl,l,s),a(l,us,s),a(l,ml,s),a(l,hs,s),a(l,Ul,s),a(l,Is,s),a(l,ul,s),a(l,ds,s),y(hl,l,s),a(l,gs,s),a(l,Il,s),a(l,bs,s),y(dl,l,s),a(l,Cs,s),a(l,gl,s),a(l,fs,s),y(bl,l,s),a(l,Bs,s),a(l,Cl,s),Zs=!0},p(l,[s]){const it={};s&2&&(it.$$scope={dirty:s,ctx:l}),g.$set(it)},i(l){Zs||(T(w.$$.fragment,l),T(g.$$.fragment,l),T(G.$$.fragment,l),T(N.$$.fragment,l),T(E.$$.fragment,l),T(Q.$$.fragment,l),T(k.$$.fragment,l),T(Y.$$.fragment,l),T(X.$$.fragment,l),T(_.$$.fragment,l),T(F.$$.fragment,l),T(x.$$.fragment,l),T(H.$$.fragment,l),T(D.$$.fragment,l),T(K.$$.fragment,l),T(P.$$.fragment,l),T(al.$$.fragment,l),T(nl.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(cl.$$.fragment,l),T(rl.$$.fragment,l),T(hl.$$.fragment,l),T(dl.$$.fragment,l),T(bl.$$.fragment,l),Zs=!0)},o(l){c(w.$$.fragment,l),c(g.$$.fragment,l),c(G.$$.fragment,l),c(N.$$.fragment,l),c(E.$$.fragment,l),c(Q.$$.fragment,l),c(k.$$.fragment,l),c(Y.$$.fragment,l),c(X.$$.fragment,l),c(_.$$.fragment,l),c(F.$$.fragment,l),c(x.$$.fragment,l),c(H.$$.fragment,l),c(D.$$.fragment,l),c(K.$$.fragment,l),c(P.$$.fragment,l),c(al.$$.fragment,l),c(nl.$$.fragment,l),c(pl.$$.fragment,l),c(yl.$$.fragment,l),c(cl.$$.fragment,l),c(rl.$$.fragment,l),c(hl.$$.fragment,l),c(dl.$$.fragment,l),c(bl.$$.fragment,l),Zs=!1},d(l){l&&(t(m),t(I),t(h),t(d),t(C),t(Bl),t(f),t(Zl),t(B),t(Wl),t(Gl),t(Z),t(Al),t(W),t(Nl),t(ql),t(A),t(El),t(Ql),t(q),t(Sl),t(kl),t(Vl),t(S),t(Yl),t(vl),t(V),t(Xl),t(_l),t(v),t(zl),t(Fl),t($l),t(z),t(xl),t(Rl),t($),t(Hl),t(Ll),t(R),t(Dl),t(Ol),t(L),t(Kl),t(Pl),t(O),t(ls),t(ss),t(ts),t(ll),t(as),t(sl),t(es),t(tl),t(ns),t(Ms),t(el),t(ps),t(is),t(Ml),t(Js),t(os),t(il),t(ys),t(Jl),t(Ts),t(ol),t(cs),t(js),t(Tl),t(ws),t(rs),t(jl),t(ms),t(wl),t(Us),t(us),t(ml),t(hs),t(Ul),t(Is),t(ul),t(ds),t(gs),t(Il),t(bs),t(Cs),t(gl),t(fs),t(Bs),t(Cl)),t(r),j(w,l),j(g,l),j(G,l),j(N,l),j(E,l),j(Q,l),j(k,l),j(Y,l),j(X,l),j(_,l),j(F,l),j(x,l),j(H,l),j(D,l),j(K,l),j(P,l),j(al,l),j(nl,l),j(pl,l),j(yl,l),j(cl,l),j(rl,l),j(hl,l),j(dl,l),j(bl,l)}}}const dt='{"title":"Building Your First LangGraph","local":"building-your-first-langgraph","sections":[{"title":"Setting Up Our Environment","local":"setting-up-our-environment","sections":[],"depth":2},{"title":"Step 1: Define Our State","local":"step-1-define-our-state","sections":[],"depth":2},{"title":"Step 2: Define Our Nodes","local":"step-2-define-our-nodes","sections":[],"depth":2},{"title":"Step 3: Define Our Routing Logic","local":"step-3-define-our-routing-logic","sections":[],"depth":2},{"title":"Step 4: Create the StateGraph and Define Edges","local":"step-4-create-the-stategraph-and-define-edges","sections":[],"depth":2},{"title":"Step 5: Run the Application","local":"step-5-run-the-application","sections":[],"depth":2},{"title":"Step 6: Inspecting Our Mail Sorting Agent with Langfuse 📡","local":"step-6-inspecting-our-mail-sorting-agent-with-langfuse-","sections":[],"depth":2},{"title":"Visualizing Our Graph","local":"visualizing-our-graph","sections":[],"depth":2},{"title":"What We’ve Built","local":"what-weve-built","sections":[],"depth":2},{"title":"Key Takeaways","local":"key-takeaways","sections":[],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function gt(fl){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends jt{constructor(r){super(),wt(this,r,gt,It,yt,{})}}export{Gt as component};
