import{s as Te,f as Ue,n as ge,o as fe}from"../chunks/scheduler.f7e1785c.js";import{S as je,i as be,g as i,s as n,r as M,A as Ie,h as o,f as l,c as a,j as Lt,u as c,x as p,k as C,y as $e,a as s,v as r,d as m,t as y,w as u}from"../chunks/index.d8354395.js";import{C as w}from"../chunks/CodeBlock.191e5103.js";import{H as nt,E as Ge}from"../chunks/getInferenceSnippets.a345c7e4.js";function ve(Dt){let h,ot,at,pt,g,Mt,f,Kt="In the previous section, we explored how to create an MCP Server using Gradio and connect to it using an MCP Client. In this section, we’re going to explore how to use Gradio as an MCP Client to connect to an MCP Server.",ct,J,Ot="<p>Gradio is best suited to the creation of UI clients and MCP servers, but it is also possible to use it as an MCP Client and expose that as a UI.</p>",rt,j,te="We’ll connect to an MCP server similar to the one we created in the previous section but with additional features, and use it to answer questions.",mt,b,yt,I,ut,$,ee='Let’s connect to an example MCP Server that is already running on Hugging Face. We’ll use <a href="https://huggingface.co/spaces/abidlabs/mcp-tool-http" rel="nofollow">this one</a> for this example. It’s a space that contains a collection of MCP tools.',dt,G,wt,v,le=`<summary>Output</summary> <pre><code>
prime_factors: Compute the prime factorization of a positive integer.
generate_cheetah_image: Generate a cheetah image.
image_orientation: Returns whether image is portrait or landscape.
sepia: Apply a sepia filter to the input image.
</code>
</pre>`,ht,B,Ct,Q,se="Great, now that you’ve connected to an example MCP Server. Now, you need to use it in an example application.",Jt,N,ne="First, we need to install the <code>smolagents</code>, Gradio and mcp-client libraries, if we haven’t already:",Tt,W,Ut,q,ae="Now, we can import the necessary libraries and create a simple Gradio interface that uses the MCP Client to connect to the MCP Server.",gt,k,ft,x,ie="Next, we’ll connect to the MCP Server and get the tools that we can use to answer questions.",jt,Z,bt,R,oe="Now that we have the tools, we can create a simple agent that uses them to answer questions. We’ll just use a simple <code>InferenceClientModel</code> and the default model from <code>smolagents</code> for now.",It,H,pe='It is important to pass your api_key to the InferenceClientModel. You can access the token from your huggingface account. <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">check here.</a>, and set the access token with the environment variable  <code>HF_TOKEN</code>.',$t,S,Gt,E,Me="Now, we can create a simple Gradio interface that uses the agent to answer questions.",vt,V,Bt,_,ce="And that’s it! We’ve created a simple Gradio interface that uses the MCP Client to connect to the MCP Server and answer questions.",Qt,d,re,Nt,P,Wt,Y,me="Here’s the complete example of the usage of an MCP Client in Gradio:",qt,A,kt,z,ye="You’ll notice that we’re closing the MCP Client in the <code>finally</code> block. This is important because the MCP Client is a long-lived object that needs to be closed when the program exits.",xt,X,Zt,F,ue=`To make your server available to others, you can deploy it to Hugging Face Spaces, just like we did in the previous section.
To deploy your Gradio MCP client to Hugging Face Spaces:`,Rt,L,de="<li><p>Create a new Space on Hugging Face:</p> <ul><li>Go to huggingface.co/spaces</li> <li>Click “Create new Space”</li> <li>Choose “Gradio” as the SDK</li> <li>Name your space (e.g., “mcp-client”)</li></ul></li> <li><p>Update MCP Server URL in the code:</p></li>",Ht,D,St,T,we="<li>Create a <code>requirements.txt</code> file:</li>",Et,K,Vt,U,he="<li>Push your code to the Space:</li>",_t,O,Pt,tt,Ce='Note: While adding remote origin, Refer to <a href="https://huggingface.co/blog/password-git-deprecation" rel="nofollow">password-git-deprecation</a> for adding with AccessToken.',Yt,et,At,lt,Je="In this section, we’ve explored how to use Gradio as an MCP Client to connect to an MCP Server. We’ve also seen how to deploy the MCP Client in Hugging Face Spaces.",zt,st,Xt,it,Ft;return g=new nt({props:{title:"Gradio as an MCP Client",local:"gradio-as-an-mcp-client",headingTag:"h1"}}),b=new nt({props:{title:"MCP Client in Gradio",local:"mcp-client-in-gradio",headingTag:"h2"}}),I=new nt({props:{title:"Connect to an example MCP Server",local:"connect-to-an-example-mcp-server",headingTag:"h3"}}),G=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMubWNwX2NsaWVudCUyMGltcG9ydCUyME1DUENsaWVudCUwQSUwQXdpdGglMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZhYmlkbGFicy1tY3AtdG9vbC1odHRwLmhmLnNwYWNlJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnNzZSUyMiUyQyU3RCUwQSklMjBhcyUyMHRvb2xzJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVG9vbHMlMjBmcm9tJTIwdGhlJTIwcmVtb3RlJTIwc2VydmVyJTIwYXJlJTIwYXZhaWxhYmxlJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyJTVDbiUyMi5qb2luKGYlMjIlN0J0Lm5hbWUlN0QlM0ElMjAlN0J0LmRlc2NyaXB0aW9uJTdEJTIyJTIwZm9yJTIwdCUyMGluJTIwdG9vbHMpKSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents.mcp_client <span class="hljs-keyword">import</span> MCPClient

<span class="hljs-keyword">with</span> MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;sse&quot;</span>,}
) <span class="hljs-keyword">as</span> tools:
    <span class="hljs-comment"># Tools from the remote server are available</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n&quot;</span>.join(<span class="hljs-string">f&quot;<span class="hljs-subst">{t.name}</span>: <span class="hljs-subst">{t.description}</span>&quot;</span> <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> tools))
`,wrap:!1}}),B=new nt({props:{title:"Connect to the MCP Server from Gradio",local:"connect-to-the-mcp-server-from-gradio",headingTag:"h3"}}),W=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjIlMjAlMjJncmFkaW8lNUJtY3AlNUQlMjIlMjBtY3AlMjBmYXN0bWNw",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span> <span class="hljs-string">&quot;gradio[mcp]&quot;</span> mcp fastmcp',wrap:!1}}),k=new w({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMG9zJTBBJTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMjBDb2RlQWdlbnQlMkMlMjBUb29sQ29sbGVjdGlvbiUyQyUyME1DUENsaWVudA==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, ToolCollection, MCPClient`,wrap:!1}}),Z=new w({props:{code:"bWNwX2NsaWVudCUyMCUzRCUyME1DUENsaWVudCglMEElMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmFiaWRsYWJzLW1jcC10b29sLWh0dHAuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3NlJTIyJTJDJTdEJTIwJTIzJTIwVGhpcyUyMGlzJTIwdGhlJTIwTUNQJTIwQ2xpZW50JTIwd2UlMjBjcmVhdGVkJTIwaW4lMjB0aGUlMjBwcmV2aW91cyUyMHNlY3Rpb24lMEEpJTBBdG9vbHMlMjAlM0QlMjBtY3BfY2xpZW50LmdldF90b29scygp",highlighted:`mcp_client = MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;sse&quot;</span>,} <span class="hljs-comment"># This is the MCP Client we created in the previous section</span>
)
tools = mcp_client.get_tools()`,wrap:!1}}),S=new w({props:{code:"bW9kZWwlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCh0b2tlbiUzRG9zLmdldGVudiglMjJIRl9UT0tFTiUyMikpJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsKQ==",highlighted:`model = InferenceClientModel(token=os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>))
agent = CodeAgent(tools=[*tools], model=model)`,wrap:!1}}),V=new w({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkNoYXRJbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RsYW1iZGElMjBtZXNzYWdlJTJDJTIwaGlzdG9yeSUzQSUyMHN0cihhZ2VudC5ydW4obWVzc2FnZSkpJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMm1lc3NhZ2VzJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0QlNUIlMjJQcmltZSUyMGZhY3Rvcml6YXRpb24lMjBvZiUyMDY4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJBZ2VudCUyMHdpdGglMjBNQ1AlMjBUb29scyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMGlzJTIwYSUyMHNpbXBsZSUyMGFnZW50JTIwdGhhdCUyMHVzZXMlMjBNQ1AlMjB0b29scyUyMHRvJTIwYW5zd2VyJTIwcXVlc3Rpb25zLiUyMiUwQSklMEElMEFkZW1vLmxhdW5jaCgp",highlighted:`demo = gr.ChatInterface(
    fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    examples=[<span class="hljs-string">&quot;Prime factorization of 68&quot;</span>],
    title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
    description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>
)

demo.launch()`,wrap:!1}}),P=new nt({props:{title:"Complete Example",local:"complete-example",headingTag:"h2"}}),A=new w({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMG9zJTBBJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUyQyUyME1DUENsaWVudCUwQSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1jcF9jbGllbnQlMjAlM0QlMjBNQ1BDbGllbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZhYmlkbGFicy1tY3AtdG9vbC1odHRwLmhmLnNwYWNlJTJGZ3JhZGlvX2FwaSUyRm1jcCUyRnNzZSUyMiUyQyUyMCUyMnRyYW5zcG9ydCUyMiUzQSUyMCUyMnNzZSUyMiUyQyU3RCUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjB0b29scyUyMCUzRCUyMG1jcF9jbGllbnQuZ2V0X3Rvb2xzKCklMEElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKHRva2VuJTNEb3MuZ2V0ZW52KCUyMkhVR0dJTkdGQUNFX0FQSV9UT0tFTiUyMikpJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbHMlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJqc29uJTIyJTJDJTIwJTIyYXN0JTIyJTJDJTIwJTIydXJsbGliJTIyJTJDJTIwJTIyYmFzZTY0JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMGRlbW8lMjAlM0QlMjBnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuJTNEbGFtYmRhJTIwbWVzc2FnZSUyQyUyMGhpc3RvcnklM0ElMjBzdHIoYWdlbnQucnVuKG1lc3NhZ2UpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHR5cGUlM0QlMjJtZXNzYWdlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTIyQW5hbHl6ZSUyMHRoZSUyMHNlbnRpbWVudCUyMG9mJTIwdGhlJTIwZm9sbG93aW5nJTIwdGV4dCUyMCdUaGlzJTIwaXMlMjBhd2Vzb21lJyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyQWdlbnQlMjB3aXRoJTIwTUNQJTIwVG9vbHMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMlRoaXMlMjBpcyUyMGElMjBzaW1wbGUlMjBhZ2VudCUyMHRoYXQlMjB1c2VzJTIwTUNQJTIwdG9vbHMlMjB0byUyMGFuc3dlciUyMHF1ZXN0aW9ucy4lMjIlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVtby5sYXVuY2goKSUwQWZpbmFsbHklM0ElMEElMjAlMjAlMjAlMjBtY3BfY2xpZW50LmRpc2Nvbm5lY3QoKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent, MCPClient


<span class="hljs-keyword">try</span>:
    mcp_client = MCPClient(
        {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;sse&quot;</span>,}
    )
    tools = mcp_client.get_tools()

    model = InferenceClientModel(token=os.getenv(<span class="hljs-string">&quot;HUGGINGFACE_API_TOKEN&quot;</span>))
    agent = CodeAgent(tools=[*tools], model=model, additional_authorized_imports=[<span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;ast&quot;</span>, <span class="hljs-string">&quot;urllib&quot;</span>, <span class="hljs-string">&quot;base64&quot;</span>])

    demo = gr.ChatInterface(
        fn=<span class="hljs-keyword">lambda</span> message, history: <span class="hljs-built_in">str</span>(agent.run(message)),
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
        examples=[<span class="hljs-string">&quot;Analyze the sentiment of the following text &#x27;This is awesome&#x27;&quot;</span>],
        title=<span class="hljs-string">&quot;Agent with MCP Tools&quot;</span>,
        description=<span class="hljs-string">&quot;This is a simple agent that uses MCP tools to answer questions.&quot;</span>,
    )

    demo.launch()
<span class="hljs-keyword">finally</span>:
    mcp_client.disconnect()`,wrap:!1}}),X=new nt({props:{title:"Deploying to Hugging Face Spaces",local:"deploying-to-hugging-face-spaces",headingTag:"h2"}}),D=new w({props:{code:"bWNwX2NsaWVudCUyMCUzRCUyME1DUENsaWVudCglMEElMjAlMjAlMjAlMjAlN0IlMjJ1cmwlMjIlM0ElMjAlMjJodHRwcyUzQSUyRiUyRmFiaWRsYWJzLW1jcC10b29sLWh0dHAuaGYuc3BhY2UlMkZncmFkaW9fYXBpJTJGbWNwJTJGc3NlJTIyJTJDJTIwJTIydHJhbnNwb3J0JTIyJTNBJTIwJTIyc3NlJTIyJTdEJTBBKQ==",highlighted:`mcp_client = MCPClient(
    {<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://abidlabs-mcp-tool-http.hf.space/gradio_api/mcp/sse&quot;</span>, <span class="hljs-string">&quot;transport&quot;</span>: <span class="hljs-string">&quot;sse&quot;</span>}
)`,wrap:!1}}),K=new w({props:{code:"Z3JhZGlvJTVCbWNwJTVEJTBBc21vbGFnZW50cyU1Qm1jcCU1RA==",highlighted:`gradio[mcp]
smolagents[mcp]`,wrap:!1}}),O=new w({props:{code:"Z2l0JTIwaW5pdCUwQWdpdCUyMGFkZCUyMGFwcC5weSUyMHJlcXVpcmVtZW50cy50eHQlMEFnaXQlMjBjb21taXQlMjAtbSUyMCUyMkluaXRpYWwlMjBjb21taXQlMjIlMEFnaXQlMjByZW1vdGUlMjBhZGQlMjBvcmlnaW4lMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGWU9VUl9VU0VSTkFNRSUyRm1jcC1jbGllbnQlMEFnaXQlMjBwdXNoJTIwLXUlMjBvcmlnaW4lMjBtYWlu",highlighted:`git init
git add app.py requirements.txt
git commit -m <span class="hljs-string">&quot;Initial commit&quot;</span>
git remote add origin https://huggingface.co/spaces/YOUR_USERNAME/mcp-client
git push -u origin main`,wrap:!1}}),et=new nt({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),st=new Ge({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit2/gradio-client.mdx"}}),{c(){h=i("meta"),ot=n(),at=i("p"),pt=n(),M(g.$$.fragment),Mt=n(),f=i("p"),f.textContent=Kt,ct=n(),J=i("blockquote"),J.innerHTML=Ot,rt=n(),j=i("p"),j.textContent=te,mt=n(),M(b.$$.fragment),yt=n(),M(I.$$.fragment),ut=n(),$=i("p"),$.innerHTML=ee,dt=n(),M(G.$$.fragment),wt=n(),v=i("details"),v.innerHTML=le,ht=n(),M(B.$$.fragment),Ct=n(),Q=i("p"),Q.textContent=se,Jt=n(),N=i("p"),N.innerHTML=ne,Tt=n(),M(W.$$.fragment),Ut=n(),q=i("p"),q.textContent=ae,gt=n(),M(k.$$.fragment),ft=n(),x=i("p"),x.textContent=ie,jt=n(),M(Z.$$.fragment),bt=n(),R=i("p"),R.innerHTML=oe,It=n(),H=i("p"),H.innerHTML=pe,$t=n(),M(S.$$.fragment),Gt=n(),E=i("p"),E.textContent=Me,vt=n(),M(V.$$.fragment),Bt=n(),_=i("p"),_.textContent=ce,Qt=n(),d=i("iframe"),Nt=n(),M(P.$$.fragment),Wt=n(),Y=i("p"),Y.textContent=me,qt=n(),M(A.$$.fragment),kt=n(),z=i("p"),z.innerHTML=ye,xt=n(),M(X.$$.fragment),Zt=n(),F=i("p"),F.textContent=ue,Rt=n(),L=i("ol"),L.innerHTML=de,Ht=n(),M(D.$$.fragment),St=n(),T=i("ol"),T.innerHTML=we,Et=n(),M(K.$$.fragment),Vt=n(),U=i("ol"),U.innerHTML=he,_t=n(),M(O.$$.fragment),Pt=n(),tt=i("p"),tt.innerHTML=Ce,Yt=n(),M(et.$$.fragment),At=n(),lt=i("p"),lt.textContent=Je,zt=n(),M(st.$$.fragment),Xt=n(),it=i("p"),this.h()},l(t){const e=Ie("svelte-u9bgzb",document.head);h=o(e,"META",{name:!0,content:!0}),e.forEach(l),ot=a(t),at=o(t,"P",{}),Lt(at).forEach(l),pt=a(t),c(g.$$.fragment,t),Mt=a(t),f=o(t,"P",{"data-svelte-h":!0}),p(f)!=="svelte-dztswv"&&(f.textContent=Kt),ct=a(t),J=o(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(J)!=="svelte-1q3o4wm"&&(J.innerHTML=Ot),rt=a(t),j=o(t,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1kac943"&&(j.textContent=te),mt=a(t),c(b.$$.fragment,t),yt=a(t),c(I.$$.fragment,t),ut=a(t),$=o(t,"P",{"data-svelte-h":!0}),p($)!=="svelte-1p6tga3"&&($.innerHTML=ee),dt=a(t),c(G.$$.fragment,t),wt=a(t),v=o(t,"DETAILS",{"data-svelte-h":!0}),p(v)!=="svelte-gt14si"&&(v.innerHTML=le),ht=a(t),c(B.$$.fragment,t),Ct=a(t),Q=o(t,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1fjnzdl"&&(Q.textContent=se),Jt=a(t),N=o(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1pg66mb"&&(N.innerHTML=ne),Tt=a(t),c(W.$$.fragment,t),Ut=a(t),q=o(t,"P",{"data-svelte-h":!0}),p(q)!=="svelte-2tsitc"&&(q.textContent=ae),gt=a(t),c(k.$$.fragment,t),ft=a(t),x=o(t,"P",{"data-svelte-h":!0}),p(x)!=="svelte-d4u1me"&&(x.textContent=ie),jt=a(t),c(Z.$$.fragment,t),bt=a(t),R=o(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-jz01ce"&&(R.innerHTML=oe),It=a(t),H=o(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-c7bqxg"&&(H.innerHTML=pe),$t=a(t),c(S.$$.fragment,t),Gt=a(t),E=o(t,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ysi4z1"&&(E.textContent=Me),vt=a(t),c(V.$$.fragment,t),Bt=a(t),_=o(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1sa2kw9"&&(_.textContent=ce),Qt=a(t),d=o(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Lt(d).forEach(l),Nt=a(t),c(P.$$.fragment,t),Wt=a(t),Y=o(t,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1x4853p"&&(Y.textContent=me),qt=a(t),c(A.$$.fragment,t),kt=a(t),z=o(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1y1vlqe"&&(z.innerHTML=ye),xt=a(t),c(X.$$.fragment,t),Zt=a(t),F=o(t,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1kft0up"&&(F.textContent=ue),Rt=a(t),L=o(t,"OL",{"data-svelte-h":!0}),p(L)!=="svelte-39e5uy"&&(L.innerHTML=de),Ht=a(t),c(D.$$.fragment,t),St=a(t),T=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-4egqr5"&&(T.innerHTML=we),Et=a(t),c(K.$$.fragment,t),Vt=a(t),U=o(t,"OL",{start:!0,"data-svelte-h":!0}),p(U)!=="svelte-1x5eyx6"&&(U.innerHTML=he),_t=a(t),c(O.$$.fragment,t),Pt=a(t),tt=o(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-14w0gvi"&&(tt.innerHTML=Ce),Yt=a(t),c(et.$$.fragment,t),At=a(t),lt=o(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-b18oph"&&(lt.textContent=Je),zt=a(t),c(st.$$.fragment,t),Xt=a(t),it=o(t,"P",{}),Lt(it).forEach(l),this.h()},h(){C(h,"name","hf:doc:metadata"),C(h,"content",Be),C(J,"class","tip"),Ue(d.src,re="https://mcp-course-unit2-gradio-client.hf.space")||C(d,"src",re),C(d,"frameborder","0"),C(d,"width","850"),C(d,"height","450"),C(T,"start","3"),C(U,"start","4")},m(t,e){$e(document.head,h),s(t,ot,e),s(t,at,e),s(t,pt,e),r(g,t,e),s(t,Mt,e),s(t,f,e),s(t,ct,e),s(t,J,e),s(t,rt,e),s(t,j,e),s(t,mt,e),r(b,t,e),s(t,yt,e),r(I,t,e),s(t,ut,e),s(t,$,e),s(t,dt,e),r(G,t,e),s(t,wt,e),s(t,v,e),s(t,ht,e),r(B,t,e),s(t,Ct,e),s(t,Q,e),s(t,Jt,e),s(t,N,e),s(t,Tt,e),r(W,t,e),s(t,Ut,e),s(t,q,e),s(t,gt,e),r(k,t,e),s(t,ft,e),s(t,x,e),s(t,jt,e),r(Z,t,e),s(t,bt,e),s(t,R,e),s(t,It,e),s(t,H,e),s(t,$t,e),r(S,t,e),s(t,Gt,e),s(t,E,e),s(t,vt,e),r(V,t,e),s(t,Bt,e),s(t,_,e),s(t,Qt,e),s(t,d,e),s(t,Nt,e),r(P,t,e),s(t,Wt,e),s(t,Y,e),s(t,qt,e),r(A,t,e),s(t,kt,e),s(t,z,e),s(t,xt,e),r(X,t,e),s(t,Zt,e),s(t,F,e),s(t,Rt,e),s(t,L,e),s(t,Ht,e),r(D,t,e),s(t,St,e),s(t,T,e),s(t,Et,e),r(K,t,e),s(t,Vt,e),s(t,U,e),s(t,_t,e),r(O,t,e),s(t,Pt,e),s(t,tt,e),s(t,Yt,e),r(et,t,e),s(t,At,e),s(t,lt,e),s(t,zt,e),r(st,t,e),s(t,Xt,e),s(t,it,e),Ft=!0},p:ge,i(t){Ft||(m(g.$$.fragment,t),m(b.$$.fragment,t),m(I.$$.fragment,t),m(G.$$.fragment,t),m(B.$$.fragment,t),m(W.$$.fragment,t),m(k.$$.fragment,t),m(Z.$$.fragment,t),m(S.$$.fragment,t),m(V.$$.fragment,t),m(P.$$.fragment,t),m(A.$$.fragment,t),m(X.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(O.$$.fragment,t),m(et.$$.fragment,t),m(st.$$.fragment,t),Ft=!0)},o(t){y(g.$$.fragment,t),y(b.$$.fragment,t),y(I.$$.fragment,t),y(G.$$.fragment,t),y(B.$$.fragment,t),y(W.$$.fragment,t),y(k.$$.fragment,t),y(Z.$$.fragment,t),y(S.$$.fragment,t),y(V.$$.fragment,t),y(P.$$.fragment,t),y(A.$$.fragment,t),y(X.$$.fragment,t),y(D.$$.fragment,t),y(K.$$.fragment,t),y(O.$$.fragment,t),y(et.$$.fragment,t),y(st.$$.fragment,t),Ft=!1},d(t){t&&(l(ot),l(at),l(pt),l(Mt),l(f),l(ct),l(J),l(rt),l(j),l(mt),l(yt),l(ut),l($),l(dt),l(wt),l(v),l(ht),l(Ct),l(Q),l(Jt),l(N),l(Tt),l(Ut),l(q),l(gt),l(ft),l(x),l(jt),l(bt),l(R),l(It),l(H),l($t),l(Gt),l(E),l(vt),l(Bt),l(_),l(Qt),l(d),l(Nt),l(Wt),l(Y),l(qt),l(kt),l(z),l(xt),l(Zt),l(F),l(Rt),l(L),l(Ht),l(St),l(T),l(Et),l(Vt),l(U),l(_t),l(Pt),l(tt),l(Yt),l(At),l(lt),l(zt),l(Xt),l(it)),l(h),u(g,t),u(b,t),u(I,t),u(G,t),u(B,t),u(W,t),u(k,t),u(Z,t),u(S,t),u(V,t),u(P,t),u(A,t),u(X,t),u(D,t),u(K,t),u(O,t),u(et,t),u(st,t)}}}const Be='{"title":"Gradio as an MCP Client","local":"gradio-as-an-mcp-client","sections":[{"title":"MCP Client in Gradio","local":"mcp-client-in-gradio","sections":[{"title":"Connect to an example MCP Server","local":"connect-to-an-example-mcp-server","sections":[],"depth":3},{"title":"Connect to the MCP Server from Gradio","local":"connect-to-the-mcp-server-from-gradio","sections":[],"depth":3}],"depth":2},{"title":"Complete Example","local":"complete-example","sections":[],"depth":2},{"title":"Deploying to Hugging Face Spaces","local":"deploying-to-hugging-face-spaces","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Qe(Dt){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xe extends je{constructor(h){super(),be(this,h,Qe,ve,Te,{})}}export{xe as component};
