import{s as ms,n as As,o as bs}from"../chunks/scheduler.f7e1785c.js";import{S as gs,i as fs,g as a,s as n,r as p,A as Bs,h as i,f as s,c as M,j as hs,u as J,x as j,k as U,y as _s,a as e,v as y,d as r,t as o,w as T}from"../chunks/index.d8354395.js";import{C as w}from"../chunks/CodeBlock.191e5103.js";import{H as ml,E as Es}from"../chunks/getInferenceSnippets.a345c7e4.js";function Zs(kt){let c,gl,Al,fl,b,Bl,g,Gt="The MCP server is the heart of our Pull Request Agent. It provides the tools that our agent will use to interact with the Hugging Face Hub, specifically for reading and updating model repository tags. In this section, we’ll build the server using FastMCP and the Hugging Face Hub Python SDK.",_l,f,El,B,qt="Our MCP server provides two essential tools:",Zl,_,Nt="<thead><tr><th>Tool</th> <th>Description</th></tr></thead> <tbody><tr><td><code>get_current_tags</code></td> <td>Retrieves existing tags from a model repository</td></tr> <tr><td><code>add_new_tag</code></td> <td>Adds a new tag to a repository via pull request</td></tr></tbody>",vl,E,Qt="These tools abstract the complexity of Hub API interactions and provide a clean interface for our agent to work with.",Rl,Z,Ht='<img src="https://huggingface.co/datasets/mcp-course/images/resolve/main/unit3/architecture.png" alt="MCP Server Tools"/>',kl,v,Gl,R,Xt="Let’s create our <code>mcp_server.py</code> file step by step. We’ll build this incrementally so you understand each component and how they work together.",ql,k,Nl,G,Wt="First, let’s set up all the necessary imports and configuration.",Ql,q,Hl,N,Vt="The imports above give us everything we need to build our MCP server. <code>FastMCP</code> provides the server framework, while the <code>huggingface_hub</code> imports give us the tools to interact with model repositories.",Xl,Q,St="The <code>load_dotenv()</code> call automatically loads environment variables from a <code>.env</code> file, making it easy to manage secrets like API tokens during development.",Wl,u,Ft="<p>If you’re using uv, you can create a <code>.env</code> file in the root of the project and you won’t need to use <code>load_dotenv()</code> if you use <code>uv run</code> to run the server.</p>",Vl,H,xt="Next, we’ll configure our server with the necessary credentials and create the FastMCP instance:",Sl,X,Fl,W,$t="This configuration block does three important things:",xl,V,Yt="<li>Retrieves the Hugging Face token from environment variables</li> <li>Creates an authenticated API client (only if a token is available)</li> <li>Initializes our FastMCP server with a descriptive name</li>",$l,S,zt="The conditional creation of <code>hf_api</code> ensures our server can start even without a token, which is useful for testing the basic structure.",Yl,F,zl,x,Pt="Now let’s implement our first tool - <code>get_current_tags</code>. This tool retrieves the existing tags from a model repository:",Pl,$,Ll,Y,Lt="The function starts with validation - checking if we have an authenticated API client. Notice how we return JSON strings instead of Python objects. This is crucial for MCP communication.",Kl,d,Kt="<p>All MCP tools must return strings, not Python objects. That’s why we use <code>json.dumps()</code> to convert our results to JSON strings. This ensures reliable data exchange between the MCP server and client.</p>",Ol,z,Ot="Let’s continue with the main logic of the <code>get_current_tags</code> function:",Dl,P,lt,L,Dt="This implementation follows a clear pattern:",tt,K,ls="<li><strong>Fetch data</strong> using the Hugging Face Hub API</li> <li><strong>Process the response</strong> to extract tag information</li> <li><strong>Structure the result</strong> in a consistent JSON format</li> <li><strong>Handle errors gracefully</strong> with detailed error messages</li>",st,I,ts="<p>The extensive logging might seem overkill, but it helps with debugging and monitoring when the server is running. Remember, your application will autonomously reacting to events from the Hub, so you won’t be able to see the logs in real time.</p>",et,O,nt,D,ss="Now for the more complex tool - <code>add_new_tag</code>. This tool adds a new tag to a repository by creating a pull request. Let’s start with the initial setup and validation:",Mt,ll,at,tl,es="Similar to our first tool, we start with validation. Now let’s fetch the current repository state to check if the tag already exists:",it,sl,jt,el,ns="This section demonstrates an important principle: <strong>validate before acting</strong>. We check if the tag already exists to avoid creating unnecessary pull requests.",pt,C,Ms="<p>Always check the current state before making changes. This prevents duplicate work and provides better user feedback. It’s especially important when creating pull requests, as duplicate PRs can clutter the repository.</p>",Jt,nl,as="Next, we’ll prepare the updated tag list and handle the model card:",yt,Ml,rt,al,is="This section handles model card management. We try to load an existing model card first, but create a new one if none exists. This ensures our tool works with any repository, even if it’s empty.",ot,il,js="The model card (<code>README.md</code>) contains the repository metadata, including tags. By updating the model card data and creating a pull request, we’re following the standard Hugging Face workflow for metadata changes.",Tt,jl,ps="Now for the pull request creation - the main part of our tool:",wt,pl,ct,Jl,Js="We create a detailed pull request description that explains what’s changing and why. This transparency is crucial for repository maintainers who will review the PR.",Ut,h,ys="<p>Clear, detailed PR descriptions are essential for automated pull requests. They help repository maintainers understand what’s happening and make informed decisions about whether to merge the changes.</p> <p>Also, it’s good practice to clearly state that the PR is created by an automated tool. This helps repository maintainers understand how to deal with the PR.</p>",ut,yl,rs="Finally, we create the commit and pull request:",dt,rl,It,ol,os="The <code>create_commit</code> function with <code>create_pr=True</code> is the key to our automation. It creates a commit with the updated <code>README.md</code> file and automatically opens a pull request for review.",Ct,Tl,Ts="Don’t forget the error handling for this complex operation:",ht,wl,mt,cl,ws="The comprehensive error handling includes the full traceback, which is invaluable for debugging when things go wrong.",At,Ul,cs="Emojis in log messages might seem silly, but they make scanning logs much faster. 🔧 for function calls, 📡 for API requests, ✅ for success, and ❌ for errors create visual patterns that help you quickly find what you’re looking for.",bt,m,Us="<p>Whilst building this application, it’s easy to accidentally create an infinite loop of PRs. This is because the <code>create_commit</code> function with <code>create_pr=True</code> will create a PR for every commit. If the PR is not merged, the <code>create_commit</code> function will be called again, and again, and again…</p> <p>We’ve added checks to prevent this, but it’s something to be aware of.</p>",gt,ul,ft,dl,us="Now that we have our MCP server implemented with robust tagging tools, we need to:",Bt,Il,ds="<li><strong>Create the MCP Client</strong> - Build the interface between our agent and MCP server</li> <li><strong>Implement Webhook Handling</strong> - Listen for Hub discussion events</li> <li><strong>Integrate Agent Logic</strong> - Connect webhooks with MCP tool calls</li> <li><strong>Test the Complete System</strong> - Validate end-to-end functionality</li>",_t,Cl,Is="In the next section, we’ll create the MCP client that will allow our webhook handler to interact with these tools intelligently.",Et,A,Cs="<p>The MCP server runs as a separate process from your main application. This isolation provides better error handling and allows the server to be reused by multiple clients or applications.</p>",Zt,hl,vt,bl,Rt;return b=new ml({props:{title:"Creating the MCP Server",local:"creating-the-mcp-server",headingTag:"h1"}}),f=new ml({props:{title:"Understanding the MCP Server Architecture",local:"understanding-the-mcp-server-architecture",headingTag:"h2"}}),v=new ml({props:{title:"Complete MCP Server Implementation",local:"complete-mcp-server-implementation",headingTag:"h2"}}),k=new ml({props:{title:"1. Imports and Configuration",local:"1-imports-and-configuration",headingTag:"h3"}}),q=new w({props:{code:"JTIzISUyRnVzciUyRmJpbiUyRmVudiUyMHB5dGhvbjMlMEElMjIlMjIlMjIlMEFTaW1wbGlmaWVkJTIwTUNQJTIwU2VydmVyJTIwZm9yJTIwSHVnZ2luZ0ZhY2UlMjBIdWIlMjBUYWdnaW5nJTIwT3BlcmF0aW9ucyUyMHVzaW5nJTIwRmFzdE1DUCUwQSUyMiUyMiUyMiUwQSUwQWltcG9ydCUyMG9zJTBBaW1wb3J0JTIwanNvbiUwQWZyb20lMjBmYXN0bWNwJTIwaW1wb3J0JTIwRmFzdE1DUCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBIZkFwaSUyQyUyMG1vZGVsX2luZm8lMkMlMjBNb2RlbENhcmQlMkMlMjBNb2RlbENhcmREYXRhJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1Yi51dGlscyUyMGltcG9ydCUyMEhmSHViSFRUUEVycm9yJTBBZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBJTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-comment">#!/usr/bin/env python3</span>
<span class="hljs-string">&quot;&quot;&quot;
Simplified MCP Server for HuggingFace Hub Tagging Operations using FastMCP
&quot;&quot;&quot;</span>

<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> fastmcp <span class="hljs-keyword">import</span> FastMCP
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, model_info, ModelCard, ModelCardData
<span class="hljs-keyword">from</span> huggingface_hub.utils <span class="hljs-keyword">import</span> HfHubHTTPError
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()`,wrap:!1}}),X=new w({props:{code:"JTIzJTIwQ29uZmlndXJhdGlvbiUwQUhGX1RPS0VOJTIwJTNEJTIwb3MuZ2V0ZW52KCUyMkhGX1RPS0VOJTIyKSUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjBIRiUyMEFQSSUyMGNsaWVudCUwQWhmX2FwaSUyMCUzRCUyMEhmQXBpKHRva2VuJTNESEZfVE9LRU4pJTIwaWYlMjBIRl9UT0tFTiUyMGVsc2UlMjBOb25lJTBBJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwRmFzdE1DUCUyMHNlcnZlciUwQW1jcCUyMCUzRCUyMEZhc3RNQ1AoJTIyaGYtdGFnZ2luZy1ib3QlMjIp",highlighted:`<span class="hljs-comment"># Configuration</span>
HF_TOKEN = os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)

<span class="hljs-comment"># Initialize HF API client</span>
hf_api = HfApi(token=HF_TOKEN) <span class="hljs-keyword">if</span> HF_TOKEN <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>

<span class="hljs-comment"># Create the FastMCP server</span>
mcp = FastMCP(<span class="hljs-string">&quot;hf-tagging-bot&quot;</span>)`,wrap:!1}}),F=new ml({props:{title:"2. Get Current Tags Tool",local:"2-get-current-tags-tool",headingTag:"h3"}}),$=new w({props:{code:"JTQwbWNwLnRvb2woKSUwQWRlZiUyMGdldF9jdXJyZW50X3RhZ3MocmVwb19pZCUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2V0JTIwY3VycmVudCUyMHRhZ3MlMjBmcm9tJTIwYSUyMEh1Z2dpbmdGYWNlJTIwbW9kZWwlMjByZXBvc2l0b3J5JTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVGMCU5RiU5NCVBNyUyMGdldF9jdXJyZW50X3RhZ3MlMjBjYWxsZWQlMjB3aXRoJTIwcmVwb19pZCUzQSUyMCU3QnJlcG9faWQlN0QlMjIpJTBBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBoZl9hcGklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvcl9yZXN1bHQlMjAlM0QlMjAlN0IlMjJlcnJvciUyMiUzQSUyMCUyMkhGJTIwdG9rZW4lMjBub3QlMjBjb25maWd1cmVkJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwanNvbl9zdHIlMjAlM0QlMjBqc29uLmR1bXBzKGVycm9yX3Jlc3VsdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwTm8lMjBIRiUyMEFQSSUyMHRva2VuJTIwLSUyMHJldHVybmluZyUzQSUyMCU3Qmpzb25fc3RyJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGpzb25fc3Ry",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_tags</span>(<span class="hljs-params">repo_id: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Get current tags from a HuggingFace model repository&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔧 get_current_tags called with repo_id: <span class="hljs-subst">{repo_id}</span>&quot;</span>)

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> hf_api:
        error_result = {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;HF token not configured&quot;</span>}
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ No HF API token - returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),P=new w({props:{code:"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",highlighted:`    <span class="hljs-keyword">try</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📡 Fetching model info for: <span class="hljs-subst">{repo_id}</span>&quot;</span>)
        info = model_info(repo_id=repo_id, token=HF_TOKEN)
        current_tags = info.tags <span class="hljs-keyword">if</span> info.tags <span class="hljs-keyword">else</span> []
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ Found <span class="hljs-subst">{<span class="hljs-built_in">len</span>(current_tags)}</span> tags: <span class="hljs-subst">{current_tags}</span>&quot;</span>)

        result = {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;success&quot;</span>,
            <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
            <span class="hljs-string">&quot;current_tags&quot;</span>: current_tags,
            <span class="hljs-string">&quot;count&quot;</span>: <span class="hljs-built_in">len</span>(current_tags),
        }
        json_str = json.dumps(result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ get_current_tags returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str

    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error in get_current_tags: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
        error_result = {<span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>, <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id, <span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e)}
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ get_current_tags error returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),O=new ml({props:{title:"3. Add New Tag Tool",local:"3-add-new-tag-tool",headingTag:"h3"}}),ll=new w({props:{code:"JTQwbWNwLnRvb2woKSUwQWRlZiUyMGFkZF9uZXdfdGFnKHJlcG9faWQlM0ElMjBzdHIlMkMlMjBuZXdfdGFnJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJBZGQlMjBhJTIwbmV3JTIwdGFnJTIwdG8lMjBhJTIwSHVnZ2luZ0ZhY2UlMjBtb2RlbCUyMHJlcG9zaXRvcnklMjB2aWElMjBQUiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRjAlOUYlOTQlQTclMjBhZGRfbmV3X3RhZyUyMGNhbGxlZCUyMHdpdGglMjByZXBvX2lkJTNBJTIwJTdCcmVwb19pZCU3RCUyQyUyMG5ld190YWclM0ElMjAlN0JuZXdfdGFnJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwbm90JTIwaGZfYXBpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXJyb3JfcmVzdWx0JTIwJTNEJTIwJTdCJTIyZXJyb3IlMjIlM0ElMjAlMjJIRiUyMHRva2VuJTIwbm90JTIwY29uZmlndXJlZCUyMiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGpzb25fc3RyJTIwJTNEJTIwanNvbi5kdW1wcyhlcnJvcl9yZXN1bHQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyME5vJTIwSEYlMjBBUEklMjB0b2tlbiUyMC0lMjByZXR1cm5pbmclM0ElMjAlN0Jqc29uX3N0ciU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBqc29uX3N0cg==",highlighted:`<span class="hljs-meta">@mcp.tool()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_new_tag</span>(<span class="hljs-params">repo_id: <span class="hljs-built_in">str</span>, new_tag: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Add a new tag to a HuggingFace model repository via PR&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🔧 add_new_tag called with repo_id: <span class="hljs-subst">{repo_id}</span>, new_tag: <span class="hljs-subst">{new_tag}</span>&quot;</span>)

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> hf_api:
        error_result = {<span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-string">&quot;HF token not configured&quot;</span>}
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ No HF API token - returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),sl=new w({props:{code:"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",highlighted:`    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Get current model info and tags</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📡 Fetching current model info for: <span class="hljs-subst">{repo_id}</span>&quot;</span>)
        info = model_info(repo_id=repo_id, token=HF_TOKEN)
        current_tags = info.tags <span class="hljs-keyword">if</span> info.tags <span class="hljs-keyword">else</span> []
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ Current tags: <span class="hljs-subst">{current_tags}</span>&quot;</span>)

        <span class="hljs-comment"># Check if tag already exists</span>
        <span class="hljs-keyword">if</span> new_tag <span class="hljs-keyword">in</span> current_tags:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;⚠️ Tag &#x27;<span class="hljs-subst">{new_tag}</span>&#x27; already exists in <span class="hljs-subst">{current_tags}</span>&quot;</span>)
            result = {
                <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;already_exists&quot;</span>,
                <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
                <span class="hljs-string">&quot;tag&quot;</span>: new_tag,
                <span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">f&quot;Tag &#x27;<span class="hljs-subst">{new_tag}</span>&#x27; already exists&quot;</span>,
            }
            json_str = json.dumps(result)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🏷️ add_new_tag (already exists) returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
            <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),Ml=new w({props:{code:"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",highlighted:`        <span class="hljs-comment"># Add the new tag to existing tags</span>
        updated_tags = current_tags + [new_tag]
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🆕 Will update tags from <span class="hljs-subst">{current_tags}</span> to <span class="hljs-subst">{updated_tags}</span>&quot;</span>)

        <span class="hljs-comment"># Create model card content with updated tags</span>
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># Load existing model card</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📄 Loading existing model card...&quot;</span>)
            card = ModelCard.load(repo_id, token=HF_TOKEN)
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> <span class="hljs-built_in">hasattr</span>(card, <span class="hljs-string">&quot;data&quot;</span>) <span class="hljs-keyword">or</span> card.data <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
                card.data = ModelCardData()
        <span class="hljs-keyword">except</span> HfHubHTTPError:
            <span class="hljs-comment"># Create new model card if none exists</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;📄 Creating new model card (none exists)&quot;</span>)
            card = ModelCard(<span class="hljs-string">&quot;&quot;</span>)
            card.data = ModelCardData()

        <span class="hljs-comment"># Update tags - create new ModelCardData with updated tags</span>
        card_dict = card.data.to_dict()
        card_dict[<span class="hljs-string">&quot;tags&quot;</span>] = updated_tags
        card.data = ModelCardData(**card_dict)`,wrap:!1}}),pl=new w({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ3JlYXRlJTIwYSUyMHB1bGwlMjByZXF1ZXN0JTIwd2l0aCUyMHRoZSUyMHVwZGF0ZWQlMjBtb2RlbCUyMGNhcmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcl90aXRsZSUyMCUzRCUyMGYlMjJBZGQlMjAnJTdCbmV3X3RhZyU3RCclMjB0YWclMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcl9kZXNjcmlwdGlvbiUyMCUzRCUyMGYlMjIlMjIlMjIlMEElMjMlMjMlMjBBZGQlMjB0YWclM0ElMjAlN0JuZXdfdGFnJTdEJTBBJTBBVGhpcyUyMFBSJTIwYWRkcyUyMHRoZSUyMCU2MCU3Qm5ld190YWclN0QlNjAlMjB0YWclMjB0byUyMHRoZSUyMG1vZGVsJTIwcmVwb3NpdG9yeS4lMEElMEEqKkNoYW5nZXMlM0EqKiUwQS0lMjBBZGRlZCUyMCU2MCU3Qm5ld190YWclN0QlNjAlMjB0byUyMG1vZGVsJTIwdGFncyUwQS0lMjBVcGRhdGVkJTIwZnJvbSUyMCU3QmxlbihjdXJyZW50X3RhZ3MpJTdEJTIwdG8lMjAlN0JsZW4odXBkYXRlZF90YWdzKSU3RCUyMHRhZ3MlMEElMEEqKkN1cnJlbnQlMjB0YWdzJTNBKiolMjAlN0IlMjIlMkMlMjAlMjIuam9pbihjdXJyZW50X3RhZ3MpJTIwaWYlMjBjdXJyZW50X3RhZ3MlMjBlbHNlJTIwJTIyTm9uZSUyMiU3RCUwQSoqTmV3JTIwdGFncyUzQSoqJTIwJTdCJTIyJTJDJTIwJTIyLmpvaW4odXBkYXRlZF90YWdzKSU3RCUwQSUwQSVGMCU5RiVBNCU5NiUyMFRoaXMlMjBpcyUyMGElMjBwdWxsJTIwcmVxdWVzdCUyMGNyZWF0ZWQlMjBieSUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTIwVGFnZ2luZyUyMEJvdC4lMEElMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUYwJTlGJTlBJTgwJTIwQ3JlYXRpbmclMjBQUiUyMHdpdGglMjB0aXRsZSUzQSUyMCU3QnByX3RpdGxlJTdEJTIyKQ==",highlighted:`        <span class="hljs-comment"># Create a pull request with the updated model card</span>
        pr_title = <span class="hljs-string">f&quot;Add &#x27;<span class="hljs-subst">{new_tag}</span>&#x27; tag&quot;</span>
        pr_description = <span class="hljs-string">f&quot;&quot;&quot;
## Add tag: <span class="hljs-subst">{new_tag}</span>

This PR adds the \`<span class="hljs-subst">{new_tag}</span>\` tag to the model repository.

**Changes:**
- Added \`<span class="hljs-subst">{new_tag}</span>\` to model tags
- Updated from <span class="hljs-subst">{<span class="hljs-built_in">len</span>(current_tags)}</span> to <span class="hljs-subst">{<span class="hljs-built_in">len</span>(updated_tags)}</span> tags

**Current tags:** <span class="hljs-subst">{<span class="hljs-string">&quot;, &quot;</span>.join(current_tags) <span class="hljs-keyword">if</span> current_tags <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;None&quot;</span>}</span>
**New tags:** <span class="hljs-subst">{<span class="hljs-string">&quot;, &quot;</span>.join(updated_tags)}</span>

🤖 This is a pull request created by the Hugging Face Hub Tagging Bot.
&quot;&quot;&quot;</span>

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;🚀 Creating PR with title: <span class="hljs-subst">{pr_title}</span>&quot;</span>)`,wrap:!1}}),rl=new w({props:{code:"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",highlighted:`        <span class="hljs-comment"># Create commit with updated model card using CommitOperationAdd</span>
        <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> CommitOperationAdd

        commit_info = hf_api.create_commit(
            repo_id=repo_id,
            operations=[
                CommitOperationAdd(
                    path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>, path_or_fileobj=<span class="hljs-built_in">str</span>(card).encode(<span class="hljs-string">&quot;utf-8&quot;</span>)
                )
            ],
            commit_message=pr_title,
            commit_description=pr_description,
            token=HF_TOKEN,
            create_pr=<span class="hljs-literal">True</span>,
        )

        <span class="hljs-comment"># Extract PR URL from commit info</span>
        pr_url_attr = commit_info.pr_url
        pr_url = pr_url_attr <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(commit_info, <span class="hljs-string">&quot;pr_url&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-built_in">str</span>(commit_info)

        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ PR created successfully! URL: <span class="hljs-subst">{pr_url}</span>&quot;</span>)

        result = {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;success&quot;</span>,
            <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
            <span class="hljs-string">&quot;tag&quot;</span>: new_tag,
            <span class="hljs-string">&quot;pr_url&quot;</span>: pr_url,
            <span class="hljs-string">&quot;previous_tags&quot;</span>: current_tags,
            <span class="hljs-string">&quot;new_tags&quot;</span>: updated_tags,
            <span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">f&quot;Created PR to add tag &#x27;<span class="hljs-subst">{new_tag}</span>&#x27;&quot;</span>,
        }
        json_str = json.dumps(result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ add_new_tag success returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),wl=new w({props:{code:"JTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyMEVycm9yJTIwaW4lMjBhZGRfbmV3X3RhZyUzQSUyMCU3QnN0cihlKSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwRXJyb3IlMjB0eXBlJTNBJTIwJTdCdHlwZShlKSU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbXBvcnQlMjB0cmFjZWJhY2slMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwVHJhY2ViYWNrJTNBJTIwJTdCdHJhY2ViYWNrLmZvcm1hdF9leGMoKSU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlcnJvcl9yZXN1bHQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzdGF0dXMlMjIlM0ElMjAlMjJlcnJvciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcG9faWQlMjIlM0ElMjByZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGFnJTIyJTNBJTIwbmV3X3RhZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVycm9yJTIyJTNBJTIwc3RyKGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwanNvbl9zdHIlMjAlM0QlMjBqc29uLmR1bXBzKGVycm9yX3Jlc3VsdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyJUUyJTlEJThDJTIwYWRkX25ld190YWclMjBlcnJvciUyMHJldHVybmluZyUzQSUyMCU3Qmpzb25fc3RyJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGpzb25fc3Ry",highlighted:`    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error in add_new_tag: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Error type: <span class="hljs-subst">{<span class="hljs-built_in">type</span>(e)}</span>&quot;</span>)
        <span class="hljs-keyword">import</span> traceback
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Traceback: <span class="hljs-subst">{traceback.format_exc()}</span>&quot;</span>)

        error_result = {
            <span class="hljs-string">&quot;status&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>,
            <span class="hljs-string">&quot;repo_id&quot;</span>: repo_id,
            <span class="hljs-string">&quot;tag&quot;</span>: new_tag,
            <span class="hljs-string">&quot;error&quot;</span>: <span class="hljs-built_in">str</span>(e),
        }
        json_str = json.dumps(error_result)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ add_new_tag error returning: <span class="hljs-subst">{json_str}</span>&quot;</span>)
        <span class="hljs-keyword">return</span> json_str`,wrap:!1}}),ul=new ml({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),hl=new Es({props:{source:"https://github.com/huggingface/mcp-course/blob/main/units/en/unit3_1/creating-the-mcp-server.mdx"}}),{c(){c=a("meta"),gl=n(),Al=a("p"),fl=n(),p(b.$$.fragment),Bl=n(),g=a("p"),g.textContent=Gt,_l=n(),p(f.$$.fragment),El=n(),B=a("p"),B.textContent=qt,Zl=n(),_=a("table"),_.innerHTML=Nt,vl=n(),E=a("p"),E.textContent=Qt,Rl=n(),Z=a("p"),Z.innerHTML=Ht,kl=n(),p(v.$$.fragment),Gl=n(),R=a("p"),R.innerHTML=Xt,ql=n(),p(k.$$.fragment),Nl=n(),G=a("p"),G.textContent=Wt,Ql=n(),p(q.$$.fragment),Hl=n(),N=a("p"),N.innerHTML=Vt,Xl=n(),Q=a("p"),Q.innerHTML=St,Wl=n(),u=a("blockquote"),u.innerHTML=Ft,Vl=n(),H=a("p"),H.textContent=xt,Sl=n(),p(X.$$.fragment),Fl=n(),W=a("p"),W.textContent=$t,xl=n(),V=a("ol"),V.innerHTML=Yt,$l=n(),S=a("p"),S.innerHTML=zt,Yl=n(),p(F.$$.fragment),zl=n(),x=a("p"),x.innerHTML=Pt,Pl=n(),p($.$$.fragment),Ll=n(),Y=a("p"),Y.textContent=Lt,Kl=n(),d=a("blockquote"),d.innerHTML=Kt,Ol=n(),z=a("p"),z.innerHTML=Ot,Dl=n(),p(P.$$.fragment),lt=n(),L=a("p"),L.textContent=Dt,tt=n(),K=a("ol"),K.innerHTML=ls,st=n(),I=a("blockquote"),I.innerHTML=ts,et=n(),p(O.$$.fragment),nt=n(),D=a("p"),D.innerHTML=ss,Mt=n(),p(ll.$$.fragment),at=n(),tl=a("p"),tl.textContent=es,it=n(),p(sl.$$.fragment),jt=n(),el=a("p"),el.innerHTML=ns,pt=n(),C=a("blockquote"),C.innerHTML=Ms,Jt=n(),nl=a("p"),nl.textContent=as,yt=n(),p(Ml.$$.fragment),rt=n(),al=a("p"),al.textContent=is,ot=n(),il=a("p"),il.innerHTML=js,Tt=n(),jl=a("p"),jl.textContent=ps,wt=n(),p(pl.$$.fragment),ct=n(),Jl=a("p"),Jl.textContent=Js,Ut=n(),h=a("blockquote"),h.innerHTML=ys,ut=n(),yl=a("p"),yl.textContent=rs,dt=n(),p(rl.$$.fragment),It=n(),ol=a("p"),ol.innerHTML=os,Ct=n(),Tl=a("p"),Tl.textContent=Ts,ht=n(),p(wl.$$.fragment),mt=n(),cl=a("p"),cl.textContent=ws,At=n(),Ul=a("p"),Ul.textContent=cs,bt=n(),m=a("blockquote"),m.innerHTML=Us,gt=n(),p(ul.$$.fragment),ft=n(),dl=a("p"),dl.textContent=us,Bt=n(),Il=a("ol"),Il.innerHTML=ds,_t=n(),Cl=a("p"),Cl.textContent=Is,Et=n(),A=a("blockquote"),A.innerHTML=Cs,Zt=n(),p(hl.$$.fragment),vt=n(),bl=a("p"),this.h()},l(l){const t=Bs("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(s),gl=M(l),Al=i(l,"P",{}),hs(Al).forEach(s),fl=M(l),J(b.$$.fragment,l),Bl=M(l),g=i(l,"P",{"data-svelte-h":!0}),j(g)!=="svelte-uvjoow"&&(g.textContent=Gt),_l=M(l),J(f.$$.fragment,l),El=M(l),B=i(l,"P",{"data-svelte-h":!0}),j(B)!=="svelte-rspfcm"&&(B.textContent=qt),Zl=M(l),_=i(l,"TABLE",{"data-svelte-h":!0}),j(_)!=="svelte-1p7818e"&&(_.innerHTML=Nt),vl=M(l),E=i(l,"P",{"data-svelte-h":!0}),j(E)!=="svelte-1ca0hup"&&(E.textContent=Qt),Rl=M(l),Z=i(l,"P",{"data-svelte-h":!0}),j(Z)!=="svelte-1fb34pj"&&(Z.innerHTML=Ht),kl=M(l),J(v.$$.fragment,l),Gl=M(l),R=i(l,"P",{"data-svelte-h":!0}),j(R)!=="svelte-1eluyaj"&&(R.innerHTML=Xt),ql=M(l),J(k.$$.fragment,l),Nl=M(l),G=i(l,"P",{"data-svelte-h":!0}),j(G)!=="svelte-oahagw"&&(G.textContent=Wt),Ql=M(l),J(q.$$.fragment,l),Hl=M(l),N=i(l,"P",{"data-svelte-h":!0}),j(N)!=="svelte-1gu0b91"&&(N.innerHTML=Vt),Xl=M(l),Q=i(l,"P",{"data-svelte-h":!0}),j(Q)!=="svelte-1bq6ctf"&&(Q.innerHTML=St),Wl=M(l),u=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(u)!=="svelte-10ylfcr"&&(u.innerHTML=Ft),Vl=M(l),H=i(l,"P",{"data-svelte-h":!0}),j(H)!=="svelte-18ddhqu"&&(H.textContent=xt),Sl=M(l),J(X.$$.fragment,l),Fl=M(l),W=i(l,"P",{"data-svelte-h":!0}),j(W)!=="svelte-1l74eyb"&&(W.textContent=$t),xl=M(l),V=i(l,"OL",{"data-svelte-h":!0}),j(V)!=="svelte-g7kq79"&&(V.innerHTML=Yt),$l=M(l),S=i(l,"P",{"data-svelte-h":!0}),j(S)!=="svelte-1bebu4l"&&(S.innerHTML=zt),Yl=M(l),J(F.$$.fragment,l),zl=M(l),x=i(l,"P",{"data-svelte-h":!0}),j(x)!=="svelte-1bxgraq"&&(x.innerHTML=Pt),Pl=M(l),J($.$$.fragment,l),Ll=M(l),Y=i(l,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-2sryu1"&&(Y.textContent=Lt),Kl=M(l),d=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(d)!=="svelte-5xu689"&&(d.innerHTML=Kt),Ol=M(l),z=i(l,"P",{"data-svelte-h":!0}),j(z)!=="svelte-1i6wv7j"&&(z.innerHTML=Ot),Dl=M(l),J(P.$$.fragment,l),lt=M(l),L=i(l,"P",{"data-svelte-h":!0}),j(L)!=="svelte-1rirk6u"&&(L.textContent=Dt),tt=M(l),K=i(l,"OL",{"data-svelte-h":!0}),j(K)!=="svelte-11qcjr4"&&(K.innerHTML=ls),st=M(l),I=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(I)!=="svelte-1i9t46e"&&(I.innerHTML=ts),et=M(l),J(O.$$.fragment,l),nt=M(l),D=i(l,"P",{"data-svelte-h":!0}),j(D)!=="svelte-2o9hbl"&&(D.innerHTML=ss),Mt=M(l),J(ll.$$.fragment,l),at=M(l),tl=i(l,"P",{"data-svelte-h":!0}),j(tl)!=="svelte-1ak2j0g"&&(tl.textContent=es),it=M(l),J(sl.$$.fragment,l),jt=M(l),el=i(l,"P",{"data-svelte-h":!0}),j(el)!=="svelte-1uivw0h"&&(el.innerHTML=ns),pt=M(l),C=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(C)!=="svelte-jpefiu"&&(C.innerHTML=Ms),Jt=M(l),nl=i(l,"P",{"data-svelte-h":!0}),j(nl)!=="svelte-msey30"&&(nl.textContent=as),yt=M(l),J(Ml.$$.fragment,l),rt=M(l),al=i(l,"P",{"data-svelte-h":!0}),j(al)!=="svelte-1kdlnhk"&&(al.textContent=is),ot=M(l),il=i(l,"P",{"data-svelte-h":!0}),j(il)!=="svelte-10h6um9"&&(il.innerHTML=js),Tt=M(l),jl=i(l,"P",{"data-svelte-h":!0}),j(jl)!=="svelte-11alcrg"&&(jl.textContent=ps),wt=M(l),J(pl.$$.fragment,l),ct=M(l),Jl=i(l,"P",{"data-svelte-h":!0}),j(Jl)!=="svelte-i1wizk"&&(Jl.textContent=Js),Ut=M(l),h=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(h)!=="svelte-1rr2eq2"&&(h.innerHTML=ys),ut=M(l),yl=i(l,"P",{"data-svelte-h":!0}),j(yl)!=="svelte-1inz0c2"&&(yl.textContent=rs),dt=M(l),J(rl.$$.fragment,l),It=M(l),ol=i(l,"P",{"data-svelte-h":!0}),j(ol)!=="svelte-1h6ylhu"&&(ol.innerHTML=os),Ct=M(l),Tl=i(l,"P",{"data-svelte-h":!0}),j(Tl)!=="svelte-4necmz"&&(Tl.textContent=Ts),ht=M(l),J(wl.$$.fragment,l),mt=M(l),cl=i(l,"P",{"data-svelte-h":!0}),j(cl)!=="svelte-936lbc"&&(cl.textContent=ws),At=M(l),Ul=i(l,"P",{"data-svelte-h":!0}),j(Ul)!=="svelte-12xaqb8"&&(Ul.textContent=cs),bt=M(l),m=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(m)!=="svelte-1046170"&&(m.innerHTML=Us),gt=M(l),J(ul.$$.fragment,l),ft=M(l),dl=i(l,"P",{"data-svelte-h":!0}),j(dl)!=="svelte-14cp6w2"&&(dl.textContent=us),Bt=M(l),Il=i(l,"OL",{"data-svelte-h":!0}),j(Il)!=="svelte-1vffloe"&&(Il.innerHTML=ds),_t=M(l),Cl=i(l,"P",{"data-svelte-h":!0}),j(Cl)!=="svelte-lcr1e1"&&(Cl.textContent=Is),Et=M(l),A=i(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),j(A)!=="svelte-1yj7rav"&&(A.innerHTML=Cs),Zt=M(l),J(hl.$$.fragment,l),vt=M(l),bl=i(l,"P",{}),hs(bl).forEach(s),this.h()},h(){U(c,"name","hf:doc:metadata"),U(c,"content",vs),U(u,"class","tip"),U(d,"class","tip"),U(I,"class","tip"),U(C,"class","tip"),U(h,"class","tip"),U(m,"class","tip"),U(A,"class","tip")},m(l,t){_s(document.head,c),e(l,gl,t),e(l,Al,t),e(l,fl,t),y(b,l,t),e(l,Bl,t),e(l,g,t),e(l,_l,t),y(f,l,t),e(l,El,t),e(l,B,t),e(l,Zl,t),e(l,_,t),e(l,vl,t),e(l,E,t),e(l,Rl,t),e(l,Z,t),e(l,kl,t),y(v,l,t),e(l,Gl,t),e(l,R,t),e(l,ql,t),y(k,l,t),e(l,Nl,t),e(l,G,t),e(l,Ql,t),y(q,l,t),e(l,Hl,t),e(l,N,t),e(l,Xl,t),e(l,Q,t),e(l,Wl,t),e(l,u,t),e(l,Vl,t),e(l,H,t),e(l,Sl,t),y(X,l,t),e(l,Fl,t),e(l,W,t),e(l,xl,t),e(l,V,t),e(l,$l,t),e(l,S,t),e(l,Yl,t),y(F,l,t),e(l,zl,t),e(l,x,t),e(l,Pl,t),y($,l,t),e(l,Ll,t),e(l,Y,t),e(l,Kl,t),e(l,d,t),e(l,Ol,t),e(l,z,t),e(l,Dl,t),y(P,l,t),e(l,lt,t),e(l,L,t),e(l,tt,t),e(l,K,t),e(l,st,t),e(l,I,t),e(l,et,t),y(O,l,t),e(l,nt,t),e(l,D,t),e(l,Mt,t),y(ll,l,t),e(l,at,t),e(l,tl,t),e(l,it,t),y(sl,l,t),e(l,jt,t),e(l,el,t),e(l,pt,t),e(l,C,t),e(l,Jt,t),e(l,nl,t),e(l,yt,t),y(Ml,l,t),e(l,rt,t),e(l,al,t),e(l,ot,t),e(l,il,t),e(l,Tt,t),e(l,jl,t),e(l,wt,t),y(pl,l,t),e(l,ct,t),e(l,Jl,t),e(l,Ut,t),e(l,h,t),e(l,ut,t),e(l,yl,t),e(l,dt,t),y(rl,l,t),e(l,It,t),e(l,ol,t),e(l,Ct,t),e(l,Tl,t),e(l,ht,t),y(wl,l,t),e(l,mt,t),e(l,cl,t),e(l,At,t),e(l,Ul,t),e(l,bt,t),e(l,m,t),e(l,gt,t),y(ul,l,t),e(l,ft,t),e(l,dl,t),e(l,Bt,t),e(l,Il,t),e(l,_t,t),e(l,Cl,t),e(l,Et,t),e(l,A,t),e(l,Zt,t),y(hl,l,t),e(l,vt,t),e(l,bl,t),Rt=!0},p:As,i(l){Rt||(r(b.$$.fragment,l),r(f.$$.fragment,l),r(v.$$.fragment,l),r(k.$$.fragment,l),r(q.$$.fragment,l),r(X.$$.fragment,l),r(F.$$.fragment,l),r($.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(ll.$$.fragment,l),r(sl.$$.fragment,l),r(Ml.$$.fragment,l),r(pl.$$.fragment,l),r(rl.$$.fragment,l),r(wl.$$.fragment,l),r(ul.$$.fragment,l),r(hl.$$.fragment,l),Rt=!0)},o(l){o(b.$$.fragment,l),o(f.$$.fragment,l),o(v.$$.fragment,l),o(k.$$.fragment,l),o(q.$$.fragment,l),o(X.$$.fragment,l),o(F.$$.fragment,l),o($.$$.fragment,l),o(P.$$.fragment,l),o(O.$$.fragment,l),o(ll.$$.fragment,l),o(sl.$$.fragment,l),o(Ml.$$.fragment,l),o(pl.$$.fragment,l),o(rl.$$.fragment,l),o(wl.$$.fragment,l),o(ul.$$.fragment,l),o(hl.$$.fragment,l),Rt=!1},d(l){l&&(s(gl),s(Al),s(fl),s(Bl),s(g),s(_l),s(El),s(B),s(Zl),s(_),s(vl),s(E),s(Rl),s(Z),s(kl),s(Gl),s(R),s(ql),s(Nl),s(G),s(Ql),s(Hl),s(N),s(Xl),s(Q),s(Wl),s(u),s(Vl),s(H),s(Sl),s(Fl),s(W),s(xl),s(V),s($l),s(S),s(Yl),s(zl),s(x),s(Pl),s(Ll),s(Y),s(Kl),s(d),s(Ol),s(z),s(Dl),s(lt),s(L),s(tt),s(K),s(st),s(I),s(et),s(nt),s(D),s(Mt),s(at),s(tl),s(it),s(jt),s(el),s(pt),s(C),s(Jt),s(nl),s(yt),s(rt),s(al),s(ot),s(il),s(Tt),s(jl),s(wt),s(ct),s(Jl),s(Ut),s(h),s(ut),s(yl),s(dt),s(It),s(ol),s(Ct),s(Tl),s(ht),s(mt),s(cl),s(At),s(Ul),s(bt),s(m),s(gt),s(ft),s(dl),s(Bt),s(Il),s(_t),s(Cl),s(Et),s(A),s(Zt),s(vt),s(bl)),s(c),T(b,l),T(f,l),T(v,l),T(k,l),T(q,l),T(X,l),T(F,l),T($,l),T(P,l),T(O,l),T(ll,l),T(sl,l),T(Ml,l),T(pl,l),T(rl,l),T(wl,l),T(ul,l),T(hl,l)}}}const vs='{"title":"Creating the MCP Server","local":"creating-the-mcp-server","sections":[{"title":"Understanding the MCP Server Architecture","local":"understanding-the-mcp-server-architecture","sections":[],"depth":2},{"title":"Complete MCP Server Implementation","local":"complete-mcp-server-implementation","sections":[{"title":"1. Imports and Configuration","local":"1-imports-and-configuration","sections":[],"depth":3},{"title":"2. Get Current Tags Tool","local":"2-get-current-tags-tool","sections":[],"depth":3},{"title":"3. Add New Tag Tool","local":"3-add-new-tag-tool","sections":[],"depth":3}],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Rs(kt){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qs extends gs{constructor(c){super(),fs(this,c,Rs,Zs,ms,{})}}export{Qs as component};
