import{s as rn,o as hn,n as on}from"../chunks/scheduler.9bc65507.js";import{S as yn,i as Jn,g as p,s as e,r as j,A as un,h as M,f as l,c as t,j as mn,u as m,x as c,k as Jl,y as Un,a as n,v as i,d as r,t as h,w as o}from"../chunks/index.707bf1b6.js";import{T as bn}from"../chunks/Tip.c2ecdbf4.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{D as Tn}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as qs,E as wn}from"../chunks/EditOnGithub.922df6ba.js";function dn($s){let J,w='このタスクと互換性のあるすべてのアーキテクチャとチェックポイントを確認するには、<a href="https://huggingface.co/tasks/object-detection" rel="nofollow">タスクページ</a> を確認することをお勧めします。';return{c(){J=p("p"),J.innerHTML=w},l(u){J=M(u,"P",{"data-svelte-h":!0}),c(J)!=="svelte-119id0v"&&(J.innerHTML=w)},m(u,Ys){n(u,J,Ys)},p:on,d(u){u&&l(J)}}}function gn($s){let J,w,u,Ys,d,Hs,g,zs,I,ul=`オブジェクト検出は、画像内のインスタンス (人間、建物、車など) を検出するコンピューター ビジョン タスクです。物体検出モデルは画像を入力および出力として受け取ります
検出されたオブジェクトの境界ボックスと関連するラベルの座標。画像には複数のオブジェクトを含めることができます。
それぞれに独自の境界ボックスとラベルがあり (例: 車と建物を持つことができます)、各オブジェクトは
画像のさまざまな部分に存在する必要があります (たとえば、画像には複数の車が含まれている可能性があります)。
このタスクは、歩行者、道路標識、信号機などを検出するために自動運転で一般的に使用されます。
他のアプリケーションには、画像内のオブジェクトのカウント、画像検索などが含まれます。`,Ss,C,Ul="このガイドでは、次の方法を学習します。",Ds,f,bl=`<li>Finetune <a href="https://huggingface.co/docs/transformers/model_doc/detr" rel="nofollow">DETR</a>、畳み込みアルゴリズムを組み合わせたモデル
<a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5</a> 上のエンコーダー/デコーダー トランスフォーマーを備えたバックボーン
データセット。</li> <li>微調整したモデルを推論に使用します。</li>`,Ls,U,Ps,Z,Tl="始める前に、必要なライブラリがすべてインストールされていることを確認してください。",Ks,_,Os,A,wl=`🤗 データセットを使用して Hugging Face Hub からデータセットをロードし、🤗 トランスフォーマーを使用してモデルをトレーニングします。
データを増強するための<code>albumentations</code>。 <code>timm</code> は現在、DETR モデルの畳み込みバックボーンをロードするために必要です。`,sa,G,dl=`モデルをコミュニティと共有することをお勧めします。 Hugging Face アカウントにログインして、ハブにアップロードします。
プロンプトが表示されたら、トークンを入力してログインします。`,aa,B,la,W,na,R,gl=`<a href="https://huggingface.co/datasets/cppe-5" rel="nofollow">CPPE-5 データセット</a> には、次の画像が含まれています。
新型コロナウイルス感染症のパンデミックにおける医療用個人保護具 (PPE) を識別する注釈。`,ea,v,Il="データセットをロードすることから始めます。",ta,Q,pa,x,Cl="このデータセットには、1000 枚の画像を含むトレーニング セットと 29 枚の画像を含むテスト セットがすでに付属していることがわかります。",Ma,k,fl="データに慣れるために、例がどのようなものかを調べてください。",ca,V,ja,E,Zl="データセット内の例には次のフィールドがあります。",ma,X,_l='<li><code>image_id</code>: サンプルの画像ID</li> <li><code>image</code>: 画像を含む <code>PIL.Image.Image</code> オブジェクト</li> <li><code>width</code>: 画像の幅</li> <li><code>height</code>: 画像の高さ</li> <li><code>objects</code>: 画像内のオブジェクトの境界ボックスのメタデータを含む辞書:<ul><li><code>id</code>: アノテーションID</li> <li><code>area</code>: 境界ボックスの領域</li> <li><code>bbox</code>: オブジェクトの境界ボックス (<a href="https://albumentations.ai/docs/getting_started/bounding_boxes_augmentation/#coco" rel="nofollow">COCO 形式</a> )</li> <li><code>category</code>: オブジェクトのカテゴリー。可能な値には、<code>Coverall (0)</code>、<code>Face_Shield (1)</code>、<code>Gloves (2)</code>、<code>Goggles (3)</code>、および <code>Mask (4)</code> が含まれます。</li></ul></li>',ia,N,Al=`<code>bbox</code>フィールドが COCO 形式に従っていることに気づくかもしれません。これは DETR モデルが予期する形式です。
ただし、「オブジェクト」内のフィールドのグループ化は、DETR が必要とする注釈形式とは異なります。あなたはするであろう
このデータをトレーニングに使用する前に、いくつかの前処理変換を適用する必要があります。`,ra,Y,Gl="データをさらに深く理解するには、データセット内の例を視覚化します。",ha,q,oa,b,Bl='<img src="https://i.imgur.com/TdaqPJO.png" alt="CPPE-5 Image Example"/>',ya,F,Wl=`関連付けられたラベルを使用して境界ボックスを視覚化するには、データセットのメタデータからラベルを取得します。
<code>category</code>フィールド。
また、ラベル ID をラベル クラスにマッピングする辞書 (<code>id2label</code>) やその逆 (<code>label2id</code>) を作成することもできます。
これらは、後でモデルをセットアップするときに使用できます。これらのマップを含めると、共有した場合に他の人がモデルを再利用できるようになります。
ハグフェイスハブに取り付けます。`,Ja,$,Rl=`データに慣れるための最後のステップとして、潜在的な問題がないかデータを調査します。データセットに関する一般的な問題の 1 つは、
オブジェクト検出は、画像の端を越えて「伸びる」境界ボックスです。このような「暴走」境界ボックスは、
トレーニング中にエラーが発生するため、この段階で対処する必要があります。このデータセットには、この問題に関する例がいくつかあります。
このガイドでは内容をわかりやすくするために、これらの画像をデータから削除します。`,ua,H,Ua,z,ba,S,vl=`モデルを微調整するには、事前トレーニングされたモデルに使用されるアプローチと正確に一致するように、使用する予定のデータを前処理する必要があります。
<a href="/docs/transformers/pr_30621/ja/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> は、画像データを処理して <code>pixel_values</code>、<code>pixel_mask</code>、および
DETR モデルをトレーニングできる「ラベル」。画像プロセッサには、心配する必要のないいくつかの属性があります。`,Ta,D,Ql="<li><code>image_mean = [0.485, 0.456, 0.406 ]</code></li> <li><code>image_std = [0.229, 0.224, 0.225]</code></li>",wa,L,xl=`これらは、モデルの事前トレーニング中に画像を正規化するために使用される平均と標準偏差です。これらの価値観は非常に重要です
事前にトレーニングされた画像モデルを推論または微調整するときに複製します。`,da,P,kl="微調整するモデルと同じチェックポイントからイメージ プロセッサをインスタンス化します。",ga,K,Ia,O,Vl="画像を<code>image_processor</code>に渡す前に、2 つの前処理変換をデータセットに適用します。",Ca,ss,El="<li>画像の拡張</li> <li>DETR の期待に応えるための注釈の再フォーマット</li>",fa,as,Xl=`まず、モデルがトレーニング データにオーバーフィットしないようにするために、任意のデータ拡張ライブラリを使用して画像拡張を適用できます。ここでは<a href="https://albumentations.ai/docs/" rel="nofollow">Albumentations</a>を使用します…
このライブラリは、変換が画像に影響を与え、それに応じて境界ボックスを更新することを保証します。
🤗 データセット ライブラリのドキュメントには、詳細な <a href="https://huggingface.co/docs/datasets/object_detection" rel="nofollow">物体検出用に画像を拡張する方法に関するガイド</a> が記載されています。
例としてまったく同じデータセットを使用しています。ここでも同じアプローチを適用し、各画像のサイズを (480, 480) に変更します。
水平に反転して明るくします。`,Za,ls,_a,ns,Nl=`<code>image_processor</code> は、注釈が次の形式であることを期待します: <code>{&#39;image_id&#39;: int, &#39;annotations&#39;: List[Dict]}</code>,
ここで、各辞書は COCO オブジェクトの注釈です。 1 つの例として、注釈を再フォーマットする関数を追加してみましょう。`,Aa,es,Ga,ts,Yl="これで、画像と注釈の変換を組み合わせてサンプルのバッチで使用できるようになりました。",Ba,ps,Wa,Ms,ql=`🤗 Datasets <code>with_transform</code> メソッドを使用して、この前処理関数をデータセット全体に適用します。この方法が適用されるのは、
データセットの要素を読み込むときに、その場で変換します。`,Ra,cs,Fl=`この時点で、データセットの例が変換後にどのようになるかを確認できます。テンソルが表示されるはずです
<code>pixel_values</code>、テンソルと <code>pixel_mask</code>、および <code>labels</code> を使用します。`,va,js,Qa,ms,$l=`個々の画像を正常に拡張し、それらの注釈を準備しました。ただし、前処理はそうではありません。
まだ完成しています。最後のステップでは、画像をバッチ処理するためのカスタム <code>collat​​e_fn</code> を作成します。
画像 (現在は <code>pixel_values</code>) をバッチ内の最大の画像にパディングし、対応する <code>pixel_mask</code> を作成します
どのピクセルが実数 (1) で、どのピクセルがパディング (0) であるかを示します。`,xa,is,ka,rs,Va,hs,Hl=`前のセクションで重労働のほとんどを完了したので、モデルをトレーニングする準備が整いました。
このデータセット内の画像は、サイズを変更した後でも依然として非常に大きいです。これは、このモデルを微調整すると、
少なくとも 1 つの GPU が必要です。`,Ea,os,zl="トレーニングには次の手順が含まれます。",Xa,ys,Sl='<li>前処理と同じチェックポイントを使用して、<a href="/docs/transformers/pr_30621/ja/model_doc/auto#transformers.AutoModelForObjectDetection">AutoModelForObjectDetection</a> でモデルを読み込みます。</li> <li><a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> でトレーニング ハイパーパラメータを定義します。</li> <li>トレーニング引数をモデル、データセット、画像プロセッサ、データ照合器とともに <a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.Trainer">Trainer</a> に渡します。</li> <li><a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出してモデルを微調整します。</li>',Na,Js,Dl=`前処理に使用したのと同じチェックポイントからモデルをロードするときは、必ず<code>label2id</code>を渡してください。
および <code>id2label</code> マップは、以前にデータセットのメタデータから作成したものです。さらに、<code>ignore_mismatched_sizes=True</code>を指定して、既存の分類頭部を新しい分類頭部に置き換えます。`,Ya,us,qa,Us,Ll=`<a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> で、<code>output_dir</code> を使用してモデルの保存場所を指定し、必要に応じてハイパーパラメーターを構成します。
画像列が削除されるため、未使用の列を削除しないことが重要です。画像列がないと、
<code>pixel_values</code> を作成できません。このため、<code>remove_unused_columns</code>を<code>False</code>に設定します。
ハブにプッシュしてモデルを共有したい場合は、<code>push_to_hub</code> を <code>True</code> に設定します (Hugging にサインインする必要があります)
顔に向かってモデルをアップロードします）。`,Fa,bs,$a,Ts,Pl='最後に、すべてをまとめて、<a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.Trainer.train">train()</a> を呼び出します。',Ha,ws,za,ds,Kl=`<code>training_args</code>で<code>push_to_hub</code>を<code>True</code>に設定した場合、トレーニング チェックポイントは
ハグフェイスハブ。トレーニングが完了したら、<a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> メソッドを呼び出して、最終モデルもハブにプッシュします。`,Sa,gs,Da,Is,La,Cs,Ol=`物体検出モデルは通常、一連の <a href="https://cocodataset.org/#detection-eval">COCO スタイルの指標</a>を使用して評価されます。
既存のメトリクス実装のいずれかを使用できますが、ここでは<code>torchvision</code>のメトリクス実装を使用して最終的なメトリクスを評価します。
ハブにプッシュしたモデル。`,Pa,fs,sn=`<code>torchvision</code>エバリュエーターを使用するには、グラウンド トゥルース COCO データセットを準備する必要があります。 COCO データセットを構築するための API
データを特定の形式で保存する必要があるため、最初に画像と注釈をディスクに保存する必要があります。と同じように
トレーニング用にデータを準備するとき、<code>cppe5[&quot;test&quot;]</code> からの注釈をフォーマットする必要があります。ただし、画像
そのままでいるべきです。`,Ka,Zs,an=`評価ステップには少し作業が必要ですが、大きく 3 つのステップに分けることができます。
まず、<code>cppe5[&quot;test&quot;]</code> セットを準備します。注釈をフォーマットし、データをディスクに保存します。`,Oa,_s,sl,As,ln="次に、<code>cocoevaluator</code>で利用できる<code>CocoDetection</code>クラスのインスタンスを用意します。",al,Gs,ll,Bs,nn="最後に、メトリクスをロードして評価を実行します。",nl,Ws,el,Rs,en='これらの結果は、<a href="/docs/transformers/pr_30621/ja/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a> のハイパーパラメータを調整することでさらに改善できます。試してごらん！',tl,vs,pl,Qs,tn=`DETR モデルを微調整して評価し、Hugging Face Hub にアップロードしたので、それを推論に使用できます。
推論用に微調整されたモデルを試す最も簡単な方法は、それを <a href="/docs/transformers/pr_30621/ja/main_classes/pipelines#transformers.pipeline">pipeline()</a> で使用することです。パイプラインをインスタンス化する
モデルを使用してオブジェクトを検出し、それに画像を渡します。`,Ml,xs,cl,ks,pn="必要に応じて、パイプラインの結果を手動で複製することもできます。",jl,Vs,ml,Es,Mn="結果をプロットしてみましょう:",il,Xs,rl,T,cn='<img src="https://i.imgur.com/4QZnf9A.png" alt="Object detection result on a new image"/>',hl,Ns,ol,Fs,yl;return d=new qs({props:{title:"Object detection",local:"object-detection",headingTag:"h1"}}),g=new Tn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/object_detection.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/object_detection.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/object_detection.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/pytorch/object_detection.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ja/tensorflow/object_detection.ipynb"}]}}),U=new bn({props:{$$slots:{default:[dn]},$$scope:{ctx:$s}}}),_=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGF0YXNldHMlMjB0cmFuc2Zvcm1lcnMlMjBldmFsdWF0ZSUyMHRpbW0lMjBhbGJ1bWVudGF0aW9ucw==",highlighted:"pip install -q datasets transformers evaluate timm albumentations",wrap:!1}}),B=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),W=new qs({props:{title:"Load the CPPE-5 dataset",local:"load-the-cppe-5-dataset",headingTag:"h2"}}),Q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY3BwZTUlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyY3BwZS01JTIyKSUwQWNwcGU1",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5 = load_dataset(<span class="hljs-string">&quot;cppe-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">1000</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;width&#x27;</span>, <span class="hljs-string">&#x27;height&#x27;</span>, <span class="hljs-string">&#x27;objects&#x27;</span>],
        num_rows: <span class="hljs-number">29</span>
    })
})`,wrap:!1}}),V=new y({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-number">15</span>,
 <span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=943x663 at <span class="hljs-number">0x7F9EC9E77C10</span>&gt;,
 <span class="hljs-string">&#x27;width&#x27;</span>: <span class="hljs-number">943</span>,
 <span class="hljs-string">&#x27;height&#x27;</span>: <span class="hljs-number">663</span>,
 <span class="hljs-string">&#x27;objects&#x27;</span>: {<span class="hljs-string">&#x27;id&#x27;</span>: [<span class="hljs-number">114</span>, <span class="hljs-number">115</span>, <span class="hljs-number">116</span>, <span class="hljs-number">117</span>],
  <span class="hljs-string">&#x27;area&#x27;</span>: [<span class="hljs-number">3796</span>, <span class="hljs-number">1596</span>, <span class="hljs-number">152768</span>, <span class="hljs-number">81002</span>],
  <span class="hljs-string">&#x27;bbox&#x27;</span>: [[<span class="hljs-number">302.0</span>, <span class="hljs-number">109.0</span>, <span class="hljs-number">73.0</span>, <span class="hljs-number">52.0</span>],
   [<span class="hljs-number">810.0</span>, <span class="hljs-number">100.0</span>, <span class="hljs-number">57.0</span>, <span class="hljs-number">28.0</span>],
   [<span class="hljs-number">160.0</span>, <span class="hljs-number">31.0</span>, <span class="hljs-number">248.0</span>, <span class="hljs-number">616.0</span>],
   [<span class="hljs-number">741.0</span>, <span class="hljs-number">68.0</span>, <span class="hljs-number">202.0</span>, <span class="hljs-number">401.0</span>]],
  <span class="hljs-string">&#x27;category&#x27;</span>: [<span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]}}`,wrap:!1}}),q=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwb3MlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMkMlMjBJbWFnZURyYXclMEElMEFpbWFnZSUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQlMEFhbm5vdGF0aW9ucyUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQlNUIwJTVEJTVCJTIyb2JqZWN0cyUyMiU1RCUwQWRyYXclMjAlM0QlMjBJbWFnZURyYXcuRHJhdyhpbWFnZSklMEElMEFjYXRlZ29yaWVzJTIwJTNEJTIwY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RC5mZWF0dXJlcyU1QiUyMm9iamVjdHMlMjIlNUQuZmVhdHVyZSU1QiUyMmNhdGVnb3J5JTIyJTVELm5hbWVzJTBBJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpbmRleCUzQSUyMHglMjBmb3IlMjBpbmRleCUyQyUyMHglMjBpbiUyMGVudW1lcmF0ZShjYXRlZ29yaWVzJTJDJTIwc3RhcnQlM0QwKSU3RCUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCdiUzQSUyMGslMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaWQybGFiZWwuaXRlbXMoKSU3RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihhbm5vdGF0aW9ucyU1QiUyMmlkJTIyJTVEKSklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjBhbm5vdGF0aW9ucyU1QiUyMmJib3glMjIlNUQlNUJpJTVEJTBBJTIwJTIwJTIwJTIwY2xhc3NfaWR4JTIwJTNEJTIwYW5ub3RhdGlvbnMlNUIlMjJjYXRlZ29yeSUyMiU1RCU1QmklNUQlMEElMjAlMjAlMjAlMjB4JTJDJTIweSUyQyUyMHclMkMlMjBoJTIwJTNEJTIwdHVwbGUoYm94KSUwQSUyMCUyMCUyMCUyMGRyYXcucmVjdGFuZ2xlKCh4JTJDJTIweSUyQyUyMHglMjAlMkIlMjB3JTJDJTIweSUyMCUyQiUyMGgpJTJDJTIwb3V0bGluZSUzRCUyMnJlZCUyMiUyQyUyMHdpZHRoJTNEMSklMEElMjAlMjAlMjAlMjBkcmF3LnRleHQoKHglMkMlMjB5KSUyQyUyMGlkMmxhYmVsJTVCY2xhc3NfaWR4JTVEJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageDraw

<span class="hljs-meta">&gt;&gt;&gt; </span>image = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>annotations = cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;objects&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span>categories = cppe5[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;objects&quot;</span>].feature[<span class="hljs-string">&quot;category&quot;</span>].names

<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {index: x <span class="hljs-keyword">for</span> index, x <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(categories, start=<span class="hljs-number">0</span>)}
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {v: k <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> id2label.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(annotations[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>    box = annotations[<span class="hljs-string">&quot;bbox&quot;</span>][i]
<span class="hljs-meta">... </span>    class_idx = annotations[<span class="hljs-string">&quot;category&quot;</span>][i]
<span class="hljs-meta">... </span>    x, y, w, h = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x + w, y + h), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), id2label[class_idx], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),H=new y({props:{code:"cmVtb3ZlX2lkeCUyMCUzRCUyMCU1QjU5MCUyQyUyMDgyMSUyQyUyMDgyMiUyQyUyMDg3NSUyQyUyMDg3NiUyQyUyMDg3OCUyQyUyMDg3OSU1RCUwQWtlZXAlMjAlM0QlMjAlNUJpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGNwcGU1JTVCJTIydHJhaW4lMjIlNUQpKSUyMGlmJTIwaSUyMG5vdCUyMGluJTIwcmVtb3ZlX2lkeCU1RCUwQWNwcGU1JTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjcHBlNSU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChrZWVwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>remove_idx = [<span class="hljs-number">590</span>, <span class="hljs-number">821</span>, <span class="hljs-number">822</span>, <span class="hljs-number">875</span>, <span class="hljs-number">876</span>, <span class="hljs-number">878</span>, <span class="hljs-number">879</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>keep = [i <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(cppe5[<span class="hljs-string">&quot;train&quot;</span>])) <span class="hljs-keyword">if</span> i <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> remove_idx]
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].select(keep)`,wrap:!1}}),z=new qs({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),K=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJTIyJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;facebook/detr-resnet-50&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)`,wrap:!1}}),ls=new y({props:{code:"aW1wb3J0JTIwYWxidW1lbnRhdGlvbnMlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRyYW5zZm9ybSUyMCUzRCUyMGFsYnVtZW50YXRpb25zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWxidW1lbnRhdGlvbnMuUmVzaXplKDQ4MCUyQyUyMDQ4MCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhbGJ1bWVudGF0aW9ucy5Ib3Jpem9udGFsRmxpcChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFsYnVtZW50YXRpb25zLlJhbmRvbUJyaWdodG5lc3NDb250cmFzdChwJTNEMS4wKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMGJib3hfcGFyYW1zJTNEYWxidW1lbnRhdGlvbnMuQmJveFBhcmFtcyhmb3JtYXQlM0QlMjJjb2NvJTIyJTJDJTIwbGFiZWxfZmllbGRzJTNEJTVCJTIyY2F0ZWdvcnklMjIlNUQpJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> albumentations
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>transform = albumentations.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        albumentations.Resize(<span class="hljs-number">480</span>, <span class="hljs-number">480</span>),
<span class="hljs-meta">... </span>        albumentations.HorizontalFlip(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>        albumentations.RandomBrightnessContrast(p=<span class="hljs-number">1.0</span>),
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>    bbox_params=albumentations.BboxParams(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;coco&quot;</span>, label_fields=[<span class="hljs-string">&quot;category&quot;</span>]),
<span class="hljs-meta">... </span>)`,wrap:!1}}),es=new y({props:{code:"ZGVmJTIwZm9ybWF0dGVkX2FubnMoaW1hZ2VfaWQlMkMlMjBjYXRlZ29yeSUyQyUyMGFyZWElMkMlMjBiYm94KSUzQSUwQSUyMCUyMCUyMCUyMGFubm90YXRpb25zJTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihjYXRlZ29yeSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X2FubiUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmltYWdlX2lkJTIyJTNBJTIwaW1hZ2VfaWQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeV9pZCUyMiUzQSUyMGNhdGVnb3J5JTVCaSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlzQ3Jvd2QlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJlYSUyMiUzQSUyMGFyZWElNUJpJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYmJveCUyMiUzQSUyMGxpc3QoYmJveCU1QmklNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYW5ub3RhdGlvbnMuYXBwZW5kKG5ld19hbm4pJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYW5ub3RhdGlvbnM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">formatted_anns</span>(<span class="hljs-params">image_id, category, area, bbox</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(category)):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: category[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;isCrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: area[i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: <span class="hljs-built_in">list</span>(bbox[i]),
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations`,wrap:!1}}),ps=new y({props:{code:"JTIzJTIwdHJhbnNmb3JtaW5nJTIwYSUyMGJhdGNoJTBBZGVmJTIwdHJhbnNmb3JtX2F1Z19hbm4oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfaWRzJTIwJTNEJTIwZXhhbXBsZXMlNUIlMjJpbWFnZV9pZCUyMiU1RCUwQSUyMCUyMCUyMCUyMGltYWdlcyUyQyUyMGJib3hlcyUyQyUyMGFyZWElMkMlMjBjYXRlZ29yaWVzJTIwJTNEJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTJDJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwaW1hZ2UlMkMlMjBvYmplY3RzJTIwaW4lMjB6aXAoZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCUyQyUyMGV4YW1wbGVzJTVCJTIyb2JqZWN0cyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklNUIlM0ElMkMlMjAlM0ElMkMlMjAlM0ElM0EtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMHRyYW5zZm9ybShpbWFnZSUzRGltYWdlJTJDJTIwYmJveGVzJTNEb2JqZWN0cyU1QiUyMmJib3glMjIlNUQlMkMlMjBjYXRlZ29yeSUzRG9iamVjdHMlNUIlMjJjYXRlZ29yeSUyMiU1RCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmVhLmFwcGVuZChvYmplY3RzJTVCJTIyYXJlYSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMuYXBwZW5kKG91dCU1QiUyMmltYWdlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJib3hlcy5hcHBlbmQob3V0JTVCJTIyYmJveGVzJTIyJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhdGVnb3JpZXMuYXBwZW5kKG91dCU1QiUyMmNhdGVnb3J5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJpbWFnZV9pZCUyMiUzQSUyMGlkXyUyQyUyMCUyMmFubm90YXRpb25zJTIyJTNBJTIwZm9ybWF0dGVkX2FubnMoaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8pJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwaWRfJTJDJTIwY2F0XyUyQyUyMGFyXyUyQyUyMGJveF8lMjBpbiUyMHppcChpbWFnZV9pZHMlMkMlMjBjYXRlZ29yaWVzJTJDJTIwYXJlYSUyQyUyMGJib3hlcyklMEElMjAlMjAlMjAlMjAlNUQlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2VzJTJDJTIwYW5ub3RhdGlvbnMlM0R0YXJnZXRzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transforming a batch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_aug_ann</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_ids = examples[<span class="hljs-string">&quot;image_id&quot;</span>]
<span class="hljs-meta">... </span>    images, bboxes, area, categories = [], [], [], []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> image, objects <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&quot;image&quot;</span>], examples[<span class="hljs-string">&quot;objects&quot;</span>]):
<span class="hljs-meta">... </span>        image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>))[:, :, ::-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>        out = transform(image=image, bboxes=objects[<span class="hljs-string">&quot;bbox&quot;</span>], category=objects[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>        area.append(objects[<span class="hljs-string">&quot;area&quot;</span>])
<span class="hljs-meta">... </span>        images.append(out[<span class="hljs-string">&quot;image&quot;</span>])
<span class="hljs-meta">... </span>        bboxes.append(out[<span class="hljs-string">&quot;bboxes&quot;</span>])
<span class="hljs-meta">... </span>        categories.append(out[<span class="hljs-string">&quot;category&quot;</span>])

<span class="hljs-meta">... </span>    targets = [
<span class="hljs-meta">... </span>        {<span class="hljs-string">&quot;image_id&quot;</span>: id_, <span class="hljs-string">&quot;annotations&quot;</span>: formatted_anns(id_, cat_, ar_, box_)}
<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> id_, cat_, ar_, box_ <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(image_ids, categories, area, bboxes)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> image_processor(images=images, annotations=targets, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),js=new y({props:{code:"Y3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCUyMCUzRCUyMGNwcGU1JTVCJTIydHJhaW4lMjIlNUQud2l0aF90cmFuc2Zvcm0odHJhbnNmb3JtX2F1Z19hbm4pJTBBY3BwZTUlNUIlMjJ0cmFpbiUyMiU1RCU1QjE1JTVEJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>] = cppe5[<span class="hljs-string">&quot;train&quot;</span>].with_transform(transform_aug_ann)
<span class="hljs-meta">&gt;&gt;&gt; </span>cppe5[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">15</span>]
{<span class="hljs-string">&#x27;pixel_values&#x27;</span>: tensor([[[ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [ <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  <span class="hljs-number">0.9132</span>,  ..., -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>, -<span class="hljs-number">1.9638</span>],
          ...,
          [-<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>, -<span class="hljs-number">1.5699</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9980</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>],
          [-<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>, -<span class="hljs-number">1.5528</span>,  ..., -<span class="hljs-number">1.9980</span>, -<span class="hljs-number">1.9809</span>, -<span class="hljs-number">1.9809</span>]],

         [[ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [ <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  <span class="hljs-number">1.3081</span>,  ..., -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>, -<span class="hljs-number">1.8256</span>],
          ...,
          [-<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>, -<span class="hljs-number">1.3179</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8606</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>],
          [-<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>, -<span class="hljs-number">1.3004</span>,  ..., -<span class="hljs-number">1.8606</span>, -<span class="hljs-number">1.8431</span>, -<span class="hljs-number">1.8431</span>]],

         [[ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>, -<span class="hljs-number">1.6476</span>],
          [ <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  <span class="hljs-number">1.4200</span>,  ..., -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>, -<span class="hljs-number">1.6302</span>],
          ...,
          [-<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>, -<span class="hljs-number">1.0201</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5604</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>],
          [-<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>, -<span class="hljs-number">1.0027</span>,  ..., -<span class="hljs-number">1.5604</span>, -<span class="hljs-number">1.5430</span>, -<span class="hljs-number">1.5430</span>]]]),
 <span class="hljs-string">&#x27;pixel_mask&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         ...,
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
         [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>,  ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: {<span class="hljs-string">&#x27;size&#x27;</span>: tensor([<span class="hljs-number">800</span>, <span class="hljs-number">800</span>]), <span class="hljs-string">&#x27;image_id&#x27;</span>: tensor([<span class="hljs-number">756</span>]), <span class="hljs-string">&#x27;class_labels&#x27;</span>: tensor([<span class="hljs-number">4</span>]), <span class="hljs-string">&#x27;boxes&#x27;</span>: tensor([[<span class="hljs-number">0.7340</span>, <span class="hljs-number">0.6986</span>, <span class="hljs-number">0.3414</span>, <span class="hljs-number">0.5944</span>]]), <span class="hljs-string">&#x27;area&#x27;</span>: tensor([<span class="hljs-number">519544.4375</span>]), <span class="hljs-string">&#x27;iscrowd&#x27;</span>: tensor([<span class="hljs-number">0</span>]), <span class="hljs-string">&#x27;orig_size&#x27;</span>: tensor([<span class="hljs-number">480</span>, <span class="hljs-number">480</span>])}}`,wrap:!1}}),is=new y({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihiYXRjaCklM0ElMEElMjAlMjAlMjAlMjBwaXhlbF92YWx1ZXMlMjAlM0QlMjAlNUJpdGVtJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBlbmNvZGluZyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wYWQocGl4ZWxfdmFsdWVzJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjAlNUJpdGVtJTVCJTIybGFiZWxzJTIyJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwYmF0Y2glNUQlMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIycGl4ZWxfdmFsdWVzJTIyJTVEJTIwJTNEJTIwZW5jb2RpbmclNUIlMjJwaXhlbF92YWx1ZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnBpeGVsX21hc2slMjIlNUQlMjAlM0QlMjBlbmNvZGluZyU1QiUyMnBpeGVsX21hc2slMjIlNUQlMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGJhdGNo",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    pixel_values = [item[<span class="hljs-string">&quot;pixel_values&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    encoding = image_processor.pad(pixel_values, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    labels = [item[<span class="hljs-string">&quot;labels&quot;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> batch]
<span class="hljs-meta">... </span>    batch = {}
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_values&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>] = encoding[<span class="hljs-string">&quot;pixel_mask&quot;</span>]
<span class="hljs-meta">... </span>    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),rs=new qs({props:{title:"Training the DETR model",local:"training-the-detr-model",headingTag:"h2"}}),us=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBjaGVja3BvaW50JTJDJTBBJTIwJTIwJTIwJTIwaWQybGFiZWwlM0RpZDJsYWJlbCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsMmlkJTNEbGFiZWwyaWQlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(
<span class="hljs-meta">... </span>    checkpoint,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),bs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJkZXRyLXJlc25ldC01MF9maW5ldHVuZWRfY3BwZTUlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QxZS00JTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV90b3RhbF9saW1pdCUzRDIlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfdW51c2VkX2NvbHVtbnMlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;detr-resnet-50_finetuned_cppe5&quot;</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">1e-4</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ws=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RjcHBlNSU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>    train_dataset=cppe5[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),gs=new y({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Is=new qs({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),_s=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> json


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># format annotations the same as for training, no need for data augmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">val_formatted_anns</span>(<span class="hljs-params">image_id, objects</span>):
<span class="hljs-meta">... </span>    annotations = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(objects[<span class="hljs-string">&quot;id&quot;</span>])):
<span class="hljs-meta">... </span>        new_ann = {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;id&quot;</span>: objects[<span class="hljs-string">&quot;id&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;category_id&quot;</span>: objects[<span class="hljs-string">&quot;category&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;iscrowd&quot;</span>: <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;image_id&quot;</span>: image_id,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;area&quot;</span>: objects[<span class="hljs-string">&quot;area&quot;</span>][i],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;bbox&quot;</span>: objects[<span class="hljs-string">&quot;bbox&quot;</span>][i],
<span class="hljs-meta">... </span>        }
<span class="hljs-meta">... </span>        annotations.append(new_ann)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> annotations


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save images and annotations into the files torchvision.datasets.CocoDetection expects</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">save_cppe5_annotation_file_images</span>(<span class="hljs-params">cppe5</span>):
<span class="hljs-meta">... </span>    output_json = {}
<span class="hljs-meta">... </span>    path_output_cppe5 = <span class="hljs-string">f&quot;<span class="hljs-subst">{os.getcwd()}</span>/cppe5/&quot;</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(path_output_cppe5):
<span class="hljs-meta">... </span>        os.makedirs(path_output_cppe5)

<span class="hljs-meta">... </span>    path_anno = os.path.join(path_output_cppe5, <span class="hljs-string">&quot;cppe5_ann.json&quot;</span>)
<span class="hljs-meta">... </span>    categories_json = [{<span class="hljs-string">&quot;supercategory&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: <span class="hljs-built_in">id</span>, <span class="hljs-string">&quot;name&quot;</span>: id2label[<span class="hljs-built_in">id</span>]} <span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span> <span class="hljs-keyword">in</span> id2label]
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;images&quot;</span>] = []
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;annotations&quot;</span>] = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> cppe5:
<span class="hljs-meta">... </span>        ann = val_formatted_anns(example[<span class="hljs-string">&quot;image_id&quot;</span>], example[<span class="hljs-string">&quot;objects&quot;</span>])
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;images&quot;</span>].append(
<span class="hljs-meta">... </span>            {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;id&quot;</span>: example[<span class="hljs-string">&quot;image_id&quot;</span>],
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;width&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].width,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;height&quot;</span>: example[<span class="hljs-string">&quot;image&quot;</span>].height,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;file_name&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{example[<span class="hljs-string">&#x27;image_id&#x27;</span>]}</span>.png&quot;</span>,
<span class="hljs-meta">... </span>            }
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        output_json[<span class="hljs-string">&quot;annotations&quot;</span>].extend(ann)
<span class="hljs-meta">... </span>    output_json[<span class="hljs-string">&quot;categories&quot;</span>] = categories_json

<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(path_anno, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>        json.dump(output_json, file, ensure_ascii=<span class="hljs-literal">False</span>, indent=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> im, img_id <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(cppe5[<span class="hljs-string">&quot;image&quot;</span>], cppe5[<span class="hljs-string">&quot;image_id&quot;</span>]):
<span class="hljs-meta">... </span>        path_img = os.path.join(path_output_cppe5, <span class="hljs-string">f&quot;<span class="hljs-subst">{img_id}</span>.png&quot;</span>)
<span class="hljs-meta">... </span>        im.save(path_img)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> path_output_cppe5, path_anno`,wrap:!1}}),Gs=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torchvision


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">CocoDetection</span>(torchvision.datasets.CocoDetection):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, img_folder, image_processor, ann_file</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__(img_folder, ann_file)
<span class="hljs-meta">... </span>        self.image_processor = image_processor

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
<span class="hljs-meta">... </span>        <span class="hljs-comment"># read in PIL image and target in COCO format</span>
<span class="hljs-meta">... </span>        img, target = <span class="hljs-built_in">super</span>(CocoDetection, self).__getitem__(idx)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># preprocess image and target: converting target to DETR format,</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># resizing + normalization of both image and target)</span>
<span class="hljs-meta">... </span>        image_id = self.ids[idx]
<span class="hljs-meta">... </span>        target = {<span class="hljs-string">&quot;image_id&quot;</span>: image_id, <span class="hljs-string">&quot;annotations&quot;</span>: target}
<span class="hljs-meta">... </span>        encoding = self.image_processor(images=img, annotations=target, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>        pixel_values = encoding[<span class="hljs-string">&quot;pixel_values&quot;</span>].squeeze()  <span class="hljs-comment"># remove batch dimension</span>
<span class="hljs-meta">... </span>        target = encoding[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]  <span class="hljs-comment"># remove batch dimension</span>

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: target}


<span class="hljs-meta">&gt;&gt;&gt; </span>im_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>path_output_cppe5, path_anno = save_cppe5_annotation_file_images(cppe5[<span class="hljs-string">&quot;test&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>test_ds_coco_format = CocoDetection(path_output_cppe5, im_processor, path_anno)`,wrap:!1}}),Ws=new y({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>module = evaluate.load(<span class="hljs-string">&quot;ybelkada/cocoevaluate&quot;</span>, coco=test_ds_coco_format.coco)
<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataloader = torch.utils.data.DataLoader(
<span class="hljs-meta">... </span>    test_ds_coco_format, batch_size=<span class="hljs-number">8</span>, shuffle=<span class="hljs-literal">False</span>, num_workers=<span class="hljs-number">4</span>, collate_fn=collate_fn
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> idx, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(val_dataloader)):
<span class="hljs-meta">... </span>        pixel_values = batch[<span class="hljs-string">&quot;pixel_values&quot;</span>]
<span class="hljs-meta">... </span>        pixel_mask = batch[<span class="hljs-string">&quot;pixel_mask&quot;</span>]

<span class="hljs-meta">... </span>        labels = [
<span class="hljs-meta">... </span>            {k: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> t.items()} <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> batch[<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">... </span>        ]  <span class="hljs-comment"># these are in DETR format, resized + normalized</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>        outputs = model(pixel_values=pixel_values, pixel_mask=pixel_mask)

<span class="hljs-meta">... </span>        orig_target_sizes = torch.stack([target[<span class="hljs-string">&quot;orig_size&quot;</span>] <span class="hljs-keyword">for</span> target <span class="hljs-keyword">in</span> labels], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>        results = im_processor.post_process(outputs, orig_target_sizes)  <span class="hljs-comment"># convert outputs of model to Pascal VOC format (xmin, ymin, xmax, ymax)</span>

<span class="hljs-meta">... </span>        module.add(prediction=results, reference=labels)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch

<span class="hljs-meta">&gt;&gt;&gt; </span>results = module.compute()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(results)
Accumulating evaluation results...
DONE (t=<span class="hljs-number">0.08</span>s).
IoU metric: bbox
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.352</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.681</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.75</span>      | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.292</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.168</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.208</span>
 Average Precision  (AP) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.429</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=  <span class="hljs-number">1</span> ] = <span class="hljs-number">0.274</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets= <span class="hljs-number">10</span> ] = <span class="hljs-number">0.484</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=   <span class="hljs-built_in">all</span> | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.501</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= small | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.191</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area=medium | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.323</span>
 Average Recall     (AR) @[ IoU=<span class="hljs-number">0.50</span>:<span class="hljs-number">0.95</span> | area= large | maxDets=<span class="hljs-number">100</span> ] = <span class="hljs-number">0.590</span>`,wrap:!1}}),vs=new qs({props:{title:"Inference",local:"inference",headingTag:"h2"}}),xs=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmkuaW1ndXIuY29tJTJGMmxuV29seS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFvYmpfZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJvYmplY3QtZGV0ZWN0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW9ial9kZXRlY3RvcihpbWFnZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://i.imgur.com/2lnWoly.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector = pipeline(<span class="hljs-string">&quot;object-detection&quot;</span>, model=<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>obj_detector(image)`,wrap:!1}}),Vs=new y({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZXZvbmhvJTJGZGV0ci1yZXNuZXQtNTBfZmluZXR1bmVkX2NwcGU1JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjAlMjAlMjB0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuNSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIwJTVEJTBBJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;devonho/detr-resnet-50_finetuned_cppe5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">... </span>    results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.5</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected Coverall <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.566</span> at location [<span class="hljs-number">1215.32</span>, <span class="hljs-number">147.38</span>, <span class="hljs-number">4401.81</span>, <span class="hljs-number">3227.08</span>]
Detected Mask <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.584</span> at location [<span class="hljs-number">2449.06</span>, <span class="hljs-number">823.19</span>, <span class="hljs-number">3256.43</span>, <span class="hljs-number">1413.9</span>]`,wrap:!1}}),Xs=new y({props:{code:"ZHJhdyUyMCUzRCUyMEltYWdlRHJhdy5EcmF3KGltYWdlKSUwQSUwQWZvciUyMHNjb3JlJTJDJTIwbGFiZWwlMkMlMjBib3glMjBpbiUyMHppcChyZXN1bHRzJTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmxhYmVscyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJib3hlcyUyMiU1RCklM0ElMEElMjAlMjAlMjAlMjBib3glMjAlM0QlMjAlNUJyb3VuZChpJTJDJTIwMiklMjBmb3IlMjBpJTIwaW4lMjBib3gudG9saXN0KCklNUQlMEElMjAlMjAlMjAlMjB4JTJDJTIweSUyQyUyMHgyJTJDJTIweTIlMjAlM0QlMjB0dXBsZShib3gpJTBBJTIwJTIwJTIwJTIwZHJhdy5yZWN0YW5nbGUoKHglMkMlMjB5JTJDJTIweDIlMkMlMjB5MiklMkMlMjBvdXRsaW5lJTNEJTIycmVkJTIyJTJDJTIwd2lkdGglM0QxKSUwQSUyMCUyMCUyMCUyMGRyYXcudGV4dCgoeCUyQyUyMHkpJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTJDJTIwZmlsbCUzRCUyMndoaXRlJTIyKSUwQSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>draw = ImageDraw.Draw(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    x, y, x2, y2 = <span class="hljs-built_in">tuple</span>(box)
<span class="hljs-meta">... </span>    draw.rectangle((x, y, x2, y2), outline=<span class="hljs-string">&quot;red&quot;</span>, width=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    draw.text((x, y), model.config.id2label[label.item()], fill=<span class="hljs-string">&quot;white&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Ns=new wn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ja/tasks/object_detection.md"}}),{c(){J=p("meta"),w=e(),u=p("p"),Ys=e(),j(d.$$.fragment),Hs=e(),j(g.$$.fragment),zs=e(),I=p("p"),I.textContent=ul,Ss=e(),C=p("p"),C.textContent=Ul,Ds=e(),f=p("ol"),f.innerHTML=bl,Ls=e(),j(U.$$.fragment),Ps=e(),Z=p("p"),Z.textContent=Tl,Ks=e(),j(_.$$.fragment),Os=e(),A=p("p"),A.innerHTML=wl,sa=e(),G=p("p"),G.textContent=dl,aa=e(),j(B.$$.fragment),la=e(),j(W.$$.fragment),na=e(),R=p("p"),R.innerHTML=gl,ea=e(),v=p("p"),v.textContent=Il,ta=e(),j(Q.$$.fragment),pa=e(),x=p("p"),x.textContent=Cl,Ma=e(),k=p("p"),k.textContent=fl,ca=e(),j(V.$$.fragment),ja=e(),E=p("p"),E.textContent=Zl,ma=e(),X=p("ul"),X.innerHTML=_l,ia=e(),N=p("p"),N.innerHTML=Al,ra=e(),Y=p("p"),Y.textContent=Gl,ha=e(),j(q.$$.fragment),oa=e(),b=p("div"),b.innerHTML=Bl,ya=e(),F=p("p"),F.innerHTML=Wl,Ja=e(),$=p("p"),$.textContent=Rl,ua=e(),j(H.$$.fragment),Ua=e(),j(z.$$.fragment),ba=e(),S=p("p"),S.innerHTML=vl,Ta=e(),D=p("ul"),D.innerHTML=Ql,wa=e(),L=p("p"),L.textContent=xl,da=e(),P=p("p"),P.textContent=kl,ga=e(),j(K.$$.fragment),Ia=e(),O=p("p"),O.innerHTML=Vl,Ca=e(),ss=p("ul"),ss.innerHTML=El,fa=e(),as=p("p"),as.innerHTML=Xl,Za=e(),j(ls.$$.fragment),_a=e(),ns=p("p"),ns.innerHTML=Nl,Aa=e(),j(es.$$.fragment),Ga=e(),ts=p("p"),ts.textContent=Yl,Ba=e(),j(ps.$$.fragment),Wa=e(),Ms=p("p"),Ms.innerHTML=ql,Ra=e(),cs=p("p"),cs.innerHTML=Fl,va=e(),j(js.$$.fragment),Qa=e(),ms=p("p"),ms.innerHTML=$l,xa=e(),j(is.$$.fragment),ka=e(),j(rs.$$.fragment),Va=e(),hs=p("p"),hs.textContent=Hl,Ea=e(),os=p("p"),os.textContent=zl,Xa=e(),ys=p("ol"),ys.innerHTML=Sl,Na=e(),Js=p("p"),Js.innerHTML=Dl,Ya=e(),j(us.$$.fragment),qa=e(),Us=p("p"),Us.innerHTML=Ll,Fa=e(),j(bs.$$.fragment),$a=e(),Ts=p("p"),Ts.innerHTML=Pl,Ha=e(),j(ws.$$.fragment),za=e(),ds=p("p"),ds.innerHTML=Kl,Sa=e(),j(gs.$$.fragment),Da=e(),j(Is.$$.fragment),La=e(),Cs=p("p"),Cs.innerHTML=Ol,Pa=e(),fs=p("p"),fs.innerHTML=sn,Ka=e(),Zs=p("p"),Zs.innerHTML=an,Oa=e(),j(_s.$$.fragment),sl=e(),As=p("p"),As.innerHTML=ln,al=e(),j(Gs.$$.fragment),ll=e(),Bs=p("p"),Bs.textContent=nn,nl=e(),j(Ws.$$.fragment),el=e(),Rs=p("p"),Rs.innerHTML=en,tl=e(),j(vs.$$.fragment),pl=e(),Qs=p("p"),Qs.innerHTML=tn,Ml=e(),j(xs.$$.fragment),cl=e(),ks=p("p"),ks.textContent=pn,jl=e(),j(Vs.$$.fragment),ml=e(),Es=p("p"),Es.textContent=Mn,il=e(),j(Xs.$$.fragment),rl=e(),T=p("div"),T.innerHTML=cn,hl=e(),j(Ns.$$.fragment),ol=e(),Fs=p("p"),this.h()},l(s){const a=un("svelte-u9bgzb",document.head);J=M(a,"META",{name:!0,content:!0}),a.forEach(l),w=t(s),u=M(s,"P",{}),mn(u).forEach(l),Ys=t(s),m(d.$$.fragment,s),Hs=t(s),m(g.$$.fragment,s),zs=t(s),I=M(s,"P",{"data-svelte-h":!0}),c(I)!=="svelte-5r6akf"&&(I.textContent=ul),Ss=t(s),C=M(s,"P",{"data-svelte-h":!0}),c(C)!=="svelte-sw406c"&&(C.textContent=Ul),Ds=t(s),f=M(s,"OL",{"data-svelte-h":!0}),c(f)!=="svelte-gfibwd"&&(f.innerHTML=bl),Ls=t(s),m(U.$$.fragment,s),Ps=t(s),Z=M(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1lya3k8"&&(Z.textContent=Tl),Ks=t(s),m(_.$$.fragment,s),Os=t(s),A=M(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1heb5sb"&&(A.innerHTML=wl),sa=t(s),G=M(s,"P",{"data-svelte-h":!0}),c(G)!=="svelte-km1v2k"&&(G.textContent=dl),aa=t(s),m(B.$$.fragment,s),la=t(s),m(W.$$.fragment,s),na=t(s),R=M(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-omjhw2"&&(R.innerHTML=gl),ea=t(s),v=M(s,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1kjcyvo"&&(v.textContent=Il),ta=t(s),m(Q.$$.fragment,s),pa=t(s),x=M(s,"P",{"data-svelte-h":!0}),c(x)!=="svelte-1edqlqi"&&(x.textContent=Cl),Ma=t(s),k=M(s,"P",{"data-svelte-h":!0}),c(k)!=="svelte-h4ffk6"&&(k.textContent=fl),ca=t(s),m(V.$$.fragment,s),ja=t(s),E=M(s,"P",{"data-svelte-h":!0}),c(E)!=="svelte-13hht2o"&&(E.textContent=Zl),ma=t(s),X=M(s,"UL",{"data-svelte-h":!0}),c(X)!=="svelte-fjri37"&&(X.innerHTML=_l),ia=t(s),N=M(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-y6a2g5"&&(N.innerHTML=Al),ra=t(s),Y=M(s,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1q29g0x"&&(Y.textContent=Gl),ha=t(s),m(q.$$.fragment,s),oa=t(s),b=M(s,"DIV",{class:!0,"data-svelte-h":!0}),c(b)!=="svelte-1mkaz8h"&&(b.innerHTML=Bl),ya=t(s),F=M(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-19dg06i"&&(F.innerHTML=Wl),Ja=t(s),$=M(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-1xdk7br"&&($.textContent=Rl),ua=t(s),m(H.$$.fragment,s),Ua=t(s),m(z.$$.fragment,s),ba=t(s),S=M(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-11anbns"&&(S.innerHTML=vl),Ta=t(s),D=M(s,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-9xz2l6"&&(D.innerHTML=Ql),wa=t(s),L=M(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-w4h0v0"&&(L.textContent=xl),da=t(s),P=M(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-16cx11i"&&(P.textContent=kl),ga=t(s),m(K.$$.fragment,s),Ia=t(s),O=M(s,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1i23rsc"&&(O.innerHTML=Vl),Ca=t(s),ss=M(s,"UL",{"data-svelte-h":!0}),c(ss)!=="svelte-17t0a11"&&(ss.innerHTML=El),fa=t(s),as=M(s,"P",{"data-svelte-h":!0}),c(as)!=="svelte-18jci73"&&(as.innerHTML=Xl),Za=t(s),m(ls.$$.fragment,s),_a=t(s),ns=M(s,"P",{"data-svelte-h":!0}),c(ns)!=="svelte-3sh3zj"&&(ns.innerHTML=Nl),Aa=t(s),m(es.$$.fragment,s),Ga=t(s),ts=M(s,"P",{"data-svelte-h":!0}),c(ts)!=="svelte-cpkzfa"&&(ts.textContent=Yl),Ba=t(s),m(ps.$$.fragment,s),Wa=t(s),Ms=M(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-fnbbog"&&(Ms.innerHTML=ql),Ra=t(s),cs=M(s,"P",{"data-svelte-h":!0}),c(cs)!=="svelte-1ddlogf"&&(cs.innerHTML=Fl),va=t(s),m(js.$$.fragment,s),Qa=t(s),ms=M(s,"P",{"data-svelte-h":!0}),c(ms)!=="svelte-lzm515"&&(ms.innerHTML=$l),xa=t(s),m(is.$$.fragment,s),ka=t(s),m(rs.$$.fragment,s),Va=t(s),hs=M(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-1144ckg"&&(hs.textContent=Hl),Ea=t(s),os=M(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-cqdmyi"&&(os.textContent=zl),Xa=t(s),ys=M(s,"OL",{"data-svelte-h":!0}),c(ys)!=="svelte-bdzb85"&&(ys.innerHTML=Sl),Na=t(s),Js=M(s,"P",{"data-svelte-h":!0}),c(Js)!=="svelte-1j2te6e"&&(Js.innerHTML=Dl),Ya=t(s),m(us.$$.fragment,s),qa=t(s),Us=M(s,"P",{"data-svelte-h":!0}),c(Us)!=="svelte-1pyjp0n"&&(Us.innerHTML=Ll),Fa=t(s),m(bs.$$.fragment,s),$a=t(s),Ts=M(s,"P",{"data-svelte-h":!0}),c(Ts)!=="svelte-1ja98f"&&(Ts.innerHTML=Pl),Ha=t(s),m(ws.$$.fragment,s),za=t(s),ds=M(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-1jaj2os"&&(ds.innerHTML=Kl),Sa=t(s),m(gs.$$.fragment,s),Da=t(s),m(Is.$$.fragment,s),La=t(s),Cs=M(s,"P",{"data-svelte-h":!0}),c(Cs)!=="svelte-1f6htse"&&(Cs.innerHTML=Ol),Pa=t(s),fs=M(s,"P",{"data-svelte-h":!0}),c(fs)!=="svelte-1urhuq1"&&(fs.innerHTML=sn),Ka=t(s),Zs=M(s,"P",{"data-svelte-h":!0}),c(Zs)!=="svelte-4fq9ze"&&(Zs.innerHTML=an),Oa=t(s),m(_s.$$.fragment,s),sl=t(s),As=M(s,"P",{"data-svelte-h":!0}),c(As)!=="svelte-1pucslt"&&(As.innerHTML=ln),al=t(s),m(Gs.$$.fragment,s),ll=t(s),Bs=M(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-b0b8dt"&&(Bs.textContent=nn),nl=t(s),m(Ws.$$.fragment,s),el=t(s),Rs=M(s,"P",{"data-svelte-h":!0}),c(Rs)!=="svelte-1iwrg24"&&(Rs.innerHTML=en),tl=t(s),m(vs.$$.fragment,s),pl=t(s),Qs=M(s,"P",{"data-svelte-h":!0}),c(Qs)!=="svelte-9ntnb4"&&(Qs.innerHTML=tn),Ml=t(s),m(xs.$$.fragment,s),cl=t(s),ks=M(s,"P",{"data-svelte-h":!0}),c(ks)!=="svelte-19p6rx9"&&(ks.textContent=pn),jl=t(s),m(Vs.$$.fragment,s),ml=t(s),Es=M(s,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-12ncpbb"&&(Es.textContent=Mn),il=t(s),m(Xs.$$.fragment,s),rl=t(s),T=M(s,"DIV",{class:!0,"data-svelte-h":!0}),c(T)!=="svelte-16oi5q2"&&(T.innerHTML=cn),hl=t(s),m(Ns.$$.fragment,s),ol=t(s),Fs=M(s,"P",{}),mn(Fs).forEach(l),this.h()},h(){Jl(J,"name","hf:doc:metadata"),Jl(J,"content",In),Jl(b,"class","flex justify-center"),Jl(T,"class","flex justify-center")},m(s,a){Un(document.head,J),n(s,w,a),n(s,u,a),n(s,Ys,a),i(d,s,a),n(s,Hs,a),i(g,s,a),n(s,zs,a),n(s,I,a),n(s,Ss,a),n(s,C,a),n(s,Ds,a),n(s,f,a),n(s,Ls,a),i(U,s,a),n(s,Ps,a),n(s,Z,a),n(s,Ks,a),i(_,s,a),n(s,Os,a),n(s,A,a),n(s,sa,a),n(s,G,a),n(s,aa,a),i(B,s,a),n(s,la,a),i(W,s,a),n(s,na,a),n(s,R,a),n(s,ea,a),n(s,v,a),n(s,ta,a),i(Q,s,a),n(s,pa,a),n(s,x,a),n(s,Ma,a),n(s,k,a),n(s,ca,a),i(V,s,a),n(s,ja,a),n(s,E,a),n(s,ma,a),n(s,X,a),n(s,ia,a),n(s,N,a),n(s,ra,a),n(s,Y,a),n(s,ha,a),i(q,s,a),n(s,oa,a),n(s,b,a),n(s,ya,a),n(s,F,a),n(s,Ja,a),n(s,$,a),n(s,ua,a),i(H,s,a),n(s,Ua,a),i(z,s,a),n(s,ba,a),n(s,S,a),n(s,Ta,a),n(s,D,a),n(s,wa,a),n(s,L,a),n(s,da,a),n(s,P,a),n(s,ga,a),i(K,s,a),n(s,Ia,a),n(s,O,a),n(s,Ca,a),n(s,ss,a),n(s,fa,a),n(s,as,a),n(s,Za,a),i(ls,s,a),n(s,_a,a),n(s,ns,a),n(s,Aa,a),i(es,s,a),n(s,Ga,a),n(s,ts,a),n(s,Ba,a),i(ps,s,a),n(s,Wa,a),n(s,Ms,a),n(s,Ra,a),n(s,cs,a),n(s,va,a),i(js,s,a),n(s,Qa,a),n(s,ms,a),n(s,xa,a),i(is,s,a),n(s,ka,a),i(rs,s,a),n(s,Va,a),n(s,hs,a),n(s,Ea,a),n(s,os,a),n(s,Xa,a),n(s,ys,a),n(s,Na,a),n(s,Js,a),n(s,Ya,a),i(us,s,a),n(s,qa,a),n(s,Us,a),n(s,Fa,a),i(bs,s,a),n(s,$a,a),n(s,Ts,a),n(s,Ha,a),i(ws,s,a),n(s,za,a),n(s,ds,a),n(s,Sa,a),i(gs,s,a),n(s,Da,a),i(Is,s,a),n(s,La,a),n(s,Cs,a),n(s,Pa,a),n(s,fs,a),n(s,Ka,a),n(s,Zs,a),n(s,Oa,a),i(_s,s,a),n(s,sl,a),n(s,As,a),n(s,al,a),i(Gs,s,a),n(s,ll,a),n(s,Bs,a),n(s,nl,a),i(Ws,s,a),n(s,el,a),n(s,Rs,a),n(s,tl,a),i(vs,s,a),n(s,pl,a),n(s,Qs,a),n(s,Ml,a),i(xs,s,a),n(s,cl,a),n(s,ks,a),n(s,jl,a),i(Vs,s,a),n(s,ml,a),n(s,Es,a),n(s,il,a),i(Xs,s,a),n(s,rl,a),n(s,T,a),n(s,hl,a),i(Ns,s,a),n(s,ol,a),n(s,Fs,a),yl=!0},p(s,[a]){const jn={};a&2&&(jn.$$scope={dirty:a,ctx:s}),U.$set(jn)},i(s){yl||(r(d.$$.fragment,s),r(g.$$.fragment,s),r(U.$$.fragment,s),r(_.$$.fragment,s),r(B.$$.fragment,s),r(W.$$.fragment,s),r(Q.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(H.$$.fragment,s),r(z.$$.fragment,s),r(K.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ps.$$.fragment,s),r(js.$$.fragment,s),r(is.$$.fragment,s),r(rs.$$.fragment,s),r(us.$$.fragment,s),r(bs.$$.fragment,s),r(ws.$$.fragment,s),r(gs.$$.fragment,s),r(Is.$$.fragment,s),r(_s.$$.fragment,s),r(Gs.$$.fragment,s),r(Ws.$$.fragment,s),r(vs.$$.fragment,s),r(xs.$$.fragment,s),r(Vs.$$.fragment,s),r(Xs.$$.fragment,s),r(Ns.$$.fragment,s),yl=!0)},o(s){h(d.$$.fragment,s),h(g.$$.fragment,s),h(U.$$.fragment,s),h(_.$$.fragment,s),h(B.$$.fragment,s),h(W.$$.fragment,s),h(Q.$$.fragment,s),h(V.$$.fragment,s),h(q.$$.fragment,s),h(H.$$.fragment,s),h(z.$$.fragment,s),h(K.$$.fragment,s),h(ls.$$.fragment,s),h(es.$$.fragment,s),h(ps.$$.fragment,s),h(js.$$.fragment,s),h(is.$$.fragment,s),h(rs.$$.fragment,s),h(us.$$.fragment,s),h(bs.$$.fragment,s),h(ws.$$.fragment,s),h(gs.$$.fragment,s),h(Is.$$.fragment,s),h(_s.$$.fragment,s),h(Gs.$$.fragment,s),h(Ws.$$.fragment,s),h(vs.$$.fragment,s),h(xs.$$.fragment,s),h(Vs.$$.fragment,s),h(Xs.$$.fragment,s),h(Ns.$$.fragment,s),yl=!1},d(s){s&&(l(w),l(u),l(Ys),l(Hs),l(zs),l(I),l(Ss),l(C),l(Ds),l(f),l(Ls),l(Ps),l(Z),l(Ks),l(Os),l(A),l(sa),l(G),l(aa),l(la),l(na),l(R),l(ea),l(v),l(ta),l(pa),l(x),l(Ma),l(k),l(ca),l(ja),l(E),l(ma),l(X),l(ia),l(N),l(ra),l(Y),l(ha),l(oa),l(b),l(ya),l(F),l(Ja),l($),l(ua),l(Ua),l(ba),l(S),l(Ta),l(D),l(wa),l(L),l(da),l(P),l(ga),l(Ia),l(O),l(Ca),l(ss),l(fa),l(as),l(Za),l(_a),l(ns),l(Aa),l(Ga),l(ts),l(Ba),l(Wa),l(Ms),l(Ra),l(cs),l(va),l(Qa),l(ms),l(xa),l(ka),l(Va),l(hs),l(Ea),l(os),l(Xa),l(ys),l(Na),l(Js),l(Ya),l(qa),l(Us),l(Fa),l($a),l(Ts),l(Ha),l(za),l(ds),l(Sa),l(Da),l(La),l(Cs),l(Pa),l(fs),l(Ka),l(Zs),l(Oa),l(sl),l(As),l(al),l(ll),l(Bs),l(nl),l(el),l(Rs),l(tl),l(pl),l(Qs),l(Ml),l(cl),l(ks),l(jl),l(ml),l(Es),l(il),l(rl),l(T),l(hl),l(ol),l(Fs)),l(J),o(d,s),o(g,s),o(U,s),o(_,s),o(B,s),o(W,s),o(Q,s),o(V,s),o(q,s),o(H,s),o(z,s),o(K,s),o(ls,s),o(es,s),o(ps,s),o(js,s),o(is,s),o(rs,s),o(us,s),o(bs,s),o(ws,s),o(gs,s),o(Is,s),o(_s,s),o(Gs,s),o(Ws,s),o(vs,s),o(xs,s),o(Vs,s),o(Xs,s),o(Ns,s)}}}const In='{"title":"Object detection","local":"object-detection","sections":[{"title":"Load the CPPE-5 dataset","local":"load-the-cppe-5-dataset","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[],"depth":2},{"title":"Training the DETR model","local":"training-the-detr-model","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Cn($s){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wn extends yn{constructor(J){super(),Jn(this,J,Cn,gn,rn,{})}}export{Wn as component};
