import{s as Dt,n as Gt,o as _t}from"../chunks/scheduler.7bc62968.js";import{S as Vt,i as zt,g as i,s as n,r as o,A as Yt,h as r,f as s,c as a,j as Qt,u as M,x as h,k as Nt,y as Xt,a as l,v as p,d as c,t as d,w as m}from"../chunks/index.2f8492b0.js";import{C as b}from"../chunks/CodeBlock.bb61a5a9.js";import{H as u,E as Ht}from"../chunks/getInferenceSnippets.06ca42cd.js";function Lt(mt){let f,ue,me,be,y,fe,j,ye,w,ht=`DETR is mainly used for object detection tasks, which is the process of detecting objects in an image. For example, the input of the model would be an image of a road, and the output of the model could be <code>[(&#39;car&#39;,X1,Y1,W1,H1),(&#39;pedestrian&#39;,X2,Y2,W2,H2)]</code>, in which X, Y, W, H represent the x, y coordinates denoting the location of the bounding box, as well as the width and height of the box.
A traditional object detection model like YOLO consists of hand-crafted features like anchor box priors, which requires initial guesses of object locations and shapes, affecting downstream training. Post-processing steps are then used to remove overlapping bounding boxes, which require careful selection of its filtering heuristics.
DEtection TRansformer, DETR for short, simplifies the detector by using an encoder-decoder transformer after the feature extraction backbone to directly predict bounding boxes in parallel, requiring minimal post-processing.`,je,T,ut=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR.png" alt="Architecture Diagram of DETR"/>
The model architecture of DETR begins with a CNN backbone, similar to other image-based networks, the output of which is processed and fed into a transformer encoder, resulting in N embeddings. The encoder embeddings are added to learned positional embeddings (called object queries) and used in a transformer decoder, generating another N embeddings. As a final step, each of the N embeddings are put through individual feed forward layers to predict the width, height, coordinates of the bounding box, as well as the object class (or whether there is an object).`,we,J,Te,U,Je,g,bt=`As with other transformers, the transformer encoder expects the output of the CNN backbone to be a sequence. Thus, the feature map of size <code>[dimension, height, width]</code> is downsized and then flattened to <code>[dimension, less than height x width]</code>.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_FeatureMaps.png" alt="Feature Maps of Encoder"/> <em><strong>Left</strong>: 12 out of 256 dimensions in the feature maps are visualized. Each dimension extracts some features of the original cat image while downsizing the original image. Some dimensions have a higher focus on the patterns on the cat; some have a higher focus on the bed sheets.</em> <em><strong>Right</strong>: Keeping the original feature dimension of size 256, the width and height are further downsized and flattened into size 850.</em><br/>
Since transformers are permutation invariant, positional embeddings are added to both the encoder and decoder to remind the model where on the image the embeddings come from. In the encoder, fixed positional encodings are used, while in the decoder, learned positional encodings (object queries) are used. Fixed encodings are similar to the ones used in the original Transformer paper, in which the encodings are defined by sinusoidal functions of varying frequencies at different feature dimensions. It gives the sense of position without having any learned parameters, indexed by the position on the image. Learned encodings are also indexed by the positions, but each position has a separate encoding that is learned throughout training to denote the positions in a way that the model understands.`,Ue,C,ge,I,ft="In YOLO, a popular object detection model, the loss function comprises the bounding box, objectness (ie. the probability of an object existing in a region of interest), and class loss. The loss is calculated over multiple bounding boxes per each grid cell, which is a fixed number. On the other hand, in DETR, the architecture is expected to generate unique bounding boxes in a permutation-invariant manner (i.e., the order of the detections does not matter in the output, and the bounding boxes must vary and cannot all be the same). Thus, matching is required to assess how good the predictions are.",Ce,A,yt=`<strong>Bipartite Matching</strong><br/>
Bipartite matching is a way to compute one-on-one matching between the ground truth bounding boxes and the predicted boxes. It finds matches with the highest similarity between ground truth and predicted bounding boxes, as well as classes. This ensures the closest prediction would be matched with the corresponding ground truth in order to properly adjust the boxes and classes in the loss function. If matching is not done, predictions not aligned with the order of the ground truth would be marked as incorrect even if it were correct.`,Ie,$,Ae,Z,jt="To see an example of how you can perform inference with DETR using Hugging Face transformers, see <code>DETR.ipynb</code>.",$e,k,Ze,v,ke,x,wt=`Two of the main problems of DETR are a long and slow process of convergence and suboptimal small object detection.
<strong>Deformable Attention</strong><br/>
The first problem is resolved by using deformable attention, which reduces the amount of sampling points to pay attention to. Traditional attention is inefficient due to global attention and heavily limit the resolution that the image can have. The model only attends to a fixed amount of sampling points around each reference point, and the reference points are learned by the model based on the input. For example, in an image of a dog, a reference point may be in the center of the dog, with sampling points near the ears, mouth, tail, etc.`,ve,E,Tt=`<strong>Multi-scale Deformable Attention Module</strong><br/>
The second problem is resolved similarly to YOLOv3, in which multi-scale feature maps are introduced. In convolutional neural networks, earlier layers extract smaller details (ex. lines) while later layers extract larger details (ex. wheels, ears). In a similar manner, different layers of deformable attention result in different levels of resolution. By connecting the outputs of some of these layers from the encoder to the decoder, it allows for the model to detect objects of a multitude of sizes.`,xe,R,Ee,W,Jt=`Conditional DETR also sets out to resolve the problem of slow training convergence in the original DETR, resulting in convergence that is over 6.7 times faster. The authors found that the object queries are general and are not specific to the input image. Using <strong>Conditional Cross-Attention</strong> in the decoder, the queries can better localize the areas for bounding box regression.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/DETR_DecoderLayer.png" alt="A decoder layer for Deformable DETR"/> <em>Left: DETR Decoder Layer. Right: Deformable DETR Decoder Layer</em><br/>
The original DETR and Deformable DETR decoder layers are compared in the figure above, with the main difference being the query input of the cross-attention block. The authors make a distinction between content query c<sub>q</sub> (decoder self attention output) and spatial query p<sub>q</sub>. The original DETR simply adds them together. In Deformable DETR, they are concatenated, with c<sub>q</sub> focusing on the content of the object and p<sub>q</sub> focusing on the bounding box regions.<br/>
The spatial query p<sub>q</sub> is the result of both the decoder embeddings and object queries projecting to the same space (to become T and p<sub>s</sub> respectively) and multiplied together. The previous layers’ decoder embeddings contain information for the bounding box regions, and the object queries contains information of learned reference points for each bounding box. Thus, their projections combine into a representation that allows for cross-attention to measure their similarities with the encoder input and sinusoidal positional embedding. This is more effective than DETR which only uses object queries and fixed reference points.`,Re,B,We,Q,Ut="You can infer with existing DETR models on Hugging Face Hub like below:",Be,N,Qe,D,gt="Outputs are below.",Ne,G,De,_,Ge,V,Ct="The implementation of DETR from the original paper is shown below:",_e,z,Ve,Y,ze,X,It=`<strong>Backbone</strong><br/>
The input image is first put through a ResNet backbone and then a convolution layer, which reduces the dimension to the <code>hidden_dim</code>.`,Ye,H,Xe,L,At="They are declared in the <code>__init__</code> function.",He,S,Le,F,$t="<strong>Positional Embeddings</strong>",Se,q,Zt="While in the paper fixed and trained embeddings are used in the encoder and decoder respectively, the authors used trained embeddings for both in the implementation for simplicity.",Fe,K,qe,P,kt="They are declared here as <code>nn.Parameter</code>. The row and column embeddings combined denote the locations in the image.",Ke,O,Pe,ee,vt=`<strong>Resize</strong><br/>
Before going into the transformer, the features with size <code>(batch size, hidden_dim, H, W)</code> are reshaped to <code>(hidden_dim, batch size, H*W)</code>. This makes them a sequential input for the transformer.`,Oe,te,et,se,xt=`<strong>Transformer</strong><br/>
The <code>nn.Transformer</code> function takes in the first parameter as the input to the encoder, and the second parameter as the input of the encoder. As you can see, the encoder takes in the resized features added to the positional embeddings, while the decoder takes in <code>query_pos</code>, which is the decoder positional embedding.`,tt,le,st,ne,Et=`<strong>Feed-Forward Network</strong><br/>
In the end, the outputs, which is a tensor of size <code>(query_pos_dim, batch size, hidden_dim)</code>, is fed through two linear layers.`,lt,ae,nt,ie,Rt="The first of which predicts the class. An additional class is added for the <code>No Object</code> class.",at,oe,it,re,Wt="The second linear layer predicts the bounding box with an output size 4 for the xy coordinates, height and width.",ot,Me,rt,pe,Mt,ce,Bt='<li><a href="https://arxiv.org/abs/2005.12872" rel="nofollow">DETR</a></li> <li><a href="https://arxiv.org/abs/1506.02640" rel="nofollow">YOLO</a></li> <li><a href="https://arxiv.org/abs/1804.02767" rel="nofollow">YOLOv3</a></li> <li><a href="https://arxiv.org/abs/2108.06152" rel="nofollow">Conditional DETR</a></li> <li><a href="https://arxiv.org/abs/2010.04159" rel="nofollow">Deformable DETR</a></li> <li><a href="https://huggingface.co/facebook/detr-resnet-50" rel="nofollow"><code>facebook/detr-resnet-50</code></a></li>',pt,de,ct,he,dt;return y=new u({props:{title:"DEtection TRansformer (DETR)",local:"detection-transformer-detr",headingTag:"h1"}}),j=new u({props:{title:"Overview of architecture",local:"overview-of-architecture",headingTag:"h2"}}),J=new u({props:{title:"Key Features",local:"key-features",headingTag:"h2"}}),U=new u({props:{title:"Encoder-Decoder",local:"encoder-decoder",headingTag:"h3"}}),C=new u({props:{title:"Set-based Global Loss Function",local:"set-based-global-loss-function",headingTag:"h3"}}),$=new u({props:{title:"Using DETR to Detect Objects",local:"using-detr-to-detect-objects",headingTag:"h2"}}),k=new u({props:{title:"Evolution of DETR",local:"evolution-of-detr",headingTag:"h2"}}),v=new u({props:{title:"Deformable DETR",local:"deformable-detr",headingTag:"h3"}}),R=new u({props:{title:"Conditional DETR",local:"conditional-detr",headingTag:"h3"}}),B=new u({props:{title:"DETR Inference",local:"detr-inference",headingTag:"h2"}}),N=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrImageProcessor, DetrForObjectDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># initialize the model</span>
processor = DetrImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;facebook/detr-resnet-101&quot;</span>, revision=<span class="hljs-string">&quot;no_timm&quot;</span>
)
model = DetrForObjectDetection.from_pretrained(
    <span class="hljs-string">&quot;facebook/detr-resnet-101&quot;</span>, revision=<span class="hljs-string">&quot;no_timm&quot;</span>
)

<span class="hljs-comment"># preprocess the inputs and infer</span>
inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)

<span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-comment"># non max supression above 0.9</span>
target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
results = processor.post_process_object_detection(
    outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.9</span>
)[<span class="hljs-number">0</span>]

<span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
    )`,wrap:!1}}),G=new b({props:{code:"RGV0ZWN0ZWQlMjBjYXQlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk4JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjM0NC4wNiUyQyUyMDI0Ljg1JTJDJTIwNjQwLjM0JTJDJTIwMzczLjc0JTVEJTBBRGV0ZWN0ZWQlMjByZW1vdGUlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk3JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjMyOC4xMyUyQyUyMDc1LjkzJTJDJTIwMzcyLjgxJTJDJTIwMTg3LjY2JTVEJTBBRGV0ZWN0ZWQlMjByZW1vdGUlMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk3JTIwYXQlMjBsb2NhdGlvbiUyMCU1QjM5LjM0JTJDJTIwNzAuMTMlMkMlMjAxNzUuNTYlMkMlMjAxMTguNzglNUQlMEFEZXRlY3RlZCUyMGNhdCUyMHdpdGglMjBjb25maWRlbmNlJTIwMC45OTglMjBhdCUyMGxvY2F0aW9uJTIwJTVCMTUuMzYlMkMlMjA1MS43NSUyQyUyMDMxNi44OSUyQyUyMDQ3MS4xNiU1RCUwQURldGVjdGVkJTIwY291Y2glMjB3aXRoJTIwY29uZmlkZW5jZSUyMDAuOTk1JTIwYXQlMjBsb2NhdGlvbiUyMCU1Qi0wLjE5JTJDJTIwMC43MSUyQyUyMDYzOS43MyUyQyUyMDQ3NC4xNyU1RA==",highlighted:`Detected <span class="hljs-built_in">cat</span> with confidence 0.998 at location [344.06, 24.85, 640.34, 373.74]
Detected remote with confidence 0.997 at location [328.13, 75.93, 372.81, 187.66]
Detected remote with confidence 0.997 at location [39.34, 70.13, 175.56, 118.78]
Detected <span class="hljs-built_in">cat</span> with confidence 0.998 at location [15.36, 51.75, 316.89, 471.16]
Detected couch with confidence 0.995 at location [-0.19, 0.71, 639.73, 474.17]`,wrap:!1}}),_=new u({props:{title:"PyTorch Implementation of DETR",local:"pytorch-implementation-of-detr",headingTag:"h2"}}),z=new b({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> torchvision.models <span class="hljs-keyword">import</span> resnet50


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DETR</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self, num_classes, hidden_dim, nheads, num_encoder_layers, num_decoder_layers
    </span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
        self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)
        self.transformer = nn.Transformer(
            hidden_dim, nheads, num_encoder_layers, num_decoder_layers
        )
        self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)
        self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)
        self.query_pos = nn.Parameter(torch.rand(<span class="hljs-number">100</span>, hidden_dim))
        self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
        self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, inputs</span>):
        x = self.backbone(inputs)
        h = self.conv(x)
        H, W = h.shape[-<span class="hljs-number">2</span>:]
        pos = (
            torch.cat(
                [
                    self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
                    self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
                ],
                dim=-<span class="hljs-number">1</span>,
            )
            .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
            .unsqueeze(<span class="hljs-number">1</span>)
        )
        h = self.transformer(
            pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>)
        )
        <span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()`,wrap:!1}}),Y=new u({props:{title:"Going line by line in the forward function:",local:"going-line-by-line-in-the-forward-function",headingTag:"h3"}}),H=new b({props:{code:"eCUyMCUzRCUyMHNlbGYuYmFja2JvbmUoaW5wdXRzKSUwQWglMjAlM0QlMjBzZWxmLmNvbnYoeCk=",highlighted:`x = self.backbone(inputs)
h = self.conv(x)`,wrap:!1}}),S=new b({props:{code:"c2VsZi5iYWNrYm9uZSUyMCUzRCUyMG5uLlNlcXVlbnRpYWwoKmxpc3QocmVzbmV0NTAocHJldHJhaW5lZCUzRFRydWUpLmNoaWxkcmVuKCkpJTVCJTNBLTIlNUQpJTBBc2VsZi5jb252JTIwJTNEJTIwbm4uQ29udjJkKDIwNDglMkMlMjBoaWRkZW5fZGltJTJDJTIwMSk=",highlighted:`self.backbone = nn.Sequential(*<span class="hljs-built_in">list</span>(resnet50(pretrained=<span class="hljs-literal">True</span>).children())[:-<span class="hljs-number">2</span>])
self.conv = nn.Conv2d(<span class="hljs-number">2048</span>, hidden_dim, <span class="hljs-number">1</span>)`,wrap:!1}}),K=new b({props:{code:"cG9zJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLmNhdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmNvbF9lbWJlZCU1QiUzQVclNUQudW5zcXVlZXplKDApLnJlcGVhdChIJTJDJTIwMSUyQyUyMDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yb3dfZW1iZWQlNUIlM0FIJTVELnVuc3F1ZWV6ZSgxKS5yZXBlYXQoMSUyQyUyMFclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpbSUzRC0xJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMC5mbGF0dGVuKDAlMkMlMjAxKSUwQSUyMCUyMCUyMCUyMC51bnNxdWVlemUoMSklMEEp",highlighted:`pos = (
    torch.cat(
        [
            self.col_embed[:W].unsqueeze(<span class="hljs-number">0</span>).repeat(H, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
            self.row_embed[:H].unsqueeze(<span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, W, <span class="hljs-number">1</span>),
        ],
        dim=-<span class="hljs-number">1</span>,
    )
    .flatten(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    .unsqueeze(<span class="hljs-number">1</span>)
)`,wrap:!1}}),O=new b({props:{code:"c2VsZi5yb3dfZW1iZWQlMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCg1MCUyQyUyMGhpZGRlbl9kaW0lMjAlMkYlMkYlMjAyKSklMEFzZWxmLmNvbF9lbWJlZCUyMCUzRCUyMG5uLlBhcmFtZXRlcih0b3JjaC5yYW5kKDUwJTJDJTIwaGlkZGVuX2RpbSUyMCUyRiUyRiUyMDIpKQ==",highlighted:`self.row_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))
self.col_embed = nn.Parameter(torch.rand(<span class="hljs-number">50</span>, hidden_dim // <span class="hljs-number">2</span>))`,wrap:!1}}),te=new b({props:{code:"aC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKQ==",highlighted:'h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)',wrap:!1}}),le=new b({props:{code:"aCUyMCUzRCUyMHNlbGYudHJhbnNmb3JtZXIocG9zJTIwJTJCJTIwaC5mbGF0dGVuKDIpLnBlcm11dGUoMiUyQyUyMDAlMkMlMjAxKSUyQyUyMHNlbGYucXVlcnlfcG9zLnVuc3F1ZWV6ZSgxKSk=",highlighted:'h = self.transformer(pos + h.flatten(<span class="hljs-number">2</span>).permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>), self.query_pos.unsqueeze(<span class="hljs-number">1</span>))',wrap:!1}}),ae=new b({props:{code:"cmV0dXJuJTIwc2VsZi5saW5lYXJfY2xhc3MoaCklMkMlMjBzZWxmLmxpbmVhcl9iYm94KGgpLnNpZ21vaWQoKQ==",highlighted:'<span class="hljs-keyword">return</span> self.linear_class(h), self.linear_bbox(h).sigmoid()',wrap:!1}}),oe=new b({props:{code:"c2VsZi5saW5lYXJfY2xhc3MlMjAlM0QlMjBubi5MaW5lYXIoaGlkZGVuX2RpbSUyQyUyMG51bV9jbGFzc2VzJTIwJTJCJTIwMSk=",highlighted:'self.linear_class = nn.Linear(hidden_dim, num_classes + <span class="hljs-number">1</span>)',wrap:!1}}),Me=new b({props:{code:"c2VsZi5saW5lYXJfYmJveCUyMCUzRCUyMG5uLkxpbmVhcihoaWRkZW5fZGltJTJDJTIwNCk=",highlighted:'self.linear_bbox = nn.Linear(hidden_dim, <span class="hljs-number">4</span>)',wrap:!1}}),pe=new u({props:{title:"References",local:"references",headingTag:"h2"}}),de=new Ht({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit3/vision-transformers/detr.mdx"}}),{c(){f=i("meta"),ue=n(),me=i("p"),be=n(),o(y.$$.fragment),fe=n(),o(j.$$.fragment),ye=n(),w=i("p"),w.innerHTML=ht,je=n(),T=i("p"),T.innerHTML=ut,we=n(),o(J.$$.fragment),Te=n(),o(U.$$.fragment),Je=n(),g=i("p"),g.innerHTML=bt,Ue=n(),o(C.$$.fragment),ge=n(),I=i("p"),I.textContent=ft,Ce=n(),A=i("p"),A.innerHTML=yt,Ie=n(),o($.$$.fragment),Ae=n(),Z=i("p"),Z.innerHTML=jt,$e=n(),o(k.$$.fragment),Ze=n(),o(v.$$.fragment),ke=n(),x=i("p"),x.innerHTML=wt,ve=n(),E=i("p"),E.innerHTML=Tt,xe=n(),o(R.$$.fragment),Ee=n(),W=i("p"),W.innerHTML=Jt,Re=n(),o(B.$$.fragment),We=n(),Q=i("p"),Q.textContent=Ut,Be=n(),o(N.$$.fragment),Qe=n(),D=i("p"),D.textContent=gt,Ne=n(),o(G.$$.fragment),De=n(),o(_.$$.fragment),Ge=n(),V=i("p"),V.textContent=Ct,_e=n(),o(z.$$.fragment),Ve=n(),o(Y.$$.fragment),ze=n(),X=i("p"),X.innerHTML=It,Ye=n(),o(H.$$.fragment),Xe=n(),L=i("p"),L.innerHTML=At,He=n(),o(S.$$.fragment),Le=n(),F=i("p"),F.innerHTML=$t,Se=n(),q=i("p"),q.textContent=Zt,Fe=n(),o(K.$$.fragment),qe=n(),P=i("p"),P.innerHTML=kt,Ke=n(),o(O.$$.fragment),Pe=n(),ee=i("p"),ee.innerHTML=vt,Oe=n(),o(te.$$.fragment),et=n(),se=i("p"),se.innerHTML=xt,tt=n(),o(le.$$.fragment),st=n(),ne=i("p"),ne.innerHTML=Et,lt=n(),o(ae.$$.fragment),nt=n(),ie=i("p"),ie.innerHTML=Rt,at=n(),o(oe.$$.fragment),it=n(),re=i("p"),re.textContent=Wt,ot=n(),o(Me.$$.fragment),rt=n(),o(pe.$$.fragment),Mt=n(),ce=i("ul"),ce.innerHTML=Bt,pt=n(),o(de.$$.fragment),ct=n(),he=i("p"),this.h()},l(e){const t=Yt("svelte-u9bgzb",document.head);f=r(t,"META",{name:!0,content:!0}),t.forEach(s),ue=a(e),me=r(e,"P",{}),Qt(me).forEach(s),be=a(e),M(y.$$.fragment,e),fe=a(e),M(j.$$.fragment,e),ye=a(e),w=r(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1uea2cx"&&(w.innerHTML=ht),je=a(e),T=r(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-1mj736s"&&(T.innerHTML=ut),we=a(e),M(J.$$.fragment,e),Te=a(e),M(U.$$.fragment,e),Je=a(e),g=r(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-t8og7r"&&(g.innerHTML=bt),Ue=a(e),M(C.$$.fragment,e),ge=a(e),I=r(e,"P",{"data-svelte-h":!0}),h(I)!=="svelte-12feezj"&&(I.textContent=ft),Ce=a(e),A=r(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-1obgrh7"&&(A.innerHTML=yt),Ie=a(e),M($.$$.fragment,e),Ae=a(e),Z=r(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-f2wazx"&&(Z.innerHTML=jt),$e=a(e),M(k.$$.fragment,e),Ze=a(e),M(v.$$.fragment,e),ke=a(e),x=r(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-w2zzks"&&(x.innerHTML=wt),ve=a(e),E=r(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-vzcbkx"&&(E.innerHTML=Tt),xe=a(e),M(R.$$.fragment,e),Ee=a(e),W=r(e,"P",{"data-svelte-h":!0}),h(W)!=="svelte-1eux0rj"&&(W.innerHTML=Jt),Re=a(e),M(B.$$.fragment,e),We=a(e),Q=r(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-fvf0lp"&&(Q.textContent=Ut),Be=a(e),M(N.$$.fragment,e),Qe=a(e),D=r(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-r4sesn"&&(D.textContent=gt),Ne=a(e),M(G.$$.fragment,e),De=a(e),M(_.$$.fragment,e),Ge=a(e),V=r(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-d0cg5t"&&(V.textContent=Ct),_e=a(e),M(z.$$.fragment,e),Ve=a(e),M(Y.$$.fragment,e),ze=a(e),X=r(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-13sutp8"&&(X.innerHTML=It),Ye=a(e),M(H.$$.fragment,e),Xe=a(e),L=r(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-f638vd"&&(L.innerHTML=At),He=a(e),M(S.$$.fragment,e),Le=a(e),F=r(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1afjwf9"&&(F.innerHTML=$t),Se=a(e),q=r(e,"P",{"data-svelte-h":!0}),h(q)!=="svelte-1e5n46h"&&(q.textContent=Zt),Fe=a(e),M(K.$$.fragment,e),qe=a(e),P=r(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-xpw6n2"&&(P.innerHTML=kt),Ke=a(e),M(O.$$.fragment,e),Pe=a(e),ee=r(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1mhfud0"&&(ee.innerHTML=vt),Oe=a(e),M(te.$$.fragment,e),et=a(e),se=r(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-b0wrkd"&&(se.innerHTML=xt),tt=a(e),M(le.$$.fragment,e),st=a(e),ne=r(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-bczn5d"&&(ne.innerHTML=Et),lt=a(e),M(ae.$$.fragment,e),nt=a(e),ie=r(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1wmk5h5"&&(ie.innerHTML=Rt),at=a(e),M(oe.$$.fragment,e),it=a(e),re=r(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-yoo56g"&&(re.textContent=Wt),ot=a(e),M(Me.$$.fragment,e),rt=a(e),M(pe.$$.fragment,e),Mt=a(e),ce=r(e,"UL",{"data-svelte-h":!0}),h(ce)!=="svelte-1ie7nnc"&&(ce.innerHTML=Bt),pt=a(e),M(de.$$.fragment,e),ct=a(e),he=r(e,"P",{}),Qt(he).forEach(s),this.h()},h(){Nt(f,"name","hf:doc:metadata"),Nt(f,"content",St)},m(e,t){Xt(document.head,f),l(e,ue,t),l(e,me,t),l(e,be,t),p(y,e,t),l(e,fe,t),p(j,e,t),l(e,ye,t),l(e,w,t),l(e,je,t),l(e,T,t),l(e,we,t),p(J,e,t),l(e,Te,t),p(U,e,t),l(e,Je,t),l(e,g,t),l(e,Ue,t),p(C,e,t),l(e,ge,t),l(e,I,t),l(e,Ce,t),l(e,A,t),l(e,Ie,t),p($,e,t),l(e,Ae,t),l(e,Z,t),l(e,$e,t),p(k,e,t),l(e,Ze,t),p(v,e,t),l(e,ke,t),l(e,x,t),l(e,ve,t),l(e,E,t),l(e,xe,t),p(R,e,t),l(e,Ee,t),l(e,W,t),l(e,Re,t),p(B,e,t),l(e,We,t),l(e,Q,t),l(e,Be,t),p(N,e,t),l(e,Qe,t),l(e,D,t),l(e,Ne,t),p(G,e,t),l(e,De,t),p(_,e,t),l(e,Ge,t),l(e,V,t),l(e,_e,t),p(z,e,t),l(e,Ve,t),p(Y,e,t),l(e,ze,t),l(e,X,t),l(e,Ye,t),p(H,e,t),l(e,Xe,t),l(e,L,t),l(e,He,t),p(S,e,t),l(e,Le,t),l(e,F,t),l(e,Se,t),l(e,q,t),l(e,Fe,t),p(K,e,t),l(e,qe,t),l(e,P,t),l(e,Ke,t),p(O,e,t),l(e,Pe,t),l(e,ee,t),l(e,Oe,t),p(te,e,t),l(e,et,t),l(e,se,t),l(e,tt,t),p(le,e,t),l(e,st,t),l(e,ne,t),l(e,lt,t),p(ae,e,t),l(e,nt,t),l(e,ie,t),l(e,at,t),p(oe,e,t),l(e,it,t),l(e,re,t),l(e,ot,t),p(Me,e,t),l(e,rt,t),p(pe,e,t),l(e,Mt,t),l(e,ce,t),l(e,pt,t),p(de,e,t),l(e,ct,t),l(e,he,t),dt=!0},p:Gt,i(e){dt||(c(y.$$.fragment,e),c(j.$$.fragment,e),c(J.$$.fragment,e),c(U.$$.fragment,e),c(C.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(R.$$.fragment,e),c(B.$$.fragment,e),c(N.$$.fragment,e),c(G.$$.fragment,e),c(_.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(K.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),dt=!0)},o(e){d(y.$$.fragment,e),d(j.$$.fragment,e),d(J.$$.fragment,e),d(U.$$.fragment,e),d(C.$$.fragment,e),d($.$$.fragment,e),d(k.$$.fragment,e),d(v.$$.fragment,e),d(R.$$.fragment,e),d(B.$$.fragment,e),d(N.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(K.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),d(Me.$$.fragment,e),d(pe.$$.fragment,e),d(de.$$.fragment,e),dt=!1},d(e){e&&(s(ue),s(me),s(be),s(fe),s(ye),s(w),s(je),s(T),s(we),s(Te),s(Je),s(g),s(Ue),s(ge),s(I),s(Ce),s(A),s(Ie),s(Ae),s(Z),s($e),s(Ze),s(ke),s(x),s(ve),s(E),s(xe),s(Ee),s(W),s(Re),s(We),s(Q),s(Be),s(Qe),s(D),s(Ne),s(De),s(Ge),s(V),s(_e),s(Ve),s(ze),s(X),s(Ye),s(Xe),s(L),s(He),s(Le),s(F),s(Se),s(q),s(Fe),s(qe),s(P),s(Ke),s(Pe),s(ee),s(Oe),s(et),s(se),s(tt),s(st),s(ne),s(lt),s(nt),s(ie),s(at),s(it),s(re),s(ot),s(rt),s(Mt),s(ce),s(pt),s(ct),s(he)),s(f),m(y,e),m(j,e),m(J,e),m(U,e),m(C,e),m($,e),m(k,e),m(v,e),m(R,e),m(B,e),m(N,e),m(G,e),m(_,e),m(z,e),m(Y,e),m(H,e),m(S,e),m(K,e),m(O,e),m(te,e),m(le,e),m(ae,e),m(oe,e),m(Me,e),m(pe,e),m(de,e)}}}const St='{"title":"DEtection TRansformer (DETR)","local":"detection-transformer-detr","sections":[{"title":"Overview of architecture","local":"overview-of-architecture","sections":[],"depth":2},{"title":"Key Features","local":"key-features","sections":[{"title":"Encoder-Decoder","local":"encoder-decoder","sections":[],"depth":3},{"title":"Set-based Global Loss Function","local":"set-based-global-loss-function","sections":[],"depth":3}],"depth":2},{"title":"Using DETR to Detect Objects","local":"using-detr-to-detect-objects","sections":[],"depth":2},{"title":"Evolution of DETR","local":"evolution-of-detr","sections":[{"title":"Deformable DETR","local":"deformable-detr","sections":[],"depth":3},{"title":"Conditional DETR","local":"conditional-detr","sections":[],"depth":3}],"depth":2},{"title":"DETR Inference","local":"detr-inference","sections":[],"depth":2},{"title":"PyTorch Implementation of DETR","local":"pytorch-implementation-of-detr","sections":[{"title":"Going line by line in the forward function:","local":"going-line-by-line-in-the-forward-function","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function Ft(mt){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Vt{constructor(f){super(),zt(this,f,Ft,Lt,Dt,{})}}export{es as component};
