import{s as Ln,f as jn,o as Jn,n as L}from"../chunks/scheduler.25b97de1.js";import{S as Zn,i as kn,g as p,s as i,r as g,A as Un,h as m,f as s,c as l,j as v,u as f,x as C,k as $,y as c,a as d,v as u,d as h,t as _,w as b}from"../chunks/index.d9030fc9.js";import{T as Lt}from"../chunks/Tip.baa67368.js";import{D as w}from"../chunks/Docstring.ffac8efa.js";import{C as ee}from"../chunks/CodeBlock.e6cd0d95.js";import{E as K}from"../chunks/ExampleCodeBlock.22dfe688.js";import{P as Wn}from"../chunks/PipelineTag.5f100392.js";import{H as q,E as zn}from"../chunks/EditOnGithub.91d95064.js";function Bn(I){let o,M="Example:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBTZWdDb25maWclMkMlMjBDTElQU2VnTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ0NvbmZpZyUyMHdpdGglMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDTElQU2VnQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ01vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQ0xJUFNlZ01vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZyUwQSUwQSUyMyUyMFdlJTIwY2FuJTIwYWxzbyUyMGluaXRpYWxpemUlMjBhJTIwQ0xJUFNlZ0NvbmZpZyUyMGZyb20lMjBhJTIwQ0xJUFNlZ1RleHRDb25maWclMjBhbmQlMjBhJTIwQ0xJUFNlZ1Zpc2lvbkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQU2VnVGV4dCUyMGFuZCUyMENMSVBTZWdWaXNpb24lMjBjb25maWd1cmF0aW9uJTBBY29uZmlnX3RleHQlMjAlM0QlMjBDTElQU2VnVGV4dENvbmZpZygpJTBBY29uZmlnX3Zpc2lvbiUyMCUzRCUyMENMSVBTZWdWaXNpb25Db25maWcoKSUwQSUwQWNvbmZpZyUyMCUzRCUyMENMSVBTZWdDb25maWcuZnJvbV90ZXh0X3Zpc2lvbl9jb25maWdzKGNvbmZpZ190ZXh0JTJDJTIwY29uZmlnX3Zpc2lvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPSegConfig, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegConfig with CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CLIPSegConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegModel (with random weights) from the CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also initialize a CLIPSegConfig from a CLIPSegTextConfig and a CLIPSegVisionConfig</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegText and CLIPSegVision configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text = CLIPSegTextConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>config_vision = CLIPSegVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>config = CLIPSegConfig.from_text_vision_configs(config_text, config_vision)`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-11lpom8"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Vn(I){let o,M="Example:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBTZWdUZXh0Q29uZmlnJTJDJTIwQ0xJUFNlZ1RleHRNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQU2VnVGV4dENvbmZpZyUyMHdpdGglMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDTElQU2VnVGV4dENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVBTZWdUZXh0TW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMENJREFTJTJGY2xpcHNlZy1yZDY0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnVGV4dE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPSegTextConfig, CLIPSegTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegTextConfig with CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CLIPSegTextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegTextModel (with random weights) from the CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegTextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-11lpom8"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Nn(I){let o,M="Example:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBTZWdWaXNpb25Db25maWclMkMlMjBDTElQU2VnVmlzaW9uTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ1Zpc2lvbkNvbmZpZyUyMHdpdGglMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDTElQU2VnVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUFNlZ1Zpc2lvbk1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBDSURBUyUyRmNsaXBzZWctcmQ2NCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQ0xJUFNlZ1Zpc2lvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPSegVisionConfig, CLIPSegVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegVisionConfig with CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CLIPSegVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIPSegVisionModel (with random weights) from the CIDAS/clipseg-rd64 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegVisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-11lpom8"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Fn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=M},l(a){o=m(a,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function En(I){let o,M="Examples:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMENMSVBTZWdNb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0c19wZXJfaW1hZ2UlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0c19wZXJfaW1hZ2UlMjAlMjAlMjMlMjB0aGlzJTIwaXMlMjB0aGUlMjBpbWFnZS10ZXh0JTIwc2ltaWxhcml0eSUyMHNjb3JlJTBBcHJvYnMlMjAlM0QlMjBsb2dpdHNfcGVyX2ltYWdlLnNvZnRtYXgoZGltJTNEMSklMjAlMjAlMjMlMjB3ZSUyMGNhbiUyMHRha2UlMjB0aGUlMjBzb2Z0bWF4JTIwdG8lMjBnZXQlMjB0aGUlMjBsYWJlbCUyMHByb2JhYmlsaXRpZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function qn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=M},l(a){o=m(a,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function Hn(I){let o,M="Examples:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDTElQU2VnTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJDSURBUyUyRmNsaXBzZWctcmQ2NC1yZWZpbmVkJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ0xJUFNlZ01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJDSURBUyUyRmNsaXBzZWctcmQ2NC1yZWZpbmVkJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBdGV4dF9mZWF0dXJlcyUyMCUzRCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqaW5wdXRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Xn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=M},l(a){o=m(a,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function Gn(I){let o,M="Examples:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMENMSVBTZWdNb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBaW1hZ2VfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Rn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=M},l(a){o=m(a,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function Qn(I){let o,M="Examples:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDTElQU2VnVGV4dE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyQ0lEQVMlMkZjbGlwc2VnLXJkNjQtcmVmaW5lZCUyMiklMEFtb2RlbCUyMCUzRCUyMENMSVBTZWdUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMmElMjBwaG90byUyMG9mJTIwYSUyMGNhdCUyMiUyQyUyMCUyMmElMjBwaG90byUyMG9mJTIwYSUyMGRvZyUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBcG9vbGVkX291dHB1dCUyMCUzRCUyMG91dHB1dHMucG9vbGVyX291dHB1dCUyMCUyMCUyMyUyMHBvb2xlZCUyMChFT1MlMjB0b2tlbiklMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CLIPSegTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegTextModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Dn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=M},l(a){o=m(a,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function An(I){let o,M="Examples:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMENMSVBTZWdWaXNpb25Nb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBDTFMlMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegVisionModel.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Yn(I){let o,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=p("p"),o.innerHTML=M},l(a){o=m(a,"P",{"data-svelte-h":!0}),C(o)!=="svelte-fincs2"&&(o.innerHTML=M)},m(a,r){d(a,o,r)},p:L,d(a){a&&s(o)}}}function On(I){let o,M="Examples:",a,r,y;return r=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBDTElQU2VnRm9ySW1hZ2VTZWdtZW50YXRpb24lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBDTElQU2VnRm9ySW1hZ2VTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkNJREFTJTJGY2xpcHNlZy1yZDY0LXJlZmluZWQlMjIpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQXRleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMCUyMmElMjByZW1vdGUlMjIlMkMlMjAlMjJhJTIwYmxhbmtldCUyMiU1RCUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dHMlMkMlMjBpbWFnZXMlM0QlNUJpbWFnZSU1RCUyMColMjBsZW4odGV4dHMpJTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQXByaW50KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, CLIPSegForImageSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CLIPSegForImageSegmentation.from_pretrained(<span class="hljs-string">&quot;CIDAS/clipseg-rd64-refined&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [<span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a remote&quot;</span>, <span class="hljs-string">&quot;a blanket&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=[image] * <span class="hljs-built_in">len</span>(texts), padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(logits.shape)
torch.Size([<span class="hljs-number">3</span>, <span class="hljs-number">352</span>, <span class="hljs-number">352</span>])`,wrap:!1}}),{c(){o=p("p"),o.textContent=M,a=i(),g(r.$$.fragment)},l(t){o=m(t,"P",{"data-svelte-h":!0}),C(o)!=="svelte-kvfsh7"&&(o.textContent=M),a=l(t),f(r.$$.fragment,t)},m(t,T){d(t,o,T),d(t,a,T),u(r,t,T),y=!0},p:L,i(t){y||(h(r.$$.fragment,t),y=!0)},o(t){_(r.$$.fragment,t),y=!1},d(t){t&&(s(o),s(a)),b(r,t)}}}function Kn(I){let o,M,a,r,y,t,T,Jt,Ce,en=`The CLIPSeg model was proposed in <a href="https://arxiv.org/abs/2112.10003" rel="nofollow">Image Segmentation Using Text and Image Prompts</a> by Timo Lüddecke
and Alexander Ecker. CLIPSeg adds a minimal decoder on top of a frozen <a href="clip">CLIP</a> model for zero-shot and one-shot image segmentation.`,Zt,Ie,tn="The abstract from the paper is the following:",kt,$e,on=`<em>Image segmentation is usually addressed by training a
model for a fixed set of object classes. Incorporating additional classes or more complex queries later is expensive
as it requires re-training the model on a dataset that encompasses these expressions. Here we propose a system
that can generate image segmentations based on arbitrary
prompts at test time. A prompt can be either a text or an
image. This approach enables us to create a unified model
(trained once) for three common segmentation tasks, which
come with distinct challenges: referring expression segmentation, zero-shot segmentation and one-shot segmentation.
We build upon the CLIP model as a backbone which we extend with a transformer-based decoder that enables dense
prediction. After training on an extended version of the
PhraseCut dataset, our system generates a binary segmentation map for an image based on a free-text prompt or on
an additional image expressing the query. We analyze different variants of the latter image-based prompts in detail.
This novel hybrid input allows for dynamic adaptation not
only to the three segmentation tasks mentioned above, but
to any binary segmentation task where a text or image query
can be formulated. Finally, we find our system to adapt well
to generalized queries involving affordances or properties</em>`,Ut,te,nn,Wt,ve,sn='CLIPSeg overview. Taken from the <a href="https://arxiv.org/abs/2112.10003">original paper.</a>',zt,we,rn=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/timojl/clipseg" rel="nofollow">here</a>.`,Bt,Pe,Vt,Se,an=`<li><a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegForImageSegmentation">CLIPSegForImageSegmentation</a> adds a decoder on top of <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. The latter is identical to <a href="/docs/transformers/pr_29886/en/model_doc/clip#transformers.CLIPModel">CLIPModel</a>.</li> <li><a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegForImageSegmentation">CLIPSegForImageSegmentation</a> can generate image segmentations based on arbitrary prompts at test time. A prompt can be either a text
(provided to the model as <code>input_ids</code>) or an image (provided to the model as <code>conditional_pixel_values</code>). One can also provide custom
conditional embeddings (provided to the model as <code>conditional_embeddings</code>).</li>`,Nt,xe,Ft,Le,ln="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with CLIPSeg. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Et,je,qt,Je,dn='<li>A notebook that illustrates <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/CLIPSeg/Zero_shot_image_segmentation_with_CLIPSeg.ipynb" rel="nofollow">zero-shot image segmentation with CLIPSeg</a>.</li>',Ht,Ze,Xt,P,ke,co,ct,cn=`<a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> is the configuration class to store the configuration of a <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. It is used to
instantiate a CLIPSeg model according to the specified arguments, defining the text model and vision model configs.
Instantiating a configuration with the defaults will yield a similar configuration to that of the CLIPSeg
<a href="https://huggingface.co/CIDAS/clipseg-rd64" rel="nofollow">CIDAS/clipseg-rd64</a> architecture.`,po,pt,pn=`Configuration objects inherit from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,mo,oe,go,ne,Ue,fo,mt,mn=`Instantiate a <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a> (or a derived class) from clipseg text model configuration and clipseg vision
model configuration.`,Gt,We,Rt,j,ze,uo,gt,gn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. It is used to instantiate an
CLIPSeg model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the CLIPSeg
<a href="https://huggingface.co/CIDAS/clipseg-rd64" rel="nofollow">CIDAS/clipseg-rd64</a> architecture.`,ho,ft,fn=`Configuration objects inherit from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,_o,se,Qt,Be,Dt,J,Ve,bo,ut,un=`This is the configuration class to store the configuration of a <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>. It is used to instantiate an
CLIPSeg model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the CLIPSeg
<a href="https://huggingface.co/CIDAS/clipseg-rd64" rel="nofollow">CIDAS/clipseg-rd64</a> architecture.`,yo,ht,hn=`Configuration objects inherit from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/pr_29886/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mo,re,At,Ne,Yt,S,Fe,To,_t,_n="Constructs a CLIPSeg processor which wraps a CLIPSeg image processor and a CLIP tokenizer into a single processor.",Co,bt,bn=`<a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegProcessor">CLIPSegProcessor</a> offers all the functionalities of <a href="/docs/transformers/pr_29886/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a> and <a href="/docs/transformers/pr_29886/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegProcessor.decode">decode()</a> for more information.`,Io,ae,Ee,$o,yt,yn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,vo,ie,qe,wo,Mt,Mn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Ot,He,Kt,x,Xe,Po,Tt,Tn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,So,z,Ge,xo,Ct,Cn='The <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> forward method, overrides the <code>__call__</code> special method.',Lo,le,jo,de,Jo,B,Re,Zo,It,In='The <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> forward method, overrides the <code>__call__</code> special method.',ko,ce,Uo,pe,Wo,V,Qe,zo,$t,$n='The <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a> forward method, overrides the <code>__call__</code> special method.',Bo,me,Vo,ge,eo,De,to,Y,Ae,No,N,Ye,Fo,vt,vn='The <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegTextModel">CLIPSegTextModel</a> forward method, overrides the <code>__call__</code> special method.',Eo,fe,qo,ue,oo,Oe,no,O,Ke,Ho,F,et,Xo,wt,wn='The <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegVisionModel">CLIPSegVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Go,he,Ro,_e,so,tt,ro,Z,ot,Qo,Pt,Pn="CLIPSeg model with a Transformer-based decoder on top for zero-shot and one-shot image segmentation.",Do,St,Sn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ao,E,nt,Yo,xt,xn='The <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegForImageSegmentation">CLIPSegForImageSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Oo,be,Ko,ye,ao,st,io,jt,lo;return y=new q({props:{title:"CLIPSeg",local:"clipseg",headingTag:"h1"}}),T=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Pe=new q({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),xe=new q({props:{title:"Resources",local:"resources",headingTag:"h2"}}),je=new Wn({props:{pipeline:"image-segmentation"}}),Ze=new q({props:{title:"CLIPSegConfig",local:"transformers.CLIPSegConfig",headingTag:"h2"}}),ke=new w({props:{name:"class transformers.CLIPSegConfig",anchor:"transformers.CLIPSegConfig",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"extract_layers",val:" = [3, 6, 9]"},{name:"reduce_dim",val:" = 64"},{name:"decoder_num_attention_heads",val:" = 4"},{name:"decoder_attention_dropout",val:" = 0.0"},{name:"decoder_hidden_act",val:" = 'quick_gelu'"},{name:"decoder_intermediate_size",val:" = 2048"},{name:"conditional_layer",val:" = 0"},{name:"use_complex_transposed_convolution",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegConfig.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegTextConfig">CLIPSegTextConfig</a>.`,name:"text_config"},{anchor:"transformers.CLIPSegConfig.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegVisionConfig">CLIPSegVisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.CLIPSegConfig.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.CLIPSegConfig.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The initial value of the <em>logit_scale</em> parameter. Default is used as per the original CLIPSeg implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.CLIPSegConfig.extract_layers",description:`<strong>extract_layers</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[3, 6, 9]</code>) &#x2014;
Layers to extract when forwarding the query image through the frozen visual backbone of CLIP.`,name:"extract_layers"},{anchor:"transformers.CLIPSegConfig.reduce_dim",description:`<strong>reduce_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Dimensionality to reduce the CLIP vision embedding.`,name:"reduce_dim"},{anchor:"transformers.CLIPSegConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads in the decoder of CLIPSeg.`,name:"decoder_num_attention_heads"},{anchor:"transformers.CLIPSegConfig.decoder_attention_dropout",description:`<strong>decoder_attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"decoder_attention_dropout"},{anchor:"transformers.CLIPSegConfig.decoder_hidden_act",description:`<strong>decoder_hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"decoder_hidden_act"},{anchor:"transformers.CLIPSegConfig.decoder_intermediate_size",description:`<strong>decoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layers in the Transformer decoder.`,name:"decoder_intermediate_size"},{anchor:"transformers.CLIPSegConfig.conditional_layer",description:`<strong>conditional_layer</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The layer to use of the Transformer encoder whose activations will be combined with the condition
embeddings using FiLM (Feature-wise Linear Modulation). If 0, the last layer is used.`,name:"conditional_layer"},{anchor:"transformers.CLIPSegConfig.use_complex_transposed_convolution",description:`<strong>use_complex_transposed_convolution</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a more complex transposed convolution in the decoder, enabling more fine-grained
segmentation.`,name:"use_complex_transposed_convolution"},{anchor:"transformers.CLIPSegConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/configuration_clipseg.py#L207"}}),oe=new K({props:{anchor:"transformers.CLIPSegConfig.example",$$slots:{default:[Bn]},$$scope:{ctx:I}}}),Ue=new w({props:{name:"from_text_vision_configs",anchor:"transformers.CLIPSegConfig.from_text_vision_configs",parameters:[{name:"text_config",val:": CLIPSegTextConfig"},{name:"vision_config",val:": CLIPSegVisionConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/configuration_clipseg.py#L383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegConfig"
>CLIPSegConfig</a></p>
`}}),We=new q({props:{title:"CLIPSegTextConfig",local:"transformers.CLIPSegTextConfig",headingTag:"h2"}}),ze=new w({props:{name:"class transformers.CLIPSegTextConfig",anchor:"transformers.CLIPSegTextConfig",parameters:[{name:"vocab_size",val:" = 49408"},{name:"hidden_size",val:" = 512"},{name:"intermediate_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 8"},{name:"max_position_embeddings",val:" = 77"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"pad_token_id",val:" = 1"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegTextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size of the CLIPSeg text model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegModel">CLIPSegModel</a>.`,name:"vocab_size"},{anchor:"transformers.CLIPSegTextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.CLIPSegTextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.CLIPSegTextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.CLIPSegTextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.CLIPSegTextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.CLIPSegTextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.CLIPSegTextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.CLIPSegTextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CLIPSegTextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CLIPSegTextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.CLIPSegTextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.CLIPSegTextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.CLIPSegTextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
End of stream token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/configuration_clipseg.py#L24"}}),se=new K({props:{anchor:"transformers.CLIPSegTextConfig.example",$$slots:{default:[Vn]},$$scope:{ctx:I}}}),Be=new q({props:{title:"CLIPSegVisionConfig",local:"transformers.CLIPSegVisionConfig",headingTag:"h2"}}),Ve=new w({props:{name:"class transformers.CLIPSegVisionConfig",anchor:"transformers.CLIPSegVisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 32"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegVisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.CLIPSegVisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.CLIPSegVisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.CLIPSegVisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.CLIPSegVisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.CLIPSegVisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.CLIPSegVisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.CLIPSegVisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.CLIPSegVisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.CLIPSegVisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CLIPSegVisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CLIPSegVisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/configuration_clipseg.py#L119"}}),re=new K({props:{anchor:"transformers.CLIPSegVisionConfig.example",$$slots:{default:[Nn]},$$scope:{ctx:I}}}),Ne=new q({props:{title:"CLIPSegProcessor",local:"transformers.CLIPSegProcessor",headingTag:"h2"}}),Fe=new w({props:{name:"class transformers.CLIPSegProcessor",anchor:"transformers.CLIPSegProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CLIPSegProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/pr_29886/en/model_doc/vit#transformers.ViTImageProcessor">ViTImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.CLIPSegProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/pr_29886/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/processing_clipseg.py#L25"}}),Ee=new w({props:{name:"batch_decode",anchor:"transformers.CLIPSegProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/processing_clipseg.py#L133"}}),qe=new w({props:{name:"decode",anchor:"transformers.CLIPSegProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/processing_clipseg.py#L140"}}),He=new q({props:{title:"CLIPSegModel",local:"transformers.CLIPSegModel",headingTag:"h2"}}),Xe=new w({props:{name:"class transformers.CLIPSegModel",anchor:"transformers.CLIPSegModel",parameters:[{name:"config",val:": CLIPSegConfig"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L945"}}),Ge=new w({props:{name:"forward",anchor:"transformers.CLIPSegModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_29886/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.CLIPSegModel.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.CLIPSegModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L1079",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clipseg.modeling_clipseg.CLIPSegOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.clipseg.configuration_clipseg.CLIPSegConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
<li><strong>text_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clipseg.modeling_clipseg.CLIPSegOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),le=new Lt({props:{$$slots:{default:[Fn]},$$scope:{ctx:I}}}),de=new K({props:{anchor:"transformers.CLIPSegModel.forward.example",$$slots:{default:[En]},$$scope:{ctx:I}}}),Re=new w({props:{name:"get_text_features",anchor:"transformers.CLIPSegModel.get_text_features",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegModel.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegModel.get_text_features.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegModel.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegModel.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegModel.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L981",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegTextModel"
>CLIPSegTextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),ce=new Lt({props:{$$slots:{default:[qn]},$$scope:{ctx:I}}}),pe=new K({props:{anchor:"transformers.CLIPSegModel.get_text_features.example",$$slots:{default:[Hn]},$$scope:{ctx:I}}}),Qe=new w({props:{name:"get_image_features",anchor:"transformers.CLIPSegModel.get_image_features",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_29886/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.CLIPSegModel.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegModel.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegModel.get_image_features.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegModel.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L1028",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),me=new Lt({props:{$$slots:{default:[Xn]},$$scope:{ctx:I}}}),ge=new K({props:{anchor:"transformers.CLIPSegModel.get_image_features.example",$$slots:{default:[Gn]},$$scope:{ctx:I}}}),De=new q({props:{title:"CLIPSegTextModel",local:"transformers.CLIPSegTextModel",headingTag:"h2"}}),Ae=new w({props:{name:"class transformers.CLIPSegTextModel",anchor:"transformers.CLIPSegTextModel",parameters:[{name:"config",val:": CLIPSegTextConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L779"}}),Ye=new w({props:{name:"forward",anchor:"transformers.CLIPSegTextModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegTextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegTextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegTextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegTextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegTextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegTextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L796",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.clipseg.configuration_clipseg.CLIPSegTextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new Lt({props:{$$slots:{default:[Rn]},$$scope:{ctx:I}}}),ue=new K({props:{anchor:"transformers.CLIPSegTextModel.forward.example",$$slots:{default:[Qn]},$$scope:{ctx:I}}}),Oe=new q({props:{title:"CLIPSegVisionModel",local:"transformers.CLIPSegVisionModel",headingTag:"h2"}}),Ke=new w({props:{name:"class transformers.CLIPSegVisionModel",anchor:"transformers.CLIPSegVisionModel",parameters:[{name:"config",val:": CLIPSegVisionConfig"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L891"}}),et=new w({props:{name:"forward",anchor:"transformers.CLIPSegVisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_29886/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.CLIPSegVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegVisionModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L904",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.clipseg.configuration_clipseg.CLIPSegVisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/pr_29886/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Lt({props:{$$slots:{default:[Dn]},$$scope:{ctx:I}}}),_e=new K({props:{anchor:"transformers.CLIPSegVisionModel.forward.example",$$slots:{default:[An]},$$scope:{ctx:I}}}),tt=new q({props:{title:"CLIPSegForImageSegmentation",local:"transformers.CLIPSegForImageSegmentation",headingTag:"h2"}}),ot=new w({props:{name:"class transformers.CLIPSegForImageSegmentation",anchor:"transformers.CLIPSegForImageSegmentation",parameters:[{name:"config",val:": CLIPSegConfig"}],parametersDescription:[{anchor:"transformers.CLIPSegForImageSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegConfig">CLIPSegConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/pr_29886/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L1332"}}),nt=new w({props:{name:"forward",anchor:"transformers.CLIPSegForImageSegmentation.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"conditional_pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"conditional_embeddings",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = True"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.CLIPSegForImageSegmentation.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/pr_29886/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it. Pixel values can be obtained using
<a href="/docs/transformers/pr_29886/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/pr_29886/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">CLIPImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/pr_29886/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.CLIPSegForImageSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/vr_29886/src/transformers/models/clipseg/modeling_clipseg.py#L1383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.clipseg.modeling_clipseg.CLIPSegImageSegmentationOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.clipseg.configuration_clipseg.CLIPSegTextConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.
…</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/pr_29886/en/model_doc/clipseg#transformers.CLIPSegVisionModel"
>CLIPSegVisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.clipseg.modeling_clipseg.CLIPSegImageSegmentationOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new Lt({props:{$$slots:{default:[Yn]},$$scope:{ctx:I}}}),ye=new K({props:{anchor:"transformers.CLIPSegForImageSegmentation.forward.example",$$slots:{default:[On]},$$scope:{ctx:I}}}),st=new zn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/clipseg.md"}}),{c(){o=p("meta"),M=i(),a=p("p"),r=i(),g(y.$$.fragment),t=i(),g(T.$$.fragment),Jt=i(),Ce=p("p"),Ce.innerHTML=en,Zt=i(),Ie=p("p"),Ie.textContent=tn,kt=i(),$e=p("p"),$e.innerHTML=on,Ut=i(),te=p("img"),Wt=i(),ve=p("small"),ve.innerHTML=sn,zt=i(),we=p("p"),we.innerHTML=rn,Bt=i(),g(Pe.$$.fragment),Vt=i(),Se=p("ul"),Se.innerHTML=an,Nt=i(),g(xe.$$.fragment),Ft=i(),Le=p("p"),Le.textContent=ln,Et=i(),g(je.$$.fragment),qt=i(),Je=p("ul"),Je.innerHTML=dn,Ht=i(),g(Ze.$$.fragment),Xt=i(),P=p("div"),g(ke.$$.fragment),co=i(),ct=p("p"),ct.innerHTML=cn,po=i(),pt=p("p"),pt.innerHTML=pn,mo=i(),g(oe.$$.fragment),go=i(),ne=p("div"),g(Ue.$$.fragment),fo=i(),mt=p("p"),mt.innerHTML=mn,Gt=i(),g(We.$$.fragment),Rt=i(),j=p("div"),g(ze.$$.fragment),uo=i(),gt=p("p"),gt.innerHTML=gn,ho=i(),ft=p("p"),ft.innerHTML=fn,_o=i(),g(se.$$.fragment),Qt=i(),g(Be.$$.fragment),Dt=i(),J=p("div"),g(Ve.$$.fragment),bo=i(),ut=p("p"),ut.innerHTML=un,yo=i(),ht=p("p"),ht.innerHTML=hn,Mo=i(),g(re.$$.fragment),At=i(),g(Ne.$$.fragment),Yt=i(),S=p("div"),g(Fe.$$.fragment),To=i(),_t=p("p"),_t.textContent=_n,Co=i(),bt=p("p"),bt.innerHTML=bn,Io=i(),ae=p("div"),g(Ee.$$.fragment),$o=i(),yt=p("p"),yt.innerHTML=yn,vo=i(),ie=p("div"),g(qe.$$.fragment),wo=i(),Mt=p("p"),Mt.innerHTML=Mn,Ot=i(),g(He.$$.fragment),Kt=i(),x=p("div"),g(Xe.$$.fragment),Po=i(),Tt=p("p"),Tt.innerHTML=Tn,So=i(),z=p("div"),g(Ge.$$.fragment),xo=i(),Ct=p("p"),Ct.innerHTML=Cn,Lo=i(),g(le.$$.fragment),jo=i(),g(de.$$.fragment),Jo=i(),B=p("div"),g(Re.$$.fragment),Zo=i(),It=p("p"),It.innerHTML=In,ko=i(),g(ce.$$.fragment),Uo=i(),g(pe.$$.fragment),Wo=i(),V=p("div"),g(Qe.$$.fragment),zo=i(),$t=p("p"),$t.innerHTML=$n,Bo=i(),g(me.$$.fragment),Vo=i(),g(ge.$$.fragment),eo=i(),g(De.$$.fragment),to=i(),Y=p("div"),g(Ae.$$.fragment),No=i(),N=p("div"),g(Ye.$$.fragment),Fo=i(),vt=p("p"),vt.innerHTML=vn,Eo=i(),g(fe.$$.fragment),qo=i(),g(ue.$$.fragment),oo=i(),g(Oe.$$.fragment),no=i(),O=p("div"),g(Ke.$$.fragment),Ho=i(),F=p("div"),g(et.$$.fragment),Xo=i(),wt=p("p"),wt.innerHTML=wn,Go=i(),g(he.$$.fragment),Ro=i(),g(_e.$$.fragment),so=i(),g(tt.$$.fragment),ro=i(),Z=p("div"),g(ot.$$.fragment),Qo=i(),Pt=p("p"),Pt.textContent=Pn,Do=i(),St=p("p"),St.innerHTML=Sn,Ao=i(),E=p("div"),g(nt.$$.fragment),Yo=i(),xt=p("p"),xt.innerHTML=xn,Oo=i(),g(be.$$.fragment),Ko=i(),g(ye.$$.fragment),ao=i(),g(st.$$.fragment),io=i(),jt=p("p"),this.h()},l(e){const n=Un("svelte-u9bgzb",document.head);o=m(n,"META",{name:!0,content:!0}),n.forEach(s),M=l(e),a=m(e,"P",{}),v(a).forEach(s),r=l(e),f(y.$$.fragment,e),t=l(e),f(T.$$.fragment,e),Jt=l(e),Ce=m(e,"P",{"data-svelte-h":!0}),C(Ce)!=="svelte-wjbpa9"&&(Ce.innerHTML=en),Zt=l(e),Ie=m(e,"P",{"data-svelte-h":!0}),C(Ie)!=="svelte-vfdo9a"&&(Ie.textContent=tn),kt=l(e),$e=m(e,"P",{"data-svelte-h":!0}),C($e)!=="svelte-2767bu"&&($e.innerHTML=on),Ut=l(e),te=m(e,"IMG",{src:!0,alt:!0,width:!0}),Wt=l(e),ve=m(e,"SMALL",{"data-svelte-h":!0}),C(ve)!=="svelte-r8s5wt"&&(ve.innerHTML=sn),zt=l(e),we=m(e,"P",{"data-svelte-h":!0}),C(we)!=="svelte-14bl8yt"&&(we.innerHTML=rn),Bt=l(e),f(Pe.$$.fragment,e),Vt=l(e),Se=m(e,"UL",{"data-svelte-h":!0}),C(Se)!=="svelte-v9z1gx"&&(Se.innerHTML=an),Nt=l(e),f(xe.$$.fragment,e),Ft=l(e),Le=m(e,"P",{"data-svelte-h":!0}),C(Le)!=="svelte-i5etz8"&&(Le.textContent=ln),Et=l(e),f(je.$$.fragment,e),qt=l(e),Je=m(e,"UL",{"data-svelte-h":!0}),C(Je)!=="svelte-ksa1e9"&&(Je.innerHTML=dn),Ht=l(e),f(Ze.$$.fragment,e),Xt=l(e),P=m(e,"DIV",{class:!0});var k=v(P);f(ke.$$.fragment,k),co=l(k),ct=m(k,"P",{"data-svelte-h":!0}),C(ct)!=="svelte-1pworjb"&&(ct.innerHTML=cn),po=l(k),pt=m(k,"P",{"data-svelte-h":!0}),C(pt)!=="svelte-n07p4j"&&(pt.innerHTML=pn),mo=l(k),f(oe.$$.fragment,k),go=l(k),ne=m(k,"DIV",{class:!0});var rt=v(ne);f(Ue.$$.fragment,rt),fo=l(rt),mt=m(rt,"P",{"data-svelte-h":!0}),C(mt)!=="svelte-1y00gqq"&&(mt.innerHTML=mn),rt.forEach(s),k.forEach(s),Gt=l(e),f(We.$$.fragment,e),Rt=l(e),j=m(e,"DIV",{class:!0});var H=v(j);f(ze.$$.fragment,H),uo=l(H),gt=m(H,"P",{"data-svelte-h":!0}),C(gt)!=="svelte-1ji4q1f"&&(gt.innerHTML=gn),ho=l(H),ft=m(H,"P",{"data-svelte-h":!0}),C(ft)!=="svelte-n07p4j"&&(ft.innerHTML=fn),_o=l(H),f(se.$$.fragment,H),H.forEach(s),Qt=l(e),f(Be.$$.fragment,e),Dt=l(e),J=m(e,"DIV",{class:!0});var X=v(J);f(Ve.$$.fragment,X),bo=l(X),ut=m(X,"P",{"data-svelte-h":!0}),C(ut)!=="svelte-1ji4q1f"&&(ut.innerHTML=un),yo=l(X),ht=m(X,"P",{"data-svelte-h":!0}),C(ht)!=="svelte-n07p4j"&&(ht.innerHTML=hn),Mo=l(X),f(re.$$.fragment,X),X.forEach(s),At=l(e),f(Ne.$$.fragment,e),Yt=l(e),S=m(e,"DIV",{class:!0});var U=v(S);f(Fe.$$.fragment,U),To=l(U),_t=m(U,"P",{"data-svelte-h":!0}),C(_t)!=="svelte-9hszhx"&&(_t.textContent=_n),Co=l(U),bt=m(U,"P",{"data-svelte-h":!0}),C(bt)!=="svelte-9by9bc"&&(bt.innerHTML=bn),Io=l(U),ae=m(U,"DIV",{class:!0});var at=v(ae);f(Ee.$$.fragment,at),$o=l(at),yt=m(at,"P",{"data-svelte-h":!0}),C(yt)!=="svelte-1dnhaca"&&(yt.innerHTML=yn),at.forEach(s),vo=l(U),ie=m(U,"DIV",{class:!0});var it=v(ie);f(qe.$$.fragment,it),wo=l(it),Mt=m(it,"P",{"data-svelte-h":!0}),C(Mt)!=="svelte-pl2mns"&&(Mt.innerHTML=Mn),it.forEach(s),U.forEach(s),Ot=l(e),f(He.$$.fragment,e),Kt=l(e),x=m(e,"DIV",{class:!0});var W=v(x);f(Xe.$$.fragment,W),Po=l(W),Tt=m(W,"P",{"data-svelte-h":!0}),C(Tt)!=="svelte-1gjh92c"&&(Tt.innerHTML=Tn),So=l(W),z=m(W,"DIV",{class:!0});var G=v(z);f(Ge.$$.fragment,G),xo=l(G),Ct=m(G,"P",{"data-svelte-h":!0}),C(Ct)!=="svelte-krcqw7"&&(Ct.innerHTML=Cn),Lo=l(G),f(le.$$.fragment,G),jo=l(G),f(de.$$.fragment,G),G.forEach(s),Jo=l(W),B=m(W,"DIV",{class:!0});var R=v(B);f(Re.$$.fragment,R),Zo=l(R),It=m(R,"P",{"data-svelte-h":!0}),C(It)!=="svelte-krcqw7"&&(It.innerHTML=In),ko=l(R),f(ce.$$.fragment,R),Uo=l(R),f(pe.$$.fragment,R),R.forEach(s),Wo=l(W),V=m(W,"DIV",{class:!0});var Q=v(V);f(Qe.$$.fragment,Q),zo=l(Q),$t=m(Q,"P",{"data-svelte-h":!0}),C($t)!=="svelte-krcqw7"&&($t.innerHTML=$n),Bo=l(Q),f(me.$$.fragment,Q),Vo=l(Q),f(ge.$$.fragment,Q),Q.forEach(s),W.forEach(s),eo=l(e),f(De.$$.fragment,e),to=l(e),Y=m(e,"DIV",{class:!0});var lt=v(Y);f(Ae.$$.fragment,lt),No=l(lt),N=m(lt,"DIV",{class:!0});var D=v(N);f(Ye.$$.fragment,D),Fo=l(D),vt=m(D,"P",{"data-svelte-h":!0}),C(vt)!=="svelte-s519ht"&&(vt.innerHTML=vn),Eo=l(D),f(fe.$$.fragment,D),qo=l(D),f(ue.$$.fragment,D),D.forEach(s),lt.forEach(s),oo=l(e),f(Oe.$$.fragment,e),no=l(e),O=m(e,"DIV",{class:!0});var dt=v(O);f(Ke.$$.fragment,dt),Ho=l(dt),F=m(dt,"DIV",{class:!0});var A=v(F);f(et.$$.fragment,A),Xo=l(A),wt=m(A,"P",{"data-svelte-h":!0}),C(wt)!=="svelte-7vqzkn"&&(wt.innerHTML=wn),Go=l(A),f(he.$$.fragment,A),Ro=l(A),f(_e.$$.fragment,A),A.forEach(s),dt.forEach(s),so=l(e),f(tt.$$.fragment,e),ro=l(e),Z=m(e,"DIV",{class:!0});var Me=v(Z);f(ot.$$.fragment,Me),Qo=l(Me),Pt=m(Me,"P",{"data-svelte-h":!0}),C(Pt)!=="svelte-qndran"&&(Pt.textContent=Pn),Do=l(Me),St=m(Me,"P",{"data-svelte-h":!0}),C(St)!=="svelte-1gjh92c"&&(St.innerHTML=Sn),Ao=l(Me),E=m(Me,"DIV",{class:!0});var Te=v(E);f(nt.$$.fragment,Te),Yo=l(Te),xt=m(Te,"P",{"data-svelte-h":!0}),C(xt)!=="svelte-1304sff"&&(xt.innerHTML=xn),Oo=l(Te),f(be.$$.fragment,Te),Ko=l(Te),f(ye.$$.fragment,Te),Te.forEach(s),Me.forEach(s),ao=l(e),f(st.$$.fragment,e),io=l(e),jt=m(e,"P",{}),v(jt).forEach(s),this.h()},h(){$(o,"name","hf:doc:metadata"),$(o,"content",es),jn(te.src,nn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/clipseg_architecture.png")||$(te,"src",nn),$(te,"alt","drawing"),$(te,"width","600"),$(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){c(document.head,o),d(e,M,n),d(e,a,n),d(e,r,n),u(y,e,n),d(e,t,n),u(T,e,n),d(e,Jt,n),d(e,Ce,n),d(e,Zt,n),d(e,Ie,n),d(e,kt,n),d(e,$e,n),d(e,Ut,n),d(e,te,n),d(e,Wt,n),d(e,ve,n),d(e,zt,n),d(e,we,n),d(e,Bt,n),u(Pe,e,n),d(e,Vt,n),d(e,Se,n),d(e,Nt,n),u(xe,e,n),d(e,Ft,n),d(e,Le,n),d(e,Et,n),u(je,e,n),d(e,qt,n),d(e,Je,n),d(e,Ht,n),u(Ze,e,n),d(e,Xt,n),d(e,P,n),u(ke,P,null),c(P,co),c(P,ct),c(P,po),c(P,pt),c(P,mo),u(oe,P,null),c(P,go),c(P,ne),u(Ue,ne,null),c(ne,fo),c(ne,mt),d(e,Gt,n),u(We,e,n),d(e,Rt,n),d(e,j,n),u(ze,j,null),c(j,uo),c(j,gt),c(j,ho),c(j,ft),c(j,_o),u(se,j,null),d(e,Qt,n),u(Be,e,n),d(e,Dt,n),d(e,J,n),u(Ve,J,null),c(J,bo),c(J,ut),c(J,yo),c(J,ht),c(J,Mo),u(re,J,null),d(e,At,n),u(Ne,e,n),d(e,Yt,n),d(e,S,n),u(Fe,S,null),c(S,To),c(S,_t),c(S,Co),c(S,bt),c(S,Io),c(S,ae),u(Ee,ae,null),c(ae,$o),c(ae,yt),c(S,vo),c(S,ie),u(qe,ie,null),c(ie,wo),c(ie,Mt),d(e,Ot,n),u(He,e,n),d(e,Kt,n),d(e,x,n),u(Xe,x,null),c(x,Po),c(x,Tt),c(x,So),c(x,z),u(Ge,z,null),c(z,xo),c(z,Ct),c(z,Lo),u(le,z,null),c(z,jo),u(de,z,null),c(x,Jo),c(x,B),u(Re,B,null),c(B,Zo),c(B,It),c(B,ko),u(ce,B,null),c(B,Uo),u(pe,B,null),c(x,Wo),c(x,V),u(Qe,V,null),c(V,zo),c(V,$t),c(V,Bo),u(me,V,null),c(V,Vo),u(ge,V,null),d(e,eo,n),u(De,e,n),d(e,to,n),d(e,Y,n),u(Ae,Y,null),c(Y,No),c(Y,N),u(Ye,N,null),c(N,Fo),c(N,vt),c(N,Eo),u(fe,N,null),c(N,qo),u(ue,N,null),d(e,oo,n),u(Oe,e,n),d(e,no,n),d(e,O,n),u(Ke,O,null),c(O,Ho),c(O,F),u(et,F,null),c(F,Xo),c(F,wt),c(F,Go),u(he,F,null),c(F,Ro),u(_e,F,null),d(e,so,n),u(tt,e,n),d(e,ro,n),d(e,Z,n),u(ot,Z,null),c(Z,Qo),c(Z,Pt),c(Z,Do),c(Z,St),c(Z,Ao),c(Z,E),u(nt,E,null),c(E,Yo),c(E,xt),c(E,Oo),u(be,E,null),c(E,Ko),u(ye,E,null),d(e,ao,n),u(st,e,n),d(e,io,n),d(e,jt,n),lo=!0},p(e,[n]){const k={};n&2&&(k.$$scope={dirty:n,ctx:e}),oe.$set(k);const rt={};n&2&&(rt.$$scope={dirty:n,ctx:e}),se.$set(rt);const H={};n&2&&(H.$$scope={dirty:n,ctx:e}),re.$set(H);const X={};n&2&&(X.$$scope={dirty:n,ctx:e}),le.$set(X);const U={};n&2&&(U.$$scope={dirty:n,ctx:e}),de.$set(U);const at={};n&2&&(at.$$scope={dirty:n,ctx:e}),ce.$set(at);const it={};n&2&&(it.$$scope={dirty:n,ctx:e}),pe.$set(it);const W={};n&2&&(W.$$scope={dirty:n,ctx:e}),me.$set(W);const G={};n&2&&(G.$$scope={dirty:n,ctx:e}),ge.$set(G);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),fe.$set(R);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),ue.$set(Q);const lt={};n&2&&(lt.$$scope={dirty:n,ctx:e}),he.$set(lt);const D={};n&2&&(D.$$scope={dirty:n,ctx:e}),_e.$set(D);const dt={};n&2&&(dt.$$scope={dirty:n,ctx:e}),be.$set(dt);const A={};n&2&&(A.$$scope={dirty:n,ctx:e}),ye.$set(A)},i(e){lo||(h(y.$$.fragment,e),h(T.$$.fragment,e),h(Pe.$$.fragment,e),h(xe.$$.fragment,e),h(je.$$.fragment,e),h(Ze.$$.fragment,e),h(ke.$$.fragment,e),h(oe.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(ze.$$.fragment,e),h(se.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(re.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(Ee.$$.fragment,e),h(qe.$$.fragment,e),h(He.$$.fragment,e),h(Xe.$$.fragment,e),h(Ge.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(Re.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(Qe.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),h(De.$$.fragment,e),h(Ae.$$.fragment,e),h(Ye.$$.fragment,e),h(fe.$$.fragment,e),h(ue.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(st.$$.fragment,e),lo=!0)},o(e){_(y.$$.fragment,e),_(T.$$.fragment,e),_(Pe.$$.fragment,e),_(xe.$$.fragment,e),_(je.$$.fragment,e),_(Ze.$$.fragment,e),_(ke.$$.fragment,e),_(oe.$$.fragment,e),_(Ue.$$.fragment,e),_(We.$$.fragment,e),_(ze.$$.fragment,e),_(se.$$.fragment,e),_(Be.$$.fragment,e),_(Ve.$$.fragment,e),_(re.$$.fragment,e),_(Ne.$$.fragment,e),_(Fe.$$.fragment,e),_(Ee.$$.fragment,e),_(qe.$$.fragment,e),_(He.$$.fragment,e),_(Xe.$$.fragment,e),_(Ge.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(Re.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(Qe.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(Ye.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),_(tt.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(st.$$.fragment,e),lo=!1},d(e){e&&(s(M),s(a),s(r),s(t),s(Jt),s(Ce),s(Zt),s(Ie),s(kt),s($e),s(Ut),s(te),s(Wt),s(ve),s(zt),s(we),s(Bt),s(Vt),s(Se),s(Nt),s(Ft),s(Le),s(Et),s(qt),s(Je),s(Ht),s(Xt),s(P),s(Gt),s(Rt),s(j),s(Qt),s(Dt),s(J),s(At),s(Yt),s(S),s(Ot),s(Kt),s(x),s(eo),s(to),s(Y),s(oo),s(no),s(O),s(so),s(ro),s(Z),s(ao),s(io),s(jt)),s(o),b(y,e),b(T,e),b(Pe,e),b(xe,e),b(je,e),b(Ze,e),b(ke),b(oe),b(Ue),b(We,e),b(ze),b(se),b(Be,e),b(Ve),b(re),b(Ne,e),b(Fe),b(Ee),b(qe),b(He,e),b(Xe),b(Ge),b(le),b(de),b(Re),b(ce),b(pe),b(Qe),b(me),b(ge),b(De,e),b(Ae),b(Ye),b(fe),b(ue),b(Oe,e),b(Ke),b(et),b(he),b(_e),b(tt,e),b(ot),b(nt),b(be),b(ye),b(st,e)}}}const es='{"title":"CLIPSeg","local":"clipseg","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"CLIPSegConfig","local":"transformers.CLIPSegConfig","sections":[],"depth":2},{"title":"CLIPSegTextConfig","local":"transformers.CLIPSegTextConfig","sections":[],"depth":2},{"title":"CLIPSegVisionConfig","local":"transformers.CLIPSegVisionConfig","sections":[],"depth":2},{"title":"CLIPSegProcessor","local":"transformers.CLIPSegProcessor","sections":[],"depth":2},{"title":"CLIPSegModel","local":"transformers.CLIPSegModel","sections":[],"depth":2},{"title":"CLIPSegTextModel","local":"transformers.CLIPSegTextModel","sections":[],"depth":2},{"title":"CLIPSegVisionModel","local":"transformers.CLIPSegVisionModel","sections":[],"depth":2},{"title":"CLIPSegForImageSegmentation","local":"transformers.CLIPSegForImageSegmentation","sections":[],"depth":2}],"depth":1}';function ts(I){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cs extends Zn{constructor(o){super(),kn(this,o,ts,Kn,Ln,{})}}export{cs as component};
