import{s as ss,f as ns,o as os,n as as}from"../chunks/scheduler.37c15a92.js";import{S as is,i as rs,g as a,s as n,r as M,A as Ms,h as i,f as l,c as o,j as rl,u as p,x as r,k as Xe,y as Fe,a as s,v as c,d as h,t as u,w as m,m as ts,n as ls}from"../chunks/index.2bf4358c.js";import{T as ps}from"../chunks/Tip.363c041f.js";import{C}from"../chunks/CodeBlock.4e987730.js";import{C as cs}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as T}from"../chunks/Heading.8ada512a.js";import{E as hs}from"../chunks/getInferenceSnippets.d4d07d1e.js";function us(Ye){let y,g,j="this notebook",J;return{c(){y=ts("You can follow the code in "),g=a("a"),g.textContent=j,J=ts(" that you can run using Google Colab."),this.h()},l(d){y=ls(d,"You can follow the code in "),g=i(d,"A",{href:!0,target:!0,"data-svelte-h":!0}),r(g)!=="svelte-z2gf46"&&(g.textContent=j),J=ls(d," that you can run using Google Colab."),this.h()},h(){Xe(g,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"),Xe(g,"target","_blank")},m(d,b){s(d,y,b),s(d,g,b),s(d,J,b)},p:as,d(d){d&&(l(y),l(g),l(J))}}}function ms(Ye){let y,g,j,J,d,b,I,Ne,v,Ml='As we explored in <a href="https://huggingface.co/learn/agents-course/unit1/tools" rel="nofollow">unit 1</a>, agents use tools to perform various actions. In <code>smolagents</code>, tools are treated as <strong>functions that an LLM can call within an agent system</strong>.',Se,B,pl="To interact with a tool, the LLM needs an <strong>interface description</strong> with these key components:",Le,Z,cl="<li><strong>Name</strong>: What the tool is called</li> <li><strong>Tool description</strong>: What the tool does</li> <li><strong>Input types and descriptions</strong>: What arguments the tool accepts</li> <li><strong>Output type</strong>: What the tool returns</li>",qe,W,hl="For instance, while preparing for a party at Wayne Manor, Alfred needs various tools to gather information - from searching for catering services to finding party theme ideas. Here’s how a simple search tool interface might look:",ze,G,ul="<li><strong>Name:</strong> <code>web_search</code></li> <li><strong>Tool description:</strong> Searches the web for specific queries</li> <li><strong>Input:</strong> <code>query</code> (string) - The search term to look up</li> <li><strong>Output:</strong> String containing the search results</li>",Pe,$,ml="By using these tools, Alfred can make informed decisions and gather all the information needed for planning the perfect party.",De,x,dl="Below, you can see an animation illustrating how a tool call is managed:",Ke,A,yl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif" alt="Agentic pipeline from https://huggingface.co/docs/smolagents/conceptual_guides/react"/>',Oe,V,et,H,gl="In <code>smolagents</code>, tools can be defined in two ways:",tt,R,Tl="<li><strong>Using the <code>@tool</code> decorator</strong> for simple function-based tools</li> <li><strong>Creating a subclass of <code>Tool</code></strong> for more complex functionality</li>",lt,_,st,k,fl="The <code>@tool</code> decorator is the <strong>recommended way to define simple tools</strong>. Under the hood, smolagents will parse basic information about the function from Python. So if you name your function clearly and write a good docstring, it will be easier for the LLM to use.",nt,E,Jl="Using this approach, we define a function with:",ot,X,wl="<li><strong>A clear and descriptive function name</strong> that helps the LLM understand its purpose.</li> <li><strong>Type hints for both inputs and outputs</strong> to ensure proper usage.</li> <li><strong>A detailed description</strong>, including an <code>Args:</code> section where each argument is explicitly described. These descriptions provide valuable context for the LLM, so it’s important to write them carefully.</li>",at,Q,it,F,jl,rt,U,Mt,Y,bl="Let’s imagine that Alfred has already decided on the menu for the party, but now he needs help preparing food for such a large number of guests. To do so, he would like to hire a catering service and needs to identify the highest-rated options available. Alfred can leverage a tool to search for the best catering services in his area.",pt,N,Ul="Below is an example of how Alfred can use the <code>@tool</code> decorator to make this happen:",ct,S,ht,L,ut,q,Cl='This approach involves creating a subclass of <a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools#smolagents.Tool" rel="nofollow"><code>Tool</code></a>.  For complex tools, we can implement a class instead of a Python function. The class wraps the function with metadata that helps the LLM understand how to use it effectively. In this class, we define:',mt,z,Il="<li><code>name</code>: The tool’s name.</li> <li><code>description</code>: A description used to populate the agent’s system prompt.</li> <li><code>inputs</code>: A dictionary with keys <code>type</code> and <code>description</code>, providing information to help the Python interpreter process inputs.</li> <li><code>output_type</code>: Specifies the expected output type.</li> <li><code>forward</code>: The method containing the inference logic to execute.</li>",dt,P,vl="Below, we can see an example of a tool built using <code>Tool</code> and how to integrate it within a <code>CodeAgent</code>.",yt,D,gt,K,Bl="Alfred’s party at the mansion is a <strong>superhero-themed event</strong>, but he needs some creative ideas to make it truly special. As a fantastic host, he wants to surprise the guests with a unique theme.",Tt,O,Zl="To do this, he can use an agent that generates superhero-themed party ideas based on a given category. This way, Alfred can find the perfect party theme to wow his guests.",ft,ee,Jt,te,Wl="With this tool, Alfred will be the ultimate super host, impressing his guests with a superhero-themed party they won’t forget! 🦸‍♂️🦸‍♀️",wt,le,jt,se,Gl='<code>smolagents</code> comes with a set of pre-built tools that can be directly injected into your agent. The <a href="https://huggingface.co/docs/smolagents/guided_tour?build-a-tool=Decorate+a+function+with+%40tool#default-toolbox" rel="nofollow">default toolbox</a> includes:',bt,ne,$l="<li><strong>PythonInterpreterTool</strong></li> <li><strong>FinalAnswerTool</strong></li> <li><strong>UserInputTool</strong></li> <li><strong>DuckDuckGoSearchTool</strong></li> <li><strong>GoogleSearchTool</strong></li> <li><strong>VisitWebpageTool</strong></li>",Ut,oe,xl="Alfred could use various tools to ensure a flawless party at Wayne Manor:",Ct,ae,Al="<li><p>First, he could use the <code>DuckDuckGoSearchTool</code> to find creative superhero-themed party ideas.</p></li> <li><p>For catering, he’d rely on the <code>GoogleSearchTool</code> to find the highest-rated services in Gotham.</p></li> <li><p>To manage seating arrangements, Alfred could run calculations with the <code>PythonInterpreterTool</code>.</p></li> <li><p>Once everything is gathered, he’d compile the plan using the <code>FinalAnswerTool</code>.</p></li>",It,ie,Vl="With these tools, Alfred guarantees the party is both exceptional and seamless. 🦇💡",vt,re,Bt,Me,Hl="One of the most powerful features of <strong>smolagents</strong> is its ability to share custom tools on the Hub and seamlessly integrate tools created by the community. This includes connecting with <strong>HF Spaces</strong> and <strong>LangChain tools</strong>, significantly enhancing Alfred’s ability to orchestrate an unforgettable party at Wayne Manor. 🎭",Zt,pe,Rl="With these integrations, Alfred can tap into advanced event-planning tools—whether it’s adjusting the lighting for the perfect ambiance, curating the ideal playlist for the party, or coordinating with Gotham’s finest caterers.",Wt,ce,_l="Here are examples showcasing how these functionalities can elevate the party experience:",Gt,he,$t,ue,kl="Sharing your custom tool with the community is easy! Simply upload it to your Hugging Face account using the <code>push_to_hub()</code> method.",xt,me,El="For instance, Alfred can share his <code>party_theme_tool</code> to help others find the best catering services in Gotham. Here’s how to do it:",At,de,Vt,ye,Ht,ge,Xl="You can easily import tools created by other users using the <code>load_tool()</code> function. For example, Alfred might want to generate a promotional image for the party using AI. Instead of building a tool from scratch, he can leverage a predefined one from the community:",Rt,Te,_t,fe,kt,Je,Ql="You can also import a HF Space as a tool using <code>Tool.from_space()</code>. This opens up possibilities for integrating with thousands of spaces from the community for tasks from image generation to data analysis.",Et,we,Fl="The tool will connect with the spaces Gradio backend using the <code>gradio_client</code>, so make sure to install it via <code>pip</code> if you don’t have it already.",Xt,je,Yl="For the party, Alfred can use an existing HF Space for the generation of the AI-generated image to be used in the announcement (instead of the pre-built tool we mentioned before). Let’s build it!",Qt,be,Ft,Ue,Yt,Ce,Nl="We’ll discuss the <code>LangChain</code> framework in upcoming sections. For now, we just note that we can reuse LangChain tools in your smolagents workflow!",Nt,Ie,Sl="You can easily load LangChain tools using the <code>Tool.from_langchain()</code> method. Alfred, ever the perfectionist, is preparing for a spectacular superhero night at Wayne Manor while the Waynes are away. To make sure every detail exceeds expectations, he taps into LangChain tools to find top-tier entertainment ideas.",St,ve,Ll="By using <code>Tool.from_langchain()</code>, Alfred effortlessly adds advanced search functionalities to his smolagent, enabling him to discover exclusive party ideas and services with just a few commands.",Lt,Be,ql="Here’s how he does it:",qt,Ze,zt,We,Pt,Ge,zl='<code>smolagents</code> also allows importing tools from the hundreds of MCP servers available on <a href="https://glama.ai/mcp/servers" rel="nofollow">glama.ai</a> or <a href="https://smithery.ai" rel="nofollow">smithery.ai</a>. If you want to dive deeper about MCP, you can check our <a href="https://huggingface.co/learn/mcp-course/" rel="nofollow">free MCP Course</a>.',Dt,f,ke,Pl="Install mcp client",al,Ee,Dl="We first need to install the <code>mcp</code> integration for <code>smolagents</code>.",il,$e,Kt,xe,Kl="The MCP servers tools can be loaded in a ToolCollection object as follow:",Ot,Ae,el,Ve,Ol="With this setup, Alfred can quickly discover luxurious entertainment options, ensuring Gotham’s elite guests have an unforgettable experience. This tool helps him curate the perfect superhero-themed event for Wayne Manor! 🎉",tl,He,ll,Re,es='<li><a href="https://huggingface.co/docs/smolagents/tutorials/tools" rel="nofollow">Tools Tutorial</a> - Explore this tutorial to learn how to work with tools effectively.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/reference/tools" rel="nofollow">Tools Documentation</a> - Comprehensive reference documentation on tools.</li> <li><a href="https://huggingface.co/docs/smolagents/v1.8.1/en/guided_tour#tools" rel="nofollow">Tools Guided Tour</a> - A step-by-step guided tour to help you build and utilize tools efficiently.</li> <li><a href="https://huggingface.co/docs/smolagents/tutorials/building_good_agents" rel="nofollow">Building Effective Agents</a> - A detailed guide on best practices for developing reliable and high-performance custom function agents.</li>',sl,_e,nl,Qe,ol;return d=new cs({props:{classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/#fileId=https://huggingface.co/agents-course/notebooks/blob/main/unit2/smolagents/tools.ipynb"}],askForHelpUrl:"http://hf.co/join/discord"}}),I=new T({props:{title:"Tools",local:"tools",headingTag:"h1"}}),V=new T({props:{title:"Tool Creation Methods",local:"tool-creation-methods",headingTag:"h2"}}),_=new T({props:{title:"The @tool Decorator",local:"the-tool-decorator",headingTag:"h3"}}),Q=new T({props:{title:"Generating a tool that retrieves the highest-rated catering",local:"generating-a-tool-that-retrieves-the-highest-rated-catering",headingTag:"h4"}}),U=new ps({props:{$$slots:{default:[us]},$$scope:{ctx:Ye}}}),S=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, tool

<span class="hljs-comment"># Let&#x27;s pretend we have a function that fetches the highest-rated catering services.</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">catering_service_tool</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    This tool returns the highest-rated catering service in Gotham City.

    Args:
        query: A search term for finding catering services.
    &quot;&quot;&quot;</span>
    <span class="hljs-comment"># Example list of catering services and their ratings</span>
    services = {
        <span class="hljs-string">&quot;Gotham Catering Co.&quot;</span>: <span class="hljs-number">4.9</span>,
        <span class="hljs-string">&quot;Wayne Manor Catering&quot;</span>: <span class="hljs-number">4.8</span>,
        <span class="hljs-string">&quot;Gotham City Events&quot;</span>: <span class="hljs-number">4.7</span>,
    }

    <span class="hljs-comment"># Find the highest rated catering service (simulating search query filtering)</span>
    best_service = <span class="hljs-built_in">max</span>(services, key=services.get)

    <span class="hljs-keyword">return</span> best_service


agent = CodeAgent(tools=[catering_service_tool], model=InferenceClientModel())

<span class="hljs-comment"># Run the agent to find the best catering service</span>
result = agent.run(
    <span class="hljs-string">&quot;Can you give me the name of the highest-rated catering service in Gotham City?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)   <span class="hljs-comment"># Output: Gotham Catering Co.</span>`,wrap:!1}}),L=new T({props:{title:"Defining a Tool as a Python Class",local:"defining-a-tool-as-a-python-class",headingTag:"h3"}}),D=new T({props:{title:"Generating a tool to generate ideas about the superhero-themed party",local:"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party",headingTag:"h4"}}),ee=new C({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool, CodeAgent, InferenceClientModel

<span class="hljs-keyword">class</span> <span class="hljs-title class_">SuperheroPartyThemeTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;superhero_party_theme_generator&quot;</span>
    description = <span class="hljs-string">&quot;&quot;&quot;
    This tool suggests creative superhero-themed party ideas based on a category.
    It returns a unique party theme idea.&quot;&quot;&quot;</span>

    inputs = {
        <span class="hljs-string">&quot;category&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The type of superhero party (e.g., &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, &#x27;futuristic Gotham&#x27;).&quot;</span>,
        }
    }

    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, category: <span class="hljs-built_in">str</span></span>):
        themes = {
            <span class="hljs-string">&quot;classic heroes&quot;</span>: <span class="hljs-string">&quot;Justice League Gala: Guests come dressed as their favorite DC heroes with themed cocktails like &#x27;The Kryptonite Punch&#x27;.&quot;</span>,
            <span class="hljs-string">&quot;villain masquerade&quot;</span>: <span class="hljs-string">&quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>,
            <span class="hljs-string">&quot;futuristic Gotham&quot;</span>: <span class="hljs-string">&quot;Neo-Gotham Night: A cyberpunk-style party inspired by Batman Beyond, with neon decorations and futuristic gadgets.&quot;</span>
        }

        <span class="hljs-keyword">return</span> themes.get(category.lower(), <span class="hljs-string">&quot;Themed party idea not found. Try &#x27;classic heroes&#x27;, &#x27;villain masquerade&#x27;, or &#x27;futuristic Gotham&#x27;.&quot;</span>)

<span class="hljs-comment"># Instantiate the tool</span>
party_theme_tool = SuperheroPartyThemeTool()
agent = CodeAgent(tools=[party_theme_tool], model=InferenceClientModel())

<span class="hljs-comment"># Run the agent to generate a party theme idea</span>
result = agent.run(
    <span class="hljs-string">&quot;What would be a good superhero party idea for a &#x27;villain masquerade&#x27; theme?&quot;</span>
)

<span class="hljs-built_in">print</span>(result)  <span class="hljs-comment"># Output: &quot;Gotham Rogues&#x27; Ball: A mysterious masquerade where guests dress as classic Batman villains.&quot;</span>`,wrap:!1}}),le=new T({props:{title:"Default Toolbox",local:"default-toolbox",headingTag:"h2"}}),re=new T({props:{title:"Sharing and Importing Tools",local:"sharing-and-importing-tools",headingTag:"h2"}}),he=new T({props:{title:"Sharing a Tool to the Hub",local:"sharing-a-tool-to-the-hub",headingTag:"h3"}}),de=new C({props:{code:"cGFydHlfdGhlbWVfdG9vbC5wdXNoX3RvX2h1YiglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGcGFydHlfdGhlbWVfdG9vbCUyMiUyQyUyMHRva2VuJTNEJTIyJTNDWU9VUl9IVUdHSU5HRkFDRUhVQl9BUElfVE9LRU4lM0UlMjIp",highlighted:'party_theme_tool.push_to_hub(<span class="hljs-string">&quot;{your_username}/party_theme_tool&quot;</span>, token=<span class="hljs-string">&quot;&lt;YOUR_HUGGINGFACEHUB_API_TOKEN&gt;&quot;</span>)',wrap:!1}}),ye=new T({props:{title:"Importing a Tool from the Hub",local:"importing-a-tool-from-the-hub",headingTag:"h3"}}),Te=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWltYWdlX2dlbmVyYXRpb25fdG9vbCUyMCUzRCUyMGxvYWRfdG9vbCglMEElMjAlMjAlMjAlMjAlMjJtLXJpYyUyRnRleHQtdG8taW1hZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCklMEEpJTBBJTBBYWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMG9mJTIwYSUyMGx1eHVyaW91cyUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyMHdpdGglMjBtYWRlLXVwJTIwc3VwZXJoZXJvcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel

image_generation_tool = load_tool(
    <span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>
)

agent = CodeAgent(
    tools=[image_generation_tool],
    model=InferenceClientModel()
)

agent.run(<span class="hljs-string">&quot;Generate an image of a luxurious superhero-themed party at Wayne Manor with made-up superheros.&quot;</span>)`,wrap:!1}}),fe=new T({props:{title:"Importing a Hugging Face Space as a Tool",local:"importing-a-hugging-face-space-as-a-tool",headingTag:"h3"}}),be=new C({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fc3BhY2UoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0QlMjJpbWFnZV9nZW5lcmF0b3IlMjIlMkMlMEElMjAlMjAlMjAlMjBkZXNjcmlwdGlvbiUzRCUyMkdlbmVyYXRlJTIwYW4lMjBpbWFnZSUyMGZyb20lMjBhJTIwcHJvbXB0JTIyJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KHRvb2xzJTNEJTVCaW1hZ2VfZ2VuZXJhdGlvbl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEFhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySW1wcm92ZSUyMHRoaXMlMjBwcm9tcHQlMkMlMjB0aGVuJTIwZ2VuZXJhdGUlMjBhbiUyMGltYWdlJTIwb2YlMjBpdC4lMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IndXNlcl9wcm9tcHQnJTNBJTIwJ0ElMjBncmFuZCUyMHN1cGVyaGVyby10aGVtZWQlMjBwYXJ0eSUyMGF0JTIwV2F5bmUlMjBNYW5vciUyQyUyMHdpdGglMjBBbGZyZWQlMjBvdmVyc2VlaW5nJTIwYSUyMGx1eHVyaW91cyUyMGdhbGEnJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

image_generation_tool = Tool.from_space(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    name=<span class="hljs-string">&quot;image_generator&quot;</span>,
    description=<span class="hljs-string">&quot;Generate an image from a prompt&quot;</span>
)

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)

agent = CodeAgent(tools=[image_generation_tool], model=model)

agent.run(
    <span class="hljs-string">&quot;Improve this prompt, then generate an image of it.&quot;</span>,
    additional_args={<span class="hljs-string">&#x27;user_prompt&#x27;</span>: <span class="hljs-string">&#x27;A grand superhero-themed party at Wayne Manor, with Alfred overseeing a luxurious gala&#x27;</span>}
)`,wrap:!1}}),Ue=new T({props:{title:"Importing a LangChain Tool",local:"importing-a-langchain-tool",headingTag:"h3"}}),Ze=new C({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2wlMEElMEFzZWFyY2hfdG9vbCUyMCUzRCUyMFRvb2wuZnJvbV9sYW5nY2hhaW4obG9hZF90b29scyglNUIlMjJzZXJwYXBpJTIyJTVEKSU1QjAlNUQpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUJzZWFyY2hfdG9vbCU1RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBJTBBYWdlbnQucnVuKCUyMlNlYXJjaCUyMGZvciUyMGx1eHVyeSUyMGVudGVydGFpbm1lbnQlMjBpZGVhcyUyMGZvciUyMGElMjBzdXBlcmhlcm8tdGhlbWVkJTIwZXZlbnQlMkMlMjBzdWNoJTIwYXMlMjBsaXZlJTIwcGVyZm9ybWFuY2VzJTIwYW5kJTIwaW50ZXJhY3RpdmUlMjBleHBlcmllbmNlcy4lMjIp",highlighted:`<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel, Tool

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

agent = CodeAgent(tools=[search_tool], model=model)

agent.run(<span class="hljs-string">&quot;Search for luxury entertainment ideas for a superhero-themed event, such as live performances and interactive experiences.&quot;</span>)`,wrap:!1}}),We=new T({props:{title:"Importing a tool collection from any MCP server",local:"importing-a-tool-collection-from-any-mcp-server",headingTag:"h3"}}),$e=new C({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNtb2xhZ2VudHMlNUJtY3AlNUQlMjI=",highlighted:'pip install <span class="hljs-string">&quot;smolagents[mcp]&quot;</span>',wrap:!1}}),Ae=new C({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMFRvb2xDb2xsZWN0aW9uJTJDJTIwQ29kZUFnZW50JTBBZnJvbSUyMG1jcCUyMGltcG9ydCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyUwQWZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMEElMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCUyMiklMEElMEElMEFzZXJ2ZXJfcGFyYW1ldGVycyUyMCUzRCUyMFN0ZGlvU2VydmVyUGFyYW1ldGVycyglMEElMjAlMjAlMjAlMjBjb21tYW5kJTNEJTIydXZ4JTIyJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRCU1QiUyMi0tcXVpZXQlMjIlMkMlMjAlMjJwdWJtZWRtY3AlNDAwLjEuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGVudiUzRCU3QiUyMlVWX1BZVEhPTiUyMiUzQSUyMCUyMjMuMTIlMjIlMkMlMjAqKm9zLmVudmlyb24lN0QlMkMlMEEpJTBBJTBBd2l0aCUyMFRvb2xDb2xsZWN0aW9uLmZyb21fbWNwKHNlcnZlcl9wYXJhbWV0ZXJzJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUyMGFzJTIwdG9vbF9jb2xsZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIqdG9vbF9jb2xsZWN0aW9uLnRvb2xzJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGFkZF9iYXNlX3Rvb2xzJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyUGxlYXNlJTIwZmluZCUyMGElMjByZW1lZHklMjBmb3IlMjBoYW5nb3Zlci4lMjIp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ToolCollection, CodeAgent
<span class="hljs-keyword">from</span> mcp <span class="hljs-keyword">import</span> StdioServerParameters
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel


model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>)


server_parameters = StdioServerParameters(
    command=<span class="hljs-string">&quot;uvx&quot;</span>,
    args=[<span class="hljs-string">&quot;--quiet&quot;</span>, <span class="hljs-string">&quot;pubmedmcp@0.1.3&quot;</span>],
    env={<span class="hljs-string">&quot;UV_PYTHON&quot;</span>: <span class="hljs-string">&quot;3.12&quot;</span>, **os.environ},
)

<span class="hljs-keyword">with</span> ToolCollection.from_mcp(server_parameters, trust_remote_code=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> tool_collection:
    agent = CodeAgent(tools=[*tool_collection.tools], model=model, add_base_tools=<span class="hljs-literal">True</span>)
    agent.run(<span class="hljs-string">&quot;Please find a remedy for hangover.&quot;</span>)`,wrap:!1}}),He=new T({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new hs({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit2/smolagents/tools.mdx"}}),{c(){y=a("meta"),g=n(),j=a("p"),J=n(),M(d.$$.fragment),b=n(),M(I.$$.fragment),Ne=n(),v=a("p"),v.innerHTML=Ml,Se=n(),B=a("p"),B.innerHTML=pl,Le=n(),Z=a("ul"),Z.innerHTML=cl,qe=n(),W=a("p"),W.textContent=hl,ze=n(),G=a("ul"),G.innerHTML=ul,Pe=n(),$=a("p"),$.textContent=ml,De=n(),x=a("p"),x.textContent=dl,Ke=n(),A=a("p"),A.innerHTML=yl,Oe=n(),M(V.$$.fragment),et=n(),H=a("p"),H.innerHTML=gl,tt=n(),R=a("ol"),R.innerHTML=Tl,lt=n(),M(_.$$.fragment),st=n(),k=a("p"),k.innerHTML=fl,nt=n(),E=a("p"),E.textContent=Jl,ot=n(),X=a("ul"),X.innerHTML=wl,at=n(),M(Q.$$.fragment),it=n(),F=a("img"),rt=n(),M(U.$$.fragment),Mt=n(),Y=a("p"),Y.textContent=bl,pt=n(),N=a("p"),N.innerHTML=Ul,ct=n(),M(S.$$.fragment),ht=n(),M(L.$$.fragment),ut=n(),q=a("p"),q.innerHTML=Cl,mt=n(),z=a("ul"),z.innerHTML=Il,dt=n(),P=a("p"),P.innerHTML=vl,yt=n(),M(D.$$.fragment),gt=n(),K=a("p"),K.innerHTML=Bl,Tt=n(),O=a("p"),O.textContent=Zl,ft=n(),M(ee.$$.fragment),Jt=n(),te=a("p"),te.textContent=Wl,wt=n(),M(le.$$.fragment),jt=n(),se=a("p"),se.innerHTML=Gl,bt=n(),ne=a("ul"),ne.innerHTML=$l,Ut=n(),oe=a("p"),oe.textContent=xl,Ct=n(),ae=a("ul"),ae.innerHTML=Al,It=n(),ie=a("p"),ie.textContent=Vl,vt=n(),M(re.$$.fragment),Bt=n(),Me=a("p"),Me.innerHTML=Hl,Zt=n(),pe=a("p"),pe.textContent=Rl,Wt=n(),ce=a("p"),ce.textContent=_l,Gt=n(),M(he.$$.fragment),$t=n(),ue=a("p"),ue.innerHTML=kl,xt=n(),me=a("p"),me.innerHTML=El,At=n(),M(de.$$.fragment),Vt=n(),M(ye.$$.fragment),Ht=n(),ge=a("p"),ge.innerHTML=Xl,Rt=n(),M(Te.$$.fragment),_t=n(),M(fe.$$.fragment),kt=n(),Je=a("p"),Je.innerHTML=Ql,Et=n(),we=a("p"),we.innerHTML=Fl,Xt=n(),je=a("p"),je.textContent=Yl,Qt=n(),M(be.$$.fragment),Ft=n(),M(Ue.$$.fragment),Yt=n(),Ce=a("p"),Ce.innerHTML=Nl,Nt=n(),Ie=a("p"),Ie.innerHTML=Sl,St=n(),ve=a("p"),ve.innerHTML=Ll,Lt=n(),Be=a("p"),Be.textContent=ql,qt=n(),M(Ze.$$.fragment),zt=n(),M(We.$$.fragment),Pt=n(),Ge=a("p"),Ge.innerHTML=zl,Dt=n(),f=a("details"),ke=a("summary"),ke.textContent=Pl,al=n(),Ee=a("p"),Ee.innerHTML=Dl,il=n(),M($e.$$.fragment),Kt=n(),xe=a("p"),xe.textContent=Kl,Ot=n(),M(Ae.$$.fragment),el=n(),Ve=a("p"),Ve.textContent=Ol,tl=n(),M(He.$$.fragment),ll=n(),Re=a("ul"),Re.innerHTML=es,sl=n(),M(_e.$$.fragment),nl=n(),Qe=a("p"),this.h()},l(e){const t=Ms("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(l),g=o(e),j=i(e,"P",{}),rl(j).forEach(l),J=o(e),p(d.$$.fragment,e),b=o(e),p(I.$$.fragment,e),Ne=o(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-11yvg4r"&&(v.innerHTML=Ml),Se=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1w4pglg"&&(B.innerHTML=pl),Le=o(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-6t5tqb"&&(Z.innerHTML=cl),qe=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-xxdm5o"&&(W.textContent=hl),ze=o(e),G=i(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-1y8sxu4"&&(G.innerHTML=ul),Pe=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1s1gqsf"&&($.textContent=ml),De=o(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-gwhed0"&&(x.textContent=dl),Ke=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1j9zfgm"&&(A.innerHTML=yl),Oe=o(e),p(V.$$.fragment,e),et=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-16o4n5p"&&(H.innerHTML=gl),tt=o(e),R=i(e,"OL",{"data-svelte-h":!0}),r(R)!=="svelte-12j65du"&&(R.innerHTML=Tl),lt=o(e),p(_.$$.fragment,e),st=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1dh93c8"&&(k.innerHTML=fl),nt=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1hsdx6m"&&(E.textContent=Jl),ot=o(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1eycwmn"&&(X.innerHTML=wl),at=o(e),p(Q.$$.fragment,e),it=o(e),F=i(e,"IMG",{src:!0,alt:!0}),rt=o(e),p(U.$$.fragment,e),Mt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-5qyq1f"&&(Y.textContent=bl),pt=o(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1f9djim"&&(N.innerHTML=Ul),ct=o(e),p(S.$$.fragment,e),ht=o(e),p(L.$$.fragment,e),ut=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-o654lj"&&(q.innerHTML=Cl),mt=o(e),z=i(e,"UL",{"data-svelte-h":!0}),r(z)!=="svelte-9qay4f"&&(z.innerHTML=Il),dt=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1pi6ccj"&&(P.innerHTML=vl),yt=o(e),p(D.$$.fragment,e),gt=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1ugsnpu"&&(K.innerHTML=Bl),Tt=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1t4n8j6"&&(O.textContent=Zl),ft=o(e),p(ee.$$.fragment,e),Jt=o(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-148a819"&&(te.textContent=Wl),wt=o(e),p(le.$$.fragment,e),jt=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1se8fk8"&&(se.innerHTML=Gl),bt=o(e),ne=i(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-1n5ilxc"&&(ne.innerHTML=$l),Ut=o(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-13b0t4l"&&(oe.textContent=xl),Ct=o(e),ae=i(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-3o3ymr"&&(ae.innerHTML=Al),It=o(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-13o2uyy"&&(ie.textContent=Vl),vt=o(e),p(re.$$.fragment,e),Bt=o(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-bfnw4l"&&(Me.innerHTML=Hl),Zt=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-p4tufw"&&(pe.textContent=Rl),Wt=o(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-fsw72s"&&(ce.textContent=_l),Gt=o(e),p(he.$$.fragment,e),$t=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1cmmx6"&&(ue.innerHTML=kl),xt=o(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2q1hux"&&(me.innerHTML=El),At=o(e),p(de.$$.fragment,e),Vt=o(e),p(ye.$$.fragment,e),Ht=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1xtes2g"&&(ge.innerHTML=Xl),Rt=o(e),p(Te.$$.fragment,e),_t=o(e),p(fe.$$.fragment,e),kt=o(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1mpb2vu"&&(Je.innerHTML=Ql),Et=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-lat3p2"&&(we.innerHTML=Fl),Xt=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1694k70"&&(je.textContent=Yl),Qt=o(e),p(be.$$.fragment,e),Ft=o(e),p(Ue.$$.fragment,e),Yt=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1osr2dc"&&(Ce.innerHTML=Nl),Nt=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-n7r7ow"&&(Ie.innerHTML=Sl),St=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-sjrzcz"&&(ve.innerHTML=Ll),Lt=o(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-154co1f"&&(Be.textContent=ql),qt=o(e),p(Ze.$$.fragment,e),zt=o(e),p(We.$$.fragment,e),Pt=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-eejp75"&&(Ge.innerHTML=zl),Dt=o(e),f=i(e,"DETAILS",{});var w=rl(f);ke=i(w,"SUMMARY",{"data-svelte-h":!0}),r(ke)!=="svelte-17v5fx6"&&(ke.textContent=Pl),al=o(w),Ee=i(w,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1yjphc7"&&(Ee.innerHTML=Dl),il=o(w),p($e.$$.fragment,w),w.forEach(l),Kt=o(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ki4qbm"&&(xe.textContent=Kl),Ot=o(e),p(Ae.$$.fragment,e),el=o(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1yv1f1"&&(Ve.textContent=Ol),tl=o(e),p(He.$$.fragment,e),ll=o(e),Re=i(e,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-1gwl39i"&&(Re.innerHTML=es),sl=o(e),p(_e.$$.fragment,e),nl=o(e),Qe=i(e,"P",{}),rl(Qe).forEach(l),this.h()},h(){Xe(y,"name","hf:doc:metadata"),Xe(y,"content",ds),ns(F.src,jl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/smolagents/alfred-catering.jpg")||Xe(F,"src",jl),Xe(F,"alt","Alfred Catering")},m(e,t){Fe(document.head,y),s(e,g,t),s(e,j,t),s(e,J,t),c(d,e,t),s(e,b,t),c(I,e,t),s(e,Ne,t),s(e,v,t),s(e,Se,t),s(e,B,t),s(e,Le,t),s(e,Z,t),s(e,qe,t),s(e,W,t),s(e,ze,t),s(e,G,t),s(e,Pe,t),s(e,$,t),s(e,De,t),s(e,x,t),s(e,Ke,t),s(e,A,t),s(e,Oe,t),c(V,e,t),s(e,et,t),s(e,H,t),s(e,tt,t),s(e,R,t),s(e,lt,t),c(_,e,t),s(e,st,t),s(e,k,t),s(e,nt,t),s(e,E,t),s(e,ot,t),s(e,X,t),s(e,at,t),c(Q,e,t),s(e,it,t),s(e,F,t),s(e,rt,t),c(U,e,t),s(e,Mt,t),s(e,Y,t),s(e,pt,t),s(e,N,t),s(e,ct,t),c(S,e,t),s(e,ht,t),c(L,e,t),s(e,ut,t),s(e,q,t),s(e,mt,t),s(e,z,t),s(e,dt,t),s(e,P,t),s(e,yt,t),c(D,e,t),s(e,gt,t),s(e,K,t),s(e,Tt,t),s(e,O,t),s(e,ft,t),c(ee,e,t),s(e,Jt,t),s(e,te,t),s(e,wt,t),c(le,e,t),s(e,jt,t),s(e,se,t),s(e,bt,t),s(e,ne,t),s(e,Ut,t),s(e,oe,t),s(e,Ct,t),s(e,ae,t),s(e,It,t),s(e,ie,t),s(e,vt,t),c(re,e,t),s(e,Bt,t),s(e,Me,t),s(e,Zt,t),s(e,pe,t),s(e,Wt,t),s(e,ce,t),s(e,Gt,t),c(he,e,t),s(e,$t,t),s(e,ue,t),s(e,xt,t),s(e,me,t),s(e,At,t),c(de,e,t),s(e,Vt,t),c(ye,e,t),s(e,Ht,t),s(e,ge,t),s(e,Rt,t),c(Te,e,t),s(e,_t,t),c(fe,e,t),s(e,kt,t),s(e,Je,t),s(e,Et,t),s(e,we,t),s(e,Xt,t),s(e,je,t),s(e,Qt,t),c(be,e,t),s(e,Ft,t),c(Ue,e,t),s(e,Yt,t),s(e,Ce,t),s(e,Nt,t),s(e,Ie,t),s(e,St,t),s(e,ve,t),s(e,Lt,t),s(e,Be,t),s(e,qt,t),c(Ze,e,t),s(e,zt,t),c(We,e,t),s(e,Pt,t),s(e,Ge,t),s(e,Dt,t),s(e,f,t),Fe(f,ke),Fe(f,al),Fe(f,Ee),Fe(f,il),c($e,f,null),s(e,Kt,t),s(e,xe,t),s(e,Ot,t),c(Ae,e,t),s(e,el,t),s(e,Ve,t),s(e,tl,t),c(He,e,t),s(e,ll,t),s(e,Re,t),s(e,sl,t),c(_e,e,t),s(e,nl,t),s(e,Qe,t),ol=!0},p(e,[t]){const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),U.$set(w)},i(e){ol||(h(d.$$.fragment,e),h(I.$$.fragment,e),h(V.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(U.$$.fragment,e),h(S.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h($e.$$.fragment,e),h(Ae.$$.fragment,e),h(He.$$.fragment,e),h(_e.$$.fragment,e),ol=!0)},o(e){u(d.$$.fragment,e),u(I.$$.fragment,e),u(V.$$.fragment,e),u(_.$$.fragment,e),u(Q.$$.fragment,e),u(U.$$.fragment,e),u(S.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(he.$$.fragment,e),u(de.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(We.$$.fragment,e),u($e.$$.fragment,e),u(Ae.$$.fragment,e),u(He.$$.fragment,e),u(_e.$$.fragment,e),ol=!1},d(e){e&&(l(g),l(j),l(J),l(b),l(Ne),l(v),l(Se),l(B),l(Le),l(Z),l(qe),l(W),l(ze),l(G),l(Pe),l($),l(De),l(x),l(Ke),l(A),l(Oe),l(et),l(H),l(tt),l(R),l(lt),l(st),l(k),l(nt),l(E),l(ot),l(X),l(at),l(it),l(F),l(rt),l(Mt),l(Y),l(pt),l(N),l(ct),l(ht),l(ut),l(q),l(mt),l(z),l(dt),l(P),l(yt),l(gt),l(K),l(Tt),l(O),l(ft),l(Jt),l(te),l(wt),l(jt),l(se),l(bt),l(ne),l(Ut),l(oe),l(Ct),l(ae),l(It),l(ie),l(vt),l(Bt),l(Me),l(Zt),l(pe),l(Wt),l(ce),l(Gt),l($t),l(ue),l(xt),l(me),l(At),l(Vt),l(Ht),l(ge),l(Rt),l(_t),l(kt),l(Je),l(Et),l(we),l(Xt),l(je),l(Qt),l(Ft),l(Yt),l(Ce),l(Nt),l(Ie),l(St),l(ve),l(Lt),l(Be),l(qt),l(zt),l(Pt),l(Ge),l(Dt),l(f),l(Kt),l(xe),l(Ot),l(el),l(Ve),l(tl),l(ll),l(Re),l(sl),l(nl),l(Qe)),l(y),m(d,e),m(I,e),m(V,e),m(_,e),m(Q,e),m(U,e),m(S,e),m(L,e),m(D,e),m(ee,e),m(le,e),m(re,e),m(he,e),m(de,e),m(ye,e),m(Te,e),m(fe,e),m(be,e),m(Ue,e),m(Ze,e),m(We,e),m($e),m(Ae,e),m(He,e),m(_e,e)}}}const ds='{"title":"Tools","local":"tools","sections":[{"title":"Tool Creation Methods","local":"tool-creation-methods","sections":[{"title":"The @tool Decorator","local":"the-tool-decorator","sections":[{"title":"Generating a tool that retrieves the highest-rated catering","local":"generating-a-tool-that-retrieves-the-highest-rated-catering","sections":[],"depth":4}],"depth":3},{"title":"Defining a Tool as a Python Class","local":"defining-a-tool-as-a-python-class","sections":[{"title":"Generating a tool to generate ideas about the superhero-themed party","local":"generating-a-tool-to-generate-ideas-about-the-superhero-themed-party","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Default Toolbox","local":"default-toolbox","sections":[],"depth":2},{"title":"Sharing and Importing Tools","local":"sharing-and-importing-tools","sections":[{"title":"Sharing a Tool to the Hub","local":"sharing-a-tool-to-the-hub","sections":[],"depth":3},{"title":"Importing a Tool from the Hub","local":"importing-a-tool-from-the-hub","sections":[],"depth":3},{"title":"Importing a Hugging Face Space as a Tool","local":"importing-a-hugging-face-space-as-a-tool","sections":[],"depth":3},{"title":"Importing a LangChain Tool","local":"importing-a-langchain-tool","sections":[],"depth":3},{"title":"Importing a tool collection from any MCP server","local":"importing-a-tool-collection-from-any-mcp-server","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ys(Ye){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends is{constructor(y){super(),rs(this,y,ys,ms,ss,{})}}export{Us as component};
