import{s as Mt,f as dl,n as ot,o as rt}from"../chunks/scheduler.37c15a92.js";import{S as pt,i as ut,g as i,s as n,r as u,A as ct,h as M,f as t,c as a,j as wl,u as c,x as o,k as p,y as mt,a as s,v as m,d as y,t as j,w as U}from"../chunks/index.2bf4358c.js";import{C as Tl}from"../chunks/CodeBlock.4e987730.js";import{H as je}from"../chunks/Heading.8ada512a.js";import{E as yt}from"../chunks/getInferenceSnippets.d4d07d1e.js";function jt(Jl){let T,Ue,me,Te,d,de,w,bl="Dans la section précédente, nous avons appris comment créer des Agents à partir de zéro en utilisant du code Python, et nous avons <strong>vu à quel point ce processus peut être fastidieux</strong>. Heureusement, de nombreuses bibliothèques d’agents simplifient ce travail en <strong>se chargeant de la majeure partie du travail lourd pour vous</strong>.",we,J,Il="Dans ce tutoriel, <strong>vous créerez votre tout premier Agent</strong> capable d’exécuter des actions telles que la génération d’images, la recherche sur le web, la vérification de fuseaux horaires et bien plus encore !",Je,b,hl="Vous publierez également votre agent <strong>sur un Hugging Face Space afin de le partager avec vos amis et collègues</strong>.",be,I,vl="C’est parti !",Ie,h,he,v,Bl,ve,B,Cl="Pour créer cet Agent, nous allons utiliser <code>smolagents</code>, une bibliothèque qui <strong>fournit un cadre facilitant le développement de vos agents</strong>.",Be,C,fl="Cette bibliothèque légère est conçue pour la simplicité, tout en masquant une grande partie de la complexité liée à la construction d’un Agent, vous permettant ainsi de vous concentrer sur la conception du comportement de votre agent.",Ce,f,gl='Nous approfondirons smolagents dans la prochaine unité. En attendant, vous pouvez également consulter ce <a href="https://huggingface.co/blog/smolagents" target="_blank">billet de blog</a> ou le <a href="https://github.com/huggingface/smolagents" target="_blank">dépôt GitHub</a> de la bibliothèque.',fe,g,Zl="En bref, <code>smolagents</code> est une bibliothèque qui se concentre sur le <strong>codeAgent</strong>, un type d’agent qui exécute des <strong>“Actions”</strong> via des blocs de code, puis <strong>“Observe”</strong> les résultats en exécutant le code.",ge,Z,Gl="Voici un exemple de ce que nous allons construire !",Ze,G,Vl="Nous avons équipé notre agent d’un <strong>outil de génération d’images</strong> et lui avons demandé de générer une image d’un chat.",Ge,V,Al="L’agent dans <code>smolagents</code> aura les <strong>mêmes comportements que celui personnalisé que nous avons construit précédemment</strong> : il va <strong>penser, agir et observer en cycle</strong> jusqu’à atteindre une réponse finale :",Ve,r,xl,Ae,A,zl="Excitant, n’est-ce pas ?",xe,x,ze,z,Hl='Pour commencer, dupliquez ce Space : <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',He,H,Wl='<p>Merci à <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> pour ce template ! 🙌</p>',We,W,Ql="Dupliquer cet Space signifie <strong>créer une copie locale sur votre propre profil</strong> :",Qe,Q,_l,_e,_,Sl='Tout au long de cette leçon, le seul fichier que vous aurez à modifier est le (actuellement incomplet) <strong>“app.py”</strong>. Vous pouvez consulter l’<a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original dans le template</a>. Pour trouver le vôtre, allez dans votre copie du Space, cliquez sur l’onglet <code>Files</code> puis sur <code>app.py</code> dans la liste des répertoires.',Se,S,Xl="Analysons le code ensemble :",Xe,X,El="<li>Le fichier commence par quelques importations de bibliothèques simples mais nécessaires</li>",Ee,E,ke,k,kl="Comme indiqué précédemment, nous utiliserons directement la classe <strong>CodeAgent</strong> de <strong>smolagents</strong>.",Re,R,Fe,F,Rl='Entrons maintenant dans le vif du sujet avec les outils ! Si vous souhaitez un rappel sur les outils, n’hésitez pas à consulter la section <a href="tools">Outils</a> du cours.',qe,q,Ne,N,Fl="Les outils sont ce que nous vous encourageons à construire dans cette section ! Nous vous donnons deux exemples :",Ye,Y,ql="<li>Un <strong>outil factice non fonctionnel</strong> que vous pouvez modifier pour créer quelque chose d’utile.</li> <li>Un <strong>outil réellement fonctionnel</strong> qui récupère l’heure actuelle quelque part dans le monde.</li>",$e,$,Nl="Pour définir votre outil, il est important de :",Le,L,Yl="<li>Fournir des types d’entrée et de sortie pour votre fonction, comme dans <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li>Fournir une <strong>docstring bien formatée</strong>. <code>smolagents</code> s’attend à ce que tous les arguments aient une <strong>description textuelle dans la docstring</strong>.</li>",De,D,Pe,P,$l='Il utilise <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> comme moteur LLM. C’est un modèle très performant auquel nous accéderons via l’API serverless.',Oe,O,Ke,K,Ll="Cet Agent utilise toujours l’<code>InferenceClient</code> que nous avons vu dans une section précédente derrière la classe <strong>HfApiModel</strong> !",el,ee,Dl="Nous fournirons des exemples plus détaillés lors de la présentation du cadre dans l’Unité 2. Pour l’instant, vous devez vous concentrer sur <strong>l’ajout de nouveaux outils à la liste des outils</strong> en utilisant le paramètre <code>tools</code> de votre Agent.",ll,le,Pl="Par exemple, vous pourriez utiliser le <code>DuckDuckGoSearchTool</code> qui a été importé dans la première ligne du code, ou vous pouvez examiner le <code>image_generation_tool</code> qui est chargé depuis le Hub plus tard dans le code.",tl,te,Ol="<strong>Ajouter des outils donnera de nouvelles capacités à votre agent</strong>, alors soyez créatif !",sl,se,Kl="Le fichier complet <strong>“app.py”</strong> :",nl,ne,al,ae,et="Votre <strong>objectif</strong> est de vous familiariser avec le Space et l’Agent.",il,ie,lt="Actuellement, l’agent dans le template <strong>n’utilise aucun outil, alors essayez de lui fournir certains des outils préfabriqués ou même de créer de nouveaux outils vous-même !</strong>",Ml,Me,tt="Nous attendons avec impatience vos incroyables agents dans le canal Discord <strong>#agents-course-showcase</strong>!",ol,rl,pl,oe,st="Félicitations, vous avez construit votre premier Agent ! N’hésitez pas à le partager avec vos amis et collègues.",ul,re,nt="Comme c’est votre première tentative, il est tout à fait normal qu’il soit un peu bogué ou lent. Dans les unités futures, nous apprendrons à construire des Agents encore meilleurs.",cl,pe,at="La meilleure façon d’apprendre est d’essayer, alors n’hésitez pas à le mettre à jour, à ajouter plus d’outils, à essayer avec un autre modèle, etc.",ml,ue,it="Dans la prochaine section, vous allez remplir le quiz final et obtenir votre certificat !",yl,ce,jl,ye,Ul;return d=new je({props:{title:"Créons notre premier Agent avec smolagents",local:"créons-notre-premier-agent-avec-smolagents",headingTag:"h1"}}),h=new je({props:{title:"Qu’est-ce que smolagents ?",local:"quest-ce-que-smolagents-",headingTag:"h2"}}),x=new je({props:{title:"Construisons notre Agent !",local:"construisons-notre-agent-",headingTag:"h2"}}),E=new Tl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),R=new je({props:{title:"Les Outils",local:"les-outils",headingTag:"h3"}}),q=new Tl({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1: <span class="hljs-built_in">str</span>, arg2: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:  <span class="hljs-comment"># il est important de spécifier le type de retour</span>
    <span class="hljs-comment"># Conservez ce format pour la description de l&#x27;outil et des arguments, mais n&#x27;hésitez pas à modifier l&#x27;outil</span>
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui ne fait encore rien
    Arguments:
        arg1: le premier argument
        arg2: le deuxième argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Quelle magie allez-vous créer ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui récupère l&#x27;heure locale actuelle dans un fuseau horaire spécifié.
    Arguments:
        timezone: Une chaîne représentant un fuseau horaire valide (par exemple, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Créer l&#x27;objet fuseau horaire</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtenir l&#x27;heure actuelle dans ce fuseau horaire</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;L&#x27;heure locale actuelle dans <span class="hljs-subst">{timezone}</span> est : <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Erreur lors de la récupération de l&#x27;heure pour le fuseau horaire &#x27;<span class="hljs-subst">{timezone}</span>&#x27; : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),D=new je({props:{title:"L’Agent",local:"lagent",headingTag:"h3"}}),O=new Tl({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBOb3VzJTIwY3IlQzMlQTlvbnMlMjBub3RyZSUyMENvZGVBZ2VudCUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QmZpbmFsX2Fuc3dlciU1RCUyQyUyMCUyMCUyMyUyMGFqb3V0ZXolMjB2b3MlMjBvdXRpbHMlMjBpY2klMjAobmUlMjBzdXBwcmltZXolMjBwYXMlMjBmaW5hbF9hbnN3ZXIpJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUzRHByb21wdF90ZW1wbGF0ZXMlMEEpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Nous créons notre CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer],  <span class="hljs-comment"># ajoutez vos outils ici (ne supprimez pas final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ne=new Tl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># Voici un exemple d&#x27;un outil qui ne fait encore rien. Épatez-nous avec votre créativité !</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1: <span class="hljs-built_in">str</span>, arg2: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">str</span>:  <span class="hljs-comment"># il est important de spécifier le type de retour</span>
    <span class="hljs-comment"># Conservez ce format pour la description de l&#x27;outil et des arguments, mais n&#x27;hésitez pas à modifier l&#x27;outil</span>
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui ne fait encore rien
    Arguments:
        arg1: le premier argument
        arg2: le deuxième argument
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Quelle magie allez-vous créer ?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Un outil qui récupère l&#x27;heure locale actuelle dans un fuseau horaire spécifié.
    Arguments:
        timezone: Une chaîne représentant un fuseau horaire valide (par exemple, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Créer l&#x27;objet fuseau horaire</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtenir l&#x27;heure actuelle dans ce fuseau horaire</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;L&#x27;heure locale actuelle dans <span class="hljs-subst">{timezone}</span> est : <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Erreur lors de la récupération de l&#x27;heure pour le fuseau horaire &#x27;<span class="hljs-subst">{timezone}</span>&#x27; : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-comment"># Importer l&#x27;outil depuis le Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer],  <span class="hljs-comment"># ajoutez vos outils ici (ne supprimez pas final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ce=new yt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit1/tutorial.mdx"}}),{c(){T=i("meta"),Ue=n(),me=i("p"),Te=n(),u(d.$$.fragment),de=n(),w=i("p"),w.innerHTML=bl,we=n(),J=i("p"),J.innerHTML=Il,Je=n(),b=i("p"),b.innerHTML=hl,be=n(),I=i("p"),I.textContent=vl,Ie=n(),u(h.$$.fragment),he=n(),v=i("img"),ve=n(),B=i("p"),B.innerHTML=Cl,Be=n(),C=i("p"),C.textContent=fl,Ce=n(),f=i("p"),f.innerHTML=gl,fe=n(),g=i("p"),g.innerHTML=Zl,ge=n(),Z=i("p"),Z.textContent=Gl,Ze=n(),G=i("p"),G.innerHTML=Vl,Ge=n(),V=i("p"),V.innerHTML=Al,Ve=n(),r=i("iframe"),Ae=n(),A=i("p"),A.textContent=zl,xe=n(),u(x.$$.fragment),ze=n(),z=i("p"),z.innerHTML=Hl,He=n(),H=i("blockquote"),H.innerHTML=Wl,We=n(),W=i("p"),W.innerHTML=Ql,Qe=n(),Q=i("img"),_e=n(),_=i("p"),_.innerHTML=Sl,Se=n(),S=i("p"),S.textContent=Xl,Xe=n(),X=i("ul"),X.innerHTML=El,Ee=n(),u(E.$$.fragment),ke=n(),k=i("p"),k.innerHTML=kl,Re=n(),u(R.$$.fragment),Fe=n(),F=i("p"),F.innerHTML=Rl,qe=n(),u(q.$$.fragment),Ne=n(),N=i("p"),N.textContent=Fl,Ye=n(),Y=i("ol"),Y.innerHTML=ql,$e=n(),$=i("p"),$.textContent=Nl,Le=n(),L=i("ol"),L.innerHTML=Yl,De=n(),u(D.$$.fragment),Pe=n(),P=i("p"),P.innerHTML=$l,Oe=n(),u(O.$$.fragment),Ke=n(),K=i("p"),K.innerHTML=Ll,el=n(),ee=i("p"),ee.innerHTML=Dl,ll=n(),le=i("p"),le.innerHTML=Pl,tl=n(),te=i("p"),te.innerHTML=Ol,sl=n(),se=i("p"),se.innerHTML=Kl,nl=n(),u(ne.$$.fragment),al=n(),ae=i("p"),ae.innerHTML=et,il=n(),ie=i("p"),ie.innerHTML=lt,Ml=n(),Me=i("p"),Me.innerHTML=tt,ol=n(),rl=i("hr"),pl=n(),oe=i("p"),oe.textContent=st,ul=n(),re=i("p"),re.textContent=nt,cl=n(),pe=i("p"),pe.textContent=at,ml=n(),ue=i("p"),ue.textContent=it,yl=n(),u(ce.$$.fragment),jl=n(),ye=i("p"),this.h()},l(e){const l=ct("svelte-u9bgzb",document.head);T=M(l,"META",{name:!0,content:!0}),l.forEach(t),Ue=a(e),me=M(e,"P",{}),wl(me).forEach(t),Te=a(e),c(d.$$.fragment,e),de=a(e),w=M(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-11h523w"&&(w.innerHTML=bl),we=a(e),J=M(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-88ryaw"&&(J.innerHTML=Il),Je=a(e),b=M(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1i7k4q"&&(b.innerHTML=hl),be=a(e),I=M(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-13o0trz"&&(I.textContent=vl),Ie=a(e),c(h.$$.fragment,e),he=a(e),v=M(e,"IMG",{src:!0,alt:!0}),ve=a(e),B=M(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1ui8pzr"&&(B.innerHTML=Cl),Be=a(e),C=M(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-14njm19"&&(C.textContent=fl),Ce=a(e),f=M(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-1su3iu4"&&(f.innerHTML=gl),fe=a(e),g=M(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-uf2563"&&(g.innerHTML=Zl),ge=a(e),Z=M(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-x6axr8"&&(Z.textContent=Gl),Ze=a(e),G=M(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-8v2mq6"&&(G.innerHTML=Vl),Ge=a(e),V=M(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1hcorju"&&(V.innerHTML=Al),Ve=a(e),r=M(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),wl(r).forEach(t),Ae=a(e),A=M(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1gth0ux"&&(A.textContent=zl),xe=a(e),c(x.$$.fragment,e),ze=a(e),z=M(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-dhfrwo"&&(z.innerHTML=Hl),He=a(e),H=M(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(H)!=="svelte-m6kzq3"&&(H.innerHTML=Wl),We=a(e),W=M(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1tom801"&&(W.innerHTML=Ql),Qe=a(e),Q=M(e,"IMG",{src:!0,alt:!0}),_e=a(e),_=M(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-2s1ata"&&(_.innerHTML=Sl),Se=a(e),S=M(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1azrb"&&(S.textContent=Xl),Xe=a(e),X=M(e,"UL",{"data-svelte-h":!0}),o(X)!=="svelte-118pf10"&&(X.innerHTML=El),Ee=a(e),c(E.$$.fragment,e),ke=a(e),k=M(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1m3exlv"&&(k.innerHTML=kl),Re=a(e),c(R.$$.fragment,e),Fe=a(e),F=M(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1ar0zqh"&&(F.innerHTML=Rl),qe=a(e),c(q.$$.fragment,e),Ne=a(e),N=M(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-193l0gp"&&(N.textContent=Fl),Ye=a(e),Y=M(e,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-1petlbb"&&(Y.innerHTML=ql),$e=a(e),$=M(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-qbfp30"&&($.textContent=Nl),Le=a(e),L=M(e,"OL",{"data-svelte-h":!0}),o(L)!=="svelte-1opewe3"&&(L.innerHTML=Yl),De=a(e),c(D.$$.fragment,e),Pe=a(e),P=M(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-xh06mr"&&(P.innerHTML=$l),Oe=a(e),c(O.$$.fragment,e),Ke=a(e),K=M(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-bhb4if"&&(K.innerHTML=Ll),el=a(e),ee=M(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-s50lu1"&&(ee.innerHTML=Dl),ll=a(e),le=M(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-rdz5a5"&&(le.innerHTML=Pl),tl=a(e),te=M(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-vatkzs"&&(te.innerHTML=Ol),sl=a(e),se=M(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-ubbbh5"&&(se.innerHTML=Kl),nl=a(e),c(ne.$$.fragment,e),al=a(e),ae=M(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-19riug"&&(ae.innerHTML=et),il=a(e),ie=M(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1x9zq1y"&&(ie.innerHTML=lt),Ml=a(e),Me=M(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-kizn95"&&(Me.innerHTML=tt),ol=a(e),rl=M(e,"HR",{}),pl=a(e),oe=M(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1ntujpe"&&(oe.textContent=st),ul=a(e),re=M(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1954v5z"&&(re.textContent=nt),cl=a(e),pe=M(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-fowehc"&&(pe.textContent=at),ml=a(e),ue=M(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-w5fwm2"&&(ue.textContent=it),yl=a(e),c(ce.$$.fragment,e),jl=a(e),ye=M(e,"P",{}),wl(ye).forEach(t),this.h()},h(){p(T,"name","hf:doc:metadata"),p(T,"content",Ut),dl(v.src,Bl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||p(v,"src",Bl),p(v,"alt","smolagents"),p(r,"width","560"),p(r,"height","315"),dl(r.src,xl="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||p(r,"src",xl),p(r,"title","YouTube video player"),p(r,"frameborder","0"),p(r,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),p(r,"referrerpolicy","strict-origin-when-cross-origin"),r.allowFullscreen="",dl(Q.src,_l="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||p(Q,"src",_l),p(Q,"alt","Duplicate")},m(e,l){mt(document.head,T),s(e,Ue,l),s(e,me,l),s(e,Te,l),m(d,e,l),s(e,de,l),s(e,w,l),s(e,we,l),s(e,J,l),s(e,Je,l),s(e,b,l),s(e,be,l),s(e,I,l),s(e,Ie,l),m(h,e,l),s(e,he,l),s(e,v,l),s(e,ve,l),s(e,B,l),s(e,Be,l),s(e,C,l),s(e,Ce,l),s(e,f,l),s(e,fe,l),s(e,g,l),s(e,ge,l),s(e,Z,l),s(e,Ze,l),s(e,G,l),s(e,Ge,l),s(e,V,l),s(e,Ve,l),s(e,r,l),s(e,Ae,l),s(e,A,l),s(e,xe,l),m(x,e,l),s(e,ze,l),s(e,z,l),s(e,He,l),s(e,H,l),s(e,We,l),s(e,W,l),s(e,Qe,l),s(e,Q,l),s(e,_e,l),s(e,_,l),s(e,Se,l),s(e,S,l),s(e,Xe,l),s(e,X,l),s(e,Ee,l),m(E,e,l),s(e,ke,l),s(e,k,l),s(e,Re,l),m(R,e,l),s(e,Fe,l),s(e,F,l),s(e,qe,l),m(q,e,l),s(e,Ne,l),s(e,N,l),s(e,Ye,l),s(e,Y,l),s(e,$e,l),s(e,$,l),s(e,Le,l),s(e,L,l),s(e,De,l),m(D,e,l),s(e,Pe,l),s(e,P,l),s(e,Oe,l),m(O,e,l),s(e,Ke,l),s(e,K,l),s(e,el,l),s(e,ee,l),s(e,ll,l),s(e,le,l),s(e,tl,l),s(e,te,l),s(e,sl,l),s(e,se,l),s(e,nl,l),m(ne,e,l),s(e,al,l),s(e,ae,l),s(e,il,l),s(e,ie,l),s(e,Ml,l),s(e,Me,l),s(e,ol,l),s(e,rl,l),s(e,pl,l),s(e,oe,l),s(e,ul,l),s(e,re,l),s(e,cl,l),s(e,pe,l),s(e,ml,l),s(e,ue,l),s(e,yl,l),m(ce,e,l),s(e,jl,l),s(e,ye,l),Ul=!0},p:ot,i(e){Ul||(y(d.$$.fragment,e),y(h.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(R.$$.fragment,e),y(q.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(ne.$$.fragment,e),y(ce.$$.fragment,e),Ul=!0)},o(e){j(d.$$.fragment,e),j(h.$$.fragment,e),j(x.$$.fragment,e),j(E.$$.fragment,e),j(R.$$.fragment,e),j(q.$$.fragment,e),j(D.$$.fragment,e),j(O.$$.fragment,e),j(ne.$$.fragment,e),j(ce.$$.fragment,e),Ul=!1},d(e){e&&(t(Ue),t(me),t(Te),t(de),t(w),t(we),t(J),t(Je),t(b),t(be),t(I),t(Ie),t(he),t(v),t(ve),t(B),t(Be),t(C),t(Ce),t(f),t(fe),t(g),t(ge),t(Z),t(Ze),t(G),t(Ge),t(V),t(Ve),t(r),t(Ae),t(A),t(xe),t(ze),t(z),t(He),t(H),t(We),t(W),t(Qe),t(Q),t(_e),t(_),t(Se),t(S),t(Xe),t(X),t(Ee),t(ke),t(k),t(Re),t(Fe),t(F),t(qe),t(Ne),t(N),t(Ye),t(Y),t($e),t($),t(Le),t(L),t(De),t(Pe),t(P),t(Oe),t(Ke),t(K),t(el),t(ee),t(ll),t(le),t(tl),t(te),t(sl),t(se),t(nl),t(al),t(ae),t(il),t(ie),t(Ml),t(Me),t(ol),t(rl),t(pl),t(oe),t(ul),t(re),t(cl),t(pe),t(ml),t(ue),t(yl),t(jl),t(ye)),t(T),U(d,e),U(h,e),U(x,e),U(E,e),U(R,e),U(q,e),U(D,e),U(O,e),U(ne,e),U(ce,e)}}}const Ut='{"title":"Créons notre premier Agent avec smolagents","local":"créons-notre-premier-agent-avec-smolagents","sections":[{"title":"Qu’est-ce que smolagents ?","local":"quest-ce-que-smolagents-","sections":[],"depth":2},{"title":"Construisons notre Agent !","local":"construisons-notre-agent-","sections":[{"title":"Les Outils","local":"les-outils","sections":[],"depth":3},{"title":"L’Agent","local":"lagent","sections":[],"depth":3}],"depth":2}],"depth":1}';function Tt(Jl){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ht extends pt{constructor(T){super(),ut(this,T,Tt,jt,Mt,{})}}export{ht as component};
