import{s as ue,f as Ht,n as Me,o as me}from"../chunks/scheduler.37c15a92.js";import{S as de,i as ce,g as i,s as n,r as o,A as ye,h as p,f as s,c as a,j as oe,u,x as r,k as h,y as he,a as l,v as M,d as m,t as d,w as c}from"../chunks/index.2bf4358c.js";import{C as D}from"../chunks/CodeBlock.4e987730.js";import{H as O}from"../chunks/Heading.8ada512a.js";import{E as Ue}from"../chunks/getInferenceSnippets.d4d07d1e.js";function ge(Rt){let y,st,tt,lt,g,nt,T,At="Pour créer des applications avec LangGraph, vous devez comprendre ses composants principaux. Explorons les blocs fondamentaux qui constituent une application LangGraph.",at,U,Qt,it,f,Ft="Une application dans LangGraph commence à partir d’un <strong>point d’entrée</strong>, et selon l’exécution, le flux peut aller vers une fonction ou une autre jusqu’à ce qu’il atteigne la FIN.",pt,J,Nt,rt,j,ot,w,Xt="L’<strong>état</strong> est le concept central dans LangGraph. Il représente toutes les informations qui circulent à travers votre application.",ut,G,Mt,$,zt="L’état est <strong>défini par l’utilisateur</strong>, donc les champs doivent être soigneusement conçus pour contenir toutes les données nécessaires au processus de prise de décision !",mt,I,Wt="<p>💡 <strong>Astuce :</strong> Réfléchissez soigneusement aux informations que votre application doit suivre entre les étapes.</p>",dt,C,ct,b,Yt="Les <strong>nœuds</strong> sont des fonctions python. Chaque nœud :",yt,_,Kt="<li>Prend l’état en entrée</li> <li>Effectue une opération</li> <li>Retourne des mises à jour de l’état</li>",ht,k,Ut,v,Pt="Par exemple, les nœuds peuvent contenir :",gt,B,Dt="<li><strong>Appels de LLM</strong> : Générer du texte ou prendre des décisions</li> <li><strong>Appels d’outils</strong> : Interagir avec des systèmes externes</li> <li><strong>Logique conditionnelle</strong> : Déterminer les prochaines étapes</li> <li><strong>Intervention humaine</strong> : Obtenir des contributions des utilisateurs</li>",Tt,Z,Ot="<p>💡 <strong>Info :</strong> Certains nœuds nécessaires pour l’ensemble du <em>workflow</em> comme <em>START</em> et <em>END</em> existent directement dans <em>langGraph</em>.</p>",ft,L,Jt,S,te="Les <strong>arêtes</strong> connectent les nœuds et définissent les chemins possibles à travers votre graphe :",jt,x,wt,E,ee="Les arêtes peuvent être :",Gt,V,se="<li><strong>Directes</strong> : Toujours aller du nœud A au nœud B</li> <li><strong>Conditionnelles</strong> : Choisir le prochain nœud basé sur l’état actuel</li>",$t,q,It,H,le="Le <strong>StateGraph</strong> est le conteneur qui détient l’ensemble de votre <em>workflow</em> d’agent :",Ct,R,bt,A,ne="Qui peut ensuite être visualisé !",_t,Q,kt,F,ae,vt,N,ie="Mais plus important encore, invoqué :",Bt,X,Zt,z,pe="sortie :",Lt,W,St,Y,xt,K,re="Dans la prochaine section, nous mettrons ces concepts en pratique en construisant notre premier graphe. Ce graphe permet à Alfred de prendre vos <em>e-mails</em>, les classifier, et rédiger une réponse préliminaire s’ils sont authentiques.",Et,P,Vt,et,qt;return g=new O({props:{title:"Les composants de base de LangGraph",local:"les-composants-de-base-de-langgraph",headingTag:"h1"}}),j=new O({props:{title:"1. État",local:"1-état",headingTag:"h2"}}),G=new D({props:{code:"ZnJvbSUyMHR5cGluZ19leHRlbnNpb25zJTIwaW1wb3J0JTIwVHlwZWREaWN0JTBBJTBBY2xhc3MlMjBTdGF0ZShUeXBlZERpY3QpJTNBJTBBJTIwJTIwJTIwJTIwZ3JhcGhfc3RhdGUlM0ElMjBzdHI=",highlighted:`<span class="hljs-keyword">from</span> typing_extensions <span class="hljs-keyword">import</span> TypedDict

<span class="hljs-keyword">class</span> <span class="hljs-title class_">State</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    graph_state: <span class="hljs-built_in">str</span>`,wrap:!1}}),C=new O({props:{title:"2. Nœuds",local:"2-nœuds",headingTag:"h2"}}),k=new D({props:{code:"ZGVmJTIwbm9kZV8xKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAxLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwSSUyMGFtJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8yKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAyLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwaGFwcHkhJTIyJTdEJTBBJTBBZGVmJTIwbm9kZV8zKHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMi0tLU5vZGUlMjAzLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmdyYXBoX3N0YXRlJTIyJTNBJTIwc3RhdGUlNUInZ3JhcGhfc3RhdGUnJTVEJTIwJTJCJTIyJTIwc2FkISUyMiU3RA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_1</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 1---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; I am&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_2</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 2---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; happy!&quot;</span>}

<span class="hljs-keyword">def</span> <span class="hljs-title function_">node_3</span>(<span class="hljs-params">state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;---Node 3---&quot;</span>)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;graph_state&quot;</span>: state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] +<span class="hljs-string">&quot; sad!&quot;</span>}`,wrap:!1}}),L=new O({props:{title:"3. Arêtes",local:"3-arêtes",headingTag:"h2"}}),x=new D({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpdGVyYWwlMEElMEFkZWYlMjBkZWNpZGVfbW9vZChzdGF0ZSklMjAtJTNFJTIwTGl0ZXJhbCU1QiUyMm5vZGVfMiUyMiUyQyUyMCUyMm5vZGVfMyUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMyUyMFNvdXZlbnQlMkMlMjBub3VzJTIwdXRpbGlzZXJvbnMlMjBsJyVDMyVBOXRhdCUyMHBvdXIlMjBkJUMzJUE5Y2lkZXIlMjBkdSUyMHByb2NoYWluJTIwbiVDNSU5M3VkJTIwJUMzJUEwJTIwdmlzaXRlciUwQSUyMCUyMCUyMCUyMHVzZXJfaW5wdXQlMjAlM0QlMjBzdGF0ZSU1QidncmFwaF9zdGF0ZSclNUQlMjAlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBJY2klMkMlMjBmYWlzb25zJTIwanVzdGUlMjB1bmUlMjByJUMzJUE5cGFydGl0aW9uJTIwNTAlMkY1MCUyMGVudHJlJTIwbGVzJTIwbiVDNSU5M3VkcyUyMDIlMkMlMjAzJTBBJTIwJTIwJTIwJTIwaWYlMjByYW5kb20ucmFuZG9tKCklMjAlM0MlMjAwLjUlM0ElMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjA1MCUyNSUyMGR1JTIwdGVtcHMlMkMlMjBub3VzJTIwcmV0b3Vybm9ucyUyME5vZGUlMjAyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIybm9kZV8yJTIyJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwNTAlMjUlMjBkdSUyMHRlbXBzJTJDJTIwbm91cyUyMHJldG91cm5vbnMlMjBOb2RlJTIwMyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCUyMm5vZGVfMyUyMg==",highlighted:`<span class="hljs-keyword">import</span> random
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Literal</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">decide_mood</span>(<span class="hljs-params">state</span>) -&gt; <span class="hljs-type">Literal</span>[<span class="hljs-string">&quot;node_2&quot;</span>, <span class="hljs-string">&quot;node_3&quot;</span>]:
    
    <span class="hljs-comment"># Souvent, nous utiliserons l&#x27;état pour décider du prochain nœud à visiter</span>
    user_input = state[<span class="hljs-string">&#x27;graph_state&#x27;</span>] 
    
    <span class="hljs-comment"># Ici, faisons juste une répartition 50/50 entre les nœuds 2, 3</span>
    <span class="hljs-keyword">if</span> random.random() &lt; <span class="hljs-number">0.5</span>:

        <span class="hljs-comment"># 50% du temps, nous retournons Node 2</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_2&quot;</span>
    
    <span class="hljs-comment"># 50% du temps, nous retournons Node 3</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;node_3&quot;</span>`,wrap:!1}}),q=new O({props:{title:"4. StateGraph",local:"4-stategraph",headingTag:"h2"}}),R=new D({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEltYWdlJTJDJTIwZGlzcGxheSUwQWZyb20lMjBsYW5nZ3JhcGguZ3JhcGglMjBpbXBvcnQlMjBTdGF0ZUdyYXBoJTJDJTIwU1RBUlQlMkMlMjBFTkQlMEElMEElMjMlMjBDb25zdHJ1aXJlJTIwbGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChTdGF0ZSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMSUyMiUyQyUyMG5vZGVfMSklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMiUyMiUyQyUyMG5vZGVfMiklMEFidWlsZGVyLmFkZF9ub2RlKCUyMm5vZGVfMyUyMiUyQyUyMG5vZGVfMyklMEElMEElMjMlMjBMb2dpcXVlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMm5vZGVfMSUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMjJub2RlXzElMjIlMkMlMjBkZWNpZGVfbW9vZCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMiUyMiUyQyUyMEVORCklMEFidWlsZGVyLmFkZF9lZGdlKCUyMm5vZGVfMyUyMiUyQyUyMEVORCklMEElMEElMjMlMjBBam91dGVyJTBBZ3JhcGglMjAlM0QlMjBidWlsZGVyLmNvbXBpbGUoKQ==",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> StateGraph, START, END

<span class="hljs-comment"># Construire le graphe</span>
builder = StateGraph(State)
builder.add_node(<span class="hljs-string">&quot;node_1&quot;</span>, node_1)
builder.add_node(<span class="hljs-string">&quot;node_2&quot;</span>, node_2)
builder.add_node(<span class="hljs-string">&quot;node_3&quot;</span>, node_3)

<span class="hljs-comment"># Logique</span>
builder.add_edge(START, <span class="hljs-string">&quot;node_1&quot;</span>)
builder.add_conditional_edges(<span class="hljs-string">&quot;node_1&quot;</span>, decide_mood)
builder.add_edge(<span class="hljs-string">&quot;node_2&quot;</span>, END)
builder.add_edge(<span class="hljs-string">&quot;node_3&quot;</span>, END)

<span class="hljs-comment"># Ajouter</span>
graph = builder.<span class="hljs-built_in">compile</span>()`,wrap:!1}}),Q=new D({props:{code:"JTIzJTIwVmlzdWFsaXNlciUwQWRpc3BsYXkoSW1hZ2UoZ3JhcGguZ2V0X2dyYXBoKCkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Visualiser</span>
display(Image(graph.get_graph().draw_mermaid_png()))`,wrap:!1}}),X=new D({props:{code:"Z3JhcGguaW52b2tlKCU3QiUyMmdyYXBoX3N0YXRlJTIyJTIwJTNBJTIwJTIySGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjIlN0Qp",highlighted:'graph.invoke({<span class="hljs-string">&quot;graph_state&quot;</span> : <span class="hljs-string">&quot;Hi, this is Lance.&quot;</span>})',wrap:!1}}),W=new D({props:{code:"LS0tTm9kZSUyMDEtLS0lMEEtLS1Ob2RlJTIwMy0tLSUwQSU3QidncmFwaF9zdGF0ZSclM0ElMjAnSGklMkMlMjB0aGlzJTIwaXMlMjBMYW5jZS4lMjBJJTIwYW0lMjBzYWQhJyU3RA==",highlighted:`---<span class="hljs-keyword">Node</span> <span class="hljs-title">1---</span>
---<span class="hljs-keyword">Node</span> <span class="hljs-title">3---</span>
{&#x27;graph_state&#x27;: &#x27;Hi, this is Lance. I am sad!&#x27;}`,wrap:!1}}),Y=new O({props:{title:"Et maintenant ?",local:"et-maintenant-",headingTag:"h2"}}),P=new Ue({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/building_blocks.mdx"}}),{c(){y=i("meta"),st=n(),tt=i("p"),lt=n(),o(g.$$.fragment),nt=n(),T=i("p"),T.textContent=At,at=n(),U=i("img"),it=n(),f=i("p"),f.innerHTML=Ft,pt=n(),J=i("img"),rt=n(),o(j.$$.fragment),ot=n(),w=i("p"),w.innerHTML=Xt,ut=n(),o(G.$$.fragment),Mt=n(),$=i("p"),$.innerHTML=zt,mt=n(),I=i("blockquote"),I.innerHTML=Wt,dt=n(),o(C.$$.fragment),ct=n(),b=i("p"),b.innerHTML=Yt,yt=n(),_=i("ul"),_.innerHTML=Kt,ht=n(),o(k.$$.fragment),Ut=n(),v=i("p"),v.textContent=Pt,gt=n(),B=i("ul"),B.innerHTML=Dt,Tt=n(),Z=i("blockquote"),Z.innerHTML=Ot,ft=n(),o(L.$$.fragment),Jt=n(),S=i("p"),S.innerHTML=te,jt=n(),o(x.$$.fragment),wt=n(),E=i("p"),E.textContent=ee,Gt=n(),V=i("ul"),V.innerHTML=se,$t=n(),o(q.$$.fragment),It=n(),H=i("p"),H.innerHTML=le,Ct=n(),o(R.$$.fragment),bt=n(),A=i("p"),A.textContent=ne,_t=n(),o(Q.$$.fragment),kt=n(),F=i("img"),vt=n(),N=i("p"),N.textContent=ie,Bt=n(),o(X.$$.fragment),Zt=n(),z=i("p"),z.textContent=pe,Lt=n(),o(W.$$.fragment),St=n(),o(Y.$$.fragment),xt=n(),K=i("p"),K.innerHTML=re,Et=n(),o(P.$$.fragment),Vt=n(),et=i("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(s),st=a(t),tt=p(t,"P",{}),oe(tt).forEach(s),lt=a(t),u(g.$$.fragment,t),nt=a(t),T=p(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18x2c8u"&&(T.textContent=At),at=a(t),U=p(t,"IMG",{src:!0,alt:!0,width:!0}),it=a(t),f=p(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-zhtr0u"&&(f.innerHTML=Ft),pt=a(t),J=p(t,"IMG",{src:!0,alt:!0}),rt=a(t),u(j.$$.fragment,t),ot=a(t),w=p(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1bnapx2"&&(w.innerHTML=Xt),ut=a(t),u(G.$$.fragment,t),Mt=a(t),$=p(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wufid7"&&($.innerHTML=zt),mt=a(t),I=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(I)!=="svelte-awafok"&&(I.innerHTML=Wt),dt=a(t),u(C.$$.fragment,t),ct=a(t),b=p(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-35inpk"&&(b.innerHTML=Yt),yt=a(t),_=p(t,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1f7e4tg"&&(_.innerHTML=Kt),ht=a(t),u(k.$$.fragment,t),Ut=a(t),v=p(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-idcot5"&&(v.textContent=Pt),gt=a(t),B=p(t,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-15s4yix"&&(B.innerHTML=Dt),Tt=a(t),Z=p(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Z)!=="svelte-tcnqn2"&&(Z.innerHTML=Ot),ft=a(t),u(L.$$.fragment,t),Jt=a(t),S=p(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-rsvnlm"&&(S.innerHTML=te),jt=a(t),u(x.$$.fragment,t),wt=a(t),E=p(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-e31ekt"&&(E.textContent=ee),Gt=a(t),V=p(t,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-8qlrxe"&&(V.innerHTML=se),$t=a(t),u(q.$$.fragment,t),It=a(t),H=p(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-3o6f6e"&&(H.innerHTML=le),Ct=a(t),u(R.$$.fragment,t),bt=a(t),A=p(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1gx08rj"&&(A.textContent=ne),_t=a(t),u(Q.$$.fragment,t),kt=a(t),F=p(t,"IMG",{src:!0,alt:!0}),vt=a(t),N=p(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ikx93n"&&(N.textContent=ie),Bt=a(t),u(X.$$.fragment,t),Zt=a(t),z=p(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-osflg"&&(z.textContent=pe),Lt=a(t),u(W.$$.fragment,t),St=a(t),u(Y.$$.fragment,t),xt=a(t),K=p(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1o88kks"&&(K.innerHTML=re),Et=a(t),u(P.$$.fragment,t),Vt=a(t),et=p(t,"P",{}),oe(et).forEach(s),this.h()},h(){h(y,"name","hf:doc:metadata"),h(y,"content",Te),Ht(U.src,Qt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Building_blocks.png")||h(U,"src",Qt),h(U,"alt","Building Blocks"),h(U,"width","70%"),Ht(J.src,Nt="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/application.png")||h(J,"src",Nt),h(J,"alt","Application"),Ht(F.src,ae="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/basic_graph.jpeg")||h(F,"src",ae),h(F,"alt","Graph Visualization")},m(t,e){he(document.head,y),l(t,st,e),l(t,tt,e),l(t,lt,e),M(g,t,e),l(t,nt,e),l(t,T,e),l(t,at,e),l(t,U,e),l(t,it,e),l(t,f,e),l(t,pt,e),l(t,J,e),l(t,rt,e),M(j,t,e),l(t,ot,e),l(t,w,e),l(t,ut,e),M(G,t,e),l(t,Mt,e),l(t,$,e),l(t,mt,e),l(t,I,e),l(t,dt,e),M(C,t,e),l(t,ct,e),l(t,b,e),l(t,yt,e),l(t,_,e),l(t,ht,e),M(k,t,e),l(t,Ut,e),l(t,v,e),l(t,gt,e),l(t,B,e),l(t,Tt,e),l(t,Z,e),l(t,ft,e),M(L,t,e),l(t,Jt,e),l(t,S,e),l(t,jt,e),M(x,t,e),l(t,wt,e),l(t,E,e),l(t,Gt,e),l(t,V,e),l(t,$t,e),M(q,t,e),l(t,It,e),l(t,H,e),l(t,Ct,e),M(R,t,e),l(t,bt,e),l(t,A,e),l(t,_t,e),M(Q,t,e),l(t,kt,e),l(t,F,e),l(t,vt,e),l(t,N,e),l(t,Bt,e),M(X,t,e),l(t,Zt,e),l(t,z,e),l(t,Lt,e),M(W,t,e),l(t,St,e),M(Y,t,e),l(t,xt,e),l(t,K,e),l(t,Et,e),M(P,t,e),l(t,Vt,e),l(t,et,e),qt=!0},p:Me,i(t){qt||(m(g.$$.fragment,t),m(j.$$.fragment,t),m(G.$$.fragment,t),m(C.$$.fragment,t),m(k.$$.fragment,t),m(L.$$.fragment,t),m(x.$$.fragment,t),m(q.$$.fragment,t),m(R.$$.fragment,t),m(Q.$$.fragment,t),m(X.$$.fragment,t),m(W.$$.fragment,t),m(Y.$$.fragment,t),m(P.$$.fragment,t),qt=!0)},o(t){d(g.$$.fragment,t),d(j.$$.fragment,t),d(G.$$.fragment,t),d(C.$$.fragment,t),d(k.$$.fragment,t),d(L.$$.fragment,t),d(x.$$.fragment,t),d(q.$$.fragment,t),d(R.$$.fragment,t),d(Q.$$.fragment,t),d(X.$$.fragment,t),d(W.$$.fragment,t),d(Y.$$.fragment,t),d(P.$$.fragment,t),qt=!1},d(t){t&&(s(st),s(tt),s(lt),s(nt),s(T),s(at),s(U),s(it),s(f),s(pt),s(J),s(rt),s(ot),s(w),s(ut),s(Mt),s($),s(mt),s(I),s(dt),s(ct),s(b),s(yt),s(_),s(ht),s(Ut),s(v),s(gt),s(B),s(Tt),s(Z),s(ft),s(Jt),s(S),s(jt),s(wt),s(E),s(Gt),s(V),s($t),s(It),s(H),s(Ct),s(bt),s(A),s(_t),s(kt),s(F),s(vt),s(N),s(Bt),s(Zt),s(z),s(Lt),s(St),s(xt),s(K),s(Et),s(Vt),s(et)),s(y),c(g,t),c(j,t),c(G,t),c(C,t),c(k,t),c(L,t),c(x,t),c(q,t),c(R,t),c(Q,t),c(X,t),c(W,t),c(Y,t),c(P,t)}}}const Te='{"title":"Les composants de base de LangGraph","local":"les-composants-de-base-de-langgraph","sections":[{"title":"1. État","local":"1-état","sections":[],"depth":2},{"title":"2. Nœuds","local":"2-nœuds","sections":[],"depth":2},{"title":"3. Arêtes","local":"3-arêtes","sections":[],"depth":2},{"title":"4. StateGraph","local":"4-stategraph","sections":[],"depth":2},{"title":"Et maintenant ?","local":"et-maintenant-","sections":[],"depth":2}],"depth":1}';function fe(Rt){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ie extends de{constructor(y){super(),ce(this,y,fe,ge,ue,{})}}export{Ie as component};
