import{s as _e,o as qe,n as He}from"../chunks/scheduler.37c15a92.js";import{S as Fe,i as Le,g as M,s as n,r as o,A as De,h as i,f as s,c as a,j as Qe,u as y,x as p,k as re,y as Pe,a as t,v as J,d as j,t as T,w as r,m as Se,n as Re}from"../chunks/index.2bf4358c.js";import{T as Ke}from"../chunks/Tip.363c041f.js";import{C as U}from"../chunks/CodeBlock.4e987730.js";import{H as m}from"../chunks/Heading.8ada512a.js";import{E as Oe}from"../chunks/getInferenceSnippets.d4d07d1e.js";function ls(ml){let w,d,I="ce notebook",c;return{c(){w=Se("Vous pouvez suivre le code dans "),d=M("a"),d.textContent=I,c=Se(" que vous pouvez exécuter avec *Google Colab*."),this.h()},l(u){w=Re(u,"Vous pouvez suivre le code dans "),d=i(u,"A",{href:!0,target:!0,"data-svelte-h":!0}),p(d)!=="svelte-sdk8an"&&(d.textContent=I),c=Re(u," que vous pouvez exécuter avec *Google Colab*."),this.h()},h(){re(d,"href","https://huggingface.co/agents-course/notebooks/blob/main/unit2/langgraph/agent.ipynb"),re(d,"target","_blank")},m(u,C){t(u,w,C),t(u,d,C),t(u,c,C)},p:He,d(u){u&&(s(w),s(d),s(c))}}}function es(ml){let w,d,I,c,u,C,h,ue="Alfred à votre service. En tant que majordome de confiance de M. Wayne, j’ai pris la liberté de documenter comment j’aide M. Wayne avec ses divers besoins documentaires. Pendant qu’il s’occupe de ses… activités nocturnes, je m’assure que tous ses papiers, programmes d’entraînement et plans nutritionnels sont correctement analysés et organisés.",Ul,B,we="Avant de partir, il a laissé une note avec son programme d’entraînement de la semaine. J’ai alors pris la responsabilité de proposer un <strong>menu</strong> pour les repas de demain.",cl,A,de="Pour de futurs événements similaires, créons un système d’analyse de documents utilisant LangGraph pour servir les besoins de M. Wayne. Ce système peut :",Il,g,me="<li>Traiter des documents image</li> <li>Extraire du texte en utilisant des modèles de vision (<em>Vision Language Model</em>)</li> <li>Effectuer des calculs quand nécessaire (pour démontrer les outils normaux)</li> <li>Analyser le contenu et fournir des résumés concis</li> <li>Exécuter des instructions spécifiques liées aux documents</li>",Cl,G,bl,Z,Ue="Le <em>workflow</em> que nous allons construire suit ce schéma structuré :",hl,f,ce='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/alfred_flow.png" alt="Butler&#39;s Document Analysis Workflow"/>',Bl,b,Al,W,gl,V,Gl,x,Ie="et les imports :",Zl,v,fl,X,Wl,$,Ce=`Cet état est un peu plus complexe que les précédents que nous avons vus.
<code>AnyMessage</code> est une classe de <em>Langchain</em> qui définit les messages, et <code>add_messages</code> est un opérateur qui ajoute le dernier message plutôt que de l’écraser avec le dernier état.`,Vl,E,be="C’est un nouveau concept dans LangGraph, où vous pouvez ajouter des opérateurs dans votre état pour définir la façon dont ils doivent interagir ensemble.",xl,z,vl,k,Xl,N,$l,Y,El,Q,zl,S,kl,R,he="Permettez-moi d’expliquer l’approche dans cet agent. L’agent suit ce qu’on appelle le modèle <em>ReAct</em> (<em>Reason-Act-Observe</em>)",Nl,_,Be="<li><strong>Raisonner</strong> sur ses documents et demandes</li> <li><strong>Agir</strong> en utilisant les outils appropriés</li> <li><strong>Observer</strong> les résultats</li> <li><strong>Répéter</strong> si nécessaire jusqu’à ce que j’aie pleinement répondu à ses besoins</li>",Yl,q,Ae="C’est une implémentation simple d’un agent utilisant LangGraph.",Ql,H,Sl,F,ge=`Nous définissons un nœud <code>tools</code> avec notre liste d’outils. Le nœud <code>assistant</code> est juste notre modèle avec les outils liés.
Nous créons un graphe avec les nœuds <code>assistant</code> et <code>tools</code>.`,Rl,L,Ge="Nous ajoutons une arête <code>tools_condition</code>, qui route vers <code>End</code> ou vers <code>tools</code> selon que l’<code>assistant</code> appelle un outil.",_l,D,Ze="Maintenant, nous ajoutons une nouvelle étape :",ql,P,fe="Nous connectons le nœud <code>tools</code> de retour à l’<code>assistant</code>, formant une boucle.",Hl,K,We="<li>Après l’exécution du nœud <code>assistant</code>, <code>tools_condition</code> vérifie si la sortie du modèle est un appel d’outil.</li> <li>Si c’est un appel d’outil, le flux est dirigé vers le nœud <code>tools</code>.</li> <li>Le nœud <code>tools</code> se reconnecte à <code>assistant</code>.</li> <li>Cette boucle continue tant que le modèle décide d’appeler des outils.</li> <li>Si la réponse du modèle n’est pas un appel d’outil, le flux est dirigé vers <em>END</em>, terminant le processus.</li>",Fl,O,Ve='<img src="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit2/LangGraph/Agent.png" alt="ReAct Pattern"/>',Ll,ll,Dl,el,Pl,sl,xe="Voici un exemple pour montrer un cas d’usage simple d’un agent utilisant un outil dans LangGraph.",Kl,tl,Ol,nl,ve="La conversation se déroulerait :",le,al,ee,Ml,se,il,Xe="Quand Maître Wayne laisse ses notes d’entraînement et de repas :",te,pl,ne,ol,$e="L’interaction se déroulerait :",ae,yl,Me,Jl,ie,jl,Ee="Si vous souhaitez créer votre propre majordome d’analyse de documents, voici les considérations clés :",pe,Tl,ze="<li><strong>Définir des outils clairs</strong> pour des tâches spécifiques liées aux documents</li> <li><strong>Créer un suivi d’état robuste</strong> pour maintenir le contexte entre les appels d’outils</li> <li><strong>Considérer la gestion d’erreurs</strong> pour les échecs d’outils</li> <li><strong>Maintenir la conscience contextuelle</strong> des interactions précédentes (assurée par l’opérateur <code>add_messages</code>)</li>",oe,rl,ke="Avec ces principes, vous aussi pouvez fournir un service d’analyse de documents exemplaire digne du manoir Wayne.",ye,ul,Ne="<em>J’espère que cette explication a été satisfaisante. Maintenant, si vous voulez bien m’excuser, la cape de Maître Wayne nécessite un repassage avant les activités de ce soir.</em>",Je,wl,je,dl,Te;return u=new m({props:{title:"Graphe d’analyse de documents",local:"graphe-danalyse-de-documents",headingTag:"h1"}}),G=new m({props:{title:"Le workflow du majordome",local:"le-workflow-du-majordome",headingTag:"h2"}}),b=new Ke({props:{$$slots:{default:[ls]},$$scope:{ctx:ml}}}),W=new m({props:{title:"Configuration de l’environnement",local:"configuration-de-lenvironnement",headingTag:"h2"}}),V=new U({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGxhbmdncmFwaCUyMGxhbmdjaGFpbl9vcGVuYWklMjBsYW5nY2hhaW5fY29yZQ==",highlighted:"%pip install langgraph langchain_openai langchain_core",wrap:!1}}),v=new U({props:{code:"aW1wb3J0JTIwYmFzZTY0JTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUeXBlZERpY3QlMkMlMjBBbm5vdGF0ZWQlMkMlMjBPcHRpb25hbCUwQWZyb20lMjBsYW5nY2hhaW5fb3BlbmFpJTIwaW1wb3J0JTIwQ2hhdE9wZW5BSSUwQWZyb20lMjBsYW5nY2hhaW5fY29yZS5tZXNzYWdlcyUyMGltcG9ydCUyMEFueU1lc3NhZ2UlMkMlMjBTeXN0ZW1NZXNzYWdlJTJDJTIwSHVtYW5NZXNzYWdlJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaC5tZXNzYWdlJTIwaW1wb3J0JTIwYWRkX21lc3NhZ2VzJTBBZnJvbSUyMGxhbmdncmFwaC5ncmFwaCUyMGltcG9ydCUyMFNUQVJUJTJDJTIwU3RhdGVHcmFwaCUwQWZyb20lMjBsYW5nZ3JhcGgucHJlYnVpbHQlMjBpbXBvcnQlMjBUb29sTm9kZSUyQyUyMHRvb2xzX2NvbmRpdGlvbiUwQWZyb20lMjBJUHl0aG9uLmRpc3BsYXklMjBpbXBvcnQlMjBJbWFnZSUyQyUyMGRpc3BsYXk=",highlighted:`<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, TypedDict, Annotated, <span class="hljs-type">Optional</span>
<span class="hljs-keyword">from</span> langchain_openai <span class="hljs-keyword">import</span> ChatOpenAI
<span class="hljs-keyword">from</span> langchain_core.messages <span class="hljs-keyword">import</span> AnyMessage, SystemMessage, HumanMessage
<span class="hljs-keyword">from</span> langgraph.graph.message <span class="hljs-keyword">import</span> add_messages
<span class="hljs-keyword">from</span> langgraph.graph <span class="hljs-keyword">import</span> START, StateGraph
<span class="hljs-keyword">from</span> langgraph.prebuilt <span class="hljs-keyword">import</span> ToolNode, tools_condition
<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image, display`,wrap:!1}}),X=new m({props:{title:"Définir l’état de l’agent",local:"définir-létat-de-lagent",headingTag:"h2"}}),z=new U({props:{code:"Y2xhc3MlMjBBZ2VudFN0YXRlKFR5cGVkRGljdCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBMZSUyMGRvY3VtZW50JTIwZm91cm5pJTBBJTIwJTIwJTIwJTIwaW5wdXRfZmlsZSUzQSUyME9wdGlvbmFsJTVCc3RyJTVEJTIwJTIwJTIzJTIwQ29udGllbnQlMjBsZSUyMGNoZW1pbiUyMGR1JTIwZmljaGllciUyMChQREYlMkZQTkcpJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0ElMjBBbm5vdGF0ZWQlNUJsaXN0JTVCQW55TWVzc2FnZSU1RCUyQyUyMGFkZF9tZXNzYWdlcyU1RA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">AgentState</span>(<span class="hljs-title class_ inherited__">TypedDict</span>):
    <span class="hljs-comment"># Le document fourni</span>
    input_file: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]  <span class="hljs-comment"># Contient le chemin du fichier (PDF/PNG)</span>
    messages: Annotated[<span class="hljs-built_in">list</span>[AnyMessage], add_messages]`,wrap:!1}}),k=new m({props:{title:"Préparer les outils",local:"préparer-les-outils",headingTag:"h2"}}),N=new U({props:{code:"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",highlighted:`vision_llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_text</span>(<span class="hljs-params">img_path: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.
    
    Maître Wayne laisse souvent des notes avec son régime d&#x27;entraînement ou ses plans de repas.
    Cela me permet d&#x27;analyser correctement le contenu.
    &quot;&quot;&quot;</span>
    all_text = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Lire l&#x27;image et encoder en base64</span>
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(img_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> image_file:
            image_bytes = image_file.read()

        image_base64 = base64.b64encode(image_bytes).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

        <span class="hljs-comment"># Préparer le prompt incluant les données d&#x27;image base64</span>
        message = [
            HumanMessage(
                content=[
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
                        <span class="hljs-string">&quot;text&quot;</span>: (
                            <span class="hljs-string">&quot;Extrayez tout le texte de cette image. &quot;</span>
                            <span class="hljs-string">&quot;Retournez seulement le texte extrait, sans explications.&quot;</span>
                        ),
                    },
                    {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
                        <span class="hljs-string">&quot;image_url&quot;</span>: {
                            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image_base64}</span>&quot;</span>
                        },
                    },
                ]
            )
        ]

        <span class="hljs-comment"># Appeler le modèle capable de vision</span>
        response = vision_llm.invoke(message)

        <span class="hljs-comment"># Ajouter le texte extrait</span>
        all_text += response.content + <span class="hljs-string">&quot;\\n\\n&quot;</span>

        <span class="hljs-keyword">return</span> all_text.strip()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-comment"># Un majordome doit gérer les erreurs avec élégance</span>
        error_msg = <span class="hljs-string">f&quot;Erreur lors de l&#x27;extraction du texte : <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
        <span class="hljs-built_in">print</span>(error_msg)
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">divide</span>(<span class="hljs-params">a: <span class="hljs-built_in">int</span>, b: <span class="hljs-built_in">int</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Diviser a et b - pour les calculs occasionnels de Maître Wayne.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a / b

<span class="hljs-comment"># Équiper le majordome avec des outils</span>
tools = [
    divide,
    extract_text
]

llm = ChatOpenAI(model=<span class="hljs-string">&quot;gpt-4o&quot;</span>)
llm_with_tools = llm.bind_tools(tools, parallel_tool_calls=<span class="hljs-literal">False</span>)`,wrap:!1}}),Y=new m({props:{title:"Les nœuds",local:"les-nœuds",headingTag:"h2"}}),Q=new U({props:{code:"ZGVmJTIwYXNzaXN0YW50KHN0YXRlJTNBJTIwQWdlbnRTdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBNZXNzYWdlJTIwc3lzdCVDMyVBOG1lJTBBJTIwJTIwJTIwJTIwdGV4dHVhbF9kZXNjcmlwdGlvbl9vZl90b29sJTNEJTIyJTIyJTIyJTBBZXh0cmFjdF90ZXh0KGltZ19wYXRoJTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjBFeHRyYWlyZSUyMGxlJTIwdGV4dGUlMjBkJ3VuJTIwZmljaGllciUyMGltYWdlJTIwZW4lMjB1dGlsaXNhbnQlMjB1biUyMG1vZCVDMyVBOGxlJTIwbXVsdGltb2RhbC4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1nX3BhdGglM0ElMjBVbiUyMGNoZW1pbiUyMGRlJTIwZmljaGllciUyMGltYWdlJTIwbG9jYWwlMjAoY2hhJUMzJUFFbmVzKS4lMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5lJTIwY2hhJUMzJUFFbmUlMjB1bmlxdWUlMjBjb250ZW5hbnQlMjBsZSUyMHRleHRlJTIwY29uY2F0JUMzJUE5biVDMyVBOSUyMGV4dHJhaXQlMjBkZSUyMGNoYXF1ZSUyMGltYWdlLiUwQWRpdmlkZShhJTNBJTIwaW50JTJDJTIwYiUzQSUyMGludCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMjAlMjAlMjAlMjBEaXZpc2VyJTIwYSUyMGV0JTIwYiUwQSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMGltYWdlJTNEc3RhdGUlNUIlMjJpbnB1dF9maWxlJTIyJTVEJTBBJTIwJTIwJTIwJTIwc3lzX21zZyUyMCUzRCUyMFN5c3RlbU1lc3NhZ2UoY29udGVudCUzRGYlMjJWb3VzJTIwJUMzJUFBdGVzJTIwdW4lMjBtYWpvcmRvbWUlMjBzZXJ2aWFibGUlMjBub21tJUMzJUE5JTIwQWxmcmVkJTIwcXVpJTIwc2VydCUyME0uJTIwV2F5bmUlMjBldCUyMEJhdG1hbi4lMjBWb3VzJTIwcG91dmV6JTIwYW5hbHlzZXIlMjBkZXMlMjBkb2N1bWVudHMlMjBldCUyMGVmZmVjdHVlciUyMGRlcyUyMGNhbGN1bHMlMjBhdmVjJTIwbGVzJTIwb3V0aWxzJTIwZm91cm5pcyUyMCUzQSU1Q24lN0J0ZXh0dWFsX2Rlc2NyaXB0aW9uX29mX3Rvb2wlN0QlMjAlNUNuJTIwVm91cyUyMGF2ZXolMjBhY2MlQzMlQThzJTIwJUMzJUEwJTIwcXVlbHF1ZXMlMjBpbWFnZXMlMjBvcHRpb25uZWxsZXMuJTIwQWN0dWVsbGVtZW50JTIwbCdpbWFnZSUyMGNoYXJnJUMzJUE5ZSUyMGVzdCUyMCUzQSUyMCU3QmltYWdlJTdEJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCbGxtX3dpdGhfdG9vbHMuaW52b2tlKCU1QnN5c19tc2clNUQlMjAlMkIlMjBzdGF0ZSU1QiUyMm1lc3NhZ2VzJTIyJTVEKSU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjBzdGF0ZSU1QiUyMmlucHV0X2ZpbGUlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0Q=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">assistant</span>(<span class="hljs-params">state: AgentState</span>):
    <span class="hljs-comment"># Message système</span>
    textual_description_of_tool=<span class="hljs-string">&quot;&quot;&quot;
extract_text(img_path: str) -&gt; str:
    Extraire le texte d&#x27;un fichier image en utilisant un modèle multimodal.

    Args:
        img_path: Un chemin de fichier image local (chaînes).

    Returns:
        Une chaîne unique contenant le texte concaténé extrait de chaque image.
divide(a: int, b: int) -&gt; float:
    Diviser a et b
&quot;&quot;&quot;</span>
    image=state[<span class="hljs-string">&quot;input_file&quot;</span>]
    sys_msg = SystemMessage(content=<span class="hljs-string">f&quot;Vous êtes un majordome serviable nommé Alfred qui sert M. Wayne et Batman. Vous pouvez analyser des documents et effectuer des calculs avec les outils fournis :\\n<span class="hljs-subst">{textual_description_of_tool}</span> \\n Vous avez accès à quelques images optionnelles. Actuellement l&#x27;image chargée est : <span class="hljs-subst">{image}</span>&quot;</span>)

    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;messages&quot;</span>: [llm_with_tools.invoke([sys_msg] + state[<span class="hljs-string">&quot;messages&quot;</span>])],
        <span class="hljs-string">&quot;input_file&quot;</span>: state[<span class="hljs-string">&quot;input_file&quot;</span>]
    }`,wrap:!1}}),S=new m({props:{title:"Le modèle ReAct : Comment j’aide M. Wayne",local:"le-modèle-react--comment-jaide-m-wayne",headingTag:"h2"}}),H=new U({props:{code:"JTIzJTIwTGUlMjBncmFwaGUlMEFidWlsZGVyJTIwJTNEJTIwU3RhdGVHcmFwaChBZ2VudFN0YXRlKSUwQSUwQSUyMyUyMEQlQzMlQTlmaW5pciUyMGxlcyUyMG4lQzUlOTN1ZHMlMjAlM0ElMjBjZXV4LWNpJTIwZm9udCUyMGxlJTIwdHJhdmFpbCUwQWJ1aWxkZXIuYWRkX25vZGUoJTIyYXNzaXN0YW50JTIyJTJDJTIwYXNzaXN0YW50KSUwQWJ1aWxkZXIuYWRkX25vZGUoJTIydG9vbHMlMjIlMkMlMjBUb29sTm9kZSh0b29scykpJTBBJTBBJTIzJTIwRCVDMyVBOWZpbmlyJTIwbGVzJTIwYXIlQzMlQUF0ZXMlMjAlM0ElMjBjZWxsZXMtY2klMjBkJUMzJUE5dGVybWluZW50JTIwY29tbWVudCUyMGxlJTIwZmx1eCUyMGRlJTIwY29udHIlQzMlQjRsZSUyMHNlJTIwZCVDMyVBOXBsYWNlJTBBYnVpbGRlci5hZGRfZWRnZShTVEFSVCUyQyUyMCUyMmFzc2lzdGFudCUyMiklMEFidWlsZGVyLmFkZF9jb25kaXRpb25hbF9lZGdlcyglMEElMjAlMjAlMjAlMjAlMjJhc3Npc3RhbnQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjMlMjBTaSUyMGxlJTIwZGVybmllciUyMG1lc3NhZ2UlMjBuJUMzJUE5Y2Vzc2l0ZSUyMHVuJTIwb3V0aWwlMkMlMjByb3V0ZXIlMjB2ZXJzJTIwbGVzJTIwb3V0aWxzJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2lub24lMkMlMjBmb3VybmlyJTIwdW5lJTIwciVDMyVBOXBvbnNlJTIwZGlyZWN0ZSUwQSUyMCUyMCUyMCUyMHRvb2xzX2NvbmRpdGlvbiUyQyUwQSklMEFidWlsZGVyLmFkZF9lZGdlKCUyMnRvb2xzJTIyJTJDJTIwJTIyYXNzaXN0YW50JTIyKSUwQXJlYWN0X2dyYXBoJTIwJTNEJTIwYnVpbGRlci5jb21waWxlKCklMEElMEElMjMlMjBNb250cmVyJTIwbGUlMjBwcm9jZXNzdXMlMjBkZSUyMHIlQzMlQTlmbGV4aW9uJTIwZHUlMjBtYWpvcmRvbWUlMEFkaXNwbGF5KEltYWdlKHJlYWN0X2dyYXBoLmdldF9ncmFwaCh4cmF5JTNEVHJ1ZSkuZHJhd19tZXJtYWlkX3BuZygpKSk=",highlighted:`<span class="hljs-comment"># Le graphe</span>
builder = StateGraph(AgentState)

<span class="hljs-comment"># Définir les nœuds : ceux-ci font le travail</span>
builder.add_node(<span class="hljs-string">&quot;assistant&quot;</span>, assistant)
builder.add_node(<span class="hljs-string">&quot;tools&quot;</span>, ToolNode(tools))

<span class="hljs-comment"># Définir les arêtes : celles-ci déterminent comment le flux de contrôle se déplace</span>
builder.add_edge(START, <span class="hljs-string">&quot;assistant&quot;</span>)
builder.add_conditional_edges(
    <span class="hljs-string">&quot;assistant&quot;</span>,
    <span class="hljs-comment"># Si le dernier message nécessite un outil, router vers les outils</span>
    <span class="hljs-comment"># Sinon, fournir une réponse directe</span>
    tools_condition,
)
builder.add_edge(<span class="hljs-string">&quot;tools&quot;</span>, <span class="hljs-string">&quot;assistant&quot;</span>)
react_graph = builder.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Montrer le processus de réflexion du majordome</span>
display(Image(react_graph.get_graph(xray=<span class="hljs-literal">True</span>).draw_mermaid_png()))`,wrap:!1}}),ll=new m({props:{title:"Le majordome en action",local:"le-majordome-en-action",headingTag:"h2"}}),el=new m({props:{title:"Exemple 1 : Calculs simples",local:"exemple-1--calculs-simples",headingTag:"h3"}}),tl=new U({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMkRpdmlzZXolMjA2NzkwJTIwcGFyJTIwNSUyMiklNUQlMEFtZXNzYWdlcyUyMCUzRCUyMHJlYWN0X2dyYXBoLmludm9rZSglN0IlMjJtZXNzYWdlcyUyMiUzQSUyMG1lc3NhZ2VzJTJDJTIwJTIyaW5wdXRfZmlsZSUyMiUzQSUyME5vbmUlN0QpJTBBJTBBJTIzJTIwTW9udHJlciUyMGxlcyUyMG1lc3NhZ2VzJTBBZm9yJTIwbSUyMGluJTIwbWVzc2FnZXMlNUInbWVzc2FnZXMnJTVEJTNBJTBBJTIwJTIwJTIwJTIwbS5wcmV0dHlfcHJpbnQoKQ==",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Divisez 6790 par 5&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-literal">None</span>})

<span class="hljs-comment"># Montrer les messages</span>
<span class="hljs-keyword">for</span> m <span class="hljs-keyword">in</span> messages[<span class="hljs-string">&#x27;messages&#x27;</span>]:
    m.pretty_print()`,wrap:!1}}),al=new U({props:{code:"SHVtYWluJTIwJTNBJTIwRGl2aXNleiUyMDY3OTAlMjBwYXIlMjA1JTBBJTBBKkFJKiUyMCpUb29sKiUyMCpDYWxsKiUyMCUzQSUyMGRpdmlkZShhJTNENjc5MCUyQyUyMGIlM0Q1KSUwQSUwQSpUb29sKiUyMCpSZXNwb25zZSolMjAlM0ElMjAxMzU4LjAlMEElMEFBbGZyZWQlMjAlM0ElMjBMZSUyMHIlQzMlQTlzdWx0YXQlMjBkZSUyMGxhJTIwZGl2aXNpb24lMjBkZSUyMDY3OTAlMjBwYXIlMjA1JTIwZXN0JTIwMTM1OC4wLg==",highlighted:`Humain : Divisez 6790 par 5

<span class="hljs-number">*A</span>I* *Tool* <span class="hljs-number">*Ca</span>ll* : divide(<span class="hljs-attribute">a</span>=6790, <span class="hljs-attribute">b</span>=5)

*Tool* *Response* : 1358.0

Alfred : Le résultat de la division de 6790 par 5 est 1358.0.`,wrap:!1}}),Ml=new m({props:{title:"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne",local:"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne",headingTag:"h3"}}),pl=new U({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUJIdW1hbk1lc3NhZ2UoY29udGVudCUzRCUyMlNlbG9uJTIwbGElMjBub3RlJTIwZm91cm5pZSUyMHBhciUyME0uJTIwV2F5bmUlMjBkYW5zJTIwbGVzJTIwaW1hZ2VzJTIwZm91cm5pZXMuJTIwUXVlbGxlJTIwZXN0JTIwbGElMjBsaXN0ZSUyMGRlcyUyMGFydGljbGVzJTIwcXVlJTIwamUlMjBkb2lzJTIwYWNoZXRlciUyMHBvdXIlMjBsZSUyMG1lbnUlMjBkdSUyMGQlQzMlQUVuZXIlMjAlM0YlMjIpJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjByZWFjdF9ncmFwaC5pbnZva2UoJTdCJTIybWVzc2FnZXMlMjIlM0ElMjBtZXNzYWdlcyUyQyUyMCUyMmlucHV0X2ZpbGUlMjIlM0ElMjAlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiU3RCk=",highlighted:`messages = [HumanMessage(content=<span class="hljs-string">&quot;Selon la note fournie par M. Wayne dans les images fournies. Quelle est la liste des articles que je dois acheter pour le menu du dîner ?&quot;</span>)]
messages = react_graph.invoke({<span class="hljs-string">&quot;messages&quot;</span>: messages, <span class="hljs-string">&quot;input_file&quot;</span>: <span class="hljs-string">&quot;Batman_training_and_meals.png&quot;</span>})`,wrap:!1}}),yl=new U({props:{code:"SHVtYWluJTIwJTNBJTIwU2Vsb24lMjBsYSUyMG5vdGUlMjBmb3VybmllJTIwcGFyJTIwTS4lMjBXYXluZSUyMGRhbnMlMjBsZXMlMjBpbWFnZXMlMjBmb3Vybmllcy4lMjBRdWVsbGUlMjBlc3QlMjBsYSUyMGxpc3RlJTIwZGVzJTIwYXJ0aWNsZXMlMjBxdWUlMjBqZSUyMGRvaXMlMjBhY2hldGVyJTIwcG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyMCUzRiUwQSUwQSpBSSolMjAqVG9vbColMjAqQ2FsbColMjAlM0ElMjBleHRyYWN0X3RleHQoaW1nX3BhdGglM0QlMjJCYXRtYW5fdHJhaW5pbmdfYW5kX21lYWxzLnBuZyUyMiklMEElMEEqVG9vbColMjAqUmVzcG9uc2UqJTIwJTNBJTIwJTVCVGV4dGUlMjBleHRyYWl0JTIwYXZlYyUyMGxlJTIwcHJvZ3JhbW1lJTIwZCdlbnRyYSVDMyVBRW5lbWVudCUyMGV0JTIwbGVzJTIwZCVDMyVBOXRhaWxzJTIwZHUlMjBtZW51JTVEJTBBJTBBQWxmcmVkJTIwJTNBJTIwUG91ciUyMGxlJTIwbWVudSUyMGR1JTIwZCVDMyVBRW5lciUyQyUyMHZvdXMlMjBkZXZyaWV6JTIwYWNoZXRlciUyMGxlcyUyMGFydGljbGVzJTIwc3VpdmFudHMlMjAlM0ElMEElMEExLiUyMFN0ZWFrJTIwZGUlMjBzdXJsb25nZSUyMGxvY2FsJTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUwQTIuJTIwJUMzJTg5cGluYXJkcyUyMGJpb2xvZ2lxdWVzJTBBMy4lMjBQb2l2cm9ucyUyMCpwaXF1aWxsbyolMEE0LiUyMFBvbW1lcyUyMGRlJTIwdGVycmUlMjAocG91ciUyMHBvbW1lcyUyMGRlJTIwdGVycmUlMjBhdXglMjBoZXJiZXMlMjBkb3IlQzMlQTllcyUyMGF1JTIwZm91ciklMEE1LiUyMEh1aWxlJTIwZGUlMjBwb2lzc29uJTIwKDIlMjBncmFtbWVzKSUwQSUwQUFzc3VyZXotdm91cyUyMHF1ZSUyMGxlJTIwc3RlYWslMjBzb2l0JTIwbm91cnJpJTIwJUMzJUEwJTIwbCdoZXJiZSUyMGV0JTIwcXVlJTIwbGVzJTIwJUMzJUE5cGluYXJkcyUyMGV0JTIwcG9pdnJvbnMlMjBzb2llbnQlMjBiaW9sb2dpcXVlcyUyMHBvdXIlMjB1biUyMHJlcGFzJTIwZGUlMjBsYSUyMG1laWxsZXVyZSUyMHF1YWxpdCVDMyVBOS4=",highlighted:`Humain : Selon <span class="hljs-keyword">la</span> <span class="hljs-keyword">note</span> fournie par <span class="hljs-keyword">M</span>. Wayne dans les images fournies. Quelle <span class="hljs-keyword">est</span> <span class="hljs-keyword">la</span> liste <span class="hljs-keyword">des</span> articles <span class="hljs-keyword">que</span> je dois acheter pour le menu du <span class="hljs-keyword">d</span>îner ?

<span class="hljs-comment">*AI* *Tool* *Call* : extract_text(img_path=&quot;Batman_training_and_meals.png&quot;)</span>

<span class="hljs-comment">*Tool* *Response* : [Texte extrait avec le programme d&#x27;entraînement et les détails du menu]</span>

Alfred : Pour le menu du <span class="hljs-keyword">d</span>îner, vous devriez acheter les articles suivants :

1. Steak <span class="hljs-keyword">de</span> surlonge <span class="hljs-keyword">local</span> nourri à <span class="hljs-keyword">l</span>&#x27;herbe
2. Épinards biologiques
3. Poivrons *piquillo*
4. Pommes <span class="hljs-keyword">de</span> terre (pour pommes <span class="hljs-keyword">de</span> terre aux herbes dorées au four)
5. Huile <span class="hljs-keyword">de</span> <span class="hljs-keyword">poisson</span> (2 grammes)

Assurez-vous <span class="hljs-keyword">que</span> le steak soit nourri à <span class="hljs-keyword">l</span>&#x27;herbe et <span class="hljs-keyword">que</span> les épinards et poivrons soient biologiques pour un repas <span class="hljs-keyword">de</span> <span class="hljs-keyword">la</span> meilleure qualité.`,wrap:!1}}),Jl=new m({props:{title:"Points clés à retenir",local:"points-clés-à-retenir",headingTag:"h2"}}),wl=new Oe({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/fr/unit2/langgraph/document_analysis_agent.mdx"}}),{c(){w=M("meta"),d=n(),I=M("p"),c=n(),o(u.$$.fragment),C=n(),h=M("p"),h.textContent=ue,Ul=n(),B=M("p"),B.innerHTML=we,cl=n(),A=M("p"),A.textContent=de,Il=n(),g=M("ol"),g.innerHTML=me,Cl=n(),o(G.$$.fragment),bl=n(),Z=M("p"),Z.innerHTML=Ue,hl=n(),f=M("p"),f.innerHTML=ce,Bl=n(),o(b.$$.fragment),Al=n(),o(W.$$.fragment),gl=n(),o(V.$$.fragment),Gl=n(),x=M("p"),x.textContent=Ie,Zl=n(),o(v.$$.fragment),fl=n(),o(X.$$.fragment),Wl=n(),$=M("p"),$.innerHTML=Ce,Vl=n(),E=M("p"),E.textContent=be,xl=n(),o(z.$$.fragment),vl=n(),o(k.$$.fragment),Xl=n(),o(N.$$.fragment),$l=n(),o(Y.$$.fragment),El=n(),o(Q.$$.fragment),zl=n(),o(S.$$.fragment),kl=n(),R=M("p"),R.innerHTML=he,Nl=n(),_=M("ol"),_.innerHTML=Be,Yl=n(),q=M("p"),q.textContent=Ae,Ql=n(),o(H.$$.fragment),Sl=n(),F=M("p"),F.innerHTML=ge,Rl=n(),L=M("p"),L.innerHTML=Ge,_l=n(),D=M("p"),D.textContent=Ze,ql=n(),P=M("p"),P.innerHTML=fe,Hl=n(),K=M("ul"),K.innerHTML=We,Fl=n(),O=M("p"),O.innerHTML=Ve,Ll=n(),o(ll.$$.fragment),Dl=n(),o(el.$$.fragment),Pl=n(),sl=M("p"),sl.textContent=xe,Kl=n(),o(tl.$$.fragment),Ol=n(),nl=M("p"),nl.textContent=ve,le=n(),o(al.$$.fragment),ee=n(),o(Ml.$$.fragment),se=n(),il=M("p"),il.textContent=Xe,te=n(),o(pl.$$.fragment),ne=n(),ol=M("p"),ol.textContent=$e,ae=n(),o(yl.$$.fragment),Me=n(),o(Jl.$$.fragment),ie=n(),jl=M("p"),jl.textContent=Ee,pe=n(),Tl=M("ol"),Tl.innerHTML=ze,oe=n(),rl=M("p"),rl.textContent=ke,ye=n(),ul=M("p"),ul.innerHTML=Ne,Je=n(),o(wl.$$.fragment),je=n(),dl=M("p"),this.h()},l(l){const e=De("svelte-u9bgzb",document.head);w=i(e,"META",{name:!0,content:!0}),e.forEach(s),d=a(l),I=i(l,"P",{}),Qe(I).forEach(s),c=a(l),y(u.$$.fragment,l),C=a(l),h=i(l,"P",{"data-svelte-h":!0}),p(h)!=="svelte-gt557y"&&(h.textContent=ue),Ul=a(l),B=i(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-4j0gl0"&&(B.innerHTML=we),cl=a(l),A=i(l,"P",{"data-svelte-h":!0}),p(A)!=="svelte-10fnikl"&&(A.textContent=de),Il=a(l),g=i(l,"OL",{"data-svelte-h":!0}),p(g)!=="svelte-1be5zfo"&&(g.innerHTML=me),Cl=a(l),y(G.$$.fragment,l),bl=a(l),Z=i(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-3lt4u7"&&(Z.innerHTML=Ue),hl=a(l),f=i(l,"P",{"data-svelte-h":!0}),p(f)!=="svelte-g7cpwr"&&(f.innerHTML=ce),Bl=a(l),y(b.$$.fragment,l),Al=a(l),y(W.$$.fragment,l),gl=a(l),y(V.$$.fragment,l),Gl=a(l),x=i(l,"P",{"data-svelte-h":!0}),p(x)!=="svelte-x7jdgr"&&(x.textContent=Ie),Zl=a(l),y(v.$$.fragment,l),fl=a(l),y(X.$$.fragment,l),Wl=a(l),$=i(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-7kjax9"&&($.innerHTML=Ce),Vl=a(l),E=i(l,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1eaw1cp"&&(E.textContent=be),xl=a(l),y(z.$$.fragment,l),vl=a(l),y(k.$$.fragment,l),Xl=a(l),y(N.$$.fragment,l),$l=a(l),y(Y.$$.fragment,l),El=a(l),y(Q.$$.fragment,l),zl=a(l),y(S.$$.fragment,l),kl=a(l),R=i(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-jejazg"&&(R.innerHTML=he),Nl=a(l),_=i(l,"OL",{"data-svelte-h":!0}),p(_)!=="svelte-18db8tg"&&(_.innerHTML=Be),Yl=a(l),q=i(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1h6mv9k"&&(q.textContent=Ae),Ql=a(l),y(H.$$.fragment,l),Sl=a(l),F=i(l,"P",{"data-svelte-h":!0}),p(F)!=="svelte-kp6yb5"&&(F.innerHTML=ge),Rl=a(l),L=i(l,"P",{"data-svelte-h":!0}),p(L)!=="svelte-g1y7jt"&&(L.innerHTML=Ge),_l=a(l),D=i(l,"P",{"data-svelte-h":!0}),p(D)!=="svelte-llapac"&&(D.textContent=Ze),ql=a(l),P=i(l,"P",{"data-svelte-h":!0}),p(P)!=="svelte-rl19lj"&&(P.innerHTML=fe),Hl=a(l),K=i(l,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-ronwmj"&&(K.innerHTML=We),Fl=a(l),O=i(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1nhlurw"&&(O.innerHTML=Ve),Ll=a(l),y(ll.$$.fragment,l),Dl=a(l),y(el.$$.fragment,l),Pl=a(l),sl=i(l,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-1521eea"&&(sl.textContent=xe),Kl=a(l),y(tl.$$.fragment,l),Ol=a(l),nl=i(l,"P",{"data-svelte-h":!0}),p(nl)!=="svelte-528ko8"&&(nl.textContent=ve),le=a(l),y(al.$$.fragment,l),ee=a(l),y(Ml.$$.fragment,l),se=a(l),il=i(l,"P",{"data-svelte-h":!0}),p(il)!=="svelte-1xfwie6"&&(il.textContent=Xe),te=a(l),y(pl.$$.fragment,l),ne=a(l),ol=i(l,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-1wf0zlb"&&(ol.textContent=$e),ae=a(l),y(yl.$$.fragment,l),Me=a(l),y(Jl.$$.fragment,l),ie=a(l),jl=i(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-1fpv4nj"&&(jl.textContent=Ee),pe=a(l),Tl=i(l,"OL",{"data-svelte-h":!0}),p(Tl)!=="svelte-frrqyp"&&(Tl.innerHTML=ze),oe=a(l),rl=i(l,"P",{"data-svelte-h":!0}),p(rl)!=="svelte-1fv1xk8"&&(rl.textContent=ke),ye=a(l),ul=i(l,"P",{"data-svelte-h":!0}),p(ul)!=="svelte-1fvnwmy"&&(ul.innerHTML=Ne),Je=a(l),y(wl.$$.fragment,l),je=a(l),dl=i(l,"P",{}),Qe(dl).forEach(s),this.h()},h(){re(w,"name","hf:doc:metadata"),re(w,"content",ss)},m(l,e){Pe(document.head,w),t(l,d,e),t(l,I,e),t(l,c,e),J(u,l,e),t(l,C,e),t(l,h,e),t(l,Ul,e),t(l,B,e),t(l,cl,e),t(l,A,e),t(l,Il,e),t(l,g,e),t(l,Cl,e),J(G,l,e),t(l,bl,e),t(l,Z,e),t(l,hl,e),t(l,f,e),t(l,Bl,e),J(b,l,e),t(l,Al,e),J(W,l,e),t(l,gl,e),J(V,l,e),t(l,Gl,e),t(l,x,e),t(l,Zl,e),J(v,l,e),t(l,fl,e),J(X,l,e),t(l,Wl,e),t(l,$,e),t(l,Vl,e),t(l,E,e),t(l,xl,e),J(z,l,e),t(l,vl,e),J(k,l,e),t(l,Xl,e),J(N,l,e),t(l,$l,e),J(Y,l,e),t(l,El,e),J(Q,l,e),t(l,zl,e),J(S,l,e),t(l,kl,e),t(l,R,e),t(l,Nl,e),t(l,_,e),t(l,Yl,e),t(l,q,e),t(l,Ql,e),J(H,l,e),t(l,Sl,e),t(l,F,e),t(l,Rl,e),t(l,L,e),t(l,_l,e),t(l,D,e),t(l,ql,e),t(l,P,e),t(l,Hl,e),t(l,K,e),t(l,Fl,e),t(l,O,e),t(l,Ll,e),J(ll,l,e),t(l,Dl,e),J(el,l,e),t(l,Pl,e),t(l,sl,e),t(l,Kl,e),J(tl,l,e),t(l,Ol,e),t(l,nl,e),t(l,le,e),J(al,l,e),t(l,ee,e),J(Ml,l,e),t(l,se,e),t(l,il,e),t(l,te,e),J(pl,l,e),t(l,ne,e),t(l,ol,e),t(l,ae,e),J(yl,l,e),t(l,Me,e),J(Jl,l,e),t(l,ie,e),t(l,jl,e),t(l,pe,e),t(l,Tl,e),t(l,oe,e),t(l,rl,e),t(l,ye,e),t(l,ul,e),t(l,Je,e),J(wl,l,e),t(l,je,e),t(l,dl,e),Te=!0},p(l,[e]){const Ye={};e&2&&(Ye.$$scope={dirty:e,ctx:l}),b.$set(Ye)},i(l){Te||(j(u.$$.fragment,l),j(G.$$.fragment,l),j(b.$$.fragment,l),j(W.$$.fragment,l),j(V.$$.fragment,l),j(v.$$.fragment,l),j(X.$$.fragment,l),j(z.$$.fragment,l),j(k.$$.fragment,l),j(N.$$.fragment,l),j(Y.$$.fragment,l),j(Q.$$.fragment,l),j(S.$$.fragment,l),j(H.$$.fragment,l),j(ll.$$.fragment,l),j(el.$$.fragment,l),j(tl.$$.fragment,l),j(al.$$.fragment,l),j(Ml.$$.fragment,l),j(pl.$$.fragment,l),j(yl.$$.fragment,l),j(Jl.$$.fragment,l),j(wl.$$.fragment,l),Te=!0)},o(l){T(u.$$.fragment,l),T(G.$$.fragment,l),T(b.$$.fragment,l),T(W.$$.fragment,l),T(V.$$.fragment,l),T(v.$$.fragment,l),T(X.$$.fragment,l),T(z.$$.fragment,l),T(k.$$.fragment,l),T(N.$$.fragment,l),T(Y.$$.fragment,l),T(Q.$$.fragment,l),T(S.$$.fragment,l),T(H.$$.fragment,l),T(ll.$$.fragment,l),T(el.$$.fragment,l),T(tl.$$.fragment,l),T(al.$$.fragment,l),T(Ml.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(Jl.$$.fragment,l),T(wl.$$.fragment,l),Te=!1},d(l){l&&(s(d),s(I),s(c),s(C),s(h),s(Ul),s(B),s(cl),s(A),s(Il),s(g),s(Cl),s(bl),s(Z),s(hl),s(f),s(Bl),s(Al),s(gl),s(Gl),s(x),s(Zl),s(fl),s(Wl),s($),s(Vl),s(E),s(xl),s(vl),s(Xl),s($l),s(El),s(zl),s(kl),s(R),s(Nl),s(_),s(Yl),s(q),s(Ql),s(Sl),s(F),s(Rl),s(L),s(_l),s(D),s(ql),s(P),s(Hl),s(K),s(Fl),s(O),s(Ll),s(Dl),s(Pl),s(sl),s(Kl),s(Ol),s(nl),s(le),s(ee),s(se),s(il),s(te),s(ne),s(ol),s(ae),s(Me),s(ie),s(jl),s(pe),s(Tl),s(oe),s(rl),s(ye),s(ul),s(Je),s(je),s(dl)),s(w),r(u,l),r(G,l),r(b,l),r(W,l),r(V,l),r(v,l),r(X,l),r(z,l),r(k,l),r(N,l),r(Y,l),r(Q,l),r(S,l),r(H,l),r(ll,l),r(el,l),r(tl,l),r(al,l),r(Ml,l),r(pl,l),r(yl,l),r(Jl,l),r(wl,l)}}}const ss='{"title":"Graphe d’analyse de documents","local":"graphe-danalyse-de-documents","sections":[{"title":"Le workflow du majordome","local":"le-workflow-du-majordome","sections":[],"depth":2},{"title":"Configuration de l’environnement","local":"configuration-de-lenvironnement","sections":[],"depth":2},{"title":"Définir l’état de l’agent","local":"définir-létat-de-lagent","sections":[],"depth":2},{"title":"Préparer les outils","local":"préparer-les-outils","sections":[],"depth":2},{"title":"Les nœuds","local":"les-nœuds","sections":[],"depth":2},{"title":"Le modèle ReAct : Comment j’aide M. Wayne","local":"le-modèle-react--comment-jaide-m-wayne","sections":[],"depth":2},{"title":"Le majordome en action","local":"le-majordome-en-action","sections":[{"title":"Exemple 1 : Calculs simples","local":"exemple-1--calculs-simples","sections":[],"depth":3},{"title":"Exemple 2 : Analyser les documents d’entraînement de Maître Wayne","local":"exemple-2--analyser-les-documents-dentraînement-de-maître-wayne","sections":[],"depth":3}],"depth":2},{"title":"Points clés à retenir","local":"points-clés-à-retenir","sections":[],"depth":2}],"depth":1}';function ts(ml){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends Fe{constructor(w){super(),Le(this,w,ts,es,_e,{})}}export{ys as component};
