import{s as ks,n as Gs,o as Rs}from"../chunks/scheduler.7da89386.js";import{S as zs,i as $s,g as i,s as t,r as u,A as vs,h,f as l,c as p,j as Zs,u as M,x as y,k as Ns,y as Ws,a as n,v as e,d as c,t as o,w as j}from"../chunks/index.20910acc.js";import{C as V}from"../chunks/CodeBlock.143bd81e.js";import{H as T,E as Xs}from"../chunks/getInferenceSnippets.cb95a28d.js";function Ss(ds){let J,Y,S,x,U,H,r,D,w,ms=`Lighteval will automatically save results and evaluation details in the
directory set with the <code>--output-dir</code> option. The results will be saved in
<code>{output_dir}/results/{model_name}/results_{timestamp}.json</code>. <a href="#example-of-a-result-file">Here is an
example of a result file</a>. The output path can be
any <a href="https://filesystem-spec.readthedocs.io/en/latest/index.html" rel="nofollow">fsspec</a>
compliant path (local, s3, hf hub, gdrive, ftp, etc).`,L,I,Cs=`To save the details of the evaluation, you can use the <code>--save-details</code>
option. The details will be saved in a parquet file
<code>{output_dir}/details/{model_name}/{timestamp}/details_{task}_{timestamp}.parquet</code>.`,P,d,As=`If you want results to be saved in a custom path, you can set the <code>results-path-template</code> option.
This allows you to set a string template for the path. The template need to contain the following
variables: <code>output_dir</code>, <code>model_name</code>, <code>org</code>. For example
<code>{output_dir}/{org}_{model}</code>. The template will be used to create the path for the results file.`,O,m,K,C,qs=`You can push the results and evaluation details to the HuggingFace hub. To do
so, you need to set the <code>--push-to-hub</code> as well as the <code>--results-org</code>
option. The results will be saved in a dataset with the name at
<code>{results_org}/{model_org}/{model_name}</code>. To push the details, you need to set
the <code>--save-details</code> option.
The dataset created will be private by default, you can make it public by
setting the <code>--public-run</code> option.`,ss,A,as,q,bs=`You can push the results to Tensorboard by setting <code>--push-to-tensorboard</code>.
This will create a Tensorboard dashboard in a HF org set with the <code>--results-org</code>
option.`,ls,b,ns,f,fs=`You can push the results to WandB by setting <code>--wandb</code>. This will init a WandB
run and log the results.`,ts,g,gs="Wandb args need to be set in your env variables.",ps,_,us,B,_s='You can find a list of variable in the <a href="https://docs.wandb.ai/guides/track/environment-variables/" rel="nofollow">wandb documentation</a>.',Ms,Q,Bs=`If trackio is available in your environment <code>pip install lighteval[trackio]</code>, it will be used to log and push the results on a
huggingface dataset. Choose the dataset name and org with:`,es,E,cs,Z,os,N,js,k,is,G,hs,R,ys,z,Qs="The detail file contains the following columns:",Js,$,Es="<li><strong>doc</strong>: The doc used for the evaluation, this will contain the gold reference, the fewshots and other hyperparamters used for the task.</li> <li><strong>model_response</strong>: where you will find model generations, logprobs and the input that was sent to the model</li> <li><strong>metric</strong>: the value of the metrics for this sample</li>",Ts,v,Us,W,rs,X,ws,F,Is;return U=new T({props:{title:"Saving and reading results",local:"saving-and-reading-results",headingTag:"h1"}}),r=new T({props:{title:"Saving results locally",local:"saving-results-locally",headingTag:"h2"}}),m=new T({props:{title:"Pushing results to the HuggingFace hub",local:"pushing-results-to-the-huggingface-hub",headingTag:"h2"}}),A=new T({props:{title:"Pushing results to Tensorboard",local:"pushing-results-to-tensorboard",headingTag:"h2"}}),b=new T({props:{title:"Pushing results to Trackio or WandB",local:"pushing-results-to-trackio-or-wandb",headingTag:"h2"}}),_=new V({props:{code:"ZXhwb3J0JTIwV0FOREJfUFJPSkVDVCUzRCUyMmxpZ2h0ZXZhbCUyMg==",highlighted:'<span class="hljs-built_in">export</span> <span class="hljs-attribute">WANDB_PROJECT</span>=<span class="hljs-string">&quot;lighteval&quot;</span>',wrap:!1}}),E=new V({props:{code:"ZXhwb3J0JTIwV0FOREJfU1BBQ0VfSUQlM0QlMjJvcmclMkZuYW1lJTIy",highlighted:'<span class="hljs-built_in">export</span> <span class="hljs-attribute">WANDB_SPACE_ID</span>=<span class="hljs-string">&quot;org/name&quot;</span>',wrap:!1}}),Z=new T({props:{title:"How to load and investigate details",local:"how-to-load-and-investigate-details",headingTag:"h2"}}),N=new T({props:{title:"Load from local detail files",local:"load-from-local-detail-files",headingTag:"h3"}}),k=new V({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwb3MlMEElMEFvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZXZhbHNfZG9jJTIyJTBBbW9kZWxfbmFtZSUyMCUzRCUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiUwQXRpbWVzdGFtcCUyMCUzRCUyMCUyMmxhdGVzdCUyMiUwQXRhc2slMjAlM0QlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlMEElMEFpZiUyMHRpbWVzdGFtcCUyMCUzRCUzRCUyMCUyMmxhdGVzdCUyMiUzQSUwQSUyMCUyMCUyMCUyMHBhdGglMjAlM0QlMjBmJTIyJTdCb3V0cHV0X2RpciU3RCUyRmRldGFpbHMlMkYlN0Jtb2RlbF9vcmclN0QlMkYlN0Jtb2RlbF9uYW1lJTdEJTJGKiUyRiUyMiUwQSUyMCUyMCUyMCUyMHRpbWVzdGFtcHMlMjAlM0QlMjBnbG9iLmdsb2IocGF0aCklMEElMjAlMjAlMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjBzb3J0ZWQodGltZXN0YW1wcyklNUItMSU1RC5zcGxpdCglMjIlMkYlMjIpJTVCLTIlNUQlMEElMjAlMjAlMjAlMjBwcmludChmJTIyTGF0ZXN0JTIwdGltZXN0YW1wJTNBJTIwJTdCdGltZXN0YW1wJTdEJTIyKSUwQSUwQWRldGFpbHNfcGF0aCUyMCUzRCUyMGYlMjIlN0JvdXRwdXRfZGlyJTdEJTJGZGV0YWlscyUyRiU3Qm1vZGVsX25hbWUlN0QlMkYlN0J0aW1lc3RhbXAlN0QlMkZkZXRhaWxzXyU3QnRhc2slN0RfJTdCdGltZXN0YW1wJTdELnBhcnF1ZXQlMjIlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwZGV0YWlscyUwQWRldGFpbHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIycGFycXVldCUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkZXRhaWxzX3BhdGglMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> os

output_dir = <span class="hljs-string">&quot;evals_doc&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
timestamp = <span class="hljs-string">&quot;latest&quot;</span>
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>

<span class="hljs-keyword">if</span> timestamp == <span class="hljs-string">&quot;latest&quot;</span>:
    path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_org}</span>/<span class="hljs-subst">{model_name}</span>/*/&quot;</span>
    timestamps = glob.glob(path)
    timestamp = <span class="hljs-built_in">sorted</span>(timestamps)[-<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">2</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Latest timestamp: <span class="hljs-subst">{timestamp}</span>&quot;</span>)

details_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{output_dir}</span>/details/<span class="hljs-subst">{model_name}</span>/<span class="hljs-subst">{timestamp}</span>/details_<span class="hljs-subst">{task}</span>_<span class="hljs-subst">{timestamp}</span>.parquet&quot;</span>

<span class="hljs-comment"># Load the details</span>
details = load_dataset(<span class="hljs-string">&quot;parquet&quot;</span>, data_files=details_path, split=<span class="hljs-string">&quot;train&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),G=new T({props:{title:"Load from the HuggingFace hub",local:"load-from-the-huggingface-hub",headingTag:"h3"}}),R=new V({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcmVzdWx0c19vcmclMjAlM0QlMjAlMjJTYXlsb3JUd2lmdCUyMiUwQW1vZGVsX25hbWUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEFzYW5pdGl6ZWRfbW9kZWxfbmFtZSUyMCUzRCUyMG1vZGVsX25hbWUucmVwbGFjZSglMjIlMkYlMjIlMkMlMjAlMjJfXyUyMiklMEF0YXNrJTIwJTNEJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslN0MwJTIyJTBBcHVibGljX3J1biUyMCUzRCUyMEZhbHNlJTBBJTBBZGF0YXNldF9wYXRoJTIwJTNEJTIwZiUyMiU3QnJlc3VsdHNfb3JnJTdEJTJGZGV0YWlsc18lN0JzYW5pdGl6ZWRfbW9kZWxfbmFtZSU3RCU3QidfcHJpdmF0ZSclMjBpZiUyMG5vdCUyMHB1YmxpY19ydW4lMjBlbHNlJTIwJyclN0QlMjIlMEFkZXRhaWxzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfcGF0aCUyQyUyMHRhc2sucmVwbGFjZSglMjIlN0MlMjIlMkMlMjAlMjJfJTIyKSUyQyUyMHNwbGl0JTNEJTIybGF0ZXN0JTIyKSUwQSUwQWZvciUyMGRldGFpbCUyMGluJTIwZGV0YWlscyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGRldGFpbCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

results_org = <span class="hljs-string">&quot;SaylorTwift&quot;</span>
model_name = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
sanitized_model_name = model_name.replace(<span class="hljs-string">&quot;/&quot;</span>, <span class="hljs-string">&quot;__&quot;</span>)
task = <span class="hljs-string">&quot;lighteval|gsm8k|0&quot;</span>
public_run = <span class="hljs-literal">False</span>

dataset_path = <span class="hljs-string">f&quot;<span class="hljs-subst">{results_org}</span>/details_<span class="hljs-subst">{sanitized_model_name}</span><span class="hljs-subst">{<span class="hljs-string">&#x27;_private&#x27;</span> <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> public_run <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;&#x27;</span>}</span>&quot;</span>
details = load_dataset(dataset_path, task.replace(<span class="hljs-string">&quot;|&quot;</span>, <span class="hljs-string">&quot;_&quot;</span>), split=<span class="hljs-string">&quot;latest&quot;</span>)

<span class="hljs-keyword">for</span> detail <span class="hljs-keyword">in</span> details:
    <span class="hljs-built_in">print</span>(detail)`,wrap:!1}}),v=new T({props:{title:"Example of a result file",local:"example-of-a-result-file",headingTag:"h2"}}),W=new V({props:{code:"JTdCJTBBJTIwJTIwJTIyY29uZmlnX2dlbmVyYWwlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWxfc2hhJTIyJTNBJTIwJTIyMjAzMDQ1YTg0MzFiYzliNzcyNDVjOTk5OGUwNWZjNTQ1MDllYTA3ZiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV9mZXdzaG90X3NlZWRzJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMm92ZXJyaWRlX2JhdGNoX3NpemUlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIybWF4X3NhbXBsZXMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIyam9iX2lkJTIyJTNBJTIwJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3RhcnRfdGltZSUyMiUzQSUyMDYyMDk3OS44NzkzMjAxNjYlMkMlMEElMjAlMjAlMjAlMjAlMjJlbmRfdGltZSUyMiUzQSUyMDYyMTAwNC42MzIxMDgwNDElMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9ldmFsdWF0aW9uX3RpbWVfc2Vjb25kZXMlMjIlM0ElMjAlMjIyNC43NTI3ODc4NzUwMTE1NjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbF9uYW1lJTIyJTNBJTIwJTIyZ3B0MiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX3NoYSUyMiUzQSUyMCUyMjYwN2EzMGQ3ODNkZmE2NjNjYWYzOWUwNjYzMzcyMWM4ZDRjZmNkN2UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbF9kdHlwZSUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjAlMjAlMjJtb2RlbF9zaXplJTIyJTNBJTIwJTIyNDc2LjIlMjBNQiUyMiUwQSUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMnJlc3VsdHMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJlbSUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmVtX3N0ZGVyciUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm1haiU0MDglMjIlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJtYWolNDA4X3N0ZGVyciUyMiUzQSUyMDAuMCUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsbCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmVtJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1fc3RkZXJyJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybWFqJTQwOCUyMiUzQSUyMDAuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm1haiU0MDhfc3RkZXJyJTIyJTNBJTIwMC4wJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIydmVyc2lvbnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJsaWdodGV2YWwlN0Nnc204ayU3QzAlMjIlM0ElMjAwJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyY29uZmlnX3Rhc2tzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIybGlnaHRldmFsJTdDZ3NtOGslMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIyZ3NtOGslMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwcm9tcHRfZnVuY3Rpb24lMjIlM0ElMjAlMjJnc204ayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmhmX3JlcG8lMjIlM0ElMjAlMjJnc204ayUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmhmX3N1YnNldCUyMiUzQSUyMCUyMm1haW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXRyaWMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtZXRyaWNfbmFtZSUyMiUzQSUyMCUyMmVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGlnaGVyX2lzX2JldHRlciUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYXRlZ29yeSUyMiUzQSUyMCUyMjMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ1c2VfY2FzZSUyMiUzQSUyMCUyMjUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzYW1wbGVfbGV2ZWxfZm4lMjIlM0ElMjAlMjJjb21wdXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29ycHVzX2xldmVsX2ZuJTIyJTNBJTIwJTIybWVhbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm1ldHJpY19uYW1lJTIyJTNBJTIwJTIybWFqJTQwOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpZ2hlcl9pc19iZXR0ZXIlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY2F0ZWdvcnklMjIlM0ElMjAlMjI1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydXNlX2Nhc2UlMjIlM0ElMjAlMjI1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxlX2xldmVsX2ZuJTIyJTNBJTIwJTIyY29tcHV0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvcnB1c19sZXZlbF9mbiUyMiUzQSUyMCUyMm1lYW4lMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoZl9hdmFpbF9zcGxpdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlc3QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJldmFsdWF0aW9uX3NwbGl0cyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlc3QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmZXdfc2hvdHNfc3BsaXQlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZmV3X3Nob3RzX3NlbGVjdCUyMiUzQSUyMCUyMnJhbmRvbV9zYW1wbGluZ19mcm9tX3RyYWluJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhdGlvbl9zaXplJTIyJTNBJTIwMjU2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhdGlvbl9ncmFtbWFyJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnN0b3Bfc2VxdWVuY2UlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJRdWVzdGlvbiUzRCUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm51bV9zYW1wbGVzJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnN1aXRlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybGlnaHRldmFsJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyb3JpZ2luYWxfbnVtX2RvY3MlMjIlM0ElMjAxMzE5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyZWZmZWN0aXZlX251bV9kb2NzJTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm11c3RfcmVtb3ZlX2R1cGxpY2F0ZV9kb2NzJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZlcnNpb24lMjIlM0ElMjAwJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyc3VtbWFyeV90YXNrcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmxpZ2h0ZXZhbCU3Q2dzbThrJTdDMCUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmhhc2hlcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhhc2hfZXhhbXBsZXMlMjIlM0ElMjAlMjI4NTE3ZDViZjdlODgwMDg2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9mdWxsX3Byb21wdHMlMjIlM0ElMjAlMjI4NTE3ZDViZjdlODgwMDg2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9pbnB1dF90b2tlbnMlMjIlM0ElMjAlMjIyOTkxNmU3YWZlNWNiNTFkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9jb250X3Rva2VucyUyMiUzQSUyMCUyMjM3ZjkxY2UyM2VmNmQ0MzUlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cnVuY2F0ZWQlMjIlM0ElMjAyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybm9uX3RydW5jYXRlZCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRkZWQlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybm9uX3BhZGRlZCUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJlZmZlY3RpdmVfZmV3X3Nob3RzJTIyJTNBJTIwMC4wJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIybnVtX3RydW5jYXRlZF9mZXdfc2hvdHMlMjIlM0ElMjAwJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyc3VtbWFyeV9nZW5lcmFsJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaGFzaGVzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyaGFzaF9leGFtcGxlcyUyMiUzQSUyMCUyMjVmMzgzYzM5NWYwMTA5NmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoYXNoX2Z1bGxfcHJvbXB0cyUyMiUzQSUyMCUyMjVmMzgzYzM5NWYwMTA5NmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoYXNoX2lucHV0X3Rva2VucyUyMiUzQSUyMCUyMmFjOTMzZmViMTRmOTZkN2IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJoYXNoX2NvbnRfdG9rZW5zJTIyJTNBJTIwJTIyOWQwM2ZiMjZmOGRhNzI3NyUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRydW5jYXRlZCUyMiUzQSUyMDIlMkMlMEElMjAlMjAlMjAlMjAlMjJub25fdHJ1bmNhdGVkJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhZGRlZCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJub25fcGFkZGVkJTIyJTNBJTIwMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV90cnVuY2F0ZWRfZmV3X3Nob3RzJTIyJTNBJTIwMCUwQSUyMCUyMCU3RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;config_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;203045a8431bc9b77245c9998e05fc54509ea07f&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_fewshot_seeds&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;override_batch_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;max_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;job_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;start_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">620979.879320166</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;end_time&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">621004.632108041</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;total_evaluation_time_secondes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;24.752787875011563&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gpt2&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_sha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;607a30d783dfa663caf39e06633721c8d4cfcd7e&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_dtype&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;model_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;476.2 MB&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;results&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;all&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;em&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;em_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;maj@8_stderr&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;versions&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;config_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;prompt_function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_repo&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;gsm8k&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_subset&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;main&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;metric&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;em&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;3&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;metric_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;maj@8&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;higher_is_better&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;category&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;use_case&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;sample_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;compute&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;corpus_level_fn&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mean&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hf_avail_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;train&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;evaluation_splits&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;test&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_split&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;few_shots_select&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;random_sampling_from_train&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_size&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">256</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;generation_grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;stop_sequence&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;Question=&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_samples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;suite&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-string">&quot;lighteval&quot;</span>
      <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;original_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1319</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_num_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;must_remove_duplicate_docs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_tasks&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;lighteval|gsm8k|0&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;8517d5bf7e880086&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;29916e7afe5cb51d&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;37f91ce23ef6d435&quot;</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;effective_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;num_truncated_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;summary_general&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;hashes&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;hash_examples&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_full_prompts&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;5f383c395f01096e&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_input_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;ac933feb14f96d7b&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;hash_cont_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;9d03fb26f8da7277&quot;</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_truncated&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;non_padded&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">2</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;num_truncated_few_shots&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),X=new Xs({props:{source:"https://github.com/huggingface/lighteval/blob/main/docs/source/saving-and-reading-results.mdx"}}),{c(){J=i("meta"),Y=t(),S=i("p"),x=t(),u(U.$$.fragment),H=t(),u(r.$$.fragment),D=t(),w=i("p"),w.innerHTML=ms,L=t(),I=i("p"),I.innerHTML=Cs,P=t(),d=i("p"),d.innerHTML=As,O=t(),u(m.$$.fragment),K=t(),C=i("p"),C.innerHTML=qs,ss=t(),u(A.$$.fragment),as=t(),q=i("p"),q.innerHTML=bs,ls=t(),u(b.$$.fragment),ns=t(),f=i("p"),f.innerHTML=fs,ts=t(),g=i("p"),g.textContent=gs,ps=t(),u(_.$$.fragment),us=t(),B=i("p"),B.innerHTML=_s,Ms=t(),Q=i("p"),Q.innerHTML=Bs,es=t(),u(E.$$.fragment),cs=t(),u(Z.$$.fragment),os=t(),u(N.$$.fragment),js=t(),u(k.$$.fragment),is=t(),u(G.$$.fragment),hs=t(),u(R.$$.fragment),ys=t(),z=i("p"),z.textContent=Qs,Js=t(),$=i("ul"),$.innerHTML=Es,Ts=t(),u(v.$$.fragment),Us=t(),u(W.$$.fragment),rs=t(),u(X.$$.fragment),ws=t(),F=i("p"),this.h()},l(s){const a=vs("svelte-u9bgzb",document.head);J=h(a,"META",{name:!0,content:!0}),a.forEach(l),Y=p(s),S=h(s,"P",{}),Zs(S).forEach(l),x=p(s),M(U.$$.fragment,s),H=p(s),M(r.$$.fragment,s),D=p(s),w=h(s,"P",{"data-svelte-h":!0}),y(w)!=="svelte-15vw0ij"&&(w.innerHTML=ms),L=p(s),I=h(s,"P",{"data-svelte-h":!0}),y(I)!=="svelte-8c212v"&&(I.innerHTML=Cs),P=p(s),d=h(s,"P",{"data-svelte-h":!0}),y(d)!=="svelte-1kiwdut"&&(d.innerHTML=As),O=p(s),M(m.$$.fragment,s),K=p(s),C=h(s,"P",{"data-svelte-h":!0}),y(C)!=="svelte-sznccd"&&(C.innerHTML=qs),ss=p(s),M(A.$$.fragment,s),as=p(s),q=h(s,"P",{"data-svelte-h":!0}),y(q)!=="svelte-1cbg3hm"&&(q.innerHTML=bs),ls=p(s),M(b.$$.fragment,s),ns=p(s),f=h(s,"P",{"data-svelte-h":!0}),y(f)!=="svelte-q3l9c9"&&(f.innerHTML=fs),ts=p(s),g=h(s,"P",{"data-svelte-h":!0}),y(g)!=="svelte-lvtunn"&&(g.textContent=gs),ps=p(s),M(_.$$.fragment,s),us=p(s),B=h(s,"P",{"data-svelte-h":!0}),y(B)!=="svelte-somvse"&&(B.innerHTML=_s),Ms=p(s),Q=h(s,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-189zyhi"&&(Q.innerHTML=Bs),es=p(s),M(E.$$.fragment,s),cs=p(s),M(Z.$$.fragment,s),os=p(s),M(N.$$.fragment,s),js=p(s),M(k.$$.fragment,s),is=p(s),M(G.$$.fragment,s),hs=p(s),M(R.$$.fragment,s),ys=p(s),z=h(s,"P",{"data-svelte-h":!0}),y(z)!=="svelte-1w33ibm"&&(z.textContent=Qs),Js=p(s),$=h(s,"UL",{"data-svelte-h":!0}),y($)!=="svelte-1sthcbx"&&($.innerHTML=Es),Ts=p(s),M(v.$$.fragment,s),Us=p(s),M(W.$$.fragment,s),rs=p(s),M(X.$$.fragment,s),ws=p(s),F=h(s,"P",{}),Zs(F).forEach(l),this.h()},h(){Ns(J,"name","hf:doc:metadata"),Ns(J,"content",Fs)},m(s,a){Ws(document.head,J),n(s,Y,a),n(s,S,a),n(s,x,a),e(U,s,a),n(s,H,a),e(r,s,a),n(s,D,a),n(s,w,a),n(s,L,a),n(s,I,a),n(s,P,a),n(s,d,a),n(s,O,a),e(m,s,a),n(s,K,a),n(s,C,a),n(s,ss,a),e(A,s,a),n(s,as,a),n(s,q,a),n(s,ls,a),e(b,s,a),n(s,ns,a),n(s,f,a),n(s,ts,a),n(s,g,a),n(s,ps,a),e(_,s,a),n(s,us,a),n(s,B,a),n(s,Ms,a),n(s,Q,a),n(s,es,a),e(E,s,a),n(s,cs,a),e(Z,s,a),n(s,os,a),e(N,s,a),n(s,js,a),e(k,s,a),n(s,is,a),e(G,s,a),n(s,hs,a),e(R,s,a),n(s,ys,a),n(s,z,a),n(s,Js,a),n(s,$,a),n(s,Ts,a),e(v,s,a),n(s,Us,a),e(W,s,a),n(s,rs,a),e(X,s,a),n(s,ws,a),n(s,F,a),Is=!0},p:Gs,i(s){Is||(c(U.$$.fragment,s),c(r.$$.fragment,s),c(m.$$.fragment,s),c(A.$$.fragment,s),c(b.$$.fragment,s),c(_.$$.fragment,s),c(E.$$.fragment,s),c(Z.$$.fragment,s),c(N.$$.fragment,s),c(k.$$.fragment,s),c(G.$$.fragment,s),c(R.$$.fragment,s),c(v.$$.fragment,s),c(W.$$.fragment,s),c(X.$$.fragment,s),Is=!0)},o(s){o(U.$$.fragment,s),o(r.$$.fragment,s),o(m.$$.fragment,s),o(A.$$.fragment,s),o(b.$$.fragment,s),o(_.$$.fragment,s),o(E.$$.fragment,s),o(Z.$$.fragment,s),o(N.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(R.$$.fragment,s),o(v.$$.fragment,s),o(W.$$.fragment,s),o(X.$$.fragment,s),Is=!1},d(s){s&&(l(Y),l(S),l(x),l(H),l(D),l(w),l(L),l(I),l(P),l(d),l(O),l(K),l(C),l(ss),l(as),l(q),l(ls),l(ns),l(f),l(ts),l(g),l(ps),l(us),l(B),l(Ms),l(Q),l(es),l(cs),l(os),l(js),l(is),l(hs),l(ys),l(z),l(Js),l($),l(Ts),l(Us),l(rs),l(ws),l(F)),l(J),j(U,s),j(r,s),j(m,s),j(A,s),j(b,s),j(_,s),j(E,s),j(Z,s),j(N,s),j(k,s),j(G,s),j(R,s),j(v,s),j(W,s),j(X,s)}}}const Fs='{"title":"Saving and reading results","local":"saving-and-reading-results","sections":[{"title":"Saving results locally","local":"saving-results-locally","sections":[],"depth":2},{"title":"Pushing results to the HuggingFace hub","local":"pushing-results-to-the-huggingface-hub","sections":[],"depth":2},{"title":"Pushing results to Tensorboard","local":"pushing-results-to-tensorboard","sections":[],"depth":2},{"title":"Pushing results to Trackio or WandB","local":"pushing-results-to-trackio-or-wandb","sections":[],"depth":2},{"title":"How to load and investigate details","local":"how-to-load-and-investigate-details","sections":[{"title":"Load from local detail files","local":"load-from-local-detail-files","sections":[],"depth":3},{"title":"Load from the HuggingFace hub","local":"load-from-the-huggingface-hub","sections":[],"depth":3}],"depth":2},{"title":"Example of a result file","local":"example-of-a-result-file","sections":[],"depth":2}],"depth":1}';function Vs(ds){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ls extends zs{constructor(J){super(),$s(this,J,Vs,Ss,ks,{})}}export{Ls as component};
