import{s as ml,n as ol,o as hl}from"../chunks/scheduler.7bc62968.js";import{S as Ml,i as cl,g as i,s as a,r as m,A as yl,h as p,f as s,c as n,j as rl,u as o,x as r,k as ws,y as ul,a as l,v as h,d as M,t as c,w as y}from"../chunks/index.2f8492b0.js";import{C as u}from"../chunks/CodeBlock.bb61a5a9.js";import{H as fs,E as fl}from"../chunks/getInferenceSnippets.7ce1588a.js";function wl(Ts){let f,Ae,We,Ee,T,Ye,U,Us="How can we match detected features from one image to another? Feature matching involves comparing key attributes in different images to find similarities. Feature matching is useful in many computer vision applications, including scene understanding, image stitching, object tracking, and pattern recognition.",Ve,J,Xe,d,Js="Imagine you have a giant box of puzzle pieces, and you’re trying to find a specific piece that fits into your puzzle. This is similar to searching for matching features in images. Instead of having any special strategy, you decide to check every piece, one by one until you find the right one. This straightforward method is a brute-force search. The advantage of brute force is its simplicity. You don’t need any special tricks – just patience. However, it can be time-consuming, especially if there are a lot of pieces to check. In the context of feature matching, this brute force approach is akin to comparing every pixel in one image to every pixel in another to see if they match. It’s exhaustive and it might take a lot of time, especially for large images.",De,b,ds="Now that we have an intuitive idea of how brute-force matches are found, let’s dive into the algorithms. We are going to use the descriptors that we learned about in the previous chapter to find the matching features in two images.",He,g,bs="First install and load libraries.",Ke,C,Pe,j,qe,$,gs="<strong>Brute Force with SIFT</strong>",Oe,k,Cs="Let’s start by initializing SIFT detector.",et,I,tt,v,js="Find the keypoints and descriptors with SIFT.",st,x,lt,R,$s="Find matches using k nearest neighbors.",at,N,nt,B,ks="Apply ratio test to threshold the best matches.",it,F,pt,G,Is="Draw the matches.",rt,S,mt,w,vs='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/SIFT.png" alt="SIFT"/>',ot,_,xs="<strong>Brute Force with ORB (binary) descriptors</strong>",ht,z,Rs="Initialize the ORB descriptor.",Mt,Z,ct,Q,Ns="Find keypoints and descriptors.",yt,W,ut,L,Bs=`Because ORB is a binary descriptor, we find matches using <a href="https://www.geeksforgeeks.org/hamming-distance-two-strings/" rel="nofollow">Hamming Distance</a>,
which is a measure of the difference between two strings of equal length.`,ft,A,wt,E,Fs="We will now find the matches.",Tt,Y,Ut,V,Gs="We can sort them in the order of their distance like the following.",Jt,X,dt,D,Ss="Draw first n matches.",bt,H,gt,K,_s="<strong>Fast Library for Approximate Nearest Neighbors (FLANN)</strong>",Ct,P,zs=`FLANN was proposed in <a href="https://www.cs.ubc.ca/research/flann/uploads/FLANN/flann_visapp09.pdf" rel="nofollow">Fast Approximate Nearest Neighbors With Automatic Algorithm Configuration</a> by Muja and Lowe. To explain FLANN, we will continue with our puzzle solving example. Visualize a giant puzzle with hundreds of pieces scattered around. Your goal is to organize these pieces based on how well they fit together. Instead of randomly trying to match pieces,
FLANN uses some clever tricks to quickly figure out which pieces are most likely to go together. Instead of trying every piece against every other piece, FLANN streamlines the process by finding pieces that are approximately similar. This means it can make educated guesses about which pieces might fit well together, even if they’re not an exact match. Under the hood, FLANN is uses something called k-D trees. Think of it as organizing the puzzle pieces in a special way. Instead of checking every piece against every other piece, FLANN arranges them in a tree-like structure that makes finding matches faster. In each node of the k-D tree, FLANN puts pieces with similar features together. It’s like sorting puzzle pieces with similar shapes or colors into piles. This way, when you’re looking for a match, you can quickly check the pile that’s most likely to have similar pieces. Let’s say you’re looking for a “sky” piece. Instead of searching through all the pieces, FLANN guides you to the right spot in the k-D tree where the sky-colored pieces are sorted. FLANN also adjusts its strategy based on the features of the puzzle pieces. If you have a puzzle with lots of colors, it will focus on color features. Alternately, if it’s a puzzle with intricate shapes, it pays attention to those shapes. By balancing speed and accuracy when finding matching features, FLANN substantially improves query time.`,jt,q,Zs="First, we create a dictionary to specify the algorithm we will use, for SIFT or SURF it looks like the following.",$t,O,kt,ee,Qs="For ORB, will use the parameters from the paper.",It,te,vt,se,Ws="We also create a dictionary to specify the maximum leafs to visit as follows.",xt,le,Rt,ae,Ls="Initiate SIFT detector.",Nt,ne,Bt,ie,As="Find the keypoints and descriptors with SIFT.",Ft,pe,Gt,re,Es="We will now define the FLANN parameters. Here, trees is the number of bins you want.",St,me,_t,oe,Ys="We will only draw good matches, so create a mask.",zt,he,Zt,Me,Vs="We can perform a ratio test to determine good matches.",Qt,ce,Wt,ye,Xs="Now let’s visualize the matches.",Lt,ue,At,fe,Ds='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/FLANN.png" alt="FLANN"/>',Et,we,Yt,Te,Hs=`LoFTR was proposed in <a href="https://arxiv.org/pdf/2104.00680.pdf" rel="nofollow">LoFTR: Detector-Free Local Feature Matching with Transformers</a> by Sun, et. al.
Instead of using feature detectors, LoFTR uses a learning-based approach to feature matching.`,Vt,Ue,Ks=`Let’s keep it simple and use our puzzle example once again. Instead of simply comparing images pixel by pixel, LoFTR looks for specific key points, or features, in each image. It’s like identifying the corners and edges of each puzzle piece. And just as someone really good a putting together a puzzle might focus on distinctive marks, LoFTR identifies these unique points in one image. These could be key landmarks or structures that stand out. As we have already learned, it is important that the matching algorithm handles changes in rotation or scale. If a feature is turned or resized, LoFTR would still recognize it. It’s like solving puzzles where pieces may be flipped or adjusted. As LoFTR matches features, it assigns a similarity score to indicate how well the features align. Higher scores mean better matches. It’s like giving a grade to how well one puzzle piece fits with another.
LoFTR is also invariant to certain transformations, meaning it can handle variations in lighting, angle, or perspective. This is crucial when dealing with images that might be photographed under different conditions. LoFTR’s ability to robustly match features makes it valuable for tasks like image stitching, where you combine multiple images seamlessly by identifying and connecting common features.`,Xt,Je,Ps='We can use <a href="https://github.com/kornia/kornia" rel="nofollow">Kornia</a> to find matching features in two images using LoFTR.',Dt,de,Ht,be,qs="Import the necessary libraries.",Kt,ge,Pt,Ce,Os="Load and resize the images.",qt,je,Ot,$e,el="Indicate whether the image is an “indoor” or “outdoor” image.",es,ke,ts,Ie,tl="LoFTR only works on grayscale images, so convert to images to grayscale.",ss,ve,ls,xe,sl="Let’s perform the inference.",as,Re,ns,Ne,ll='Clean up the correspondences using Random Sample Consensus (<a href="https://en.wikipedia.org/wiki/Random_sample_consensus" rel="nofollow">RANSAC</a>). This helps to deal with noise or outliers in the data.',is,Be,ps,Fe,al="Finally, we can visualize the matches.",rs,Ge,ms,Se,nl="The best matches are visualized in green, while less certain matches are in blue.",os,_e,il='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/feature-extraction-feature-matching/LoFTR.png" alt="LoFTR"/>',hs,ze,Ms,Ze,pl='<li><a href="https://github.com/flann-lib/flann" rel="nofollow">FLANN Github</a></li> <li><a href="https://arxiv.org/pdf/1710.02726.pdf" rel="nofollow">Image Matching Using SIFT, SURF, BRIEF and ORB: Performance Comparison for Distorted Images</a></li> <li><a href="https://docs.opencv.org/4.x/d1/d89/tutorial_py_orb.html" rel="nofollow">ORB (Oriented FAST and Rotated BRIEF) tutorial</a></li> <li><a href="https://kornia.github.io/tutorials/nbs/image_matching.html" rel="nofollow">Kornia tutorial on Image Matching</a></li> <li><a href="https://github.com/zju3dv/LoFTR" rel="nofollow">LoFTR Github</a></li> <li><a href="https://github.com/opencv/opencv-python" rel="nofollow">OpenCV Github</a></li> <li><a href="https://docs.opencv.org/4.x/dc/dc3/tutorial_py_matcher.html" rel="nofollow">OpenCV Feature Matching Tutorial</a></li> <li><a href="https://arxiv.org/abs/2204.08870" rel="nofollow">OpenGlue: Open Source Graph Neural Net Based Pipeline for Image Matching</a></li>',cs,Qe,ys,Le,us;return T=new fs({props:{title:"Feature Matching",local:"feature-matching",headingTag:"h1"}}),J=new fs({props:{title:"Brute-Force Search",local:"brute-force-search",headingTag:"h2"}}),C=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBvcGVuY3YtcHl0aG9u",highlighted:"!pip install opencv-python",wrap:!1}}),j=new u({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5w",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np`,wrap:!1}}),I=new u({props:{code:"c2lmdCUyMCUzRCUyMGN2Mi5TSUZUX2NyZWF0ZSgp",highlighted:"sift = cv2.SIFT_create()",wrap:!1}}),x=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),N=new u({props:{code:"YmYlMjAlM0QlMjBjdjIuQkZNYXRjaGVyKCklMEFtYXRjaGVzJTIwJTNEJTIwYmYua25uTWF0Y2goZGVzMSUyQyUyMGRlczIlMkMlMjBrJTNEMik=",highlighted:`bf = cv2.BFMatcher()
matches = bf.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new u({props:{code:"Z29vZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMG0lMkMlMjBuJTIwaW4lMjBtYXRjaGVzJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBtLmRpc3RhbmNlJTIwJTNDJTIwMC43NSUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZ29vZC5hcHBlbmQoJTVCbSU1RCk=",highlighted:`good = []
<span class="hljs-keyword">for</span> m, n <span class="hljs-keyword">in</span> matches:
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.75</span> * n.distance:
        good.append([m])`,wrap:!1}}),S=new u({props:{code:"aW1nMyUyMCUzRCUyMGN2Mi5kcmF3TWF0Y2hlc0tubiglMEElMjAlMjAlMjAlMjBpbWcxJTJDJTIwa3AxJTJDJTIwaW1nMiUyQyUyMGtwMiUyQyUyMGdvb2QlMkMlMjBOb25lJTJDJTIwZmxhZ3MlM0RjdjIuRHJhd01hdGNoZXNGbGFnc19OT1RfRFJBV19TSU5HTEVfUE9JTlRTJTBBKQ==",highlighted:`img3 = cv2.drawMatchesKnn(
    img1, kp1, img2, kp2, good, <span class="hljs-literal">None</span>, flags=cv2.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS
)`,wrap:!1}}),Z=new u({props:{code:"b3JiJTIwJTNEJTIwY3YyLk9SQl9jcmVhdGUoKQ==",highlighted:"orb = cv2.ORB_create()",wrap:!1}}),W=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMG9yYi5kZXRlY3RBbmRDb21wdXRlKGltZzElMkMlMjBOb25lKSUwQWtwMiUyQyUyMGRlczIlMjAlM0QlMjBvcmIuZGV0ZWN0QW5kQ29tcHV0ZShpbWcyJTJDJTIwTm9uZSk=",highlighted:`kp1, des1 = orb.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = orb.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),A=new u({props:{code:"YmYlMjAlM0QlMjBjdjIuQkZNYXRjaGVyKGN2Mi5OT1JNX0hBTU1JTkclMkMlMjBjcm9zc0NoZWNrJTNEVHJ1ZSk=",highlighted:'bf = cv2.BFMatcher(cv2.NORM_HAMMING, crossCheck=<span class="hljs-literal">True</span>)',wrap:!1}}),Y=new u({props:{code:"bWF0Y2hlcyUyMCUzRCUyMGJmLm1hdGNoKGRlczElMkMlMjBkZXMyKQ==",highlighted:'matches = bf.<span class="hljs-keyword">match</span>(des1, des2)',wrap:!1}}),X=new u({props:{code:"bWF0Y2hlcyUyMCUzRCUyMHNvcnRlZChtYXRjaGVzJTJDJTIwa2V5JTNEbGFtYmRhJTIweCUzQSUyMHguZGlzdGFuY2Up",highlighted:'matches = <span class="hljs-built_in">sorted</span>(matches, key=<span class="hljs-keyword">lambda</span> x: x.distance)',wrap:!1}}),H=new u({props:{code:"aW1nMyUyMCUzRCUyMGN2Mi5kcmF3TWF0Y2hlcyglMEElMjAlMjAlMjAlMjBpbWcxJTJDJTBBJTIwJTIwJTIwJTIwa3AxJTJDJTBBJTIwJTIwJTIwJTIwaW1nMiUyQyUwQSUyMCUyMCUyMCUyMGtwMiUyQyUwQSUyMCUyMCUyMCUyMG1hdGNoZXMlNUIlM0FuJTVEJTJDJTBBJTIwJTIwJTIwJTIwTm9uZSUyQyUwQSUyMCUyMCUyMCUyMGZsYWdzJTNEY3YyLkRyYXdNYXRjaGVzRmxhZ3NfTk9UX0RSQVdfU0lOR0xFX1BPSU5UUyUyQyUwQSk=",highlighted:`img3 = cv2.drawMatches(
    img1,
    kp1,
    img2,
    kp2,
    matches[:n],
    <span class="hljs-literal">None</span>,
    flags=cv2.DrawMatchesFlags_NOT_DRAW_SINGLE_POINTS,
)`,wrap:!1}}),O=new u({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KQ==",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)`,wrap:!1}}),te=new u({props:{code:"RkxBTk5fSU5ERVhfTFNIJTIwJTNEJTIwNiUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoJTBBJTIwJTIwJTIwJTIwYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfTFNIJTJDJTIwdGFibGVfbnVtYmVyJTNEMTIlMkMlMjBrZXlfc2l6ZSUzRDIwJTJDJTIwbXVsdGlfcHJvYmVfbGV2ZWwlM0QyJTBBKQ==",highlighted:`FLANN_INDEX_LSH = <span class="hljs-number">6</span>
index_params = <span class="hljs-built_in">dict</span>(
    algorithm=FLANN_INDEX_LSH, table_number=<span class="hljs-number">12</span>, key_size=<span class="hljs-number">20</span>, multi_probe_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),le=new u({props:{code:"c2VhcmNoX3BhcmFtcyUyMCUzRCUyMGRpY3QoY2hlY2tzJTNENTAp",highlighted:'search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)',wrap:!1}}),ne=new u({props:{code:"c2lmdCUyMCUzRCUyMGN2Mi5TSUZUX2NyZWF0ZSgp",highlighted:"sift = cv2.SIFT_create()",wrap:!1}}),pe=new u({props:{code:"a3AxJTJDJTIwZGVzMSUyMCUzRCUyMHNpZnQuZGV0ZWN0QW5kQ29tcHV0ZShpbWcxJTJDJTIwTm9uZSklMEFrcDIlMkMlMjBkZXMyJTIwJTNEJTIwc2lmdC5kZXRlY3RBbmRDb21wdXRlKGltZzIlMkMlMjBOb25lKQ==",highlighted:`kp1, des1 = sift.detectAndCompute(img1, <span class="hljs-literal">None</span>)
kp2, des2 = sift.detectAndCompute(img2, <span class="hljs-literal">None</span>)`,wrap:!1}}),me=new u({props:{code:"RkxBTk5fSU5ERVhfS0RUUkVFJTIwJTNEJTIwMSUwQWluZGV4X3BhcmFtcyUyMCUzRCUyMGRpY3QoYWxnb3JpdGhtJTNERkxBTk5fSU5ERVhfS0RUUkVFJTJDJTIwdHJlZXMlM0Q1KSUwQXNlYXJjaF9wYXJhbXMlMjAlM0QlMjBkaWN0KGNoZWNrcyUzRDUwKSUwQWZsYW5uJTIwJTNEJTIwY3YyLkZsYW5uQmFzZWRNYXRjaGVyKGluZGV4X3BhcmFtcyUyQyUyMHNlYXJjaF9wYXJhbXMpJTBBJTBBbWF0Y2hlcyUyMCUzRCUyMGZsYW5uLmtubk1hdGNoKGRlczElMkMlMjBkZXMyJTJDJTIwayUzRDIp",highlighted:`FLANN_INDEX_KDTREE = <span class="hljs-number">1</span>
index_params = <span class="hljs-built_in">dict</span>(algorithm=FLANN_INDEX_KDTREE, trees=<span class="hljs-number">5</span>)
search_params = <span class="hljs-built_in">dict</span>(checks=<span class="hljs-number">50</span>)
flann = cv2.FlannBasedMatcher(index_params, search_params)

matches = flann.knnMatch(des1, des2, k=<span class="hljs-number">2</span>)`,wrap:!1}}),he=new u({props:{code:"bWF0Y2hlc01hc2slMjAlM0QlMjAlNUIlNUIwJTJDJTIwMCU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihtYXRjaGVzKSklNUQ=",highlighted:'matchesMask = [[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(matches))]',wrap:!1}}),ce=new u({props:{code:"Zm9yJTIwaSUyQyUyMChtJTJDJTIwbiklMjBpbiUyMGVudW1lcmF0ZShtYXRjaGVzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbS5kaXN0YW5jZSUyMCUzQyUyMDAuNyUyMColMjBuLmRpc3RhbmNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF0Y2hlc01hc2slNUJpJTVEJTIwJTNEJTIwJTVCMSUyQyUyMDAlNUQ=",highlighted:`<span class="hljs-keyword">for</span> i, (m, n) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(matches):
    <span class="hljs-keyword">if</span> m.distance &lt; <span class="hljs-number">0.7</span> * n.distance:
        matchesMask[i] = [<span class="hljs-number">1</span>, <span class="hljs-number">0</span>]`,wrap:!1}}),ue=new u({props:{code:"ZHJhd19wYXJhbXMlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMG1hdGNoQ29sb3IlM0QoMCUyQyUyMDI1NSUyQyUyMDApJTJDJTBBJTIwJTIwJTIwJTIwc2luZ2xlUG9pbnRDb2xvciUzRCgyNTUlMkMlMjAwJTJDJTIwMCklMkMlMEElMjAlMjAlMjAlMjBtYXRjaGVzTWFzayUzRG1hdGNoZXNNYXNrJTJDJTBBJTIwJTIwJTIwJTIwZmxhZ3MlM0RjdjIuRHJhd01hdGNoZXNGbGFnc19ERUZBVUxUJTJDJTBBKSUwQSUwQWltZzMlMjAlM0QlMjBjdjIuZHJhd01hdGNoZXNLbm4oaW1nMSUyQyUyMGtwMSUyQyUyMGltZzIlMkMlMjBrcDIlMkMlMjBtYXRjaGVzJTJDJTIwTm9uZSUyQyUyMCoqZHJhd19wYXJhbXMp",highlighted:`draw_params = <span class="hljs-built_in">dict</span>(
    matchColor=(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>),
    singlePointColor=(<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>),
    matchesMask=matchesMask,
    flags=cv2.DrawMatchesFlags_DEFAULT,
)

img3 = cv2.drawMatchesKnn(img1, kp1, img2, kp2, matches, <span class="hljs-literal">None</span>, **draw_params)`,wrap:!1}}),we=new fs({props:{title:"Local Feature Matching with Transformers (LoFTR)",local:"local-feature-matching-with-transformers-loftr",headingTag:"h2"}}),de=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBrb3JuaWElMjAlMjBrb3JuaWEtcnMlMjAlMjBrb3JuaWFfbW9vbnMlMjBvcGVuY3YtcHl0aG9uJTIwLS11cGdyYWRl",highlighted:"!pip install kornia  kornia-rs  kornia_moons opencv-python --upgrade",wrap:!1}}),ge=new u({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwa29ybmlhJTIwYXMlMjBLJTBBaW1wb3J0JTIwa29ybmlhLmZlYXR1cmUlMjBhcyUyMEtGJTBBaW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGtvcm5pYV9tb29ucy52aXolMjBpbXBvcnQlMjBkcmF3X0xBRl9tYXRjaGVz",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> kornia <span class="hljs-keyword">as</span> K
<span class="hljs-keyword">import</span> kornia.feature <span class="hljs-keyword">as</span> KF
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> kornia_moons.viz <span class="hljs-keyword">import</span> draw_LAF_matches`,wrap:!1}}),je=new u({props:{code:"ZnJvbSUyMGtvcm5pYS5mZWF0dXJlJTIwaW1wb3J0JTIwTG9GVFIlMEElMEFpbWcxJTIwJTNEJTIwSy5pby5sb2FkX2ltYWdlKGltYWdlMS5qcGclMkMlMjBLLmlvLkltYWdlTG9hZFR5cGUuUkdCMzIpJTVCTm9uZSUyQyUyMC4uLiU1RCUwQWltZzIlMjAlM0QlMjBLLmlvLmxvYWRfaW1hZ2UoaW1hZ2UyLmpwZyUyQyUyMEsuaW8uSW1hZ2VMb2FkVHlwZS5SR0IzMiklNUJOb25lJTJDJTIwLi4uJTVEJTBBJTBBaW1nMSUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzElMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUpJTBBaW1nMiUyMCUzRCUyMEsuZ2VvbWV0cnkucmVzaXplKGltZzIlMkMlMjAoNTEyJTJDJTIwNTEyKSUyQyUyMGFudGlhbGlhcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> kornia.feature <span class="hljs-keyword">import</span> LoFTR

img1 = K.io.load_image(image1.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]
img2 = K.io.load_image(image2.jpg, K.io.ImageLoadType.RGB32)[<span class="hljs-literal">None</span>, ...]

img1 = K.geometry.resize(img1, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)
img2 = K.geometry.resize(img2, (<span class="hljs-number">512</span>, <span class="hljs-number">512</span>), antialias=<span class="hljs-literal">True</span>)`,wrap:!1}}),ke=new u({props:{code:"bWF0Y2hlciUyMCUzRCUyMExvRlRSKHByZXRyYWluZWQlM0QlMjJvdXRkb29yJTIyKQ==",highlighted:'matcher = LoFTR(pretrained=<span class="hljs-string">&quot;outdoor&quot;</span>)',wrap:!1}}),ve=new u({props:{code:"aW5wdXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMCUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMmltYWdlMSUyMiUzQSUyMEsuY29sb3IucmdiX3RvX2dyYXlzY2FsZShpbWcyKSUyQyUwQSU3RA==",highlighted:`input_dict = {
    <span class="hljs-string">&quot;image0&quot;</span>: K.color.rgb_to_grayscale(img1),
    <span class="hljs-string">&quot;image1&quot;</span>: K.color.rgb_to_grayscale(img2),
}`,wrap:!1}}),Re=new u({props:{code:"d2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBjb3JyZXNwb25kZW5jZXMlMjAlM0QlMjBtYXRjaGVyKGlucHV0X2RpY3Qp",highlighted:`<span class="hljs-keyword">with</span> torch.inference_mode():
    correspondences = matcher(input_dict)`,wrap:!1}}),Be=new u({props:{code:"bWtwdHMwJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMCUyMiU1RC5jcHUoKS5udW1weSgpJTBBbWtwdHMxJTIwJTNEJTIwY29ycmVzcG9uZGVuY2VzJTVCJTIya2V5cG9pbnRzMSUyMiU1RC5jcHUoKS5udW1weSgpJTBBRm0lMkMlMjBpbmxpZXJzJTIwJTNEJTIwY3YyLmZpbmRGdW5kYW1lbnRhbE1hdChta3B0czAlMkMlMjBta3B0czElMkMlMjBjdjIuVVNBQ19NQUdTQUMlMkMlMjAwLjUlMkMlMjAwLjk5OSUyQyUyMDEwMDAwMCklMEFpbmxpZXJzJTIwJTNEJTIwaW5saWVycyUyMCUzRSUyMDA=",highlighted:`mkpts0 = correspondences[<span class="hljs-string">&quot;keypoints0&quot;</span>].cpu().numpy()
mkpts1 = correspondences[<span class="hljs-string">&quot;keypoints1&quot;</span>].cpu().numpy()
Fm, inliers = cv2.findFundamentalMat(mkpts0, mkpts1, cv2.USAC_MAGSAC, <span class="hljs-number">0.5</span>, <span class="hljs-number">0.999</span>, <span class="hljs-number">100000</span>)
inliers = inliers &gt; <span class="hljs-number">0</span>`,wrap:!1}}),Ge=new u({props:{code:"ZHJhd19MQUZfbWF0Y2hlcyglMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMwKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czAuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjBLRi5sYWZfZnJvbV9jZW50ZXJfc2NhbGVfb3JpKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLmZyb21fbnVtcHkobWtwdHMxKS52aWV3KDElMkMlMjAtMSUyQyUyMDIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2gub25lcyhta3B0czEuc2hhcGUlNUIwJTVEKS52aWV3KDElMkMlMjAtMSUyQyUyMDElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcmNoLm9uZXMobWtwdHMxLnNoYXBlJTVCMCU1RCkudmlldygxJTJDJTIwLTElMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjB0b3JjaC5hcmFuZ2UobWtwdHMwLnNoYXBlJTVCMCU1RCkudmlldygtMSUyQyUyMDEpLnJlcGVhdCgxJTJDJTIwMiklMkMlMEElMjAlMjAlMjAlMjBLLnRlbnNvcl90b19pbWFnZShpbWcxKSUyQyUwQSUyMCUyMCUyMCUyMEsudGVuc29yX3RvX2ltYWdlKGltZzIpJTJDJTBBJTIwJTIwJTIwJTIwaW5saWVycyUyQyUwQSUyMCUyMCUyMCUyMGRyYXdfZGljdCUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmlubGllcl9jb2xvciUyMiUzQSUyMCgwLjElMkMlMjAxJTJDJTIwMC4xJTJDJTIwMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRlbnRhdGl2ZV9jb2xvciUyMiUzQSUyME5vbmUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmZWF0dXJlX2NvbG9yJTIyJTNBJTIwKDAuMiUyQyUyMDAuMiUyQyUyMDElMkMlMjAwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydmVydGljYWwlMjIlM0ElMjBGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSk=",highlighted:`draw_LAF_matches(
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts0).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts0.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    KF.laf_from_center_scale_ori(
        torch.from_numpy(mkpts1).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
        torch.ones(mkpts1.shape[<span class="hljs-number">0</span>]).view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>, <span class="hljs-number">1</span>),
    ),
    torch.arange(mkpts0.shape[<span class="hljs-number">0</span>]).view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>).repeat(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>),
    K.tensor_to_image(img1),
    K.tensor_to_image(img2),
    inliers,
    draw_dict={
        <span class="hljs-string">&quot;inlier_color&quot;</span>: (<span class="hljs-number">0.1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;tentative_color&quot;</span>: <span class="hljs-literal">None</span>,
        <span class="hljs-string">&quot;feature_color&quot;</span>: (<span class="hljs-number">0.2</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0.5</span>),
        <span class="hljs-string">&quot;vertical&quot;</span>: <span class="hljs-literal">False</span>,
    },
)`,wrap:!1}}),ze=new fs({props:{title:"Resources and Further Reading",local:"resources-and-further-reading",headingTag:"h2"}}),Qe=new fl({props:{source:"https://github.com/huggingface/computer-vision-course/blob/main/chapters/en/unit1/feature-extraction/feature-matching.mdx"}}),{c(){f=i("meta"),Ae=a(),We=i("p"),Ee=a(),m(T.$$.fragment),Ye=a(),U=i("p"),U.textContent=Us,Ve=a(),m(J.$$.fragment),Xe=a(),d=i("p"),d.textContent=Js,De=a(),b=i("p"),b.textContent=ds,He=a(),g=i("p"),g.textContent=bs,Ke=a(),m(C.$$.fragment),Pe=a(),m(j.$$.fragment),qe=a(),$=i("p"),$.innerHTML=gs,Oe=a(),k=i("p"),k.textContent=Cs,et=a(),m(I.$$.fragment),tt=a(),v=i("p"),v.textContent=js,st=a(),m(x.$$.fragment),lt=a(),R=i("p"),R.textContent=$s,at=a(),m(N.$$.fragment),nt=a(),B=i("p"),B.textContent=ks,it=a(),m(F.$$.fragment),pt=a(),G=i("p"),G.textContent=Is,rt=a(),m(S.$$.fragment),mt=a(),w=i("div"),w.innerHTML=vs,ot=a(),_=i("p"),_.innerHTML=xs,ht=a(),z=i("p"),z.textContent=Rs,Mt=a(),m(Z.$$.fragment),ct=a(),Q=i("p"),Q.textContent=Ns,yt=a(),m(W.$$.fragment),ut=a(),L=i("p"),L.innerHTML=Bs,ft=a(),m(A.$$.fragment),wt=a(),E=i("p"),E.textContent=Fs,Tt=a(),m(Y.$$.fragment),Ut=a(),V=i("p"),V.textContent=Gs,Jt=a(),m(X.$$.fragment),dt=a(),D=i("p"),D.textContent=Ss,bt=a(),m(H.$$.fragment),gt=a(),K=i("p"),K.innerHTML=_s,Ct=a(),P=i("p"),P.innerHTML=zs,jt=a(),q=i("p"),q.textContent=Zs,$t=a(),m(O.$$.fragment),kt=a(),ee=i("p"),ee.textContent=Qs,It=a(),m(te.$$.fragment),vt=a(),se=i("p"),se.textContent=Ws,xt=a(),m(le.$$.fragment),Rt=a(),ae=i("p"),ae.textContent=Ls,Nt=a(),m(ne.$$.fragment),Bt=a(),ie=i("p"),ie.textContent=As,Ft=a(),m(pe.$$.fragment),Gt=a(),re=i("p"),re.textContent=Es,St=a(),m(me.$$.fragment),_t=a(),oe=i("p"),oe.textContent=Ys,zt=a(),m(he.$$.fragment),Zt=a(),Me=i("p"),Me.textContent=Vs,Qt=a(),m(ce.$$.fragment),Wt=a(),ye=i("p"),ye.textContent=Xs,Lt=a(),m(ue.$$.fragment),At=a(),fe=i("p"),fe.innerHTML=Ds,Et=a(),m(we.$$.fragment),Yt=a(),Te=i("p"),Te.innerHTML=Hs,Vt=a(),Ue=i("p"),Ue.textContent=Ks,Xt=a(),Je=i("p"),Je.innerHTML=Ps,Dt=a(),m(de.$$.fragment),Ht=a(),be=i("p"),be.textContent=qs,Kt=a(),m(ge.$$.fragment),Pt=a(),Ce=i("p"),Ce.textContent=Os,qt=a(),m(je.$$.fragment),Ot=a(),$e=i("p"),$e.textContent=el,es=a(),m(ke.$$.fragment),ts=a(),Ie=i("p"),Ie.textContent=tl,ss=a(),m(ve.$$.fragment),ls=a(),xe=i("p"),xe.textContent=sl,as=a(),m(Re.$$.fragment),ns=a(),Ne=i("p"),Ne.innerHTML=ll,is=a(),m(Be.$$.fragment),ps=a(),Fe=i("p"),Fe.textContent=al,rs=a(),m(Ge.$$.fragment),ms=a(),Se=i("p"),Se.textContent=nl,os=a(),_e=i("p"),_e.innerHTML=il,hs=a(),m(ze.$$.fragment),Ms=a(),Ze=i("ul"),Ze.innerHTML=pl,cs=a(),m(Qe.$$.fragment),ys=a(),Le=i("p"),this.h()},l(e){const t=yl("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(s),Ae=n(e),We=p(e,"P",{}),rl(We).forEach(s),Ee=n(e),o(T.$$.fragment,e),Ye=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-15xns04"&&(U.textContent=Us),Ve=n(e),o(J.$$.fragment,e),Xe=n(e),d=p(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-on1oww"&&(d.textContent=Js),De=n(e),b=p(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-18ol5uq"&&(b.textContent=ds),He=n(e),g=p(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-j7e5uv"&&(g.textContent=bs),Ke=n(e),o(C.$$.fragment,e),Pe=n(e),o(j.$$.fragment,e),qe=n(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-9u0yio"&&($.innerHTML=gs),Oe=n(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-w6x33t"&&(k.textContent=Cs),et=n(e),o(I.$$.fragment,e),tt=n(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1rqvoxt"&&(v.textContent=js),st=n(e),o(x.$$.fragment,e),lt=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1s4nnss"&&(R.textContent=$s),at=n(e),o(N.$$.fragment,e),nt=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-11pmghx"&&(B.textContent=ks),it=n(e),o(F.$$.fragment,e),pt=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1dxu9r2"&&(G.textContent=Is),rt=n(e),o(S.$$.fragment,e),mt=n(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-65csdm"&&(w.innerHTML=vs),ot=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-ugbzmf"&&(_.innerHTML=xs),ht=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-118nbqb"&&(z.textContent=Rs),Mt=n(e),o(Z.$$.fragment,e),ct=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1db2byq"&&(Q.textContent=Ns),yt=n(e),o(W.$$.fragment,e),ut=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-16ya51f"&&(L.innerHTML=Bs),ft=n(e),o(A.$$.fragment,e),wt=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1qu6t9d"&&(E.textContent=Fs),Tt=n(e),o(Y.$$.fragment,e),Ut=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-16suw0v"&&(V.textContent=Gs),Jt=n(e),o(X.$$.fragment,e),dt=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1uxd7nf"&&(D.textContent=Ss),bt=n(e),o(H.$$.fragment,e),gt=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1br77qa"&&(K.innerHTML=_s),Ct=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1bts3l5"&&(P.innerHTML=zs),jt=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-12c8hlw"&&(q.textContent=Zs),$t=n(e),o(O.$$.fragment,e),kt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-xztual"&&(ee.textContent=Qs),It=n(e),o(te.$$.fragment,e),vt=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-aqv1ru"&&(se.textContent=Ws),xt=n(e),o(le.$$.fragment,e),Rt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1uz9tsf"&&(ae.textContent=Ls),Nt=n(e),o(ne.$$.fragment,e),Bt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1rqvoxt"&&(ie.textContent=As),Ft=n(e),o(pe.$$.fragment,e),Gt=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1owh1z6"&&(re.textContent=Es),St=n(e),o(me.$$.fragment,e),_t=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-fflevz"&&(oe.textContent=Ys),zt=n(e),o(he.$$.fragment,e),Zt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-wxpfev"&&(Me.textContent=Vs),Qt=n(e),o(ce.$$.fragment,e),Wt=n(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1v2s6y7"&&(ye.textContent=Xs),Lt=n(e),o(ue.$$.fragment,e),At=n(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1wrykwq"&&(fe.innerHTML=Ds),Et=n(e),o(we.$$.fragment,e),Yt=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-lacwgz"&&(Te.innerHTML=Hs),Vt=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-9siw9c"&&(Ue.textContent=Ks),Xt=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1e39a5t"&&(Je.innerHTML=Ps),Dt=n(e),o(de.$$.fragment,e),Ht=n(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-srwjmc"&&(be.textContent=qs),Kt=n(e),o(ge.$$.fragment,e),Pt=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-5yf40"&&(Ce.textContent=Os),qt=n(e),o(je.$$.fragment,e),Ot=n(e),$e=p(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-h1pkxc"&&($e.textContent=el),es=n(e),o(ke.$$.fragment,e),ts=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-mpwa7r"&&(Ie.textContent=tl),ss=n(e),o(ve.$$.fragment,e),ls=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1d3obuy"&&(xe.textContent=sl),as=n(e),o(Re.$$.fragment,e),ns=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1pdz4rs"&&(Ne.innerHTML=ll),is=n(e),o(Be.$$.fragment,e),ps=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1h7emw7"&&(Fe.textContent=al),rs=n(e),o(Ge.$$.fragment,e),ms=n(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-19n2hbq"&&(Se.textContent=nl),os=n(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1p8df1m"&&(_e.innerHTML=il),hs=n(e),o(ze.$$.fragment,e),Ms=n(e),Ze=p(e,"UL",{"data-svelte-h":!0}),r(Ze)!=="svelte-5o0z5y"&&(Ze.innerHTML=pl),cs=n(e),o(Qe.$$.fragment,e),ys=n(e),Le=p(e,"P",{}),rl(Le).forEach(s),this.h()},h(){ws(f,"name","hf:doc:metadata"),ws(f,"content",Tl),ws(w,"class","flex justify-center")},m(e,t){ul(document.head,f),l(e,Ae,t),l(e,We,t),l(e,Ee,t),h(T,e,t),l(e,Ye,t),l(e,U,t),l(e,Ve,t),h(J,e,t),l(e,Xe,t),l(e,d,t),l(e,De,t),l(e,b,t),l(e,He,t),l(e,g,t),l(e,Ke,t),h(C,e,t),l(e,Pe,t),h(j,e,t),l(e,qe,t),l(e,$,t),l(e,Oe,t),l(e,k,t),l(e,et,t),h(I,e,t),l(e,tt,t),l(e,v,t),l(e,st,t),h(x,e,t),l(e,lt,t),l(e,R,t),l(e,at,t),h(N,e,t),l(e,nt,t),l(e,B,t),l(e,it,t),h(F,e,t),l(e,pt,t),l(e,G,t),l(e,rt,t),h(S,e,t),l(e,mt,t),l(e,w,t),l(e,ot,t),l(e,_,t),l(e,ht,t),l(e,z,t),l(e,Mt,t),h(Z,e,t),l(e,ct,t),l(e,Q,t),l(e,yt,t),h(W,e,t),l(e,ut,t),l(e,L,t),l(e,ft,t),h(A,e,t),l(e,wt,t),l(e,E,t),l(e,Tt,t),h(Y,e,t),l(e,Ut,t),l(e,V,t),l(e,Jt,t),h(X,e,t),l(e,dt,t),l(e,D,t),l(e,bt,t),h(H,e,t),l(e,gt,t),l(e,K,t),l(e,Ct,t),l(e,P,t),l(e,jt,t),l(e,q,t),l(e,$t,t),h(O,e,t),l(e,kt,t),l(e,ee,t),l(e,It,t),h(te,e,t),l(e,vt,t),l(e,se,t),l(e,xt,t),h(le,e,t),l(e,Rt,t),l(e,ae,t),l(e,Nt,t),h(ne,e,t),l(e,Bt,t),l(e,ie,t),l(e,Ft,t),h(pe,e,t),l(e,Gt,t),l(e,re,t),l(e,St,t),h(me,e,t),l(e,_t,t),l(e,oe,t),l(e,zt,t),h(he,e,t),l(e,Zt,t),l(e,Me,t),l(e,Qt,t),h(ce,e,t),l(e,Wt,t),l(e,ye,t),l(e,Lt,t),h(ue,e,t),l(e,At,t),l(e,fe,t),l(e,Et,t),h(we,e,t),l(e,Yt,t),l(e,Te,t),l(e,Vt,t),l(e,Ue,t),l(e,Xt,t),l(e,Je,t),l(e,Dt,t),h(de,e,t),l(e,Ht,t),l(e,be,t),l(e,Kt,t),h(ge,e,t),l(e,Pt,t),l(e,Ce,t),l(e,qt,t),h(je,e,t),l(e,Ot,t),l(e,$e,t),l(e,es,t),h(ke,e,t),l(e,ts,t),l(e,Ie,t),l(e,ss,t),h(ve,e,t),l(e,ls,t),l(e,xe,t),l(e,as,t),h(Re,e,t),l(e,ns,t),l(e,Ne,t),l(e,is,t),h(Be,e,t),l(e,ps,t),l(e,Fe,t),l(e,rs,t),h(Ge,e,t),l(e,ms,t),l(e,Se,t),l(e,os,t),l(e,_e,t),l(e,hs,t),h(ze,e,t),l(e,Ms,t),l(e,Ze,t),l(e,cs,t),h(Qe,e,t),l(e,ys,t),l(e,Le,t),us=!0},p:ol,i(e){us||(M(T.$$.fragment,e),M(J.$$.fragment,e),M(C.$$.fragment,e),M(j.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(N.$$.fragment,e),M(F.$$.fragment,e),M(S.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(A.$$.fragment,e),M(Y.$$.fragment,e),M(X.$$.fragment,e),M(H.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(ce.$$.fragment,e),M(ue.$$.fragment,e),M(we.$$.fragment,e),M(de.$$.fragment,e),M(ge.$$.fragment,e),M(je.$$.fragment,e),M(ke.$$.fragment,e),M(ve.$$.fragment,e),M(Re.$$.fragment,e),M(Be.$$.fragment,e),M(Ge.$$.fragment,e),M(ze.$$.fragment,e),M(Qe.$$.fragment,e),us=!0)},o(e){c(T.$$.fragment,e),c(J.$$.fragment,e),c(C.$$.fragment,e),c(j.$$.fragment,e),c(I.$$.fragment,e),c(x.$$.fragment,e),c(N.$$.fragment,e),c(F.$$.fragment,e),c(S.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(A.$$.fragment,e),c(Y.$$.fragment,e),c(X.$$.fragment,e),c(H.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(we.$$.fragment,e),c(de.$$.fragment,e),c(ge.$$.fragment,e),c(je.$$.fragment,e),c(ke.$$.fragment,e),c(ve.$$.fragment,e),c(Re.$$.fragment,e),c(Be.$$.fragment,e),c(Ge.$$.fragment,e),c(ze.$$.fragment,e),c(Qe.$$.fragment,e),us=!1},d(e){e&&(s(Ae),s(We),s(Ee),s(Ye),s(U),s(Ve),s(Xe),s(d),s(De),s(b),s(He),s(g),s(Ke),s(Pe),s(qe),s($),s(Oe),s(k),s(et),s(tt),s(v),s(st),s(lt),s(R),s(at),s(nt),s(B),s(it),s(pt),s(G),s(rt),s(mt),s(w),s(ot),s(_),s(ht),s(z),s(Mt),s(ct),s(Q),s(yt),s(ut),s(L),s(ft),s(wt),s(E),s(Tt),s(Ut),s(V),s(Jt),s(dt),s(D),s(bt),s(gt),s(K),s(Ct),s(P),s(jt),s(q),s($t),s(kt),s(ee),s(It),s(vt),s(se),s(xt),s(Rt),s(ae),s(Nt),s(Bt),s(ie),s(Ft),s(Gt),s(re),s(St),s(_t),s(oe),s(zt),s(Zt),s(Me),s(Qt),s(Wt),s(ye),s(Lt),s(At),s(fe),s(Et),s(Yt),s(Te),s(Vt),s(Ue),s(Xt),s(Je),s(Dt),s(Ht),s(be),s(Kt),s(Pt),s(Ce),s(qt),s(Ot),s($e),s(es),s(ts),s(Ie),s(ss),s(ls),s(xe),s(as),s(ns),s(Ne),s(is),s(ps),s(Fe),s(rs),s(ms),s(Se),s(os),s(_e),s(hs),s(Ms),s(Ze),s(cs),s(ys),s(Le)),s(f),y(T,e),y(J,e),y(C,e),y(j,e),y(I,e),y(x,e),y(N,e),y(F,e),y(S,e),y(Z,e),y(W,e),y(A,e),y(Y,e),y(X,e),y(H,e),y(O,e),y(te,e),y(le,e),y(ne,e),y(pe,e),y(me,e),y(he,e),y(ce,e),y(ue,e),y(we,e),y(de,e),y(ge,e),y(je,e),y(ke,e),y(ve,e),y(Re,e),y(Be,e),y(Ge,e),y(ze,e),y(Qe,e)}}}const Tl='{"title":"Feature Matching","local":"feature-matching","sections":[{"title":"Brute-Force Search","local":"brute-force-search","sections":[],"depth":2},{"title":"Local Feature Matching with Transformers (LoFTR)","local":"local-feature-matching-with-transformers-loftr","sections":[],"depth":2},{"title":"Resources and Further Reading","local":"resources-and-further-reading","sections":[],"depth":2}],"depth":1}';function Ul(Ts){return hl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cl extends Ml{constructor(f){super(),cl(this,f,Ul,wl,ml,{})}}export{Cl as component};
