import{s as It,n as Et,o as At}from"../chunks/scheduler.c57aa7ef.js";import{S as Ft,i as Gt,g as s,s as a,r as p,A as Ht,h as o,f as l,c as i,j as Xt,u as m,x as r,k as Rt,y as Nt,a as n,v as f,d as u,t as d,w as h}from"../chunks/index.c50cb18e.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as b,E as Vt}from"../chunks/EditOnGithub.958a8a49.js";function Yt(ft){let c,he,ue,Me,g,ce,y,ut="Quantization represents data with fewer bits, making it a useful technique for reducing memory-usage and accelerating inference especially when it comes to large language models (LLMs). There are several ways to quantize a model including:",be,w,dt='<li>optimizing which model weights are quantized with the <a href="https://hf.co/papers/2306.00978" rel="nofollow">AWQ</a> algorithm</li> <li>independently quantizing each row of a weight matrix with the <a href="https://hf.co/papers/2210.17323" rel="nofollow">GPTQ</a> algorithm</li> <li>quantizing to 8-bit and 4-bit precision with the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> library</li> <li>quantizing to as low as 2-bit precision with the <a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a> algorithm</li>',ge,T,ht='However, after a model is quantized it isn’t typically further trained for downstream tasks because training can be unstable due to the lower precision of the weights and activations. But since PEFT methods only add <em>extra</em> trainable parameters, this allows you to train a quantized model with a PEFT adapter on top! Combining quantization with PEFT can be a good strategy for training even the largest models on a single GPU. For example, <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a> is a method that quantizes a model to 4-bits and then trains it with LoRA. This method allows you to finetune a 65B parameter model on a single 48GB GPU!',ye,J,Mt="In this guide, you’ll see how to quantize a model to 4-bits and train it with LoRA.",we,_,Te,$,ct='<a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a> is a quantization library with a Transformers integration. With this integration, you can quantize a model to 8 or 4-bits and enable many other options by configuring the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class. For example, you can:',Je,q,bt="<li>set <code>load_in_4bit=True</code> to quantize the model to 4-bits when you load it</li> <li>set <code>bnb_4bit_quant_type=&quot;nf4&quot;</code> to use a special 4-bit data type for weights initialized from a normal distribution</li> <li>set <code>bnb_4bit_use_double_quant=True</code> to use a nested quantization scheme to quantize the already quantized weights</li> <li>set <code>bnb_4bit_compute_dtype=torch.bfloat16</code> to use bfloat16 for faster computation</li>",_e,v,$e,j,gt='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',qe,C,ve,Z,yt='Next, you should call the <a href="/docs/peft/pr_1871/en/package_reference/peft_model#peft.prepare_model_for_kbit_training">prepare_model_for_kbit_training()</a> function to preprocess the quantized model for training.',je,B,Ce,Q,wt="Now that the quantized model is ready, let’s set up a configuration.",Ze,L,Be,z,Tt='Create a <a href="/docs/peft/pr_1871/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> with the following parameters (or choose your own):',Qe,U,Le,k,Jt='Then use the <a href="/docs/peft/pr_1871/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/pr_1871/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the quantized model and configuration.',ze,x,Ue,W,_t="You’re all set for training with whichever training method you prefer!",ke,X,xe,R,$t='<a href="https://hf.co/papers/2310.08659" rel="nofollow">LoftQ</a> initializes LoRA weights such that the quantization error is minimized, and it can improve performance when training quantized models. To get started, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',We,I,qt="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Xe,E,Re,A,vt="QLoRA adds trainable weights to all the linear layers in the transformer architecture. Since the attribute names for these linear layers can vary across architectures, set <code>target_modules</code> to <code>&quot;all-linear&quot;</code> to add LoRA to all the linear layers:",Ie,F,Ee,G,Ae,H,jt='Additive Quantization of Language Models (<a href="https://arxiv.org/abs/2401.06118" rel="nofollow">AQLM</a>) is a Large Language Models compression method. It quantizes multiple weights together and takes advantage of interdependencies between them. AQLM represents groups of 8-16 weights as a sum of multiple vector codes. This allows it to compress models down to as low as 2-bit with considerably low accuracy losses.',Fe,N,Ct='Since the AQLM quantization process is computationally expensive, a use of prequantized models is recommended. A partial list of available models can be found in the official aqlm <a href="https://github.com/Vahe1994/AQLM" rel="nofollow">repository</a>.',Ge,V,Zt="The models support LoRA adapter tuning. To tune the quantized model you’ll need to install the <code>aqlm</code> inference library: <code>pip install aqlm&gt;=1.0.2</code>. Finetuned LoRA adapters shall be saved separately, as merging them with AQLM quantized weights is not possible.",He,Y,Ne,S,Bt='You can refer to the <a href="https://colab.research.google.com/drive/12GTp1FCj5_0SnnNQH18h_2XFh9vS_guX?usp=sharing" rel="nofollow">Google Colab</a> example for an overview of AQLM+LoRA finetuning.',Ve,P,Ye,D,Qt='You can also perform LoRA fine-tuning on EETQ quantized models. <a href="https://github.com/NetEase-FuXi/EETQ" rel="nofollow">EETQ</a> package offers simple and efficient way to perform 8-bit quantization, which is claimed to be faster than the <code>LLM.int8()</code> algorithm. First, make sure that you have a transformers version that is compatible with EETQ (e.g. by installing it from latest pypi or from source).',Se,K,Pe,O,Lt='Pass the <code>config</code> to the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> method.',De,ee,Ke,te,zt="and create a <code>LoraConfig</code> and pass it to <code>get_peft_model</code>:",Oe,le,et,ne,tt,ae,Ut='The models that is quantized using Half-Quadratic Quantization of Large Machine Learning Models (<a href="https://mobiusml.github.io/hqq_blog/" rel="nofollow">HQQ</a>) support LoRA adapter tuning. To tune the quantized model, you’ll need to install the <code>hqq</code> library with: <code>pip install hqq</code>.',lt,ie,nt,se,kt="Or using transformers version that is compatible with HQQ (e.g. by installing it from latest pypi or from source).",at,oe,it,re,st,pe,xt="If you’re interested in learning more about quantization, the following may be helpful:",ot,me,Wt='<li>Learn more about details about QLoRA and check out some benchmarks on its impact in the <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a> blog post.</li> <li>Read more about different quantization schemes in the Transformers <a href="https://hf.co/docs/transformers/main/quantization" rel="nofollow">Quantization</a> guide.</li>',rt,fe,pt,de,mt;return g=new b({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),_=new b({props:{title:"Quantize a model",local:"quantize-a-model",headingTag:"h2"}}),v=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)`,wrap:!1}}),C=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model = prepare_model_for_kbit_training(model)`,wrap:!1}}),L=new b({props:{title:"LoraConfig",local:"loraconfig",headingTag:"h2"}}),U=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycV9wcm9qJTIyJTJDJTIwJTIya19wcm9qJTIyJTJDJTIwJTIydl9wcm9qJTIyJTJDJTIwJTIyb19wcm9qJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4wNSUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),x=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBjb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, config)`,wrap:!1}}),X=new b({props:{title:"LoftQ initialization",local:"loftq-initialization",headingTag:"h3"}}),E=new b({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),F=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),G=new b({props:{title:"AQLM quantization",local:"aqlm-quantization",headingTag:"h2"}}),Y=new M({props:{code:"cXVhbnRpemVkX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkJsYWNrU2Ftb3JleiUyRk1peHRyYWwtOHg3Yi1BUUxNLTJCaXQtMXgxNi1oZi10ZXN0LWRpc3BhdGNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEEpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKC4uLiklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyk=",highlighted:`quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;BlackSamorez/Mixtral-8x7b-AQLM-2Bit-1x16-hf-test-dispatch&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>,
)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),P=new b({props:{title:"EETQ quantization",local:"eetq-quantization",headingTag:"h2"}}),K=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwRWV0cUNvbmZpZyUwQSUwQWNvbmZpZyUyMCUzRCUyMEVldHFDb25maWcoJTIyaW50OCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> EetqConfig

config = EetqConfig(<span class="hljs-string">&quot;int8&quot;</span>)`,wrap:!1}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, quantization_config=config)`,wrap:!1}}),le=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0Q4JTJDJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X21vZHVsZXMlM0QlNUIlMjJxX3Byb2olMjIlMkMlMjAlMjJrX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlMkMlMjAlMjJvX3Byb2olMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=[<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>],
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)

model = get_peft_model(model, config)`,wrap:!1}}),ne=new b({props:{title:"HQQ quantization",local:"hqq-quantization",headingTag:"h2"}}),ie=new M({props:{code:"ZnJvbSUyMGhxcS5lbmdpbmUuaGYlMjBpbXBvcnQlMjBIUVFNb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwSFFRTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3F1YW50aXplZChzYXZlX2Rpcl9vcl9oZmh1YiUyQyUyMGRldmljZSUzRCdjdWRhJyklMEElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoLi4uKSUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKHF1YW50aXplZF9tb2RlbCUyQyUyMHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> hqq.engine.hf <span class="hljs-keyword">import</span> HQQModelForCausalLM

quantized_model = HQQModelForCausalLM.from_quantized(save_dir_or_hfhub, device=<span class="hljs-string">&#x27;cuda&#x27;</span>)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),oe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhxcUNvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSHFxQ29uZmlnKG5iaXRzJTNENCUyQyUyMGdyb3VwX3NpemUlM0Q2NCklMEElMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJfb3JfaGZodWIlMkMlMjBkZXZpY2UlM0QnY3VkYSclMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRfY29uZmlnKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4pJTBBJTBBcXVhbnRpemVkX21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwocXVhbnRpemVkX21vZGVsJTJDJTIwcGVmdF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HqqConfig, AutoModelForCausalLM

quant_config = HqqConfig(nbits=<span class="hljs-number">4</span>, group_size=<span class="hljs-number">64</span>)

quantized_model = AutoModelForCausalLM.from_pretrained(save_dir_or_hfhub, device=<span class="hljs-string">&#x27;cuda&#x27;</span>, quantization_config=quant_config)

peft_config = LoraConfig(...)

quantized_model = get_peft_model(quantized_model, peft_config)`,wrap:!1}}),re=new b({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),fe=new Vt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/quantization.md"}}),{c(){c=s("meta"),he=a(),ue=s("p"),Me=a(),p(g.$$.fragment),ce=a(),y=s("p"),y.textContent=ut,be=a(),w=s("ul"),w.innerHTML=dt,ge=a(),T=s("p"),T.innerHTML=ht,ye=a(),J=s("p"),J.textContent=Mt,we=a(),p(_.$$.fragment),Te=a(),$=s("p"),$.innerHTML=ct,Je=a(),q=s("ul"),q.innerHTML=bt,_e=a(),p(v.$$.fragment),$e=a(),j=s("p"),j.innerHTML=gt,qe=a(),p(C.$$.fragment),ve=a(),Z=s("p"),Z.innerHTML=yt,je=a(),p(B.$$.fragment),Ce=a(),Q=s("p"),Q.textContent=wt,Ze=a(),p(L.$$.fragment),Be=a(),z=s("p"),z.innerHTML=Tt,Qe=a(),p(U.$$.fragment),Le=a(),k=s("p"),k.innerHTML=Jt,ze=a(),p(x.$$.fragment),Ue=a(),W=s("p"),W.textContent=_t,ke=a(),p(X.$$.fragment),xe=a(),R=s("p"),R.innerHTML=$t,We=a(),I=s("p"),I.innerHTML=qt,Xe=a(),p(E.$$.fragment),Re=a(),A=s("p"),A.innerHTML=vt,Ie=a(),p(F.$$.fragment),Ee=a(),p(G.$$.fragment),Ae=a(),H=s("p"),H.innerHTML=jt,Fe=a(),N=s("p"),N.innerHTML=Ct,Ge=a(),V=s("p"),V.innerHTML=Zt,He=a(),p(Y.$$.fragment),Ne=a(),S=s("p"),S.innerHTML=Bt,Ve=a(),p(P.$$.fragment),Ye=a(),D=s("p"),D.innerHTML=Qt,Se=a(),p(K.$$.fragment),Pe=a(),O=s("p"),O.innerHTML=Lt,De=a(),p(ee.$$.fragment),Ke=a(),te=s("p"),te.innerHTML=zt,Oe=a(),p(le.$$.fragment),et=a(),p(ne.$$.fragment),tt=a(),ae=s("p"),ae.innerHTML=Ut,lt=a(),p(ie.$$.fragment),nt=a(),se=s("p"),se.textContent=kt,at=a(),p(oe.$$.fragment),it=a(),p(re.$$.fragment),st=a(),pe=s("p"),pe.textContent=xt,ot=a(),me=s("ul"),me.innerHTML=Wt,rt=a(),p(fe.$$.fragment),pt=a(),de=s("p"),this.h()},l(e){const t=Ht("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),he=i(e),ue=o(e,"P",{}),Xt(ue).forEach(l),Me=i(e),m(g.$$.fragment,e),ce=i(e),y=o(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-famg4s"&&(y.textContent=ut),be=i(e),w=o(e,"UL",{"data-svelte-h":!0}),r(w)!=="svelte-27c91"&&(w.innerHTML=dt),ge=i(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-142xot4"&&(T.innerHTML=ht),ye=i(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1demhiu"&&(J.textContent=Mt),we=i(e),m(_.$$.fragment,e),Te=i(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-p0gbf4"&&($.innerHTML=ct),Je=i(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-hfynw8"&&(q.innerHTML=bt),_e=i(e),m(v.$$.fragment,e),$e=i(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-pxonbi"&&(j.innerHTML=gt),qe=i(e),m(C.$$.fragment,e),ve=i(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-kg8am5"&&(Z.innerHTML=yt),je=i(e),m(B.$$.fragment,e),Ce=i(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-11mx7fc"&&(Q.textContent=wt),Ze=i(e),m(L.$$.fragment,e),Be=i(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-63zx57"&&(z.innerHTML=Tt),Qe=i(e),m(U.$$.fragment,e),Le=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1mab3v0"&&(k.innerHTML=Jt),ze=i(e),m(x.$$.fragment,e),Ue=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-xd402n"&&(W.textContent=_t),ke=i(e),m(X.$$.fragment,e),xe=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-f32n60"&&(R.innerHTML=$t),We=i(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-7f0aai"&&(I.innerHTML=qt),Xe=i(e),m(E.$$.fragment,e),Re=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1c7jiea"&&(A.innerHTML=vt),Ie=i(e),m(F.$$.fragment,e),Ee=i(e),m(G.$$.fragment,e),Ae=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-h7ytse"&&(H.innerHTML=jt),Fe=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-120mr43"&&(N.innerHTML=Ct),Ge=i(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wlm3ol"&&(V.innerHTML=Zt),He=i(e),m(Y.$$.fragment,e),Ne=i(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1f1bzer"&&(S.innerHTML=Bt),Ve=i(e),m(P.$$.fragment,e),Ye=i(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-16tz5mo"&&(D.innerHTML=Qt),Se=i(e),m(K.$$.fragment,e),Pe=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-pxonbi"&&(O.innerHTML=Lt),De=i(e),m(ee.$$.fragment,e),Ke=i(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1wgonl8"&&(te.innerHTML=zt),Oe=i(e),m(le.$$.fragment,e),et=i(e),m(ne.$$.fragment,e),tt=i(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-17kgu1v"&&(ae.innerHTML=Ut),lt=i(e),m(ie.$$.fragment,e),nt=i(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-p9acs7"&&(se.textContent=kt),at=i(e),m(oe.$$.fragment,e),it=i(e),m(re.$$.fragment,e),st=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-agdyn7"&&(pe.textContent=xt),ot=i(e),me=o(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-83nivc"&&(me.innerHTML=Wt),rt=i(e),m(fe.$$.fragment,e),pt=i(e),de=o(e,"P",{}),Xt(de).forEach(l),this.h()},h(){Rt(c,"name","hf:doc:metadata"),Rt(c,"content",St)},m(e,t){Nt(document.head,c),n(e,he,t),n(e,ue,t),n(e,Me,t),f(g,e,t),n(e,ce,t),n(e,y,t),n(e,be,t),n(e,w,t),n(e,ge,t),n(e,T,t),n(e,ye,t),n(e,J,t),n(e,we,t),f(_,e,t),n(e,Te,t),n(e,$,t),n(e,Je,t),n(e,q,t),n(e,_e,t),f(v,e,t),n(e,$e,t),n(e,j,t),n(e,qe,t),f(C,e,t),n(e,ve,t),n(e,Z,t),n(e,je,t),f(B,e,t),n(e,Ce,t),n(e,Q,t),n(e,Ze,t),f(L,e,t),n(e,Be,t),n(e,z,t),n(e,Qe,t),f(U,e,t),n(e,Le,t),n(e,k,t),n(e,ze,t),f(x,e,t),n(e,Ue,t),n(e,W,t),n(e,ke,t),f(X,e,t),n(e,xe,t),n(e,R,t),n(e,We,t),n(e,I,t),n(e,Xe,t),f(E,e,t),n(e,Re,t),n(e,A,t),n(e,Ie,t),f(F,e,t),n(e,Ee,t),f(G,e,t),n(e,Ae,t),n(e,H,t),n(e,Fe,t),n(e,N,t),n(e,Ge,t),n(e,V,t),n(e,He,t),f(Y,e,t),n(e,Ne,t),n(e,S,t),n(e,Ve,t),f(P,e,t),n(e,Ye,t),n(e,D,t),n(e,Se,t),f(K,e,t),n(e,Pe,t),n(e,O,t),n(e,De,t),f(ee,e,t),n(e,Ke,t),n(e,te,t),n(e,Oe,t),f(le,e,t),n(e,et,t),f(ne,e,t),n(e,tt,t),n(e,ae,t),n(e,lt,t),f(ie,e,t),n(e,nt,t),n(e,se,t),n(e,at,t),f(oe,e,t),n(e,it,t),f(re,e,t),n(e,st,t),n(e,pe,t),n(e,ot,t),n(e,me,t),n(e,rt,t),f(fe,e,t),n(e,pt,t),n(e,de,t),mt=!0},p:Et,i(e){mt||(u(g.$$.fragment,e),u(_.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(U.$$.fragment,e),u(x.$$.fragment,e),u(X.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(G.$$.fragment,e),u(Y.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(fe.$$.fragment,e),mt=!0)},o(e){d(g.$$.fragment,e),d(_.$$.fragment,e),d(v.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(L.$$.fragment,e),d(U.$$.fragment,e),d(x.$$.fragment,e),d(X.$$.fragment,e),d(E.$$.fragment,e),d(F.$$.fragment,e),d(G.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(fe.$$.fragment,e),mt=!1},d(e){e&&(l(he),l(ue),l(Me),l(ce),l(y),l(be),l(w),l(ge),l(T),l(ye),l(J),l(we),l(Te),l($),l(Je),l(q),l(_e),l($e),l(j),l(qe),l(ve),l(Z),l(je),l(Ce),l(Q),l(Ze),l(Be),l(z),l(Qe),l(Le),l(k),l(ze),l(Ue),l(W),l(ke),l(xe),l(R),l(We),l(I),l(Xe),l(Re),l(A),l(Ie),l(Ee),l(Ae),l(H),l(Fe),l(N),l(Ge),l(V),l(He),l(Ne),l(S),l(Ve),l(Ye),l(D),l(Se),l(Pe),l(O),l(De),l(Ke),l(te),l(Oe),l(et),l(tt),l(ae),l(lt),l(nt),l(se),l(at),l(it),l(st),l(pe),l(ot),l(me),l(rt),l(pt),l(de)),l(c),h(g,e),h(_,e),h(v,e),h(C,e),h(B,e),h(L,e),h(U,e),h(x,e),h(X,e),h(E,e),h(F,e),h(G,e),h(Y,e),h(P,e),h(K,e),h(ee,e),h(le,e),h(ne,e),h(ie,e),h(oe,e),h(re,e),h(fe,e)}}}const St='{"title":"Quantization","local":"quantization","sections":[{"title":"Quantize a model","local":"quantize-a-model","sections":[],"depth":2},{"title":"LoraConfig","local":"loraconfig","sections":[{"title":"LoftQ initialization","local":"loftq-initialization","sections":[],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3}],"depth":2},{"title":"AQLM quantization","local":"aqlm-quantization","sections":[],"depth":2},{"title":"EETQ quantization","local":"eetq-quantization","sections":[],"depth":2},{"title":"HQQ quantization","local":"hqq-quantization","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Pt(ft){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tl extends Ft{constructor(c){super(),Gt(this,c,Pt,Yt,It,{})}}export{tl as component};
