import{s as Yi,o as qi,n as I}from"../chunks/scheduler.8c3d61f6.js";import{S as Qi,i as Ai,g as r,s as i,r as u,A as Oi,h as l,f as p,c as s,j,u as h,x as c,k as D,y as n,a as y,v as g,d as b,t as _,w as v}from"../chunks/index.589a98e8.js";import{T as _t}from"../chunks/Tip.42aa8582.js";import{D as P}from"../chunks/Docstring.27406313.js";import{C as te}from"../chunks/CodeBlock.36627b28.js";import{E as ee}from"../chunks/ExampleCodeBlock.3dc467a7.js";import{H as kn,E as Ki}from"../chunks/EditOnGithub.e5a8d9cb.js";function es(T){let o,x='You shouldn’t use the <a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/pr_7359/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/pr_7359/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',d,a,m,t,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=r("p"),o.innerHTML=x,d=i(),a=r("br"),m=i(),t=r("p"),t.innerHTML=M},l(Z){o=l(Z,"P",{"data-svelte-h":!0}),c(o)!=="svelte-bznqnl"&&(o.innerHTML=x),d=s(Z),a=l(Z,"BR",{}),m=s(Z),t=l(Z,"P",{"data-svelte-h":!0}),c(t)!=="svelte-1a94ctl"&&(t.innerHTML=M)},m(Z,z){y(Z,o,z),y(Z,d,z),y(Z,a,z),y(Z,m,z),y(Z,t,z)},p:I,d(Z){Z&&(p(o),p(d),p(a),p(m),p(t))}}}function ts(T){let o,x=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=r("p"),o.textContent=x},l(d){o=l(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-18gkv0g"&&(o.textContent=x)},m(d,a){y(d,o,a)},p:I,d(d){d&&p(o)}}}function ns(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFpbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyklMEFpbnBhaW50JTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW5wYWludFBpcGVsaW5lKCoqdGV4dDJpbWcuY29tcG9uZW50cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function os(T){let o,x=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=r("p"),o.innerHTML=x},l(d){o=l(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-6jnfc0"&&(o.innerHTML=x)},m(d,a){y(d,o,a)},p:I,d(d){d&&p(o)}}}function is(T){let o,x=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=r("p"),o.innerHTML=x},l(d){o=l(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-ackzsn"&&(o.innerHTML=x)},m(d,a){y(d,o,a)},p:I,d(d){d&&p(o)}}}function ss(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function as(T){let o,x=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=r("p"),o.textContent=x},l(d){o=l(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-17p1lpg"&&(o.textContent=x)},m(d,a){y(d,o,a)},p:I,d(d){d&&p(o)}}}function rs(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function ls(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQW5ld19waXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUuZnJvbV9waXBlKHBpcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function ds(T){let o,x="If you get the error message below, you need to finetune the weights for your downstream task:",d,a,m;return a=new te({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights <span class="hljs-keyword">of</span> UNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:
- conv_in.weight: found shape torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> checkpoint <span class="hljs-keyword">and</span> torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) <span class="hljs-keyword">in</span> <span class="hljs-keyword">the</span> model instantiated
You should probably TRAIN this model <span class="hljs-keyword">on</span> <span class="hljs-title">a</span> <span class="hljs-title">down-stream</span> <span class="hljs-title">task</span> <span class="hljs-title">to</span> <span class="hljs-title">be</span> <span class="hljs-title">able</span> <span class="hljs-title">to</span> <span class="hljs-title">use</span> <span class="hljs-title">it</span> <span class="hljs-title">for</span> <span class="hljs-title">predictions</span> <span class="hljs-title">and</span> <span class="hljs-title">inference</span>.`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function ps(T){let o,x=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=r("p"),o.innerHTML=x},l(d){o=l(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-x73rgs"&&(o.innerHTML=x)},m(d,a){y(d,o,a)},p:I,d(d){d&&p(o)}}}function fs(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBJTBBJTIzJTIwVXNlJTIwYSUyMGRpZmZlcmVudCUyMHNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwc2NoZWR1bGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function cs(T){let o,x="If you get the error message below, you need to finetune the weights for your downstream task:",d,a,m;return a=new te({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQQ==",highlighted:'Some weights <span class="hljs-keyword">of</span> FlaxUNet2DConditionModel were <span class="hljs-keyword">not</span> initialized <span class="hljs-built_in">from</span> <span class="hljs-keyword">the</span> model checkpoint <span class="hljs-keyword">at</span> runwayml/stable-diffusion-v1<span class="hljs-number">-5</span> <span class="hljs-keyword">and</span> are newly initialized because <span class="hljs-keyword">the</span> shapes did <span class="hljs-keyword">not</span> match:',wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function ms(T){let o,x=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>.`;return{c(){o=r("p"),o.innerHTML=x},l(d){o=l(d,"P",{"data-svelte-h":!0}),c(o)!=="svelte-6jnfc0"&&(o.innerHTML=x)},m(d,a){y(d,o,a)},p:I,d(d){d&&p(o)}}}function us(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJiZjE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwZHR5cGUlM0RqbnAuYmZsb2F0MTYlMkMlMEEpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyQyUyMGJ1dCUyMHVzZSUyMGElMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFkcG1wcCUyQyUyMGRwbXBwX3N0YXRlJTIwJTNEJTIwRmxheERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMEEpJTBBJTBBZHBtX3BpcGUlMkMlMjBkcG1fcGFyYW1zJTIwJTNEJTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUyMHZhcmlhbnQlM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqbnAuYmZsb2F0MTYlMkMlMjBzY2hlZHVsZXIlM0RkcG1wcCUwQSklMEFkcG1fcGFyYW1zJTVCJTIyc2NoZWR1bGVyJTIyJTVEJTIwJTNEJTIwZHBtcHBfc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, variant=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function hs(T){let o,x="Examples:",d,a,m;return a=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=r("p"),o.textContent=x,d=i(),u(a.$$.fragment)},l(t){o=l(t,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=x),d=s(t),h(a.$$.fragment,t)},m(t,M){y(t,o,M),y(t,d,M),g(a,t,M),m=!0},p:I,i(t){m||(b(a.$$.fragment,t),m=!0)},o(t){_(a.$$.fragment,t),m=!1},d(t){t&&(p(o),p(d)),v(a,t)}}}function gs(T){let o,x,d,a,m,t,M,Z="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",z,Ze,ii='All pipelines are built from the base <a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/pr_7359/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',cn,ne,mn,ke,si="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",un,Ce,ai='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="alt_diffusion">AltDiffusion</a></td> <td>image2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audio_diffusion">Audio Diffusion</a></td> <td>image2audio</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="cycle_diffusion">Cycle Diffusion</a></td> <td>image2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/gligen">GLIGEN</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="stable_diffusion/ldm3d_diffusion">LDM3D</a></td> <td>text2image, text-to-3D, text-to-pano, upscaling</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="paradigms">ParaDiGMS</a></td> <td>text2image</td></tr> <tr><td><a href="pix2pix_zero">Pix2Pix Zero</a></td> <td>image editing</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pndm">PNDM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="repaint">RePaint</a></td> <td>inpainting</td></tr> <tr><td><a href="score_sde_ve">Score SDE VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="spectrogram_diffusion">Spectrogram Diffusion</a></td> <td></td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="model_editing">Stable Diffusion Model Editing</a></td> <td>model editing</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stochastic_karras_ve">Stochastic Karras VE</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="latent_diffusion_uncond">Unconditional Latent Diffusion</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="versatile_diffusion">Versatile Diffusion</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="vq_diffusion">VQ Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr></tbody>',hn,Ie,gn,w,Ge,Cn,vt,ri="Base class for all pipelines.",In,yt,li=`<a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Gn,wt,di="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",Wn,xt,pi="Class attributes:",Hn,$t,fi=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,Vn,oe,We,Bn,Mt,ci="Call self as a function.",Fn,Tt,He,Ln,W,Ve,Sn,jt,mi=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,Nn,ie,En,Dt,ui="Here are the ways to call <code>to</code>:",Rn,Pt,hi=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,Xn,B,Be,zn,Ut,gi=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,Yn,Jt,bi=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,qn,se,Qn,ae,Fe,An,Zt,_i=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,On,re,Le,Kn,kt,vi='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',eo,Y,Se,to,Ct,yi="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",no,le,oo,F,Ne,io,It,wi=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,so,de,ao,pe,ro,fe,Ee,lo,Gt,xi=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,po,ce,Re,fo,Wt,$i=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,co,L,Xe,mo,Ht,Mi=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,uo,me,ho,ue,go,q,ze,bo,Vt,Ti=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,_o,he,vo,k,Ye,yo,Bt,ji="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",wo,Ft,Di="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",xo,ge,$o,be,Mo,_e,To,ve,qe,jo,Lt,Pi=`Function that offloads all components, removes all model hooks that were added when using
<code>enable_model_cpu_offload</code> and then applies them again. In case the model has not been offloaded this function
is a no-op. Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it
functions correctly when applying enable_model_cpu_offload.`,Do,ye,Qe,Po,St,Ui="Convert a NumPy image or a batch of images to a PIL image.",Uo,we,Ae,Jo,Nt,Ji="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",Zo,xe,Oe,ko,Et,Zi="Resets the device maps (if any) to None.",Co,$e,Ke,Io,Rt,ki=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,bn,H,et,Go,Xt,Ci='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Wo,zt,Ii="The suffixes after the scaling factors represent the stages where they are being applied.",Ho,Yt,Gi=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,_n,A,tt,Vo,qt,Wi="Disables the FreeU mechanism if enabled.",vn,nt,yn,U,ot,Bo,Qt,Hi="Base class for Flax-based pipelines.",Fo,At,Vi=`<a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Lo,Ot,Bi="<li>enable/disable the progress bar for the denoising iteration</li>",So,Kt,Fi="Class attributes:",No,en,Li=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,Eo,C,it,Ro,tn,Si="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",Xo,nn,Ni="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",zo,Me,Yo,Te,qo,je,Qo,De,st,Ao,on,Ei="Convert a NumPy image or a batch of images to a PIL image.",Oo,Pe,at,Ko,sn,Ri=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,wn,rt,xn,N,lt,ei,an,Xi="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",ti,Q,dt,ni,rn,zi="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",oi,Ue,$n,pt,Mn,pn,Tn;return m=new kn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),ne=new _t({props:{warning:!0,$$slots:{default:[es]},$$scope:{ctx:T}}}),Ie=new kn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),Ge=new P({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L127"}}),We=new P({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),He=new P({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L448",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Ve=new P({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L303",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),ie=new _t({props:{$$slots:{default:[ts]},$$scope:{ctx:T}}}),Be=new P({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1581"}}),se=new ee({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[ns]},$$scope:{ctx:T}}}),Fe=new P({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1743"}}),Le=new P({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1677"}}),Se=new P({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1181",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),le=new _t({props:{$$slots:{default:[os]},$$scope:{ctx:T}}}),Ne=new P({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1703"}}),de=new _t({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:T}}}),pe=new ee({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[ss]},$$scope:{ctx:T}}}),Ee=new P({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1015"}}),Re=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1107"}}),Xe=new P({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1642"}}),me=new _t({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:T}}}),ue=new ee({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[rs]},$$scope:{ctx:T}}}),ze=new P({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1759",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),he=new ee({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[ls]},$$scope:{ctx:T}}}),Ye=new P({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If &#x201C;auto&#x201D; is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L478"}}),ge=new ee({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[ds]},$$scope:{ctx:T}}}),be=new _t({props:{$$slots:{default:[ps]},$$scope:{ctx:T}}}),_e=new ee({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[fs]},$$scope:{ctx:T}}}),qe=new P({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1093"}}),Qe=new P({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1617"}}),Ae=new P({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1006"}}),Oe=new P({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1168"}}),Ke=new P({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L183"}}),et=new P({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1917"}}),tt=new P({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_utils.py#L1939"}}),nt=new kn({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),ot=new P({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),it=new P({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/pr_7359/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>str</code> or <code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype. If <code>&quot;auto&quot;</code>, the dtype is
automatically derived from the model&#x2019;s weights.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.
resume_download &#x2014;
Deprecated and ignored. All downloads are now resumed by default when possible. Will be removed in v1
of Diffusers.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),Me=new ee({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[cs]},$$scope:{ctx:T}}}),Te=new _t({props:{$$slots:{default:[ms]},$$scope:{ctx:T}}}),je=new ee({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[us]},$$scope:{ctx:T}}}),st=new P({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_flax_utils.py#L588"}}),at=new P({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": Union"},{name:"params",val:": Union"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/pr_7359/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),rt=new kn({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),lt=new P({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/utils/hub_utils.py#L502"}}),dt=new P({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Optional = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/vr_7359/src/diffusers/utils/hub_utils.py#L531"}}),Ue=new ee({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[hs]},$$scope:{ctx:T}}}),pt=new Ki({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){o=r("meta"),x=i(),d=r("p"),a=i(),u(m.$$.fragment),t=i(),M=r("p"),M.textContent=Z,z=i(),Ze=r("p"),Ze.innerHTML=ii,cn=i(),u(ne.$$.fragment),mn=i(),ke=r("p"),ke.textContent=si,un=i(),Ce=r("table"),Ce.innerHTML=ai,hn=i(),u(Ie.$$.fragment),gn=i(),w=r("div"),u(Ge.$$.fragment),Cn=i(),vt=r("p"),vt.textContent=ri,In=i(),yt=r("p"),yt.innerHTML=li,Gn=i(),wt=r("ul"),wt.innerHTML=di,Wn=i(),xt=r("p"),xt.textContent=pi,Hn=i(),$t=r("ul"),$t.innerHTML=fi,Vn=i(),oe=r("div"),u(We.$$.fragment),Bn=i(),Mt=r("p"),Mt.textContent=ci,Fn=i(),Tt=r("div"),u(He.$$.fragment),Ln=i(),W=r("div"),u(Ve.$$.fragment),Sn=i(),jt=r("p"),jt.innerHTML=mi,Nn=i(),u(ie.$$.fragment),En=i(),Dt=r("p"),Dt.innerHTML=ui,Rn=i(),Pt=r("ul"),Pt.innerHTML=hi,Xn=i(),B=r("div"),u(Be.$$.fragment),zn=i(),Ut=r("p"),Ut.innerHTML=gi,Yn=i(),Jt=r("p"),Jt.innerHTML=bi,qn=i(),u(se.$$.fragment),Qn=i(),ae=r("div"),u(Fe.$$.fragment),An=i(),Zt=r("p"),Zt.innerHTML=_i,On=i(),re=r("div"),u(Le.$$.fragment),Kn=i(),kt=r("p"),kt.innerHTML=vi,eo=i(),Y=r("div"),u(Se.$$.fragment),to=i(),Ct=r("p"),Ct.textContent=yi,no=i(),u(le.$$.fragment),oo=i(),F=r("div"),u(Ne.$$.fragment),io=i(),It=r("p"),It.textContent=wi,so=i(),u(de.$$.fragment),ao=i(),u(pe.$$.fragment),ro=i(),fe=r("div"),u(Ee.$$.fragment),lo=i(),Gt=r("p"),Gt.innerHTML=xi,po=i(),ce=r("div"),u(Re.$$.fragment),fo=i(),Wt=r("p"),Wt.innerHTML=$i,co=i(),L=r("div"),u(Xe.$$.fragment),mo=i(),Ht=r("p"),Ht.innerHTML=Mi,uo=i(),u(me.$$.fragment),ho=i(),u(ue.$$.fragment),go=i(),q=r("div"),u(ze.$$.fragment),bo=i(),Vt=r("p"),Vt.textContent=Ti,_o=i(),u(he.$$.fragment),vo=i(),k=r("div"),u(Ye.$$.fragment),yo=i(),Bt=r("p"),Bt.textContent=ji,wo=i(),Ft=r("p"),Ft.innerHTML=Di,xo=i(),u(ge.$$.fragment),$o=i(),u(be.$$.fragment),Mo=i(),u(_e.$$.fragment),To=i(),ve=r("div"),u(qe.$$.fragment),jo=i(),Lt=r("p"),Lt.innerHTML=Pi,Do=i(),ye=r("div"),u(Qe.$$.fragment),Po=i(),St=r("p"),St.textContent=Ui,Uo=i(),we=r("div"),u(Ae.$$.fragment),Jo=i(),Nt=r("p"),Nt.innerHTML=Ji,Zo=i(),xe=r("div"),u(Oe.$$.fragment),ko=i(),Et=r("p"),Et.textContent=Zi,Co=i(),$e=r("div"),u(Ke.$$.fragment),Io=i(),Rt=r("p"),Rt.innerHTML=ki,bn=i(),H=r("div"),u(et.$$.fragment),Go=i(),Xt=r("p"),Xt.innerHTML=Ci,Wo=i(),zt=r("p"),zt.textContent=Ii,Ho=i(),Yt=r("p"),Yt.innerHTML=Gi,_n=i(),A=r("div"),u(tt.$$.fragment),Vo=i(),qt=r("p"),qt.textContent=Wi,vn=i(),u(nt.$$.fragment),yn=i(),U=r("div"),u(ot.$$.fragment),Bo=i(),Qt=r("p"),Qt.textContent=Hi,Fo=i(),At=r("p"),At.innerHTML=Vi,Lo=i(),Ot=r("ul"),Ot.innerHTML=Bi,So=i(),Kt=r("p"),Kt.textContent=Fi,No=i(),en=r("ul"),en.innerHTML=Li,Eo=i(),C=r("div"),u(it.$$.fragment),Ro=i(),tn=r("p"),tn.textContent=Si,Xo=i(),nn=r("p"),nn.textContent=Ni,zo=i(),u(Me.$$.fragment),Yo=i(),u(Te.$$.fragment),qo=i(),u(je.$$.fragment),Qo=i(),De=r("div"),u(st.$$.fragment),Ao=i(),on=r("p"),on.textContent=Ei,Oo=i(),Pe=r("div"),u(at.$$.fragment),Ko=i(),sn=r("p"),sn.innerHTML=Ri,wn=i(),u(rt.$$.fragment),xn=i(),N=r("div"),u(lt.$$.fragment),ei=i(),an=r("p"),an.textContent=Xi,ti=i(),Q=r("div"),u(dt.$$.fragment),ni=i(),rn=r("p"),rn.textContent=zi,oi=i(),u(Ue.$$.fragment),$n=i(),u(pt.$$.fragment),Mn=i(),pn=r("p"),this.h()},l(e){const f=Oi("svelte-u9bgzb",document.head);o=l(f,"META",{name:!0,content:!0}),f.forEach(p),x=s(e),d=l(e,"P",{}),j(d).forEach(p),a=s(e),h(m.$$.fragment,e),t=s(e),M=l(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-eejdx6"&&(M.textContent=Z),z=s(e),Ze=l(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-19q6sjd"&&(Ze.innerHTML=ii),cn=s(e),h(ne.$$.fragment,e),mn=s(e),ke=l(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-2xd39c"&&(ke.textContent=si),un=s(e),Ce=l(e,"TABLE",{"data-svelte-h":!0}),c(Ce)!=="svelte-156aj54"&&(Ce.innerHTML=ai),hn=s(e),h(Ie.$$.fragment,e),gn=s(e),w=l(e,"DIV",{class:!0});var $=j(w);h(Ge.$$.fragment,$),Cn=s($),vt=l($,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1neg3rw"&&(vt.textContent=ri),In=s($),yt=l($,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-1xvza0e"&&(yt.innerHTML=li),Gn=s($),wt=l($,"UL",{"data-svelte-h":!0}),c(wt)!=="svelte-2a5chx"&&(wt.innerHTML=di),Wn=s($),xt=l($,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-wz8va1"&&(xt.textContent=pi),Hn=s($),$t=l($,"UL",{"data-svelte-h":!0}),c($t)!=="svelte-1ilr6sx"&&($t.innerHTML=fi),Vn=s($),oe=l($,"DIV",{class:!0});var ft=j(oe);h(We.$$.fragment,ft),Bn=s(ft),Mt=l(ft,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1eed40t"&&(Mt.textContent=ci),ft.forEach(p),Fn=s($),Tt=l($,"DIV",{class:!0});var fn=j(Tt);h(He.$$.fragment,fn),fn.forEach(p),Ln=s($),W=l($,"DIV",{class:!0});var V=j(W);h(Ve.$$.fragment,V),Sn=s(V),jt=l(V,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-1vbhnip"&&(jt.innerHTML=mi),Nn=s(V),h(ie.$$.fragment,V),En=s(V),Dt=l(V,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-5ul9n2"&&(Dt.innerHTML=ui),Rn=s(V),Pt=l(V,"UL",{"data-svelte-h":!0}),c(Pt)!=="svelte-1icy6l9"&&(Pt.innerHTML=hi),V.forEach(p),Xn=s($),B=l($,"DIV",{class:!0});var E=j(B);h(Be.$$.fragment,E),zn=s(E),Ut=l(E,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-had4mb"&&(Ut.innerHTML=gi),Yn=s(E),Jt=l(E,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-19k67ce"&&(Jt.innerHTML=bi),qn=s(E),h(se.$$.fragment,E),E.forEach(p),Qn=s($),ae=l($,"DIV",{class:!0});var ct=j(ae);h(Fe.$$.fragment,ct),An=s(ct),Zt=l(ct,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-1lh0nh5"&&(Zt.innerHTML=_i),ct.forEach(p),On=s($),re=l($,"DIV",{class:!0});var mt=j(re);h(Le.$$.fragment,mt),Kn=s(mt),kt=l(mt,"P",{"data-svelte-h":!0}),c(kt)!=="svelte-1vfte1e"&&(kt.innerHTML=vi),mt.forEach(p),eo=s($),Y=l($,"DIV",{class:!0});var O=j(Y);h(Se.$$.fragment,O),to=s(O),Ct=l(O,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-1mfctah"&&(Ct.textContent=yi),no=s(O),h(le.$$.fragment,O),O.forEach(p),oo=s($),F=l($,"DIV",{class:!0});var R=j(F);h(Ne.$$.fragment,R),io=s(R),It=l(R,"P",{"data-svelte-h":!0}),c(It)!=="svelte-10jaql7"&&(It.textContent=wi),so=s(R),h(de.$$.fragment,R),ao=s(R),h(pe.$$.fragment,R),R.forEach(p),ro=s($),fe=l($,"DIV",{class:!0});var ut=j(fe);h(Ee.$$.fragment,ut),lo=s(ut),Gt=l(ut,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-d7vywi"&&(Gt.innerHTML=xi),ut.forEach(p),po=s($),ce=l($,"DIV",{class:!0});var ht=j(ce);h(Re.$$.fragment,ht),fo=s(ht),Wt=l(ht,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-n1oyuv"&&(Wt.innerHTML=$i),ht.forEach(p),co=s($),L=l($,"DIV",{class:!0});var X=j(L);h(Xe.$$.fragment,X),mo=s(X),Ht=l(X,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-e03q3e"&&(Ht.innerHTML=Mi),uo=s(X),h(me.$$.fragment,X),ho=s(X),h(ue.$$.fragment,X),X.forEach(p),go=s($),q=l($,"DIV",{class:!0});var K=j(q);h(ze.$$.fragment,K),bo=s(K),Vt=l(K,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-1jx3icn"&&(Vt.textContent=Ti),_o=s(K),h(he.$$.fragment,K),K.forEach(p),vo=s($),k=l($,"DIV",{class:!0});var G=j(k);h(Ye.$$.fragment,G),yo=s(G),Bt=l(G,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-ccbjek"&&(Bt.textContent=ji),wo=s(G),Ft=l(G,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1p5vgmd"&&(Ft.innerHTML=Di),xo=s(G),h(ge.$$.fragment,G),$o=s(G),h(be.$$.fragment,G),Mo=s(G),h(_e.$$.fragment,G),G.forEach(p),To=s($),ve=l($,"DIV",{class:!0});var gt=j(ve);h(qe.$$.fragment,gt),jo=s(gt),Lt=l(gt,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-zkab0b"&&(Lt.innerHTML=Pi),gt.forEach(p),Do=s($),ye=l($,"DIV",{class:!0});var bt=j(ye);h(Qe.$$.fragment,bt),Po=s(bt),St=l(bt,"P",{"data-svelte-h":!0}),c(St)!=="svelte-1gut907"&&(St.textContent=Ui),bt.forEach(p),Uo=s($),we=l($,"DIV",{class:!0});var jn=j(we);h(Ae.$$.fragment,jn),Jo=s(jn),Nt=l(jn,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-8kophh"&&(Nt.innerHTML=Ji),jn.forEach(p),Zo=s($),xe=l($,"DIV",{class:!0});var Dn=j(xe);h(Oe.$$.fragment,Dn),ko=s(Dn),Et=l(Dn,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-6tjysh"&&(Et.textContent=Zi),Dn.forEach(p),Co=s($),$e=l($,"DIV",{class:!0});var Pn=j($e);h(Ke.$$.fragment,Pn),Io=s(Pn),Rt=l(Pn,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-2d0d24"&&(Rt.innerHTML=ki),Pn.forEach(p),$.forEach(p),bn=s(e),H=l(e,"DIV",{class:!0});var Je=j(H);h(et.$$.fragment,Je),Go=s(Je),Xt=l(Je,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-1f3tmq1"&&(Xt.innerHTML=Ci),Wo=s(Je),zt=l(Je,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-xjijlp"&&(zt.textContent=Ii),Ho=s(Je),Yt=l(Je,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-hy0nzs"&&(Yt.innerHTML=Gi),Je.forEach(p),_n=s(e),A=l(e,"DIV",{class:!0});var Un=j(A);h(tt.$$.fragment,Un),Vo=s(Un),qt=l(Un,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-psupw6"&&(qt.textContent=Wi),Un.forEach(p),vn=s(e),h(nt.$$.fragment,e),yn=s(e),U=l(e,"DIV",{class:!0});var J=j(U);h(ot.$$.fragment,J),Bo=s(J),Qt=l(J,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-1o1wti6"&&(Qt.textContent=Hi),Fo=s(J),At=l(J,"P",{"data-svelte-h":!0}),c(At)!=="svelte-14c92ja"&&(At.innerHTML=Vi),Lo=s(J),Ot=l(J,"UL",{"data-svelte-h":!0}),c(Ot)!=="svelte-1kk3msp"&&(Ot.innerHTML=Bi),So=s(J),Kt=l(J,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-wz8va1"&&(Kt.textContent=Fi),No=s(J),en=l(J,"UL",{"data-svelte-h":!0}),c(en)!=="svelte-56flce"&&(en.innerHTML=Li),Eo=s(J),C=l(J,"DIV",{class:!0});var S=j(C);h(it.$$.fragment,S),Ro=s(S),tn=l(S,"P",{"data-svelte-h":!0}),c(tn)!=="svelte-7z61o"&&(tn.textContent=Si),Xo=s(S),nn=l(S,"P",{"data-svelte-h":!0}),c(nn)!=="svelte-wyh2cr"&&(nn.textContent=Ni),zo=s(S),h(Me.$$.fragment,S),Yo=s(S),h(Te.$$.fragment,S),qo=s(S),h(je.$$.fragment,S),S.forEach(p),Qo=s(J),De=l(J,"DIV",{class:!0});var Jn=j(De);h(st.$$.fragment,Jn),Ao=s(Jn),on=l(Jn,"P",{"data-svelte-h":!0}),c(on)!=="svelte-1gut907"&&(on.textContent=Ei),Jn.forEach(p),Oo=s(J),Pe=l(J,"DIV",{class:!0});var Zn=j(Pe);h(at.$$.fragment,Zn),Ko=s(Zn),sn=l(Zn,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-1fx09xr"&&(sn.innerHTML=Ri),Zn.forEach(p),J.forEach(p),wn=s(e),h(rt.$$.fragment,e),xn=s(e),N=l(e,"DIV",{class:!0});var ln=j(N);h(lt.$$.fragment,ln),ei=s(ln),an=l(ln,"P",{"data-svelte-h":!0}),c(an)!=="svelte-7y8zei"&&(an.textContent=Xi),ti=s(ln),Q=l(ln,"DIV",{class:!0});var dn=j(Q);h(dt.$$.fragment,dn),ni=s(dn),rn=l(dn,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-5nfhmh"&&(rn.textContent=zi),oi=s(dn),h(Ue.$$.fragment,dn),dn.forEach(p),ln.forEach(p),$n=s(e),h(pt.$$.fragment,e),Mn=s(e),pn=l(e,"P",{}),j(pn).forEach(p),this.h()},h(){D(o,"name","hf:doc:metadata"),D(o,"content",bs),D(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){n(document.head,o),y(e,x,f),y(e,d,f),y(e,a,f),g(m,e,f),y(e,t,f),y(e,M,f),y(e,z,f),y(e,Ze,f),y(e,cn,f),g(ne,e,f),y(e,mn,f),y(e,ke,f),y(e,un,f),y(e,Ce,f),y(e,hn,f),g(Ie,e,f),y(e,gn,f),y(e,w,f),g(Ge,w,null),n(w,Cn),n(w,vt),n(w,In),n(w,yt),n(w,Gn),n(w,wt),n(w,Wn),n(w,xt),n(w,Hn),n(w,$t),n(w,Vn),n(w,oe),g(We,oe,null),n(oe,Bn),n(oe,Mt),n(w,Fn),n(w,Tt),g(He,Tt,null),n(w,Ln),n(w,W),g(Ve,W,null),n(W,Sn),n(W,jt),n(W,Nn),g(ie,W,null),n(W,En),n(W,Dt),n(W,Rn),n(W,Pt),n(w,Xn),n(w,B),g(Be,B,null),n(B,zn),n(B,Ut),n(B,Yn),n(B,Jt),n(B,qn),g(se,B,null),n(w,Qn),n(w,ae),g(Fe,ae,null),n(ae,An),n(ae,Zt),n(w,On),n(w,re),g(Le,re,null),n(re,Kn),n(re,kt),n(w,eo),n(w,Y),g(Se,Y,null),n(Y,to),n(Y,Ct),n(Y,no),g(le,Y,null),n(w,oo),n(w,F),g(Ne,F,null),n(F,io),n(F,It),n(F,so),g(de,F,null),n(F,ao),g(pe,F,null),n(w,ro),n(w,fe),g(Ee,fe,null),n(fe,lo),n(fe,Gt),n(w,po),n(w,ce),g(Re,ce,null),n(ce,fo),n(ce,Wt),n(w,co),n(w,L),g(Xe,L,null),n(L,mo),n(L,Ht),n(L,uo),g(me,L,null),n(L,ho),g(ue,L,null),n(w,go),n(w,q),g(ze,q,null),n(q,bo),n(q,Vt),n(q,_o),g(he,q,null),n(w,vo),n(w,k),g(Ye,k,null),n(k,yo),n(k,Bt),n(k,wo),n(k,Ft),n(k,xo),g(ge,k,null),n(k,$o),g(be,k,null),n(k,Mo),g(_e,k,null),n(w,To),n(w,ve),g(qe,ve,null),n(ve,jo),n(ve,Lt),n(w,Do),n(w,ye),g(Qe,ye,null),n(ye,Po),n(ye,St),n(w,Uo),n(w,we),g(Ae,we,null),n(we,Jo),n(we,Nt),n(w,Zo),n(w,xe),g(Oe,xe,null),n(xe,ko),n(xe,Et),n(w,Co),n(w,$e),g(Ke,$e,null),n($e,Io),n($e,Rt),y(e,bn,f),y(e,H,f),g(et,H,null),n(H,Go),n(H,Xt),n(H,Wo),n(H,zt),n(H,Ho),n(H,Yt),y(e,_n,f),y(e,A,f),g(tt,A,null),n(A,Vo),n(A,qt),y(e,vn,f),g(nt,e,f),y(e,yn,f),y(e,U,f),g(ot,U,null),n(U,Bo),n(U,Qt),n(U,Fo),n(U,At),n(U,Lo),n(U,Ot),n(U,So),n(U,Kt),n(U,No),n(U,en),n(U,Eo),n(U,C),g(it,C,null),n(C,Ro),n(C,tn),n(C,Xo),n(C,nn),n(C,zo),g(Me,C,null),n(C,Yo),g(Te,C,null),n(C,qo),g(je,C,null),n(U,Qo),n(U,De),g(st,De,null),n(De,Ao),n(De,on),n(U,Oo),n(U,Pe),g(at,Pe,null),n(Pe,Ko),n(Pe,sn),y(e,wn,f),g(rt,e,f),y(e,xn,f),y(e,N,f),g(lt,N,null),n(N,ei),n(N,an),n(N,ti),n(N,Q),g(dt,Q,null),n(Q,ni),n(Q,rn),n(Q,oi),g(Ue,Q,null),y(e,$n,f),g(pt,e,f),y(e,Mn,f),y(e,pn,f),Tn=!0},p(e,[f]){const $={};f&2&&($.$$scope={dirty:f,ctx:e}),ne.$set($);const ft={};f&2&&(ft.$$scope={dirty:f,ctx:e}),ie.$set(ft);const fn={};f&2&&(fn.$$scope={dirty:f,ctx:e}),se.$set(fn);const V={};f&2&&(V.$$scope={dirty:f,ctx:e}),le.$set(V);const E={};f&2&&(E.$$scope={dirty:f,ctx:e}),de.$set(E);const ct={};f&2&&(ct.$$scope={dirty:f,ctx:e}),pe.$set(ct);const mt={};f&2&&(mt.$$scope={dirty:f,ctx:e}),me.$set(mt);const O={};f&2&&(O.$$scope={dirty:f,ctx:e}),ue.$set(O);const R={};f&2&&(R.$$scope={dirty:f,ctx:e}),he.$set(R);const ut={};f&2&&(ut.$$scope={dirty:f,ctx:e}),ge.$set(ut);const ht={};f&2&&(ht.$$scope={dirty:f,ctx:e}),be.$set(ht);const X={};f&2&&(X.$$scope={dirty:f,ctx:e}),_e.$set(X);const K={};f&2&&(K.$$scope={dirty:f,ctx:e}),Me.$set(K);const G={};f&2&&(G.$$scope={dirty:f,ctx:e}),Te.$set(G);const gt={};f&2&&(gt.$$scope={dirty:f,ctx:e}),je.$set(gt);const bt={};f&2&&(bt.$$scope={dirty:f,ctx:e}),Ue.$set(bt)},i(e){Tn||(b(m.$$.fragment,e),b(ne.$$.fragment,e),b(Ie.$$.fragment,e),b(Ge.$$.fragment,e),b(We.$$.fragment,e),b(He.$$.fragment,e),b(Ve.$$.fragment,e),b(ie.$$.fragment,e),b(Be.$$.fragment,e),b(se.$$.fragment,e),b(Fe.$$.fragment,e),b(Le.$$.fragment,e),b(Se.$$.fragment,e),b(le.$$.fragment,e),b(Ne.$$.fragment,e),b(de.$$.fragment,e),b(pe.$$.fragment,e),b(Ee.$$.fragment,e),b(Re.$$.fragment,e),b(Xe.$$.fragment,e),b(me.$$.fragment,e),b(ue.$$.fragment,e),b(ze.$$.fragment,e),b(he.$$.fragment,e),b(Ye.$$.fragment,e),b(ge.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(qe.$$.fragment,e),b(Qe.$$.fragment,e),b(Ae.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(it.$$.fragment,e),b(Me.$$.fragment,e),b(Te.$$.fragment,e),b(je.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(rt.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(Ue.$$.fragment,e),b(pt.$$.fragment,e),Tn=!0)},o(e){_(m.$$.fragment,e),_(ne.$$.fragment,e),_(Ie.$$.fragment,e),_(Ge.$$.fragment,e),_(We.$$.fragment,e),_(He.$$.fragment,e),_(Ve.$$.fragment,e),_(ie.$$.fragment,e),_(Be.$$.fragment,e),_(se.$$.fragment,e),_(Fe.$$.fragment,e),_(Le.$$.fragment,e),_(Se.$$.fragment,e),_(le.$$.fragment,e),_(Ne.$$.fragment,e),_(de.$$.fragment,e),_(pe.$$.fragment,e),_(Ee.$$.fragment,e),_(Re.$$.fragment,e),_(Xe.$$.fragment,e),_(me.$$.fragment,e),_(ue.$$.fragment,e),_(ze.$$.fragment,e),_(he.$$.fragment,e),_(Ye.$$.fragment,e),_(ge.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(qe.$$.fragment,e),_(Qe.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(it.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(je.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(Ue.$$.fragment,e),_(pt.$$.fragment,e),Tn=!1},d(e){e&&(p(x),p(d),p(a),p(t),p(M),p(z),p(Ze),p(cn),p(mn),p(ke),p(un),p(Ce),p(hn),p(gn),p(w),p(bn),p(H),p(_n),p(A),p(vn),p(yn),p(U),p(wn),p(xn),p(N),p($n),p(Mn),p(pn)),p(o),v(m,e),v(ne,e),v(Ie,e),v(Ge),v(We),v(He),v(Ve),v(ie),v(Be),v(se),v(Fe),v(Le),v(Se),v(le),v(Ne),v(de),v(pe),v(Ee),v(Re),v(Xe),v(me),v(ue),v(ze),v(he),v(Ye),v(ge),v(be),v(_e),v(qe),v(Qe),v(Ae),v(Oe),v(Ke),v(et),v(tt),v(nt,e),v(ot),v(it),v(Me),v(Te),v(je),v(st),v(at),v(rt,e),v(lt),v(dt),v(Ue),v(pt,e)}}}const bs='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function _s(T){return qi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends Qi{constructor(o){super(),Ai(this,o,_s,gs,Yi,{})}}export{js as component};
