import{s as _s,n as Qs,o as Fs}from"../chunks/scheduler.f7e1785c.js";import{S as Ys,i as qs,g as f,s as n,r as a,A as Ps,h as g,f as s,c as i,j as Ns,u as r,x as h,k as Ls,y as Ks,a as l,v as p,d as o,t as m,w as c}from"../chunks/index.9f8f0838.js";import{C as M}from"../chunks/CodeBlock.4baef5d7.js";import{H as d,E as Ds}from"../chunks/getInferenceSnippets.00780c44.js";function Os(ws){let w,Le,Xe,_e,u,Qe,y,us="While 🤗 Transformers provides an excellent foundation for ASR with models like Whisper, Moonshine, and Kyutai STT, the broader ASR ecosystem offers numerous optimized implementations that can significantly improve performance, reduce resource usage, and enable deployment in resource-constrained environments.",Fe,T,ys="This section explores high-performance alternatives, platform-specific optimizations, and specialized architectures that complement the transformers ecosystem while offering different trade-offs for speed, memory usage, and deployment scenarios.",Ye,$,qe,J,Pe,j,Ts='<a href="https://github.com/ggml-org/whisper.cpp" rel="nofollow">whisper.cpp</a> is a C++ port of OpenAI’s Whisper model that delivers exceptional performance improvements, particularly for CPU-based inference and edge deployment.',Ke,b,De,U,$s="<li><strong>10x faster inference</strong> on CPU compared to the original Python implementation</li> <li><strong>Extremely low memory usage</strong> - runs on devices with limited RAM</li> <li><strong>Cross-platform support</strong> - works on macOS, Linux, Windows, iOS, Android</li> <li><strong>Apple Silicon optimization</strong> - leverages Apple Neural Engine (ANE) for 3x additional speedup</li> <li><strong>No dependencies</strong> - self-contained C++ implementation</li>",Oe,I,et,C,Js="<li><strong>Memory</strong>: Lowest VRAM consumption among all implementations</li> <li><strong>Speed</strong>: Excellent CPU performance, especially on Apple Silicon</li> <li><strong>Accuracy</strong>: ~75% transcription accuracy (some degradation from original)</li> <li><strong>Deployment</strong>: Ideal for edge devices and mobile applications</li>",tt,v,st,W,lt,B,nt,Z,it,G,at,A,js="<li><strong>Edge computing</strong> and IoT devices</li> <li><strong>Mobile applications</strong> requiring offline processing</li> <li><strong>CPU-only environments</strong> without GPU acceleration</li> <li><strong>Memory-constrained</strong> systems</li> <li><strong>Real-time processing</strong> on low-power hardware</li>",rt,x,pt,k,bs='<a href="https://github.com/SYSTRAN/faster-whisper" rel="nofollow">faster-whisper</a> is a reimplementation of Whisper using CTranslate2, delivering significant performance improvements while maintaining full accuracy.',ot,z,mt,V,Us="<li><strong>4x faster inference</strong> than the original Whisper</li> <li><strong>Same accuracy</strong> as the original implementation</li> <li><strong>Lower memory usage</strong> through optimized memory management</li> <li><strong>GPU and CPU support</strong> with automatic optimization</li> <li><strong>Streaming support</strong> for real-time applications</li>",ct,S,dt,R,Is="<li><strong>Speed</strong>: 4x faster than original, excellent GPU utilization</li> <li><strong>Memory</strong>: Reduced memory footprint</li> <li><strong>Accuracy</strong>: 100% accuracy preservation</li> <li><strong>Deployment</strong>: Ideal for server-based applications</li>",ft,E,gt,H,ht,X,Mt,N,wt,L,ut,_,yt,Q,Tt,F,Cs='<a href="https://github.com/ml-explore/mlx-examples/tree/main/whisper" rel="nofollow">MLX-Whisper</a> leverages Apple’s MLX framework for optimal performance on Apple Silicon devices.',$t,Y,Jt,q,vs="<li><strong>50% faster</strong> than standard Whisper on Apple Silicon</li> <li><strong>Native Metal performance</strong> shading language integration</li> <li><strong>Memory efficient</strong> unified memory architecture utilization</li> <li><strong>Energy efficient</strong> for mobile and laptop deployment</li>",jt,P,bt,K,Ws="<li><strong>Speed</strong>: 2x faster on Apple Silicon devices</li> <li><strong>Memory</strong>: Optimized for unified memory architecture</li> <li><strong>Accuracy</strong>: Full accuracy preservation</li> <li><strong>Deployment</strong>: Exclusive to Apple Silicon (M1, M2, M3, M4)</li>",Ut,D,It,O,Ct,ee,vt,te,Wt,se,Bt,le,Zt,ne,Bs='<a href="https://github.com/argmaxinc/WhisperKit" rel="nofollow">WhisperKit</a> provides production-ready on-device speech recognition for Apple platforms.',Gt,ie,At,ae,Zs="<li><strong>On-device processing</strong> with privacy guarantees</li> <li><strong>Core ML integration</strong> for optimal performance</li> <li><strong>iOS and macOS support</strong> with native Swift APIs</li> <li><strong>Real-time transcription</strong> capabilities</li>",xt,re,kt,pe,zt,oe,Gs="Conformer architectures offer competitive performance with significantly lower computational requirements, making them ideal for edge deployment.",Vt,me,St,ce,As="<li><strong>5.26x faster than real-time</strong> on wearable devices</li> <li><strong>Low power consumption</strong> optimized for battery-powered devices</li> <li><strong>Depthwise separable convolutions</strong> reducing computational complexity from 32.8% to 4.0%</li> <li><strong>Streaming capabilities</strong> for real-time applications</li>",Rt,de,Et,fe,xs="<thead><tr><th>Implementation</th> <th>Speed vs Original</th> <th>Memory Usage</th> <th>Platform Focus</th> <th>Accuracy vs Original</th> <th>Use Case</th></tr></thead> <tbody><tr><td><strong>whisper.cpp</strong></td> <td>10x faster (CPU)</td> <td>Very Low</td> <td>Cross-platform</td> <td>~75%</td> <td>Edge/Mobile</td></tr> <tr><td><strong>faster-whisper</strong></td> <td>4x faster</td> <td>Low</td> <td>GPU/CPU</td> <td>100%</td> <td>Server/Cloud</td></tr> <tr><td><strong>MLX-Whisper</strong></td> <td>2x faster</td> <td>Medium</td> <td>Apple Silicon</td> <td>100%</td> <td>Apple devices</td></tr> <tr><td><strong>Lightning-Whisper-MLX</strong></td> <td>10x faster</td> <td>Medium</td> <td>Apple Silicon</td> <td>~98%</td> <td>Apple real-time</td></tr> <tr><td><strong>WhisperKit</strong></td> <td>3x faster</td> <td>Low</td> <td>Apple Mobile</td> <td>100%</td> <td>iOS/macOS apps</td></tr> <tr><td><strong>Conformer</strong></td> <td>5.26x realtime</td> <td>Very Low</td> <td>Edge devices</td> <td>Competitive</td> <td>Wearables</td></tr></tbody>",Ht,ge,Xt,he,Nt,Me,Lt,we,ks="<li><strong>Minimum RAM</strong>: 1GB for small models, 4GB for medium models</li> <li><strong>CPU</strong>: ARM Cortex-A78 or equivalent x86_64</li> <li><strong>GPU</strong>: Optional but recommended for real-time applications</li> <li><strong>Storage</strong>: 200MB for tiny models, 1GB for small models</li>",_t,ue,Qt,ye,zs="<li><strong>Model Quantization</strong>: Reduce model size by 75% with minimal accuracy loss</li> <li><strong>Pruning</strong>: Remove unnecessary parameters for faster inference</li> <li><strong>Knowledge Distillation</strong>: Create smaller models that maintain accuracy</li> <li><strong>Memory Mapping</strong>: Load models efficiently on resource-constrained devices</li>",Ft,Te,Yt,$e,qt,Je,Pt,je,Kt,be,Dt,Ue,Ot,Ie,es,Ce,ts,ve,ss,We,ls,Be,ns,Ze,is,Ge,as,Ae,Vs="<li><strong>For Production Servers</strong>: Use <strong>faster-whisper</strong> for the best balance of speed and accuracy</li> <li><strong>For Real-Time Applications</strong>: Use <strong>Lightning-Whisper-MLX</strong></li> <li><strong>For Edge/Mobile Devices</strong>: Use <strong>whisper.cpp</strong> or <strong>WhisperKit</strong> (Apple)</li> <li><strong>For Apple Silicon</strong>: Use <strong>MLX-Whisper</strong> or <strong>Lightning-Whisper-MLX</strong></li> <li><strong>For Wearables</strong>: Use <strong>Conformer-based</strong> models</li>",rs,xe,ps,ke,Ss="<li><strong>Model Selection</strong>: Choose the smallest model that meets your accuracy requirements</li> <li><strong>Quantization</strong>: Use INT8 quantization for 4x speed improvement with minimal accuracy loss</li> <li><strong>Batching</strong>: Process multiple audio files simultaneously when possible</li> <li><strong>Memory Management</strong>: Use memory mapping for large models on resource-constrained devices</li> <li><strong>Preprocessing</strong>: Ensure audio is properly formatted (16kHz, mono) before transcription</li>",os,ze,ms,Ve,Rs="The ASR ecosystem extends far beyond transformers-based implementations, offering specialized solutions for different deployment scenarios:",cs,Se,Es="<li><strong>whisper.cpp</strong> excels in edge computing and mobile deployment with minimal resource usage</li> <li><strong>faster-whisper</strong> provides the best balance of speed and accuracy for server deployments</li> <li><strong>MLX-Whisper</strong> optimizes performance specifically for Apple Silicon devices</li> <li><strong>Conformer-based models</strong> offer efficient alternatives for resource-constrained environments</li>",ds,Re,Hs="The choice between these implementations depends on your specific requirements for speed, accuracy, memory usage, and deployment environment. Many applications benefit from using multiple implementations in combination, leveraging the strengths of each for different components of the speech recognition pipeline.",fs,Ee,Xs="In the next section, we’ll explore how to evaluate these different implementations and choose the right metrics for your specific use case.",gs,He,hs,Ne,Ms;return u=new d({props:{title:"Alternative ASR Implementations: Beyond Transformers",local:"alternative-asr-implementations-beyond-transformers",headingTag:"h1"}}),$=new d({props:{title:"High-Performance Optimized Implementations",local:"high-performance-optimized-implementations",headingTag:"h2"}}),J=new d({props:{title:"whisper.cpp: C++ Port for Maximum Efficiency",local:"whispercpp-c-port-for-maximum-efficiency",headingTag:"h3"}}),b=new d({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),I=new d({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),v=new d({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),W=new M({props:{code:"JTIzJTIwQ2xvbmUlMjBhbmQlMjBidWlsZCUwQWdpdCUyMGNsb25lJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGZ2dtbC1vcmclMkZ3aGlzcGVyLmNwcC5naXQlMEFjZCUyMHdoaXNwZXIuY3BwJTBBbWFrZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwYSUyMG1vZGVsJTIwKGUuZy4lMkMlMjBzbWFsbCUyMG1vZGVsKSUwQWJhc2glMjAuJTJGbW9kZWxzJTJGZG93bmxvYWQtZ2dtbC1tb2RlbC5zaCUyMHNtYWxsJTBBJTBBJTIzJTIwQmFzaWMlMjB1c2FnZSUwQS4lMkZtYWluJTIwLW0lMjBtb2RlbHMlMkZnZ21sLXNtYWxsLmJpbiUyMC1mJTIwYXVkaW8ud2F2",highlighted:`<span class="hljs-comment"># Clone and build</span>
git <span class="hljs-built_in">clone</span> https://github.com/ggml-org/whisper.cpp.git
<span class="hljs-built_in">cd</span> whisper.cpp
make

<span class="hljs-comment"># Download a model (e.g., small model)</span>
bash ./models/download-ggml-model.sh small

<span class="hljs-comment"># Basic usage</span>
./main -m models/ggml-small.bin -f audio.wav`,wrap:!1}}),B=new d({props:{title:"Python Bindings:",local:"python-bindings",headingTag:"h4"}}),Z=new M({props:{code:"aW1wb3J0JTIwd2hpc3Blcl9jcHAlMEElMEElMjMlMjBJbml0aWFsaXplJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMHdoaXNwZXJfY3BwLldoaXNwZXIoJTIybW9kZWxzJTJGZ2dtbC1zbWFsbC5iaW4lMjIpJTBBJTBBJTIzJTIwVHJhbnNjcmliZSUyMGF1ZGlvJTBBcmVzdWx0JTIwJTNEJTIwbW9kZWwudHJhbnNjcmliZSglMjJhdWRpby53YXYlMjIpJTBBcHJpbnQoZiUyMlRyYW5zY3JpcHRpb24lM0ElMjAlN0JyZXN1bHQlNUIndGV4dCclNUQlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> whisper_cpp

<span class="hljs-comment"># Initialize model</span>
model = whisper_cpp.Whisper(<span class="hljs-string">&quot;models/ggml-small.bin&quot;</span>)

<span class="hljs-comment"># Transcribe audio</span>
result = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Transcription: <span class="hljs-subst">{result[<span class="hljs-string">&#x27;text&#x27;</span>]}</span>&quot;</span>)`,wrap:!1}}),G=new d({props:{title:"When to Use whisper.cpp:",local:"when-to-use-whispercpp",headingTag:"h4"}}),x=new d({props:{title:"faster-whisper: GPU-Accelerated Performance",local:"faster-whisper-gpu-accelerated-performance",headingTag:"h3"}}),z=new d({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),S=new d({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),E=new d({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),H=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMGZhc3Rlci13aGlzcGVy",highlighted:"pip install faster-whisper",wrap:!1}}),X=new M({props:{code:"ZnJvbSUyMGZhc3Rlcl93aGlzcGVyJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6ZSUyMG1vZGVsJTIwd2l0aCUyMEdQVSUyMHN1cHBvcnQlMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJNb2RlbCglMjJzbWFsbCUyMiUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMjBjb21wdXRlX3R5cGUlM0QlMjJmbG9hdDE2JTIyKSUwQSUwQSUyMyUyMFRyYW5zY3JpYmUlMjBhdWRpbyUwQXNlZ21lbnRzJTJDJTIwaW5mbyUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyJTJDJTIwYmVhbV9zaXplJTNENSklMEElMEFwcmludChmJTIyRGV0ZWN0ZWQlMjBsYW5ndWFnZSUyMCclN0JpbmZvLmxhbmd1YWdlJTdEJyUyMHdpdGglMjBwcm9iYWJpbGl0eSUyMCU3QmluZm8ubGFuZ3VhZ2VfcHJvYmFiaWxpdHklN0QlMjIpJTBBJTBBZm9yJTIwc2VnbWVudCUyMGluJTIwc2VnbWVudHMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTVCJTdCc2VnbWVudC5zdGFydCUzQS4yZiU3RHMlMjAtJTNFJTIwJTdCc2VnbWVudC5lbmQlM0EuMmYlN0RzJTVEJTIwJTdCc2VnbWVudC50ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> faster_whisper <span class="hljs-keyword">import</span> WhisperModel

<span class="hljs-comment"># Initialize model with GPU support</span>
model = WhisperModel(<span class="hljs-string">&quot;small&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, compute_type=<span class="hljs-string">&quot;float16&quot;</span>)

<span class="hljs-comment"># Transcribe audio</span>
segments, info = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>, beam_size=<span class="hljs-number">5</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected language &#x27;<span class="hljs-subst">{info.language}</span>&#x27; with probability <span class="hljs-subst">{info.language_probability}</span>&quot;</span>)

<span class="hljs-keyword">for</span> segment <span class="hljs-keyword">in</span> segments:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;[<span class="hljs-subst">{segment.start:<span class="hljs-number">.2</span>f}</span>s -&gt; <span class="hljs-subst">{segment.end:<span class="hljs-number">.2</span>f}</span>s] <span class="hljs-subst">{segment.text}</span>&quot;</span>)`,wrap:!1}}),N=new d({props:{title:"Advanced Features:",local:"advanced-features",headingTag:"h4"}}),L=new M({props:{code:"JTIzJTIwU3RyZWFtaW5nJTIwdHJhbnNjcmlwdGlvbiUwQXNlZ21lbnRzJTJDJTIwaW5mbyUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTBBJTIwJTIwJTIwJTIwJTIyYXVkaW8ud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwYmVhbV9zaXplJTNENSUyQyUwQSUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJTIyZW4lMjIlMkMlMEElMjAlMjAlMjAlMjBjb25kaXRpb25fb25fcHJldmlvdXNfdGV4dCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjAlMkMlMEElMjAlMjAlMjAlMjBjb21wcmVzc2lvbl9yYXRpb190aHJlc2hvbGQlM0QyLjQlMkMlMEElMjAlMjAlMjAlMjBsb2dfcHJvYl90aHJlc2hvbGQlM0QtMS4wJTJDJTBBJTIwJTIwJTIwJTIwbm9fc3BlZWNoX3RocmVzaG9sZCUzRDAuNiUyQyUwQSUyMCUyMCUyMCUyMHdvcmRfdGltZXN0YW1wcyUzRFRydWUlMkMlMEEpJTBBJTBBJTIzJTIwVm9pY2UlMjBBY3Rpdml0eSUyMERldGVjdGlvbiUyMChWQUQpJTBBc2VnbWVudHMlMkMlMjBpbmZvJTIwJTNEJTIwbW9kZWwudHJhbnNjcmliZSglMEElMjAlMjAlMjAlMjAlMjJhdWRpby53YXYlMjIlMkMlMjB2YWRfZmlsdGVyJTNEVHJ1ZSUyQyUyMHZhZF9wYXJhbWV0ZXJzJTNEZGljdChtaW5fc2lsZW5jZV9kdXJhdGlvbl9tcyUzRDUwMCklMEEp",highlighted:`<span class="hljs-comment"># Streaming transcription</span>
segments, info = model.transcribe(
    <span class="hljs-string">&quot;audio.wav&quot;</span>,
    beam_size=<span class="hljs-number">5</span>,
    language=<span class="hljs-string">&quot;en&quot;</span>,
    condition_on_previous_text=<span class="hljs-literal">False</span>,
    temperature=<span class="hljs-number">0.0</span>,
    compression_ratio_threshold=<span class="hljs-number">2.4</span>,
    log_prob_threshold=-<span class="hljs-number">1.0</span>,
    no_speech_threshold=<span class="hljs-number">0.6</span>,
    word_timestamps=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Voice Activity Detection (VAD)</span>
segments, info = model.transcribe(
    <span class="hljs-string">&quot;audio.wav&quot;</span>, vad_filter=<span class="hljs-literal">True</span>, vad_parameters=<span class="hljs-built_in">dict</span>(min_silence_duration_ms=<span class="hljs-number">500</span>)
)`,wrap:!1}}),_=new d({props:{title:"Platform-Specific Optimizations",local:"platform-specific-optimizations",headingTag:"h2"}}),Q=new d({props:{title:"MLX-Whisper: Apple Silicon Native Performance",local:"mlx-whisper-apple-silicon-native-performance",headingTag:"h3"}}),Y=new d({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),P=new d({props:{title:"Performance Characteristics:",local:"performance-characteristics",headingTag:"h4"}}),D=new d({props:{title:"Installation and Usage:",local:"installation-and-usage",headingTag:"h4"}}),O=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMG1seC13aGlzcGVy",highlighted:"pip install mlx-whisper",wrap:!1}}),ee=new M({props:{code:"aW1wb3J0JTIwbWx4X3doaXNwZXIlMEElMEElMjMlMjBMb2FkJTIwbW9kZWwlMjBvcHRpbWl6ZWQlMjBmb3IlMjBBcHBsZSUyMFNpbGljb24lMEFtb2RlbCUyMCUzRCUyMG1seF93aGlzcGVyLmxvYWRfbW9kZWwoJTIyc21hbGwlMjIpJTBBJTBBJTIzJTIwVHJhbnNjcmliZSUyMHdpdGglMjBNZXRhbCUyMGFjY2VsZXJhdGlvbiUwQXJlc3VsdCUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyKSUwQXByaW50KHJlc3VsdCU1QiUyMnRleHQlMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> mlx_whisper

<span class="hljs-comment"># Load model optimized for Apple Silicon</span>
model = mlx_whisper.load_model(<span class="hljs-string">&quot;small&quot;</span>)

<span class="hljs-comment"># Transcribe with Metal acceleration</span>
result = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;text&quot;</span>])`,wrap:!1}}),te=new d({props:{title:"Lightning-Whisper-MLX: Maximum Apple Silicon Speed",local:"lightning-whisper-mlx-maximum-apple-silicon-speed",headingTag:"h4"}}),se=new M({props:{code:"JTIzJTIwRXZlbiUyMGZhc3RlciUyME1MWCUyMGltcGxlbWVudGF0aW9uJTBBZnJvbSUyMGxpZ2h0bmluZ193aGlzcGVyX21seCUyMGltcG9ydCUyMExpZ2h0bmluZ1doaXNwZXJNTFglMEElMEFtb2RlbCUyMCUzRCUyMExpZ2h0bmluZ1doaXNwZXJNTFgobW9kZWxfbmFtZSUzRCUyMnNtYWxsJTIyJTJDJTIwYmF0Y2hfc2l6ZSUzRDEyJTJDJTIwcXVhbnQlM0ROb25lKSUwQXJlc3VsdCUyMCUzRCUyMG1vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyKSUwQXByaW50KHJlc3VsdCU1QiUyMnRleHQlMjIlNUQp",highlighted:`<span class="hljs-comment"># Even faster MLX implementation</span>
<span class="hljs-keyword">from</span> lightning_whisper_mlx <span class="hljs-keyword">import</span> LightningWhisperMLX

model = LightningWhisperMLX(model_name=<span class="hljs-string">&quot;small&quot;</span>, batch_size=<span class="hljs-number">12</span>, quant=<span class="hljs-literal">None</span>)
result = model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(result[<span class="hljs-string">&quot;text&quot;</span>])`,wrap:!1}}),le=new d({props:{title:"WhisperKit: On-Device Apple Deployment",local:"whisperkit-on-device-apple-deployment",headingTag:"h3"}}),ie=new d({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),re=new d({props:{title:"Alternative Architectures",local:"alternative-architectures",headingTag:"h2"}}),pe=new d({props:{title:"Conformer-Based Models: Edge Computing Focus",local:"conformer-based-models-edge-computing-focus",headingTag:"h3"}}),me=new d({props:{title:"Key Features:",local:"key-features",headingTag:"h4"}}),de=new d({props:{title:"Comprehensive Performance Comparison",local:"comprehensive-performance-comparison",headingTag:"h2"}}),ge=new d({props:{title:"Deployment Strategies",local:"deployment-strategies",headingTag:"h2"}}),he=new d({props:{title:"Edge Computing Deployment",local:"edge-computing-deployment",headingTag:"h3"}}),Me=new d({props:{title:"Hardware Requirements:",local:"hardware-requirements",headingTag:"h4"}}),ue=new d({props:{title:"Optimization Techniques:",local:"optimization-techniques",headingTag:"h4"}}),Te=new d({props:{title:"Mobile Deployment",local:"mobile-deployment",headingTag:"h3"}}),$e=new d({props:{title:"iOS/macOS with WhisperKit:",local:"iosmacos-with-whisperkit",headingTag:"h4"}}),Je=new M({props:{code:"aW1wb3J0JTIwV2hpc3BlcktpdCUwQSUwQWxldCUyMHdoaXNwZXJLaXQlMjAlM0QlMjB0cnklMjBhd2FpdCUyMFdoaXNwZXJLaXQobW9kZWwlM0ElMjAlMjJzbWFsbCUyMiklMEFsZXQlMjB0cmFuc2NyaXB0aW9uJTIwJTNEJTIwdHJ5JTIwYXdhaXQlMjB3aGlzcGVyS2l0LnRyYW5zY3JpYmUoYXVkaW9QYXRoJTNBJTIwJTIyYXVkaW8ud2F2JTIyKSUwQXByaW50KHRyYW5zY3JpcHRpb24udGV4dCk=",highlighted:`<span class="hljs-keyword">import</span> WhisperKit

<span class="hljs-keyword">let</span> whisperKit <span class="hljs-operator">=</span> <span class="hljs-keyword">try</span> <span class="hljs-keyword">await</span> <span class="hljs-type">WhisperKit</span>(model: <span class="hljs-string">&quot;small&quot;</span>)
<span class="hljs-keyword">let</span> transcription <span class="hljs-operator">=</span> <span class="hljs-keyword">try</span> <span class="hljs-keyword">await</span> whisperKit.transcribe(audioPath: <span class="hljs-string">&quot;audio.wav&quot;</span>)
<span class="hljs-built_in">print</span>(transcription.text)`,wrap:!1}}),je=new d({props:{title:"Android with whisper.cpp:",local:"android-with-whispercpp",headingTag:"h4"}}),be=new M({props:{code:"cHVibGljJTIwY2xhc3MlMjBXaGlzcGVyQW5kcm9pZCUyMCU3QiUwQSUyMCUyMCUyMCUyMHN0YXRpYyUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFN5c3RlbS5sb2FkTGlicmFyeSglMjJ3aGlzcGVyX2FuZHJvaWQlMjIpJTNCJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHVibGljJTIwbmF0aXZlJTIwU3RyaW5nJTIwdHJhbnNjcmliZShTdHJpbmclMjBhdWRpb1BhdGglMkMlMjBTdHJpbmclMjBtb2RlbFBhdGgpJTNCJTBBJTdE",highlighted:`<span class="hljs-keyword">public</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">WhisperAndroid</span> {
    <span class="hljs-keyword">static</span> {
        System.loadLibrary(<span class="hljs-string">&quot;whisper_android&quot;</span>);
    }
    
    <span class="hljs-keyword">public</span> <span class="hljs-keyword">native</span> String <span class="hljs-title function_">transcribe</span><span class="hljs-params">(String audioPath, String modelPath)</span>;
}`,wrap:!1}}),Ue=new d({props:{title:"Real-Time Streaming",local:"real-time-streaming",headingTag:"h3"}}),Ie=new d({props:{title:"Streaming with faster-whisper:",local:"streaming-with-faster-whisper",headingTag:"h4"}}),Ce=new M({props:{code:"ZnJvbSUyMGZhc3Rlcl93aGlzcGVyJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTBBaW1wb3J0JTIwcHlhdWRpbyUwQWltcG9ydCUyMHRocmVhZGluZyUwQWltcG9ydCUyMHF1ZXVlJTBBJTBBJTBBY2xhc3MlMjBTdHJlYW1pbmdXaGlzcGVyJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMG1vZGVsX25hbWUlM0QlMjJzbWFsbCUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLm1vZGVsJTIwJTNEJTIwV2hpc3Blck1vZGVsKG1vZGVsX25hbWUlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwY29tcHV0ZV90eXBlJTNEJTIyZmxvYXQxNiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmF1ZGlvX3F1ZXVlJTIwJTNEJTIwcXVldWUuUXVldWUoKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHN0cmVhbV90cmFuc2NyaWJlKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBzZWxmLmF1ZGlvX3F1ZXVlLmVtcHR5KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpb19kYXRhJTIwJTNEJTIwc2VsZi5hdWRpb19xdWV1ZS5nZXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlZ21lbnRzJTJDJTIwaW5mbyUyMCUzRCUyMHNlbGYubW9kZWwudHJhbnNjcmliZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdWRpb19kYXRhJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVhbV9zaXplJTNENSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhbmd1YWdlJTNEJTIyZW4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25kaXRpb25fb25fcHJldmlvdXNfdGV4dCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHNlZ21lbnQlMjBpbiUyMHNlZ21lbnRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1QiU3QnNlZ21lbnQuc3RhcnQlM0EuMmYlN0RzJTIwLSUzRSUyMCU3QnNlZ21lbnQuZW5kJTNBLjJmJTdEcyU1RCUyMCU3QnNlZ21lbnQudGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">from</span> faster_whisper <span class="hljs-keyword">import</span> WhisperModel
<span class="hljs-keyword">import</span> pyaudio
<span class="hljs-keyword">import</span> threading
<span class="hljs-keyword">import</span> queue


<span class="hljs-keyword">class</span> <span class="hljs-title class_">StreamingWhisper</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;small&quot;</span></span>):
        self.model = WhisperModel(model_name, device=<span class="hljs-string">&quot;cuda&quot;</span>, compute_type=<span class="hljs-string">&quot;float16&quot;</span>)
        self.audio_queue = queue.Queue()

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">stream_transcribe</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">while</span> <span class="hljs-literal">True</span>:
            <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.audio_queue.empty():
                audio_data = self.audio_queue.get()
                segments, info = self.model.transcribe(
                    audio_data,
                    beam_size=<span class="hljs-number">5</span>,
                    language=<span class="hljs-string">&quot;en&quot;</span>,
                    condition_on_previous_text=<span class="hljs-literal">False</span>,
                )

                <span class="hljs-keyword">for</span> segment <span class="hljs-keyword">in</span> segments:
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;[<span class="hljs-subst">{segment.start:<span class="hljs-number">.2</span>f}</span>s -&gt; <span class="hljs-subst">{segment.end:<span class="hljs-number">.2</span>f}</span>s] <span class="hljs-subst">{segment.text}</span>&quot;</span>)`,wrap:!1}}),ve=new d({props:{title:"Integration with Existing Workflows",local:"integration-with-existing-workflows",headingTag:"h2"}}),We=new d({props:{title:"Combining with 🤗 Transformers:",local:"combining-with--transformers",headingTag:"h3"}}),Be=new M({props:{code:"JTIzJTIwVXNlJTIwZmFzdGVyLXdoaXNwZXIlMjBmb3IlMjB0cmFuc2NyaXB0aW9uJTJDJTIwdHJhbnNmb3JtZXJzJTIwZm9yJTIwcG9zdC1wcm9jZXNzaW5nJTBBZnJvbSUyMGZhc3Rlcl93aGlzcGVyJTIwaW1wb3J0JTIwV2hpc3Blck1vZGVsJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwRmFzdCUyMHRyYW5zY3JpcHRpb24lMEF3aGlzcGVyX21vZGVsJTIwJTNEJTIwV2hpc3Blck1vZGVsKCUyMnNtYWxsJTIyJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiklMEFzZWdtZW50cyUyQyUyMGluZm8lMjAlM0QlMjB3aGlzcGVyX21vZGVsLnRyYW5zY3JpYmUoJTIyYXVkaW8ud2F2JTIyKSUwQSUwQSUyMyUyMFBvc3QtcHJvY2Vzc2luZyUyMHdpdGglMjB0cmFuc2Zvcm1lcnMlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBZm9yJTIwc2VnbWVudCUyMGluJTIwc2VnbWVudHMlM0ElMEElMjAlMjAlMjAlMjBlbW90aW9uJTIwJTNEJTIwY2xhc3NpZmllcihzZWdtZW50LnRleHQpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlRleHQlM0ElMjAlN0JzZWdtZW50LnRleHQlN0QlMkMlMjBFbW90aW9uJTNBJTIwJTdCZW1vdGlvbiU3RCUyMik=",highlighted:`<span class="hljs-comment"># Use faster-whisper for transcription, transformers for post-processing</span>
<span class="hljs-keyword">from</span> faster_whisper <span class="hljs-keyword">import</span> WhisperModel
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-comment"># Fast transcription</span>
whisper_model = WhisperModel(<span class="hljs-string">&quot;small&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>)
segments, info = whisper_model.transcribe(<span class="hljs-string">&quot;audio.wav&quot;</span>)

<span class="hljs-comment"># Post-processing with transformers</span>
classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
<span class="hljs-keyword">for</span> segment <span class="hljs-keyword">in</span> segments:
    emotion = classifier(segment.text)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Text: <span class="hljs-subst">{segment.text}</span>, Emotion: <span class="hljs-subst">{emotion}</span>&quot;</span>)`,wrap:!1}}),Ze=new d({props:{title:"Best Practices and Recommendations",local:"best-practices-and-recommendations",headingTag:"h2"}}),Ge=new d({props:{title:"Choosing the Right Implementation:",local:"choosing-the-right-implementation",headingTag:"h3"}}),xe=new d({props:{title:"Performance Optimization Tips:",local:"performance-optimization-tips",headingTag:"h3"}}),ze=new d({props:{title:"Summary",local:"summary",headingTag:"h2"}}),He=new Ds({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/alternative_implementations.mdx"}}),{c(){w=f("meta"),Le=n(),Xe=f("p"),_e=n(),a(u.$$.fragment),Qe=n(),y=f("p"),y.textContent=us,Fe=n(),T=f("p"),T.textContent=ys,Ye=n(),a($.$$.fragment),qe=n(),a(J.$$.fragment),Pe=n(),j=f("p"),j.innerHTML=Ts,Ke=n(),a(b.$$.fragment),De=n(),U=f("ul"),U.innerHTML=$s,Oe=n(),a(I.$$.fragment),et=n(),C=f("ul"),C.innerHTML=Js,tt=n(),a(v.$$.fragment),st=n(),a(W.$$.fragment),lt=n(),a(B.$$.fragment),nt=n(),a(Z.$$.fragment),it=n(),a(G.$$.fragment),at=n(),A=f("ul"),A.innerHTML=js,rt=n(),a(x.$$.fragment),pt=n(),k=f("p"),k.innerHTML=bs,ot=n(),a(z.$$.fragment),mt=n(),V=f("ul"),V.innerHTML=Us,ct=n(),a(S.$$.fragment),dt=n(),R=f("ul"),R.innerHTML=Is,ft=n(),a(E.$$.fragment),gt=n(),a(H.$$.fragment),ht=n(),a(X.$$.fragment),Mt=n(),a(N.$$.fragment),wt=n(),a(L.$$.fragment),ut=n(),a(_.$$.fragment),yt=n(),a(Q.$$.fragment),Tt=n(),F=f("p"),F.innerHTML=Cs,$t=n(),a(Y.$$.fragment),Jt=n(),q=f("ul"),q.innerHTML=vs,jt=n(),a(P.$$.fragment),bt=n(),K=f("ul"),K.innerHTML=Ws,Ut=n(),a(D.$$.fragment),It=n(),a(O.$$.fragment),Ct=n(),a(ee.$$.fragment),vt=n(),a(te.$$.fragment),Wt=n(),a(se.$$.fragment),Bt=n(),a(le.$$.fragment),Zt=n(),ne=f("p"),ne.innerHTML=Bs,Gt=n(),a(ie.$$.fragment),At=n(),ae=f("ul"),ae.innerHTML=Zs,xt=n(),a(re.$$.fragment),kt=n(),a(pe.$$.fragment),zt=n(),oe=f("p"),oe.textContent=Gs,Vt=n(),a(me.$$.fragment),St=n(),ce=f("ul"),ce.innerHTML=As,Rt=n(),a(de.$$.fragment),Et=n(),fe=f("table"),fe.innerHTML=xs,Ht=n(),a(ge.$$.fragment),Xt=n(),a(he.$$.fragment),Nt=n(),a(Me.$$.fragment),Lt=n(),we=f("ul"),we.innerHTML=ks,_t=n(),a(ue.$$.fragment),Qt=n(),ye=f("ol"),ye.innerHTML=zs,Ft=n(),a(Te.$$.fragment),Yt=n(),a($e.$$.fragment),qt=n(),a(Je.$$.fragment),Pt=n(),a(je.$$.fragment),Kt=n(),a(be.$$.fragment),Dt=n(),a(Ue.$$.fragment),Ot=n(),a(Ie.$$.fragment),es=n(),a(Ce.$$.fragment),ts=n(),a(ve.$$.fragment),ss=n(),a(We.$$.fragment),ls=n(),a(Be.$$.fragment),ns=n(),a(Ze.$$.fragment),is=n(),a(Ge.$$.fragment),as=n(),Ae=f("ol"),Ae.innerHTML=Vs,rs=n(),a(xe.$$.fragment),ps=n(),ke=f("ol"),ke.innerHTML=Ss,os=n(),a(ze.$$.fragment),ms=n(),Ve=f("p"),Ve.textContent=Rs,cs=n(),Se=f("ul"),Se.innerHTML=Es,ds=n(),Re=f("p"),Re.textContent=Hs,fs=n(),Ee=f("p"),Ee.textContent=Xs,gs=n(),a(He.$$.fragment),hs=n(),Ne=f("p"),this.h()},l(e){const t=Ps("svelte-u9bgzb",document.head);w=g(t,"META",{name:!0,content:!0}),t.forEach(s),Le=i(e),Xe=g(e,"P",{}),Ns(Xe).forEach(s),_e=i(e),r(u.$$.fragment,e),Qe=i(e),y=g(e,"P",{"data-svelte-h":!0}),h(y)!=="svelte-1tyh4bp"&&(y.textContent=us),Fe=i(e),T=g(e,"P",{"data-svelte-h":!0}),h(T)!=="svelte-1e9xdbq"&&(T.textContent=ys),Ye=i(e),r($.$$.fragment,e),qe=i(e),r(J.$$.fragment,e),Pe=i(e),j=g(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1ncmokw"&&(j.innerHTML=Ts),Ke=i(e),r(b.$$.fragment,e),De=i(e),U=g(e,"UL",{"data-svelte-h":!0}),h(U)!=="svelte-13drr5p"&&(U.innerHTML=$s),Oe=i(e),r(I.$$.fragment,e),et=i(e),C=g(e,"UL",{"data-svelte-h":!0}),h(C)!=="svelte-16s4uuk"&&(C.innerHTML=Js),tt=i(e),r(v.$$.fragment,e),st=i(e),r(W.$$.fragment,e),lt=i(e),r(B.$$.fragment,e),nt=i(e),r(Z.$$.fragment,e),it=i(e),r(G.$$.fragment,e),at=i(e),A=g(e,"UL",{"data-svelte-h":!0}),h(A)!=="svelte-13siu0x"&&(A.innerHTML=js),rt=i(e),r(x.$$.fragment,e),pt=i(e),k=g(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-qzfp0v"&&(k.innerHTML=bs),ot=i(e),r(z.$$.fragment,e),mt=i(e),V=g(e,"UL",{"data-svelte-h":!0}),h(V)!=="svelte-1d03qfu"&&(V.innerHTML=Us),ct=i(e),r(S.$$.fragment,e),dt=i(e),R=g(e,"UL",{"data-svelte-h":!0}),h(R)!=="svelte-8bdcxs"&&(R.innerHTML=Is),ft=i(e),r(E.$$.fragment,e),gt=i(e),r(H.$$.fragment,e),ht=i(e),r(X.$$.fragment,e),Mt=i(e),r(N.$$.fragment,e),wt=i(e),r(L.$$.fragment,e),ut=i(e),r(_.$$.fragment,e),yt=i(e),r(Q.$$.fragment,e),Tt=i(e),F=g(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1nmuo4d"&&(F.innerHTML=Cs),$t=i(e),r(Y.$$.fragment,e),Jt=i(e),q=g(e,"UL",{"data-svelte-h":!0}),h(q)!=="svelte-1x0ax2x"&&(q.innerHTML=vs),jt=i(e),r(P.$$.fragment,e),bt=i(e),K=g(e,"UL",{"data-svelte-h":!0}),h(K)!=="svelte-1m0jpy3"&&(K.innerHTML=Ws),Ut=i(e),r(D.$$.fragment,e),It=i(e),r(O.$$.fragment,e),Ct=i(e),r(ee.$$.fragment,e),vt=i(e),r(te.$$.fragment,e),Wt=i(e),r(se.$$.fragment,e),Bt=i(e),r(le.$$.fragment,e),Zt=i(e),ne=g(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-yrp1m9"&&(ne.innerHTML=Bs),Gt=i(e),r(ie.$$.fragment,e),At=i(e),ae=g(e,"UL",{"data-svelte-h":!0}),h(ae)!=="svelte-tg6v2i"&&(ae.innerHTML=Zs),xt=i(e),r(re.$$.fragment,e),kt=i(e),r(pe.$$.fragment,e),zt=i(e),oe=g(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-1oeqjh8"&&(oe.textContent=Gs),Vt=i(e),r(me.$$.fragment,e),St=i(e),ce=g(e,"UL",{"data-svelte-h":!0}),h(ce)!=="svelte-1kv2wf9"&&(ce.innerHTML=As),Rt=i(e),r(de.$$.fragment,e),Et=i(e),fe=g(e,"TABLE",{"data-svelte-h":!0}),h(fe)!=="svelte-1i7ez7b"&&(fe.innerHTML=xs),Ht=i(e),r(ge.$$.fragment,e),Xt=i(e),r(he.$$.fragment,e),Nt=i(e),r(Me.$$.fragment,e),Lt=i(e),we=g(e,"UL",{"data-svelte-h":!0}),h(we)!=="svelte-kkvih6"&&(we.innerHTML=ks),_t=i(e),r(ue.$$.fragment,e),Qt=i(e),ye=g(e,"OL",{"data-svelte-h":!0}),h(ye)!=="svelte-mt0lyc"&&(ye.innerHTML=zs),Ft=i(e),r(Te.$$.fragment,e),Yt=i(e),r($e.$$.fragment,e),qt=i(e),r(Je.$$.fragment,e),Pt=i(e),r(je.$$.fragment,e),Kt=i(e),r(be.$$.fragment,e),Dt=i(e),r(Ue.$$.fragment,e),Ot=i(e),r(Ie.$$.fragment,e),es=i(e),r(Ce.$$.fragment,e),ts=i(e),r(ve.$$.fragment,e),ss=i(e),r(We.$$.fragment,e),ls=i(e),r(Be.$$.fragment,e),ns=i(e),r(Ze.$$.fragment,e),is=i(e),r(Ge.$$.fragment,e),as=i(e),Ae=g(e,"OL",{"data-svelte-h":!0}),h(Ae)!=="svelte-1uo850a"&&(Ae.innerHTML=Vs),rs=i(e),r(xe.$$.fragment,e),ps=i(e),ke=g(e,"OL",{"data-svelte-h":!0}),h(ke)!=="svelte-l1b4r9"&&(ke.innerHTML=Ss),os=i(e),r(ze.$$.fragment,e),ms=i(e),Ve=g(e,"P",{"data-svelte-h":!0}),h(Ve)!=="svelte-11xe3vy"&&(Ve.textContent=Rs),cs=i(e),Se=g(e,"UL",{"data-svelte-h":!0}),h(Se)!=="svelte-w6nbsb"&&(Se.innerHTML=Es),ds=i(e),Re=g(e,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1ndvy6z"&&(Re.textContent=Hs),fs=i(e),Ee=g(e,"P",{"data-svelte-h":!0}),h(Ee)!=="svelte-161m7eq"&&(Ee.textContent=Xs),gs=i(e),r(He.$$.fragment,e),hs=i(e),Ne=g(e,"P",{}),Ns(Ne).forEach(s),this.h()},h(){Ls(w,"name","hf:doc:metadata"),Ls(w,"content",el)},m(e,t){Ks(document.head,w),l(e,Le,t),l(e,Xe,t),l(e,_e,t),p(u,e,t),l(e,Qe,t),l(e,y,t),l(e,Fe,t),l(e,T,t),l(e,Ye,t),p($,e,t),l(e,qe,t),p(J,e,t),l(e,Pe,t),l(e,j,t),l(e,Ke,t),p(b,e,t),l(e,De,t),l(e,U,t),l(e,Oe,t),p(I,e,t),l(e,et,t),l(e,C,t),l(e,tt,t),p(v,e,t),l(e,st,t),p(W,e,t),l(e,lt,t),p(B,e,t),l(e,nt,t),p(Z,e,t),l(e,it,t),p(G,e,t),l(e,at,t),l(e,A,t),l(e,rt,t),p(x,e,t),l(e,pt,t),l(e,k,t),l(e,ot,t),p(z,e,t),l(e,mt,t),l(e,V,t),l(e,ct,t),p(S,e,t),l(e,dt,t),l(e,R,t),l(e,ft,t),p(E,e,t),l(e,gt,t),p(H,e,t),l(e,ht,t),p(X,e,t),l(e,Mt,t),p(N,e,t),l(e,wt,t),p(L,e,t),l(e,ut,t),p(_,e,t),l(e,yt,t),p(Q,e,t),l(e,Tt,t),l(e,F,t),l(e,$t,t),p(Y,e,t),l(e,Jt,t),l(e,q,t),l(e,jt,t),p(P,e,t),l(e,bt,t),l(e,K,t),l(e,Ut,t),p(D,e,t),l(e,It,t),p(O,e,t),l(e,Ct,t),p(ee,e,t),l(e,vt,t),p(te,e,t),l(e,Wt,t),p(se,e,t),l(e,Bt,t),p(le,e,t),l(e,Zt,t),l(e,ne,t),l(e,Gt,t),p(ie,e,t),l(e,At,t),l(e,ae,t),l(e,xt,t),p(re,e,t),l(e,kt,t),p(pe,e,t),l(e,zt,t),l(e,oe,t),l(e,Vt,t),p(me,e,t),l(e,St,t),l(e,ce,t),l(e,Rt,t),p(de,e,t),l(e,Et,t),l(e,fe,t),l(e,Ht,t),p(ge,e,t),l(e,Xt,t),p(he,e,t),l(e,Nt,t),p(Me,e,t),l(e,Lt,t),l(e,we,t),l(e,_t,t),p(ue,e,t),l(e,Qt,t),l(e,ye,t),l(e,Ft,t),p(Te,e,t),l(e,Yt,t),p($e,e,t),l(e,qt,t),p(Je,e,t),l(e,Pt,t),p(je,e,t),l(e,Kt,t),p(be,e,t),l(e,Dt,t),p(Ue,e,t),l(e,Ot,t),p(Ie,e,t),l(e,es,t),p(Ce,e,t),l(e,ts,t),p(ve,e,t),l(e,ss,t),p(We,e,t),l(e,ls,t),p(Be,e,t),l(e,ns,t),p(Ze,e,t),l(e,is,t),p(Ge,e,t),l(e,as,t),l(e,Ae,t),l(e,rs,t),p(xe,e,t),l(e,ps,t),l(e,ke,t),l(e,os,t),p(ze,e,t),l(e,ms,t),l(e,Ve,t),l(e,cs,t),l(e,Se,t),l(e,ds,t),l(e,Re,t),l(e,fs,t),l(e,Ee,t),l(e,gs,t),p(He,e,t),l(e,hs,t),l(e,Ne,t),Ms=!0},p:Qs,i(e){Ms||(o(u.$$.fragment,e),o($.$$.fragment,e),o(J.$$.fragment,e),o(b.$$.fragment,e),o(I.$$.fragment,e),o(v.$$.fragment,e),o(W.$$.fragment,e),o(B.$$.fragment,e),o(Z.$$.fragment,e),o(G.$$.fragment,e),o(x.$$.fragment,e),o(z.$$.fragment,e),o(S.$$.fragment,e),o(E.$$.fragment,e),o(H.$$.fragment,e),o(X.$$.fragment,e),o(N.$$.fragment,e),o(L.$$.fragment,e),o(_.$$.fragment,e),o(Q.$$.fragment,e),o(Y.$$.fragment,e),o(P.$$.fragment,e),o(D.$$.fragment,e),o(O.$$.fragment,e),o(ee.$$.fragment,e),o(te.$$.fragment,e),o(se.$$.fragment,e),o(le.$$.fragment,e),o(ie.$$.fragment,e),o(re.$$.fragment,e),o(pe.$$.fragment,e),o(me.$$.fragment,e),o(de.$$.fragment,e),o(ge.$$.fragment,e),o(he.$$.fragment,e),o(Me.$$.fragment,e),o(ue.$$.fragment,e),o(Te.$$.fragment,e),o($e.$$.fragment,e),o(Je.$$.fragment,e),o(je.$$.fragment,e),o(be.$$.fragment,e),o(Ue.$$.fragment,e),o(Ie.$$.fragment,e),o(Ce.$$.fragment,e),o(ve.$$.fragment,e),o(We.$$.fragment,e),o(Be.$$.fragment,e),o(Ze.$$.fragment,e),o(Ge.$$.fragment,e),o(xe.$$.fragment,e),o(ze.$$.fragment,e),o(He.$$.fragment,e),Ms=!0)},o(e){m(u.$$.fragment,e),m($.$$.fragment,e),m(J.$$.fragment,e),m(b.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m(B.$$.fragment,e),m(Z.$$.fragment,e),m(G.$$.fragment,e),m(x.$$.fragment,e),m(z.$$.fragment,e),m(S.$$.fragment,e),m(E.$$.fragment,e),m(H.$$.fragment,e),m(X.$$.fragment,e),m(N.$$.fragment,e),m(L.$$.fragment,e),m(_.$$.fragment,e),m(Q.$$.fragment,e),m(Y.$$.fragment,e),m(P.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(pe.$$.fragment,e),m(me.$$.fragment,e),m(de.$$.fragment,e),m(ge.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(ue.$$.fragment,e),m(Te.$$.fragment,e),m($e.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(Ie.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m(We.$$.fragment,e),m(Be.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(xe.$$.fragment,e),m(ze.$$.fragment,e),m(He.$$.fragment,e),Ms=!1},d(e){e&&(s(Le),s(Xe),s(_e),s(Qe),s(y),s(Fe),s(T),s(Ye),s(qe),s(Pe),s(j),s(Ke),s(De),s(U),s(Oe),s(et),s(C),s(tt),s(st),s(lt),s(nt),s(it),s(at),s(A),s(rt),s(pt),s(k),s(ot),s(mt),s(V),s(ct),s(dt),s(R),s(ft),s(gt),s(ht),s(Mt),s(wt),s(ut),s(yt),s(Tt),s(F),s($t),s(Jt),s(q),s(jt),s(bt),s(K),s(Ut),s(It),s(Ct),s(vt),s(Wt),s(Bt),s(Zt),s(ne),s(Gt),s(At),s(ae),s(xt),s(kt),s(zt),s(oe),s(Vt),s(St),s(ce),s(Rt),s(Et),s(fe),s(Ht),s(Xt),s(Nt),s(Lt),s(we),s(_t),s(Qt),s(ye),s(Ft),s(Yt),s(qt),s(Pt),s(Kt),s(Dt),s(Ot),s(es),s(ts),s(ss),s(ls),s(ns),s(is),s(as),s(Ae),s(rs),s(ps),s(ke),s(os),s(ms),s(Ve),s(cs),s(Se),s(ds),s(Re),s(fs),s(Ee),s(gs),s(hs),s(Ne)),s(w),c(u,e),c($,e),c(J,e),c(b,e),c(I,e),c(v,e),c(W,e),c(B,e),c(Z,e),c(G,e),c(x,e),c(z,e),c(S,e),c(E,e),c(H,e),c(X,e),c(N,e),c(L,e),c(_,e),c(Q,e),c(Y,e),c(P,e),c(D,e),c(O,e),c(ee,e),c(te,e),c(se,e),c(le,e),c(ie,e),c(re,e),c(pe,e),c(me,e),c(de,e),c(ge,e),c(he,e),c(Me,e),c(ue,e),c(Te,e),c($e,e),c(Je,e),c(je,e),c(be,e),c(Ue,e),c(Ie,e),c(Ce,e),c(ve,e),c(We,e),c(Be,e),c(Ze,e),c(Ge,e),c(xe,e),c(ze,e),c(He,e)}}}const el='{"title":"Alternative ASR Implementations: Beyond Transformers","local":"alternative-asr-implementations-beyond-transformers","sections":[{"title":"High-Performance Optimized Implementations","local":"high-performance-optimized-implementations","sections":[{"title":"whisper.cpp: C++ Port for Maximum Efficiency","local":"whispercpp-c-port-for-maximum-efficiency","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4},{"title":"Python Bindings:","local":"python-bindings","sections":[],"depth":4},{"title":"When to Use whisper.cpp:","local":"when-to-use-whispercpp","sections":[],"depth":4}],"depth":3},{"title":"faster-whisper: GPU-Accelerated Performance","local":"faster-whisper-gpu-accelerated-performance","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4},{"title":"Advanced Features:","local":"advanced-features","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Platform-Specific Optimizations","local":"platform-specific-optimizations","sections":[{"title":"MLX-Whisper: Apple Silicon Native Performance","local":"mlx-whisper-apple-silicon-native-performance","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4},{"title":"Performance Characteristics:","local":"performance-characteristics","sections":[],"depth":4},{"title":"Installation and Usage:","local":"installation-and-usage","sections":[],"depth":4},{"title":"Lightning-Whisper-MLX: Maximum Apple Silicon Speed","local":"lightning-whisper-mlx-maximum-apple-silicon-speed","sections":[],"depth":4}],"depth":3},{"title":"WhisperKit: On-Device Apple Deployment","local":"whisperkit-on-device-apple-deployment","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Alternative Architectures","local":"alternative-architectures","sections":[{"title":"Conformer-Based Models: Edge Computing Focus","local":"conformer-based-models-edge-computing-focus","sections":[{"title":"Key Features:","local":"key-features","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Comprehensive Performance Comparison","local":"comprehensive-performance-comparison","sections":[],"depth":2},{"title":"Deployment Strategies","local":"deployment-strategies","sections":[{"title":"Edge Computing Deployment","local":"edge-computing-deployment","sections":[{"title":"Hardware Requirements:","local":"hardware-requirements","sections":[],"depth":4},{"title":"Optimization Techniques:","local":"optimization-techniques","sections":[],"depth":4}],"depth":3},{"title":"Mobile Deployment","local":"mobile-deployment","sections":[{"title":"iOS/macOS with WhisperKit:","local":"iosmacos-with-whisperkit","sections":[],"depth":4},{"title":"Android with whisper.cpp:","local":"android-with-whispercpp","sections":[],"depth":4}],"depth":3},{"title":"Real-Time Streaming","local":"real-time-streaming","sections":[{"title":"Streaming with faster-whisper:","local":"streaming-with-faster-whisper","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Integration with Existing Workflows","local":"integration-with-existing-workflows","sections":[{"title":"Combining with 🤗 Transformers:","local":"combining-with--transformers","sections":[],"depth":3}],"depth":2},{"title":"Best Practices and Recommendations","local":"best-practices-and-recommendations","sections":[{"title":"Choosing the Right Implementation:","local":"choosing-the-right-implementation","sections":[],"depth":3},{"title":"Performance Optimization Tips:","local":"performance-optimization-tips","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function tl(ws){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Ys{constructor(w){super(),qs(this,w,tl,Os,_s,{})}}export{al as component};
