import{s as ea,o as ta}from"../chunks/scheduler.f7e1785c.js";import{S as la,i as sa,g as i,s as n,r as p,A as na,h as o,f as l,c as a,j as Ln,u as c,x as r,k as Dn,y as aa,a as s,v as h,d,t as M,w as u,m as Kn,n as On}from"../chunks/index.9f8f0838.js";import{T as Pn}from"../chunks/Tip.4575d9cf.js";import{C as m}from"../chunks/CodeBlock.4baef5d7.js";import{H as T,E as ia}from"../chunks/getInferenceSnippets.00780c44.js";function oa(bt){let y;return{c(){y=Kn('You can change the language identifier from `"dv"` to a language identifier of your choice. To see all possible languages\n    in Common Voice 13, check out the dataset card on the Hugging Face Hub: https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},l(w){y=On(w,'You can change the language identifier from `"dv"` to a language identifier of your choice. To see all possible languages\n    in Common Voice 13, check out the dataset card on the Hugging Face Hub: https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0')},m(w,J){s(w,y,J)},d(w){w&&l(y)}}}function ra(bt){let y;return{c(){y=Kn("If you do not want to upload the model checkpoints to the Hub, set `push_to_hub=False`.")},l(w){y=On(w,"If you do not want to upload the model checkpoints to the Hub, set `push_to_hub=False`.")},m(w,J){s(w,y,J)},d(w){w&&l(y)}}}function pa(bt){let y,w,J,It,j,vt,U,xs=`In this section, we’ll cover a step-by-step guide on fine-tuning Whisper for speech recognition on the Common Voice 13
dataset. We’ll use the ‘small’ version of the model and a relatively lightweight dataset, enabling you to run fine-tuning
fairly quickly on any 16GB+ GPU with low disk space requirements, such as the 16GB T4 GPU provided in the Google Colab free
tier.`,Wt,b,Gs=`Should you have a smaller GPU or encounter memory issues during training, you can follow the suggestions provided for
reducing memory usage. Conversely, should you have access to a larger GPU, you can amend the training arguments to maximise
your throughput. Thus, this guide is accessible regardless of your GPU specifications!`,_t,C,Zs=`Likewise, this guide outlines how to fine-tune the Whisper model for the Dhivehi language. However, the steps covered here
generalise to any language in the Common Voice dataset, and more generally to any ASR dataset on the Hugging Face Hub.
You can tweak the code to quickly switch to a language of your choice and fine-tune a Whisper model in your native tongue 🌍`,kt,I,Bs="Right! Now that’s out the way, let’s get started and kick-off our fine-tuning pipeline!",$t,v,xt,W,Xs=`We strongly advise you to upload model checkpoints directly the <a href="https://huggingface.co/" rel="nofollow">Hugging Face Hub</a> while training.
The Hub provides:`,Gt,_,Vs="<li>Integrated version control: you can be sure that no model checkpoint is lost during training.</li> <li>Tensorboard logs: track important metrics over the course of training.</li> <li>Model cards: document what a model does and its intended use cases.</li> <li>Community: an easy way to share and collaborate with the community! 🤗</li>",Zt,k,Rs=`Linking the notebook to the Hub is straightforward - it simply requires entering your Hub authentication token when prompted.
Find your Hub authentication token <a href="https://huggingface.co/settings/tokens" rel="nofollow">here</a> and enter it when prompted:`,Bt,$,Xt,x,Hs="<strong>Output:</strong>",Vt,G,Rt,Z,Ht,B,Ns=`<a href="https://huggingface.co/datasets/mozilla-foundation/common_voice_13_0" rel="nofollow">Common Voice 13</a> contains approximately ten
hours of labelled Dhivehi data, three of which is held-out test data. This is extremely little data for fine-tuning, so
we’ll be relying on leveraging the extensive multilingual ASR knowledge acquired by Whisper during pre-training for the
low-resource Dhivehi language.`,Nt,X,As=`Using 🤗 Datasets, downloading and preparing data is extremely simple. We can download and prepare the Common Voice 13
splits in just one line of code. Since Dhivehi is very low-resource, we’ll combine the <code>train</code> and <code>validation</code> splits
to give approximately seven hours of training data. We’ll use the three hours of <code>test</code> data as our held-out test set:`,At,V,Et,R,Es="<strong>Output:</strong>",Yt,H,Ft,f,zt,N,Ys=`Most ASR datasets only provide input audio samples (<code>audio</code>) and the corresponding transcribed text (<code>sentence</code>).
Common Voice contains additional metadata information, such as <code>accent</code> and <code>locale</code>, which we can disregard for ASR.
Keeping the notebook as general as possible, we only consider the input audio and transcribed text for fine-tuning,
discarding the additional metadata information:`,Qt,A,qt,E,St,Y,Fs="The ASR pipeline can be de-composed into three stages:",Lt,F,zs="<li>The feature extractor which pre-processes the raw audio-inputs to log-mel spectrograms</li> <li>The model which performs the sequence-to-sequence mapping</li> <li>The tokenizer which post-processes the predicted tokens to text</li>",Dt,z,Qs=`In 🤗 Transformers, the Whisper model has an associated feature extractor and tokenizer, called <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperFeatureExtractor" rel="nofollow">WhisperFeatureExtractor</a> and <a href="https://huggingface.co/docs/transformers/main/model_doc/whisper#transformers.WhisperTokenizer" rel="nofollow">WhisperTokenizer</a>
respectively. To make our lives simple, these two objects are wrapped under a single class, called the <a href="https://huggingface.co/docs/transformers/model_doc/whisper#transformers.WhisperProcessor" rel="nofollow">WhisperProcessor</a>.
We can call the WhisperProcessor to perform both the audio pre-processing and the text token post-processing. In doing
so, we only need to keep track of two objects during training: the processor and the model.`,Pt,Q,qs=`When performing multilingual fine-tuning, we need to set the <code>&quot;language&quot;</code> and <code>&quot;task&quot;</code> when instantiating the processor.
The <code>&quot;language&quot;</code> should be set to the source audio language, and the task to <code>&quot;transcribe&quot;</code> for speech recognition or
<code>&quot;translate&quot;</code> for speech translation. These arguments modify the behaviour of the tokenizer, and should be set correctly
to ensure the target labels are encoded properly.`,Kt,q,Ss="We can see all possible languages supported by Whisper by importing the list of languages:",Ot,S,el,L,Ls=`If you scroll through this list, you’ll notice that many languages are present, but Dhivehi is one of few that is not!
This means that Whisper was not pre-trained on Dhivehi. However, this doesn’t mean that we can’t fine tune Whisper on it.
In doing so, we’ll be teaching Whisper a new language, one that the pre-trained checkpoint does not support. That’s pretty
cool, right!`,tl,D,Ds=`When you fine-tune it on a new language, Whisper does a good job at leveraging its knowledge of the other 96 languages
it’s pre-trained on. Largely speaking, all modern languages will be linguistically similar to at least one of the
96 languages Whisper already knows, so we’ll fall under this paradigm of cross-lingual knowledge representation.`,ll,P,Ps=`What we need to do to fine-tune Whisper on a new language is find the language <strong>most similar</strong> that Whisper was
pre-trained on. The Wikipedia article for Dhivehi states that Dhivehi is closely related to the Sinhalese language of Sri Lanka.
If we check the language codes again, we can see that Sinhalese is present in the Whisper language set,
so we can safely set our language argument to <code>&quot;sinhalese&quot;</code>.`,sl,K,Ks=`Right! We’ll load our processor from the pre-trained checkpoint, setting the language to <code>&quot;sinhalese&quot;</code> and task to <code>&quot;transcribe&quot;</code>
as explained above:`,nl,O,al,ee,Os=`It’s worth reiterating that in most circumstances, you’ll find that the language you want to fine-tune on is in the set of
pre-training languages, in which case you can simply set the language directly as your source audio language! Note that
both of these arguments should be omitted for English-only fine-tuning, where there is only one option for the language
(<code>&quot;English&quot;</code>) and task (<code>&quot;transcribe&quot;</code>).`,il,te,ol,le,en=`Let’s have a look at the dataset features. Pay particular attention to the <code>&quot;audio&quot;</code> column - this details the sampling
rate of our audio inputs:`,rl,se,pl,ne,tn="<strong>Output:</strong>",cl,ae,hl,ie,ln=`Since our input audio is sampled at 48kHz, we need to <em>downsample</em> it to 16kHz prior to passing it to the Whisper feature
extractor, 16kHz being the sampling rate expected by the Whisper model.`,dl,oe,sn=`We’ll set the audio inputs to the correct sampling rate using dataset’s <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.cast_column" rel="nofollow"><code>cast_column</code></a>
method. This operation does not change the audio in-place, but rather signals to datasets to resample audio samples
on-the-fly when they are loaded:`,Ml,re,ul,pe,nn="Now we can write a function to prepare our data ready for the model:",ml,ce,an="<li>We load and resample the audio data on a sample-by-sample basis by calling <code>sample[&quot;audio&quot;]</code>. As explained above, 🤗 Datasets performs any necessary resampling operations on the fly.</li> <li>We use the feature extractor to compute the log-mel spectrogram input features from our 1-dimensional audio array.</li> <li>We encode the transcriptions to label ids through the use of the tokenizer.</li>",yl,he,wl,de,on=`We can apply the data preparation function to all of our training examples using 🤗 Datasets’ <code>.map</code> method. We’ll
remove the columns from the raw training data (the audio and text), leaving just the columns returned by the
<code>prepare_dataset</code> function:`,Tl,Me,Jl,ue,rn=`Finally, we filter any training data with audio samples longer than 30s. These samples would otherwise be truncated by
the Whisper feature-extractor which could affect the stability of training. We define a function that returns <code>True</code> for
samples that are less than 30s, and <code>False</code> for those that are longer:`,fl,me,gl,ye,pn="We apply our filter function to all samples of our training dataset through 🤗 Datasets’ <code>.filter</code> method:",jl,we,Ul,Te,cn="Let’s check how much training data we removed through this filtering step:",bl,Je,Cl,fe,hn="<strong>Output</strong>",Il,ge,vl,je,dn=`Alright! In this case we actually have the same number of samples as before, so there were no samples longer than 30s.
This might not be the case if you switch languages, so it’s best to keep this filter step in-place for robustness. With
that, we have our data fully prepared for training! Let’s continue and take a look at how we can use this data to fine-tune
Whisper.`,Wl,Ue,_l,be,Mn=`Now that we’ve prepared our data, we’re ready to dive into the training pipeline.
The <a href="https://huggingface.co/transformers/master/main_classes/trainer.html?highlight=trainer" rel="nofollow">🤗 Trainer</a>
will do much of the heavy lifting for us. All we have to do is:`,kl,Ce,un="<li><p>Define a data collator: the data collator takes our pre-processed data and prepares PyTorch tensors ready for the model.</p></li> <li><p>Evaluation metrics: during evaluation, we want to evaluate the model using the word error rate (WER) metric. We need to define a <code>compute_metrics</code> function that handles this computation.</p></li> <li><p>Load a pre-trained checkpoint: we need to load a pre-trained checkpoint and configure it correctly for training.</p></li> <li><p>Define the training arguments: these will be used by the 🤗 Trainer in constructing the training schedule.</p></li>",$l,Ie,mn=`Once we’ve fine-tuned the model, we will evaluate it on the test data to verify that we have correctly trained it
to transcribe speech in Dhivehi.`,xl,ve,Gl,We,yn=`The data collator for a sequence-to-sequence speech model is unique in the sense that it treats the <code>input_features</code>
and <code>labels</code> independently: the  <code>input_features</code> must be handled by the feature extractor and the <code>labels</code> by the tokenizer.`,Zl,_e,wn=`The <code>input_features</code> are already padded to 30s and converted to a log-Mel spectrogram of fixed dimension, so all we
have to do is convert them to batched PyTorch tensors. We do this using the feature extractor’s <code>.pad</code> method with
<code>return_tensors=pt</code>. Note that no additional padding is applied here since the inputs are of fixed dimension, the
<code>input_features</code> are simply converted to PyTorch tensors.`,Bl,ke,Tn=`On the other hand, the <code>labels</code> are un-padded. We first pad the sequences to the maximum length in the batch using
the tokenizer’s <code>.pad</code> method. The padding tokens are then replaced by <code>-100</code> so that these tokens are <strong>not</strong> taken
into account when computing the loss. We then cut the start of transcript token from the beginning of the label sequence
as we append it later during training.`,Xl,$e,Jn="We can leverage the <code>WhisperProcessor</code> we defined earlier to perform both the feature extractor and the tokenizer operations:",Vl,xe,Rl,Ge,fn="We can now initialise the data collator we’ve just defined:",Hl,Ze,Nl,Be,gn="Onwards!",Al,Xe,El,Ve,jn=`Next, we define the evaluation metric we’ll use on our evaluation set. We’ll use the Word Error Rate (WER) metric introduced
in the section on <a href="evaluation">Evaluation</a>, the ‘de-facto’ metric for assessing ASR systems.`,Yl,Re,Un="We’ll load the WER metric from 🤗 Evaluate:",Fl,He,zl,Ne,bn=`We then simply have to define a function that takes our model predictions and returns the WER metric. This function, called
<code>compute_metrics</code>, first replaces <code>-100</code> with the <code>pad_token_id</code> in the <code>label_ids</code> (undoing the step we applied in the
data collator to ignore padded tokens correctly in the loss). It then decodes the predicted and label ids to strings. Finally,
it computes the WER between the predictions and reference labels. Here, we have the option of evaluating with the ‘normalised’
transcriptions and predictions, which have punctuation and casing removed. We recommend you follow this to benefit
from the WER improvement obtained by normalising the transcriptions.`,Ql,Ae,ql,Ee,Sl,Ye,Cn="Now let’s load the pre-trained Whisper small checkpoint. Again, this is trivial through use of 🤗 Transformers!",Ll,Fe,Dl,ze,In=`We’ll set <code>use_cache</code> to <code>False</code> for training since we’re using <a href="https://huggingface.co/docs/transformers/v4.18.0/en/performance#gradient-checkpointing" rel="nofollow">gradient checkpointing</a>
and the two are incompatible. We’ll also override two generation arguments to control the behaviour of the model during inference:
we’ll force the language and task tokens during generation by setting the <code>language</code> and <code>task</code> arguments, and also re-enable
cache for generation to speed-up inference time:`,Pl,Qe,Kl,qe,Ol,Se,vn=`In the final step, we define all the parameters related to training. Here, we set the number of training steps to 500.
This is enough steps to see a big WER improvement compared to the pre-trained Whisper model, while ensuring that fine-tuning can
be run in approximately 45 minutes on a Google Colab free tier. For more detail on the training arguments, refer to the
Seq2SeqTrainingArguments <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments" rel="nofollow">docs</a>.`,es,Le,ts,g,ls,De,Wn="We can forward the training arguments to the 🤗 Trainer along with our model, dataset, data collator and <code>compute_metrics</code> function:",ss,Pe,ns,Ke,_n="And with that, we’re ready to start training!",as,Oe,is,et,kn="To launch training, simply execute:",os,tt,rs,lt,$n=`Training will take approximately 45 minutes depending on your GPU or the one allocated to the Google Colab. Depending on
your GPU, it is possible that you will encounter a CUDA <code>&quot;out-of-memory&quot;</code> error when you start training. In this case,
you can reduce the <code>per_device_train_batch_size</code> incrementally by factors of 2 and employ <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.Seq2SeqTrainingArguments.gradient_accumulation_steps" rel="nofollow"><code>gradient_accumulation_steps</code></a>
to compensate.`,ps,st,xn="<strong>Output:</strong>",cs,nt,Gn='<thead><tr><th align="center">Training Loss</th> <th align="center">Epoch</th> <th align="center">Step</th> <th align="center">Validation Loss</th> <th align="center">Wer Ortho</th> <th align="center">Wer</th></tr></thead> <tbody><tr><td align="center">0.136</td> <td align="center">1.63</td> <td align="center">500</td> <td align="center">0.1727</td> <td align="center">63.8972</td> <td align="center">14.0661</td></tr></tbody>',hs,at,Zn=`Our final WER is 14.1% - not bad for seven hours of training data and just 500 training steps! That amounts to a 112%
improvement versus the pre-trained model! That means we’ve taken a model that previously had no knowledge about Dhivehi,
and fine-tuned it to recognise Dhivehi speech with adequate accuracy in under one hour 🤯`,ds,it,Bn=`The big question is how this compares to other ASR systems. For that, we can view the autoevaluate <a href="https://huggingface.co/spaces/autoevaluate/leaderboards?dataset=mozilla-foundation%2Fcommon_voice_13_0&amp;only_verified=0&amp;task=automatic-speech-recognition&amp;config=dv&amp;split=test&amp;metric=wer" rel="nofollow">leaderboard</a>,
a leaderboard that categorises models by language and dataset, and subsequently ranks them according to their WER.`,Ms,ot,Xn=`Looking at the leaderboard, we see that our model trained for 500 steps convincingly beats the pre-trained <a href="https://huggingface.co/openai/whisper-small" rel="nofollow">Whisper Small</a>
checkpoint that we evaluated in the previous section. Nice job 👏`,us,rt,Vn=`We see that there are a few checkpoints that do better than the one we trained. The beauty of the Hugging Face Hub is that
it’s a <em>collaborative</em> platform - if we don’t have the time or resources to perform a longer training run ourselves, we
can load a checkpoint that someone else in the community has trained and been kind enough to share (making sure to thank them for it!).
You’ll be able to load these checkpoints in exactly the same way as the pre-trained ones using the <code>pipeline</code> class as we
did previously! So there’s nothing stopping you cherry-picking the best model on the leaderboard to use for your task!`,ms,pt,Rn=`We can automatically submit our checkpoint to the leaderboard when we push the training results to the Hub - we simply
have to set the appropriate key-word arguments (kwargs). You can change these values to match your dataset, language and
model name accordingly:`,ys,ct,ws,ht,Hn="The training results can now be uploaded to the Hub. To do so, execute the <code>push_to_hub</code> command:",Ts,dt,Js,Mt,Nn=`This will save the training logs and model weights under <code>&quot;your-username/the-name-you-picked&quot;</code>. For this example, check
out the upload at <code>sanchit-gandhi/whisper-small-dv</code>.`,fs,ut,An=`While the fine-tuned model yields satisfactory results on the Common Voice 13 Dhivehi test data, it is by no means optimal.
The purpose of this guide is to demonstrate how to fine-tune an ASR model using the 🤗 Trainer for multilingual speech
recognition.`,gs,mt,En=`If you have access to your own GPU or are subscribed to a Google Colab paid plan, you can increase <code>max_steps</code> to 4000 steps
to improve the WER further by training for more steps. Training for 4000 steps will take approximately 3-5 hours depending
on your GPU and yield WER results approximately 3% lower than training for 500 steps. If you decide to train for 4000 steps,
we also recommend changing the learning rate scheduler to a <em>linear</em> schedule (set <code>lr_scheduler_type=&quot;linear&quot;</code>), as this will
yield an additional performance boost over long training runs.`,js,yt,Yn=`The results could likely be improved further by optimising the training hyperparameters, such as <em>learning rate</em> and
<em>dropout</em>, and using a larger pre-trained checkpoint (<code>medium</code> or <code>large</code>). We leave this as an exercise to the reader.`,Us,wt,bs,Tt,Fn=`You can now share this model with anyone using the link on the Hub. They can load it with the identifier <code>&quot;your-username/the-name-you-picked&quot;</code>
directly into the <code>pipeline()</code> object. For instance, to load the fine-tuned checkpoint <a href="https://huggingface.co/sanchit-gandhi/whisper-small-dv" rel="nofollow">“sanchit-gandhi/whisper-small-dv”</a>:`,Cs,Jt,Is,ft,vs,gt,zn=`In this section, we covered a step-by-step guide on fine-tuning the Whisper model for speech recognition 🤗 Datasets,
Transformers and the Hugging Face Hub. We first loaded the Dhivehi subset of the Common Voice 13 dataset and pre-processed
it by computing log-mel spectrograms and tokenising the text. We then defined a data collator, evaluation metric and
training arguments, before using the 🤗 Trainer to train and evaluate our model. We finished by uploading the fine-tuned
model to the Hugging Face Hub, and showcased how to share and use it with the <code>pipeline()</code> class.`,Ws,jt,Qn=`If you followed through to this point, you should now have a fine-tuned checkpoint for speech recognition, well done! 🥳
Even more importantly, you’re equipped with all the tools you need to fine-tune the Whisper model on any speech recognition
dataset or domain. So what are you waiting for! Pick one of the datasets covered in the section <a href="choosing_dataset">Choosing a Dataset</a>
or select a dataset of your own, and see whether you can get state-of-the-art performance! The leaderboard is waiting for you…`,_s,Ut,ks,Ct,$s;return j=new T({props:{title:"Fine-tuning the ASR model",local:"fine-tuning-the-asr-model",headingTag:"h1"}}),v=new T({props:{title:"Prepare Environment",local:"prepare-environment",headingTag:"h2"}}),$=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),G=new m({props:{code:"TG9naW4lMjBzdWNjZXNzZnVsJTBBWW91ciUyMHRva2VuJTIwaGFzJTIwYmVlbiUyMHNhdmVkJTIwdG8lMjAlMkZyb290JTJGLmh1Z2dpbmdmYWNlJTJGdG9rZW4=",highlighted:`Login successful
Your token has been saved to /root/.huggingface/token`,wrap:!1}}),Z=new T({props:{title:"Load Dataset",local:"load-dataset",headingTag:"h2"}}),V=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwRGF0YXNldERpY3QlMEElMEFjb21tb25fdm9pY2UlMjAlM0QlMjBEYXRhc2V0RGljdCgpJTBBJTBBY29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMkJ2YWxpZGF0aW9uJTIyJTBBKSUwQWNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMjAlMjJkdiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMiUwQSklMEElMEFwcmludChjb21tb25fdm9pY2Up",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, DatasetDict

common_voice = DatasetDict()

common_voice[<span class="hljs-string">&quot;train&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;train+validation&quot;</span>
)
common_voice[<span class="hljs-string">&quot;test&quot;</span>] = load_dataset(
    <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>, <span class="hljs-string">&quot;dv&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>
)

<span class="hljs-built_in">print</span>(common_voice)`,wrap:!1}}),H=new m({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2NsaWVudF9pZCclMkMlMjAncGF0aCclMkMlMjAnYXVkaW8nJTJDJTIwJ3NlbnRlbmNlJyUyQyUyMCd1cF92b3RlcyclMkMlMjAnZG93bl92b3RlcyclMkMlMjAnYWdlJyUyQyUyMCdnZW5kZXInJTJDJTIwJ2FjY2VudCclMkMlMjAnbG9jYWxlJyUyQyUyMCdzZWdtZW50JyUyQyUyMCd2YXJpYW50JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNDkwNCUwQSUyMCUyMCUyMCUyMCU3RCklMEElMjAlMjAlMjAlMjB0ZXN0JTNBJTIwRGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidjbGllbnRfaWQnJTJDJTIwJ3BhdGgnJTJDJTIwJ2F1ZGlvJyUyQyUyMCdzZW50ZW5jZSclMkMlMjAndXBfdm90ZXMnJTJDJTIwJ2Rvd25fdm90ZXMnJTJDJTIwJ2FnZSclMkMlMjAnZ2VuZGVyJyUyQyUyMCdhY2NlbnQnJTJDJTIwJ2xvY2FsZSclMkMlMjAnc2VnbWVudCclMkMlMjAndmFyaWFudCclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fcm93cyUzQSUyMDIyMTIlMEElMjAlMjAlMjAlMjAlN0QpJTBBJTdEKQ==",highlighted:`DatasetDict({
    train: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">4904</span>
    })
    test: <span class="hljs-built_in">Dataset</span>({
        features: [<span class="hljs-string">&#x27;client_id&#x27;</span>, <span class="hljs-string">&#x27;path&#x27;</span>, <span class="hljs-string">&#x27;audio&#x27;</span>, <span class="hljs-string">&#x27;sentence&#x27;</span>, <span class="hljs-string">&#x27;up_votes&#x27;</span>, <span class="hljs-string">&#x27;down_votes&#x27;</span>, <span class="hljs-string">&#x27;age&#x27;</span>, <span class="hljs-string">&#x27;gender&#x27;</span>, <span class="hljs-string">&#x27;accent&#x27;</span>, <span class="hljs-string">&#x27;locale&#x27;</span>, <span class="hljs-string">&#x27;segment&#x27;</span>, <span class="hljs-string">&#x27;variant&#x27;</span>],
        num_rows: <span class="hljs-number">2212</span>
    })
})`,wrap:!1}}),f=new Pn({props:{$$slots:{default:[oa]},$$scope:{ctx:bt}}}),A=new m({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLnNlbGVjdF9jb2x1bW5zKCU1QiUyMmF1ZGlvJTIyJTJDJTIwJTIyc2VudGVuY2UlMjIlNUQp",highlighted:'common_voice = common_voice.select_columns([<span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;sentence&quot;</span>])',wrap:!1}}),E=new T({props:{title:"Feature Extractor, Tokenizer and Processor",local:"feature-extractor-tokenizer-and-processor",headingTag:"h2"}}),S=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5tb2RlbHMud2hpc3Blci50b2tlbml6YXRpb25fd2hpc3BlciUyMGltcG9ydCUyMFRPX0xBTkdVQUdFX0NPREUlMEElMEFUT19MQU5HVUFHRV9DT0RF",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.tokenization_whisper <span class="hljs-keyword">import</span> TO_LANGUAGE_CODE

TO_LANGUAGE_CODE`,wrap:!1}}),O=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBXaGlzcGVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTIwbGFuZ3VhZ2UlM0QlMjJzaW5oYWxlc2UlMjIlMkMlMjB0YXNrJTNEJTIydHJhbnNjcmliZSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperProcessor

processor = WhisperProcessor.from_pretrained(
    <span class="hljs-string">&quot;openai/whisper-small&quot;</span>, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>
)`,wrap:!1}}),te=new T({props:{title:"Pre-Process the Data",local:"pre-process-the-data",headingTag:"h2"}}),se=new m({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQuZmVhdHVyZXM=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>].features',wrap:!1}}),ae=new m({props:{code:"JTdCJ2F1ZGlvJyUzQSUyMEF1ZGlvKHNhbXBsaW5nX3JhdGUlM0Q0ODAwMCUyQyUyMG1vbm8lM0RUcnVlJTJDJTIwZGVjb2RlJTNEVHJ1ZSUyQyUyMGlkJTNETm9uZSklMkMlMEElMjAnc2VudGVuY2UnJTNBJTIwVmFsdWUoZHR5cGUlM0Qnc3RyaW5nJyUyQyUyMGlkJTNETm9uZSklN0Q=",highlighted:`{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(<span class="hljs-attribute">sampling_rate</span>=48000, <span class="hljs-attribute">mono</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">decode</span>=<span class="hljs-literal">True</span>, <span class="hljs-attribute">id</span>=None),
 <span class="hljs-string">&#x27;sentence&#x27;</span>: Value(<span class="hljs-attribute">dtype</span>=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-attribute">id</span>=None)}`,wrap:!1}}),re=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwcHJvY2Vzc29yLmZlYXR1cmVfZXh0cmFjdG9yLnNhbXBsaW5nX3JhdGUlMEFjb21tb25fdm9pY2UlMjAlM0QlMjBjb21tb25fdm9pY2UuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

sampling_rate = processor.feature_extractor.sampling_rate
common_voice = common_voice.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=sampling_rate))`,wrap:!1}}),he=new m({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0ZXh0JTNEZXhhbXBsZSU1QiUyMnNlbnRlbmNlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGNvbXB1dGUlMjBpbnB1dCUyMGxlbmd0aCUyMG9mJTIwYXVkaW8lMjBzYW1wbGUlMjBpbiUyMHNlY29uZHMlMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW5wdXRfbGVuZ3RoJTIyJTVEJTIwJTNEJTIwbGVuKGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTIwYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

    example = processor(
        audio=audio[<span class="hljs-string">&quot;array&quot;</span>],
        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        text=example[<span class="hljs-string">&quot;sentence&quot;</span>],
    )

    <span class="hljs-comment"># compute input length of audio sample in seconds</span>
    example[<span class="hljs-string">&quot;input_length&quot;</span>] = <span class="hljs-built_in">len</span>(audio[<span class="hljs-string">&quot;array&quot;</span>]) / audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>]

    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Me=new m({props:{code:"Y29tbW9uX3ZvaWNlJTIwJTNEJTIwY29tbW9uX3ZvaWNlLm1hcCglMEElMjAlMjAlMjAlMjBwcmVwYXJlX2RhdGFzZXQlMkMlMjByZW1vdmVfY29sdW1ucyUzRGNvbW1vbl92b2ljZS5jb2x1bW5fbmFtZXMlNUIlMjJ0cmFpbiUyMiU1RCUyQyUyMG51bV9wcm9jJTNEMSUwQSk=",highlighted:`common_voice = common_voice.<span class="hljs-built_in">map</span>(
    prepare_dataset, remove_columns=common_voice.column_names[<span class="hljs-string">&quot;train&quot;</span>], num_proc=<span class="hljs-number">1</span>
)`,wrap:!1}}),me=new m({props:{code:"bWF4X2lucHV0X2xlbmd0aCUyMCUzRCUyMDMwLjAlMEElMEElMEFkZWYlMjBpc19hdWRpb19pbl9sZW5ndGhfcmFuZ2UobGVuZ3RoKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxlbmd0aCUyMCUzQyUyMG1heF9pbnB1dF9sZW5ndGg=",highlighted:`max_input_length = <span class="hljs-number">30.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_in_length_range</span>(<span class="hljs-params">length</span>):
    <span class="hljs-keyword">return</span> length &lt; max_input_length`,wrap:!1}}),we=new m({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQlMjAlM0QlMjBjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RC5maWx0ZXIoJTBBJTIwJTIwJTIwJTIwaXNfYXVkaW9faW5fbGVuZ3RoX3JhbmdlJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRfY29sdW1ucyUzRCU1QiUyMmlucHV0X2xlbmd0aCUyMiU1RCUyQyUwQSk=",highlighted:`common_voice[<span class="hljs-string">&quot;train&quot;</span>] = common_voice[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">filter</span>(
    is_audio_in_length_range,
    input_columns=[<span class="hljs-string">&quot;input_length&quot;</span>],
)`,wrap:!1}}),Je=new m({props:{code:"Y29tbW9uX3ZvaWNlJTVCJTIydHJhaW4lMjIlNUQ=",highlighted:'common_voice[<span class="hljs-string">&quot;train&quot;</span>]',wrap:!1}}),ge=new m({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QidpbnB1dF9mZWF0dXJlcyclMkMlMjAnbGFiZWxzJyUyQyUyMCdpbnB1dF9sZW5ndGgnJTVEJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA0OTA0JTBBJTdEKQ==",highlighted:`<span class="hljs-title function_ invoke__">Dataset</span>({
    <span class="hljs-attr">features</span>: [<span class="hljs-string">&#x27;input_features&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;input_length&#x27;</span>],
    <span class="hljs-attr">num_rows</span>: <span class="hljs-number">4904</span>
})`,wrap:!1}}),Ue=new T({props:{title:"Training and Evaluation",local:"training-and-evaluation",headingTag:"h2"}}),ve=new T({props:{title:"Define a Data Collator",local:"define-a-data-collator",headingTag:"h3"}}),xe=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataCollatorSpeechSeq2SeqWithPadding</span>:
    processor: <span class="hljs-type">Any</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">
        self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]
    </span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
        <span class="hljs-comment"># split inputs and labels since they have to be of different lengths and need different padding methods</span>
        <span class="hljs-comment"># first treat the audio inputs by simply returning torch tensors</span>
        input_features = [
            {<span class="hljs-string">&quot;input_features&quot;</span>: feature[<span class="hljs-string">&quot;input_features&quot;</span>][<span class="hljs-number">0</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features
        ]
        batch = self.processor.feature_extractor.pad(input_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># get the tokenized label sequences</span>
        label_features = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
        <span class="hljs-comment"># pad the labels to max length</span>
        labels_batch = self.processor.tokenizer.pad(label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
        labels = labels_batch[<span class="hljs-string">&quot;input_ids&quot;</span>].masked_fill(
            labels_batch.attention_mask.ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>
        )

        <span class="hljs-comment"># if bos token is appended in previous tokenization step,</span>
        <span class="hljs-comment"># cut bos token here as it&#x27;s append later anyways</span>
        <span class="hljs-keyword">if</span> (labels[:, <span class="hljs-number">0</span>] == self.processor.tokenizer.bos_token_id).<span class="hljs-built_in">all</span>().cpu().item():
            labels = labels[:, <span class="hljs-number">1</span>:]

        batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Ze=new m({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvclNwZWVjaFNlcTJTZXFXaXRoUGFkZGluZyhwcm9jZXNzb3IlM0Rwcm9jZXNzb3Ip",highlighted:"data_collator = DataCollatorSpeechSeq2SeqWithPadding(processor=processor)",wrap:!1}}),Xe=new T({props:{title:"Evaluation Metrics",local:"evaluation-metrics",headingTag:"h3"}}),He=new m({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMndlciUyMik=",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;wer&quot;</span>)`,wrap:!1}}),Ae=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers.models.whisper.english_normalizer <span class="hljs-keyword">import</span> BasicTextNormalizer

normalizer = BasicTextNormalizer()


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">pred</span>):
    pred_ids = pred.predictions
    label_ids = pred.label_ids

    <span class="hljs-comment"># replace -100 with the pad_token_id</span>
    label_ids[label_ids == -<span class="hljs-number">100</span>] = processor.tokenizer.pad_token_id

    <span class="hljs-comment"># we do not want to group tokens when computing the metrics</span>
    pred_str = processor.batch_decode(pred_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
    label_str = processor.batch_decode(label_ids, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># compute orthographic wer</span>
    wer_ortho = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str, references=label_str)

    <span class="hljs-comment"># compute normalised WER</span>
    pred_str_norm = [normalizer(pred) <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> pred_str]
    label_str_norm = [normalizer(label) <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> label_str]
    <span class="hljs-comment"># filtering step to only evaluate the samples that correspond to non-zero references:</span>
    pred_str_norm = [
        pred_str_norm[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(pred_str_norm)) <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]
    label_str_norm = [
        label_str_norm[i]
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(label_str_norm))
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(label_str_norm[i]) &gt; <span class="hljs-number">0</span>
    ]

    wer = <span class="hljs-number">100</span> * metric.compute(predictions=pred_str_norm, references=label_str_norm)

    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_ortho&quot;</span>: wer_ortho, <span class="hljs-string">&quot;wer&quot;</span>: wer}`,wrap:!1}}),Ee=new T({props:{title:"Load a Pre-Trained Checkpoint",local:"load-a-pre-trained-checkpoint",headingTag:"h3"}}),Fe=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRndoaXNwZXItc21hbGwlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperForConditionalGeneration

model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),Qe=new m({props:{code:"ZnJvbSUyMGZ1bmN0b29scyUyMGltcG9ydCUyMHBhcnRpYWwlMEElMEElMjMlMjBkaXNhYmxlJTIwY2FjaGUlMjBkdXJpbmclMjB0cmFpbmluZyUyMHNpbmNlJTIwaXQncyUyMGluY29tcGF0aWJsZSUyMHdpdGglMjBncmFkaWVudCUyMGNoZWNrcG9pbnRpbmclMEFtb2RlbC5jb25maWcudXNlX2NhY2hlJTIwJTNEJTIwRmFsc2UlMEElMEElMjMlMjBzZXQlMjBsYW5ndWFnZSUyMGFuZCUyMHRhc2slMjBmb3IlMjBnZW5lcmF0aW9uJTIwYW5kJTIwcmUtZW5hYmxlJTIwY2FjaGUlMEFtb2RlbC5nZW5lcmF0ZSUyMCUzRCUyMHBhcnRpYWwoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2VuZXJhdGUlMkMlMjBsYW5ndWFnZSUzRCUyMnNpbmhhbGVzZSUyMiUyQyUyMHRhc2slM0QlMjJ0cmFuc2NyaWJlJTIyJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> functools <span class="hljs-keyword">import</span> partial

<span class="hljs-comment"># disable cache during training since it&#x27;s incompatible with gradient checkpointing</span>
model.config.use_cache = <span class="hljs-literal">False</span>

<span class="hljs-comment"># set language and task for generation and re-enable cache</span>
model.generate = partial(
    model.generate, language=<span class="hljs-string">&quot;sinhalese&quot;</span>, task=<span class="hljs-string">&quot;transcribe&quot;</span>, use_cache=<span class="hljs-literal">True</span>
)`,wrap:!1}}),qe=new T({props:{title:"Define the Training Configuration",local:"define-the-training-configuration",headingTag:"h2"}}),Le=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMi4lMkZ3aGlzcGVyLXNtYWxsLWR2JTIyJTJDJTIwJTIwJTIzJTIwbmFtZSUyMG9uJTIwdGhlJTIwSEYlMjBIdWIlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDElMkMlMjAlMjAlMjMlMjBpbmNyZWFzZSUyMGJ5JTIwMnglMjBmb3IlMjBldmVyeSUyMDJ4JTIwZGVjcmVhc2UlMjBpbiUyMGJhdGNoJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0QxZS01JTJDJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyX3R5cGUlM0QlMjJjb25zdGFudF93aXRoX3dhcm11cCUyMiUyQyUwQSUyMCUyMCUyMCUyMHdhcm11cF9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENTAwJTJDJTIwJTIwJTIzJTIwaW5jcmVhc2UlMjB0byUyMDQwMDAlMjBpZiUyMHlvdSUyMGhhdmUlMjB5b3VyJTIwb3duJTIwR1BVJTIwb3IlMjBhJTIwQ29sYWIlMjBwYWlkJTIwcGxhbiUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2NoZWNrcG9pbnRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZnAxNiUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2X2Z1bGxfZXZhbCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyc3RlcHMlMjIlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwcHJlZGljdF93aXRoX2dlbmVyYXRlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRpb25fbWF4X2xlbmd0aCUzRDIyNSUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0ZXBzJTNENTAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDI1JTJDJTBBJTIwJTIwJTIwJTIwcmVwb3J0X3RvJTNEJTVCJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpY19mb3JfYmVzdF9tb2RlbCUzRCUyMndlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGdyZWF0ZXJfaXNfYmV0dGVyJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBwdXNoX3RvX2h1YiUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

training_args = Seq2SeqTrainingArguments(
    output_dir=<span class="hljs-string">&quot;./whisper-small-dv&quot;</span>,  <span class="hljs-comment"># name on the HF Hub</span>
    per_device_train_batch_size=<span class="hljs-number">16</span>,
    gradient_accumulation_steps=<span class="hljs-number">1</span>,  <span class="hljs-comment"># increase by 2x for every 2x decrease in batch size</span>
    learning_rate=<span class="hljs-number">1e-5</span>,
    lr_scheduler_type=<span class="hljs-string">&quot;constant_with_warmup&quot;</span>,
    warmup_steps=<span class="hljs-number">50</span>,
    max_steps=<span class="hljs-number">500</span>,  <span class="hljs-comment"># increase to 4000 if you have your own GPU or a Colab paid plan</span>
    gradient_checkpointing=<span class="hljs-literal">True</span>,
    fp16=<span class="hljs-literal">True</span>,
    fp16_full_eval=<span class="hljs-literal">True</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    per_device_eval_batch_size=<span class="hljs-number">16</span>,
    predict_with_generate=<span class="hljs-literal">True</span>,
    generation_max_length=<span class="hljs-number">225</span>,
    save_steps=<span class="hljs-number">500</span>,
    eval_steps=<span class="hljs-number">500</span>,
    logging_steps=<span class="hljs-number">25</span>,
    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
    metric_for_best_model=<span class="hljs-string">&quot;wer&quot;</span>,
    greater_is_better=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),g=new Pn({props:{$$slots:{default:[ra]},$$scope:{ctx:bt}}}),Pe=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rjb21tb25fdm9pY2UlNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGNvbW1vbl92b2ljZSU1QiUyMnRlc3QlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

trainer = Seq2SeqTrainer(
    args=training_args,
    model=model,
    train_dataset=common_voice[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=common_voice[<span class="hljs-string">&quot;test&quot;</span>],
    data_collator=data_collator,
    compute_metrics=compute_metrics,
    tokenizer=processor,
)`,wrap:!1}}),Oe=new T({props:{title:"Training",local:"training",headingTag:"h3"}}),tt=new m({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),ct=new m({props:{code:"a3dhcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZGF0YXNldF90YWdzJTIyJTNBJTIwJTIybW96aWxsYS1mb3VuZGF0aW9uJTJGY29tbW9uX3ZvaWNlXzEzXzAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYXRhc2V0JTIyJTNBJTIwJTIyQ29tbW9uJTIwVm9pY2UlMjAxMyUyMiUyQyUyMCUyMCUyMyUyMGElMjAncHJldHR5JyUyMG5hbWUlMjBmb3IlMjB0aGUlMjB0cmFpbmluZyUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjAlMjJsYW5ndWFnZSUyMiUzQSUyMCUyMmR2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIybW9kZWxfbmFtZSUyMiUzQSUyMCUyMldoaXNwZXIlMjBTbWFsbCUyMER2JTIwLSUyMFNhbmNoaXQlMjBHYW5kaGklMjIlMkMlMjAlMjAlMjMlMjBhJTIwJ3ByZXR0eSclMjBuYW1lJTIwZm9yJTIweW91ciUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIyZmluZXR1bmVkX2Zyb20lMjIlM0ElMjAlMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydGFza3MlMjIlM0ElMjAlMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTBBJTdE",highlighted:`kwargs = {
    <span class="hljs-string">&quot;dataset_tags&quot;</span>: <span class="hljs-string">&quot;mozilla-foundation/common_voice_13_0&quot;</span>,
    <span class="hljs-string">&quot;dataset&quot;</span>: <span class="hljs-string">&quot;Common Voice 13&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for the training dataset</span>
    <span class="hljs-string">&quot;language&quot;</span>: <span class="hljs-string">&quot;dv&quot;</span>,
    <span class="hljs-string">&quot;model_name&quot;</span>: <span class="hljs-string">&quot;Whisper Small Dv - Sanchit Gandhi&quot;</span>,  <span class="hljs-comment"># a &#x27;pretty&#x27; name for your model</span>
    <span class="hljs-string">&quot;finetuned_from&quot;</span>: <span class="hljs-string">&quot;openai/whisper-small&quot;</span>,
    <span class="hljs-string">&quot;tasks&quot;</span>: <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>,
}`,wrap:!1}}),dt=new m({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1YigqKmt3YXJncyk=",highlighted:"trainer.push_to_hub(**kwargs)",wrap:!1}}),wt=new T({props:{title:"Sharing Your Model",local:"sharing-your-model",headingTag:"h2"}}),Jt=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNhbmNoaXQtZ2FuZGhpJTJGd2hpc3Blci1zbWFsbC1kdiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-small-dv&quot;</span>)`,wrap:!1}}),ft=new T({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ut=new ia({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter5/fine-tuning.mdx"}}),{c(){y=i("meta"),w=n(),J=i("p"),It=n(),p(j.$$.fragment),vt=n(),U=i("p"),U.textContent=xs,Wt=n(),b=i("p"),b.textContent=Gs,_t=n(),C=i("p"),C.textContent=Zs,kt=n(),I=i("p"),I.textContent=Bs,$t=n(),p(v.$$.fragment),xt=n(),W=i("p"),W.innerHTML=Xs,Gt=n(),_=i("ul"),_.innerHTML=Vs,Zt=n(),k=i("p"),k.innerHTML=Rs,Bt=n(),p($.$$.fragment),Xt=n(),x=i("p"),x.innerHTML=Hs,Vt=n(),p(G.$$.fragment),Rt=n(),p(Z.$$.fragment),Ht=n(),B=i("p"),B.innerHTML=Ns,Nt=n(),X=i("p"),X.innerHTML=As,At=n(),p(V.$$.fragment),Et=n(),R=i("p"),R.innerHTML=Es,Yt=n(),p(H.$$.fragment),Ft=n(),p(f.$$.fragment),zt=n(),N=i("p"),N.innerHTML=Ys,Qt=n(),p(A.$$.fragment),qt=n(),p(E.$$.fragment),St=n(),Y=i("p"),Y.textContent=Fs,Lt=n(),F=i("ol"),F.innerHTML=zs,Dt=n(),z=i("p"),z.innerHTML=Qs,Pt=n(),Q=i("p"),Q.innerHTML=qs,Kt=n(),q=i("p"),q.textContent=Ss,Ot=n(),p(S.$$.fragment),el=n(),L=i("p"),L.textContent=Ls,tl=n(),D=i("p"),D.textContent=Ds,ll=n(),P=i("p"),P.innerHTML=Ps,sl=n(),K=i("p"),K.innerHTML=Ks,nl=n(),p(O.$$.fragment),al=n(),ee=i("p"),ee.innerHTML=Os,il=n(),p(te.$$.fragment),ol=n(),le=i("p"),le.innerHTML=en,rl=n(),p(se.$$.fragment),pl=n(),ne=i("p"),ne.innerHTML=tn,cl=n(),p(ae.$$.fragment),hl=n(),ie=i("p"),ie.innerHTML=ln,dl=n(),oe=i("p"),oe.innerHTML=sn,Ml=n(),p(re.$$.fragment),ul=n(),pe=i("p"),pe.textContent=nn,ml=n(),ce=i("ol"),ce.innerHTML=an,yl=n(),p(he.$$.fragment),wl=n(),de=i("p"),de.innerHTML=on,Tl=n(),p(Me.$$.fragment),Jl=n(),ue=i("p"),ue.innerHTML=rn,fl=n(),p(me.$$.fragment),gl=n(),ye=i("p"),ye.innerHTML=pn,jl=n(),p(we.$$.fragment),Ul=n(),Te=i("p"),Te.textContent=cn,bl=n(),p(Je.$$.fragment),Cl=n(),fe=i("p"),fe.innerHTML=hn,Il=n(),p(ge.$$.fragment),vl=n(),je=i("p"),je.textContent=dn,Wl=n(),p(Ue.$$.fragment),_l=n(),be=i("p"),be.innerHTML=Mn,kl=n(),Ce=i("ul"),Ce.innerHTML=un,$l=n(),Ie=i("p"),Ie.textContent=mn,xl=n(),p(ve.$$.fragment),Gl=n(),We=i("p"),We.innerHTML=yn,Zl=n(),_e=i("p"),_e.innerHTML=wn,Bl=n(),ke=i("p"),ke.innerHTML=Tn,Xl=n(),$e=i("p"),$e.innerHTML=Jn,Vl=n(),p(xe.$$.fragment),Rl=n(),Ge=i("p"),Ge.textContent=fn,Hl=n(),p(Ze.$$.fragment),Nl=n(),Be=i("p"),Be.textContent=gn,Al=n(),p(Xe.$$.fragment),El=n(),Ve=i("p"),Ve.innerHTML=jn,Yl=n(),Re=i("p"),Re.textContent=Un,Fl=n(),p(He.$$.fragment),zl=n(),Ne=i("p"),Ne.innerHTML=bn,Ql=n(),p(Ae.$$.fragment),ql=n(),p(Ee.$$.fragment),Sl=n(),Ye=i("p"),Ye.textContent=Cn,Ll=n(),p(Fe.$$.fragment),Dl=n(),ze=i("p"),ze.innerHTML=In,Pl=n(),p(Qe.$$.fragment),Kl=n(),p(qe.$$.fragment),Ol=n(),Se=i("p"),Se.innerHTML=vn,es=n(),p(Le.$$.fragment),ts=n(),p(g.$$.fragment),ls=n(),De=i("p"),De.innerHTML=Wn,ss=n(),p(Pe.$$.fragment),ns=n(),Ke=i("p"),Ke.textContent=_n,as=n(),p(Oe.$$.fragment),is=n(),et=i("p"),et.textContent=kn,os=n(),p(tt.$$.fragment),rs=n(),lt=i("p"),lt.innerHTML=$n,ps=n(),st=i("p"),st.innerHTML=xn,cs=n(),nt=i("table"),nt.innerHTML=Gn,hs=n(),at=i("p"),at.textContent=Zn,ds=n(),it=i("p"),it.innerHTML=Bn,Ms=n(),ot=i("p"),ot.innerHTML=Xn,us=n(),rt=i("p"),rt.innerHTML=Vn,ms=n(),pt=i("p"),pt.textContent=Rn,ys=n(),p(ct.$$.fragment),ws=n(),ht=i("p"),ht.innerHTML=Hn,Ts=n(),p(dt.$$.fragment),Js=n(),Mt=i("p"),Mt.innerHTML=Nn,fs=n(),ut=i("p"),ut.textContent=An,gs=n(),mt=i("p"),mt.innerHTML=En,js=n(),yt=i("p"),yt.innerHTML=Yn,Us=n(),p(wt.$$.fragment),bs=n(),Tt=i("p"),Tt.innerHTML=Fn,Cs=n(),p(Jt.$$.fragment),Is=n(),p(ft.$$.fragment),vs=n(),gt=i("p"),gt.innerHTML=zn,Ws=n(),jt=i("p"),jt.innerHTML=Qn,_s=n(),p(Ut.$$.fragment),ks=n(),Ct=i("p"),this.h()},l(e){const t=na("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),J=o(e,"P",{}),Ln(J).forEach(l),It=a(e),c(j.$$.fragment,e),vt=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-y7r5mv"&&(U.textContent=xs),Wt=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-15djjoq"&&(b.textContent=Gs),_t=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1qs2xtc"&&(C.textContent=Zs),kt=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vn1gx2"&&(I.textContent=Bs),$t=a(e),c(v.$$.fragment,e),xt=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-lavash"&&(W.innerHTML=Xs),Gt=a(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-1vhmuwk"&&(_.innerHTML=Vs),Zt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-dngs6s"&&(k.innerHTML=Rs),Bt=a(e),c($.$$.fragment,e),Xt=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1mvdyro"&&(x.innerHTML=Hs),Vt=a(e),c(G.$$.fragment,e),Rt=a(e),c(Z.$$.fragment,e),Ht=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9bh3m8"&&(B.innerHTML=Ns),Nt=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1d296ko"&&(X.innerHTML=As),At=a(e),c(V.$$.fragment,e),Et=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1mvdyro"&&(R.innerHTML=Es),Yt=a(e),c(H.$$.fragment,e),Ft=a(e),c(f.$$.fragment,e),zt=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-amnv42"&&(N.innerHTML=Ys),Qt=a(e),c(A.$$.fragment,e),qt=a(e),c(E.$$.fragment,e),St=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1iebir5"&&(Y.textContent=Fs),Lt=a(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-peruey"&&(F.innerHTML=zs),Dt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1al0blu"&&(z.innerHTML=Qs),Pt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-zcpfiu"&&(Q.innerHTML=qs),Kt=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1o6e7as"&&(q.textContent=Ss),Ot=a(e),c(S.$$.fragment,e),el=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-bbew1u"&&(L.textContent=Ls),tl=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1c5pwr8"&&(D.textContent=Ds),ll=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-nq5sit"&&(P.innerHTML=Ps),sl=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-14p5mnr"&&(K.innerHTML=Ks),nl=a(e),c(O.$$.fragment,e),al=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-kof0c9"&&(ee.innerHTML=Os),il=a(e),c(te.$$.fragment,e),ol=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1h5ivu3"&&(le.innerHTML=en),rl=a(e),c(se.$$.fragment,e),pl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1mvdyro"&&(ne.innerHTML=tn),cl=a(e),c(ae.$$.fragment,e),hl=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1k18r6h"&&(ie.innerHTML=ln),dl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-17pt1y2"&&(oe.innerHTML=sn),Ml=a(e),c(re.$$.fragment,e),ul=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-93po82"&&(pe.textContent=nn),ml=a(e),ce=o(e,"OL",{"data-svelte-h":!0}),r(ce)!=="svelte-51y4cn"&&(ce.innerHTML=an),yl=a(e),c(he.$$.fragment,e),wl=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-c2eyft"&&(de.innerHTML=on),Tl=a(e),c(Me.$$.fragment,e),Jl=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1a11l7s"&&(ue.innerHTML=rn),fl=a(e),c(me.$$.fragment,e),gl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1mmculc"&&(ye.innerHTML=pn),jl=a(e),c(we.$$.fragment,e),Ul=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-184pc3h"&&(Te.textContent=cn),bl=a(e),c(Je.$$.fragment,e),Cl=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1ga3zr2"&&(fe.innerHTML=hn),Il=a(e),c(ge.$$.fragment,e),vl=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-6oin7m"&&(je.textContent=dn),Wl=a(e),c(Ue.$$.fragment,e),_l=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1ei1tif"&&(be.innerHTML=Mn),kl=a(e),Ce=o(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1osxt83"&&(Ce.innerHTML=un),$l=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-pvjt36"&&(Ie.textContent=mn),xl=a(e),c(ve.$$.fragment,e),Gl=a(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-3d3hl2"&&(We.innerHTML=yn),Zl=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1r84vh4"&&(_e.innerHTML=wn),Bl=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-e9pzmh"&&(ke.innerHTML=Tn),Xl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-ah9f4t"&&($e.innerHTML=Jn),Vl=a(e),c(xe.$$.fragment,e),Rl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-14k5ead"&&(Ge.textContent=fn),Hl=a(e),c(Ze.$$.fragment,e),Nl=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-hg8uw5"&&(Be.textContent=gn),Al=a(e),c(Xe.$$.fragment,e),El=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1dqtuem"&&(Ve.innerHTML=jn),Yl=a(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-16pkeis"&&(Re.textContent=Un),Fl=a(e),c(He.$$.fragment,e),zl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-wtclzb"&&(Ne.innerHTML=bn),Ql=a(e),c(Ae.$$.fragment,e),ql=a(e),c(Ee.$$.fragment,e),Sl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1xesvxe"&&(Ye.textContent=Cn),Ll=a(e),c(Fe.$$.fragment,e),Dl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1fuw0bw"&&(ze.innerHTML=In),Pl=a(e),c(Qe.$$.fragment,e),Kl=a(e),c(qe.$$.fragment,e),Ol=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1h5nxlm"&&(Se.innerHTML=vn),es=a(e),c(Le.$$.fragment,e),ts=a(e),c(g.$$.fragment,e),ls=a(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1i53tjj"&&(De.innerHTML=Wn),ss=a(e),c(Pe.$$.fragment,e),ns=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-rljiwv"&&(Ke.textContent=_n),as=a(e),c(Oe.$$.fragment,e),is=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1ary2hj"&&(et.textContent=kn),os=a(e),c(tt.$$.fragment,e),rs=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-k1eeda"&&(lt.innerHTML=$n),ps=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1mvdyro"&&(st.innerHTML=xn),cs=a(e),nt=o(e,"TABLE",{"data-svelte-h":!0}),r(nt)!=="svelte-10vryw9"&&(nt.innerHTML=Gn),hs=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1w06i7z"&&(at.textContent=Zn),ds=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1ryvxjm"&&(it.innerHTML=Bn),Ms=a(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-yo8880"&&(ot.innerHTML=Xn),us=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-nt4ns1"&&(rt.innerHTML=Vn),ms=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1jhde3j"&&(pt.textContent=Rn),ys=a(e),c(ct.$$.fragment,e),ws=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-14z2x03"&&(ht.innerHTML=Hn),Ts=a(e),c(dt.$$.fragment,e),Js=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1m7wkzz"&&(Mt.innerHTML=Nn),fs=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-ywnn18"&&(ut.textContent=An),gs=a(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-7mks79"&&(mt.innerHTML=En),js=a(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-1i1ixy0"&&(yt.innerHTML=Yn),Us=a(e),c(wt.$$.fragment,e),bs=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-5ekp45"&&(Tt.innerHTML=Fn),Cs=a(e),c(Jt.$$.fragment,e),Is=a(e),c(ft.$$.fragment,e),vs=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-z4yljy"&&(gt.innerHTML=zn),Ws=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1kap55g"&&(jt.innerHTML=Qn),_s=a(e),c(Ut.$$.fragment,e),ks=a(e),Ct=o(e,"P",{}),Ln(Ct).forEach(l),this.h()},h(){Dn(y,"name","hf:doc:metadata"),Dn(y,"content",ca)},m(e,t){aa(document.head,y),s(e,w,t),s(e,J,t),s(e,It,t),h(j,e,t),s(e,vt,t),s(e,U,t),s(e,Wt,t),s(e,b,t),s(e,_t,t),s(e,C,t),s(e,kt,t),s(e,I,t),s(e,$t,t),h(v,e,t),s(e,xt,t),s(e,W,t),s(e,Gt,t),s(e,_,t),s(e,Zt,t),s(e,k,t),s(e,Bt,t),h($,e,t),s(e,Xt,t),s(e,x,t),s(e,Vt,t),h(G,e,t),s(e,Rt,t),h(Z,e,t),s(e,Ht,t),s(e,B,t),s(e,Nt,t),s(e,X,t),s(e,At,t),h(V,e,t),s(e,Et,t),s(e,R,t),s(e,Yt,t),h(H,e,t),s(e,Ft,t),h(f,e,t),s(e,zt,t),s(e,N,t),s(e,Qt,t),h(A,e,t),s(e,qt,t),h(E,e,t),s(e,St,t),s(e,Y,t),s(e,Lt,t),s(e,F,t),s(e,Dt,t),s(e,z,t),s(e,Pt,t),s(e,Q,t),s(e,Kt,t),s(e,q,t),s(e,Ot,t),h(S,e,t),s(e,el,t),s(e,L,t),s(e,tl,t),s(e,D,t),s(e,ll,t),s(e,P,t),s(e,sl,t),s(e,K,t),s(e,nl,t),h(O,e,t),s(e,al,t),s(e,ee,t),s(e,il,t),h(te,e,t),s(e,ol,t),s(e,le,t),s(e,rl,t),h(se,e,t),s(e,pl,t),s(e,ne,t),s(e,cl,t),h(ae,e,t),s(e,hl,t),s(e,ie,t),s(e,dl,t),s(e,oe,t),s(e,Ml,t),h(re,e,t),s(e,ul,t),s(e,pe,t),s(e,ml,t),s(e,ce,t),s(e,yl,t),h(he,e,t),s(e,wl,t),s(e,de,t),s(e,Tl,t),h(Me,e,t),s(e,Jl,t),s(e,ue,t),s(e,fl,t),h(me,e,t),s(e,gl,t),s(e,ye,t),s(e,jl,t),h(we,e,t),s(e,Ul,t),s(e,Te,t),s(e,bl,t),h(Je,e,t),s(e,Cl,t),s(e,fe,t),s(e,Il,t),h(ge,e,t),s(e,vl,t),s(e,je,t),s(e,Wl,t),h(Ue,e,t),s(e,_l,t),s(e,be,t),s(e,kl,t),s(e,Ce,t),s(e,$l,t),s(e,Ie,t),s(e,xl,t),h(ve,e,t),s(e,Gl,t),s(e,We,t),s(e,Zl,t),s(e,_e,t),s(e,Bl,t),s(e,ke,t),s(e,Xl,t),s(e,$e,t),s(e,Vl,t),h(xe,e,t),s(e,Rl,t),s(e,Ge,t),s(e,Hl,t),h(Ze,e,t),s(e,Nl,t),s(e,Be,t),s(e,Al,t),h(Xe,e,t),s(e,El,t),s(e,Ve,t),s(e,Yl,t),s(e,Re,t),s(e,Fl,t),h(He,e,t),s(e,zl,t),s(e,Ne,t),s(e,Ql,t),h(Ae,e,t),s(e,ql,t),h(Ee,e,t),s(e,Sl,t),s(e,Ye,t),s(e,Ll,t),h(Fe,e,t),s(e,Dl,t),s(e,ze,t),s(e,Pl,t),h(Qe,e,t),s(e,Kl,t),h(qe,e,t),s(e,Ol,t),s(e,Se,t),s(e,es,t),h(Le,e,t),s(e,ts,t),h(g,e,t),s(e,ls,t),s(e,De,t),s(e,ss,t),h(Pe,e,t),s(e,ns,t),s(e,Ke,t),s(e,as,t),h(Oe,e,t),s(e,is,t),s(e,et,t),s(e,os,t),h(tt,e,t),s(e,rs,t),s(e,lt,t),s(e,ps,t),s(e,st,t),s(e,cs,t),s(e,nt,t),s(e,hs,t),s(e,at,t),s(e,ds,t),s(e,it,t),s(e,Ms,t),s(e,ot,t),s(e,us,t),s(e,rt,t),s(e,ms,t),s(e,pt,t),s(e,ys,t),h(ct,e,t),s(e,ws,t),s(e,ht,t),s(e,Ts,t),h(dt,e,t),s(e,Js,t),s(e,Mt,t),s(e,fs,t),s(e,ut,t),s(e,gs,t),s(e,mt,t),s(e,js,t),s(e,yt,t),s(e,Us,t),h(wt,e,t),s(e,bs,t),s(e,Tt,t),s(e,Cs,t),h(Jt,e,t),s(e,Is,t),h(ft,e,t),s(e,vs,t),s(e,gt,t),s(e,Ws,t),s(e,jt,t),s(e,_s,t),h(Ut,e,t),s(e,ks,t),s(e,Ct,t),$s=!0},p(e,[t]){const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),f.$set(qn);const Sn={};t&2&&(Sn.$$scope={dirty:t,ctx:e}),g.$set(Sn)},i(e){$s||(d(j.$$.fragment,e),d(v.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(f.$$.fragment,e),d(A.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(re.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(me.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(ge.$$.fragment,e),d(Ue.$$.fragment,e),d(ve.$$.fragment,e),d(xe.$$.fragment,e),d(Ze.$$.fragment,e),d(Xe.$$.fragment,e),d(He.$$.fragment,e),d(Ae.$$.fragment,e),d(Ee.$$.fragment,e),d(Fe.$$.fragment,e),d(Qe.$$.fragment,e),d(qe.$$.fragment,e),d(Le.$$.fragment,e),d(g.$$.fragment,e),d(Pe.$$.fragment,e),d(Oe.$$.fragment,e),d(tt.$$.fragment,e),d(ct.$$.fragment,e),d(dt.$$.fragment,e),d(wt.$$.fragment,e),d(Jt.$$.fragment,e),d(ft.$$.fragment,e),d(Ut.$$.fragment,e),$s=!0)},o(e){M(j.$$.fragment,e),M(v.$$.fragment,e),M($.$$.fragment,e),M(G.$$.fragment,e),M(Z.$$.fragment,e),M(V.$$.fragment,e),M(H.$$.fragment,e),M(f.$$.fragment,e),M(A.$$.fragment,e),M(E.$$.fragment,e),M(S.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(he.$$.fragment,e),M(Me.$$.fragment,e),M(me.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(ge.$$.fragment,e),M(Ue.$$.fragment,e),M(ve.$$.fragment,e),M(xe.$$.fragment,e),M(Ze.$$.fragment,e),M(Xe.$$.fragment,e),M(He.$$.fragment,e),M(Ae.$$.fragment,e),M(Ee.$$.fragment,e),M(Fe.$$.fragment,e),M(Qe.$$.fragment,e),M(qe.$$.fragment,e),M(Le.$$.fragment,e),M(g.$$.fragment,e),M(Pe.$$.fragment,e),M(Oe.$$.fragment,e),M(tt.$$.fragment,e),M(ct.$$.fragment,e),M(dt.$$.fragment,e),M(wt.$$.fragment,e),M(Jt.$$.fragment,e),M(ft.$$.fragment,e),M(Ut.$$.fragment,e),$s=!1},d(e){e&&(l(w),l(J),l(It),l(vt),l(U),l(Wt),l(b),l(_t),l(C),l(kt),l(I),l($t),l(xt),l(W),l(Gt),l(_),l(Zt),l(k),l(Bt),l(Xt),l(x),l(Vt),l(Rt),l(Ht),l(B),l(Nt),l(X),l(At),l(Et),l(R),l(Yt),l(Ft),l(zt),l(N),l(Qt),l(qt),l(St),l(Y),l(Lt),l(F),l(Dt),l(z),l(Pt),l(Q),l(Kt),l(q),l(Ot),l(el),l(L),l(tl),l(D),l(ll),l(P),l(sl),l(K),l(nl),l(al),l(ee),l(il),l(ol),l(le),l(rl),l(pl),l(ne),l(cl),l(hl),l(ie),l(dl),l(oe),l(Ml),l(ul),l(pe),l(ml),l(ce),l(yl),l(wl),l(de),l(Tl),l(Jl),l(ue),l(fl),l(gl),l(ye),l(jl),l(Ul),l(Te),l(bl),l(Cl),l(fe),l(Il),l(vl),l(je),l(Wl),l(_l),l(be),l(kl),l(Ce),l($l),l(Ie),l(xl),l(Gl),l(We),l(Zl),l(_e),l(Bl),l(ke),l(Xl),l($e),l(Vl),l(Rl),l(Ge),l(Hl),l(Nl),l(Be),l(Al),l(El),l(Ve),l(Yl),l(Re),l(Fl),l(zl),l(Ne),l(Ql),l(ql),l(Sl),l(Ye),l(Ll),l(Dl),l(ze),l(Pl),l(Kl),l(Ol),l(Se),l(es),l(ts),l(ls),l(De),l(ss),l(ns),l(Ke),l(as),l(is),l(et),l(os),l(rs),l(lt),l(ps),l(st),l(cs),l(nt),l(hs),l(at),l(ds),l(it),l(Ms),l(ot),l(us),l(rt),l(ms),l(pt),l(ys),l(ws),l(ht),l(Ts),l(Js),l(Mt),l(fs),l(ut),l(gs),l(mt),l(js),l(yt),l(Us),l(bs),l(Tt),l(Cs),l(Is),l(vs),l(gt),l(Ws),l(jt),l(_s),l(ks),l(Ct)),l(y),u(j,e),u(v,e),u($,e),u(G,e),u(Z,e),u(V,e),u(H,e),u(f,e),u(A,e),u(E,e),u(S,e),u(O,e),u(te,e),u(se,e),u(ae,e),u(re,e),u(he,e),u(Me,e),u(me,e),u(we,e),u(Je,e),u(ge,e),u(Ue,e),u(ve,e),u(xe,e),u(Ze,e),u(Xe,e),u(He,e),u(Ae,e),u(Ee,e),u(Fe,e),u(Qe,e),u(qe,e),u(Le,e),u(g,e),u(Pe,e),u(Oe,e),u(tt,e),u(ct,e),u(dt,e),u(wt,e),u(Jt,e),u(ft,e),u(Ut,e)}}}const ca='{"title":"Fine-tuning the ASR model","local":"fine-tuning-the-asr-model","sections":[{"title":"Prepare Environment","local":"prepare-environment","sections":[],"depth":2},{"title":"Load Dataset","local":"load-dataset","sections":[],"depth":2},{"title":"Feature Extractor, Tokenizer and Processor","local":"feature-extractor-tokenizer-and-processor","sections":[],"depth":2},{"title":"Pre-Process the Data","local":"pre-process-the-data","sections":[],"depth":2},{"title":"Training and Evaluation","local":"training-and-evaluation","sections":[{"title":"Define a Data Collator","local":"define-a-data-collator","sections":[],"depth":3},{"title":"Evaluation Metrics","local":"evaluation-metrics","sections":[],"depth":3},{"title":"Load a Pre-Trained Checkpoint","local":"load-a-pre-trained-checkpoint","sections":[],"depth":3}],"depth":2},{"title":"Define the Training Configuration","local":"define-the-training-configuration","sections":[{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Sharing Your Model","local":"sharing-your-model","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ha(bt){return ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wa extends la{constructor(y){super(),sa(this,y,ha,pa,ea,{})}}export{wa as component};
