import{s as hs,f as us,o as ds,n as ms}from"../chunks/scheduler.f7e1785c.js";import{S as fs,i as ys,g as i,s as n,r,A as gs,h as o,f as s,c as l,j as Gt,u as c,x as p,k as U,y as ws,a,v as h,d as u,t as d,w as m,m as Ts,n as Ms}from"../chunks/index.9f8f0838.js";import{T as cs}from"../chunks/Tip.4575d9cf.js";import{C as y}from"../chunks/CodeBlock.4baef5d7.js";import{H as $e,E as Js}from"../chunks/getInferenceSnippets.00780c44.js";function bs(je){let f,w=`Whisper can also be ‘tricked’ into translating from speech in any language X to any language Y. Simply set the task to
<code>&quot;transcribe&quot;</code> and the <code>&quot;language&quot;</code> to your target language in the generation key-word arguments,
e.g. for Spanish, one would set:`,M,J,j="<code>generate_kwargs={&quot;task&quot;: &quot;transcribe&quot;, &quot;language&quot;: &quot;es&quot;}</code>";return{c(){f=i("p"),f.innerHTML=w,M=n(),J=i("p"),J.innerHTML=j},l(g){f=o(g,"P",{"data-svelte-h":!0}),p(f)!=="svelte-vga0jc"&&(f.innerHTML=w),M=l(g),J=o(g,"P",{"data-svelte-h":!0}),p(J)!=="svelte-130lm1j"&&(J.innerHTML=j)},m(g,b){a(g,f,b),a(g,M,b),a(g,J,b)},p:ms,d(g){g&&(s(f),s(M),s(J))}}}function Us(je){let f;return{c(){f=Ts(`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},l(w){f=Ms(w,`Here we're using SpeechT5 checkpoint trained specifically for English TTS. Should you wish to translate into a language 
    other than English, either swap the checkpoint for a SpeechT5 TTS model fine-tuned on your language of choice, or 
    use an MMS TTS checkpoint pre-trained in your target langauge.`)},m(w,M){a(w,f,M)},d(w){w&&s(f)}}}function js(je){let f,w,M,J,j,g,b,xt=`Speech-to-speech translation (STST or S2ST) is a relatively new spoken language processing task. It involves translating
speech from one langauge into speech in a <strong>different</strong> language:`,ke,v,St='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st.png" alt="Diagram of speech to speech translation"/>',Ze,G,Ct=`STST can be viewed as an extension of the traditional machine translation (MT) task: instead of translating <strong>text</strong> from one
language into another, we translate <strong>speech</strong> from one language into another. STST holds applications in the field of
multilingual communication, enabling speakers in different languages to communicate with one another through the medium
of speech.`,Ge,x,It=`Suppose you want to communicate with another individual across a langauge barrier. Rather
than writing the information that you want to convey and then translating it to text in the target language, you
can speak it directly and have a STST system convert your spoken speech into the target langauge. The recipient can then
respond by speaking back at the STST system, and you can listen to their response. This is a more natural way of communicating
compared to text-based machine translation.`,xe,S,Wt=`In this chapter, we’ll explore a <em>cascaded</em> approach to STST, piecing together the knowledge you’ve acquired in Units
5 and 6 of the course. We’ll use a <em>speech translation (ST)</em> system to transcribe the source speech into text in the target
language, then <em>text-to-speech (TTS)</em> to generate speech in the target language from the translated text:`,Se,$,Nt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/s2st_cascaded.png" alt="Diagram of cascaded speech to speech translation"/>',Ce,C,_t=`We could also have used a three stage approach, where first we use an automatic speech recognition (ASR) system to
transcribe the source speech into text in the same language, then machine translation to translate the transcribed text
into the target language, and finally text-to-speech to generate speech in the target language. However, adding more
components to the pipeline lends itself to <em>error propagation</em>, where the errors introduced in one system are compounded
as they flow through the remaining systems, and also increases latency, since inference has to be conducted for more models.`,Ie,I,Bt=`While this cascaded approach to STST is pretty straightforward, it results in very effective STST systems. The three-stage
cascaded system of ASR + MT + TTS was previously used to power many commercial STST products, including <a href="https://ai.googleblog.com/2019/05/introducing-translatotron-end-to-end.html" rel="nofollow">Google Translate</a>.
It’s also a very data and compute efficient way of developing a STST system, since existing speech recognition and
text-to-speech systems can be coupled together to yield a new STST model without any additional training.`,We,W,Vt=`In the remainder of this Unit, we’ll focus on creating a STST system that translates speech from any language X to speech
in English. The methods covered can be extended to STST systems that translate from any language X to any
langauge Y, but we leave this as an extension to the reader and provide pointers where applicable. We further divide up the
task of STST into its two constituent components: ST and TTS. We’ll finish by piecing them together to build a Gradio
demo to showcase our system.`,Ne,N,_e,_,Ht=`We’ll use the Whisper model for our speech translation system, since it’s capable of translating from over 96 languages
to English. Specifically, we’ll load the <a href="https://huggingface.co/openai/whisper-base" rel="nofollow">Whisper Base</a> checkpoint, which
clocks in at 74M parameters. It’s by no means the most performant Whisper model, with the <a href="https://huggingface.co/openai/whisper-large-v2" rel="nofollow">largest Whisper checkpoint</a>
being over 20x larger, but since we’re concatenating two auto-regressive systems together (ST + TTS), we want to ensure
each model can generate relatively quickly so that we get reasonable inference speed:`,Be,B,Ve,V,Xt=`Great! To test our STST system, we’ll load an audio sample in a non-English language. Let’s load the first example of the
Italian (<code>it</code>) split of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset:`,He,H,Xe,X,qt='To listen to this sample, we can either play it using the dataset viewer on the Hub: <a href="https://huggingface.co/datasets/facebook/voxpopuli/viewer/it/validation?row=0" rel="nofollow">facebook/voxpopuli/viewer</a>',qe,q,Rt="Or playback using the ipynb audio feature:",Re,R,Ye,Y,Yt=`Now let’s define a function that takes this audio input and returns the translated text. You’ll remember that we have to
pass the generation key-word argument for the <code>&quot;task&quot;</code>, setting it to <code>&quot;translate&quot;</code> to ensure that Whisper performs
speech translation and not speech recognition:`,Qe,Q,Fe,k,Ee,F,Qt="Great! Let’s quickly check that we get a sensible result from the model:",ze,E,Le,z,Pe,L,Ft="Alright! If we compare this to the source text:",Ae,P,Ke,A,De,K,Et=`We see that the translation more or less lines up (you can double check this using Google Translate), barring a small
extra few words at the start of the transcription where the speaker was finishing off their previous sentence.`,Oe,D,zt=`With that, we’ve completed the first half of our cascaded STST pipeline, putting into practice the skills we gained in Unit 5
when we learnt how to use the Whisper model for speech recognition and translation. If you want a refresher on any of the
steps we covered, have a read through the section on <a href="../chapter5/asr_models">Pre-trained models for ASR</a> from Unit 5.`,et,O,tt,ee,Lt=`The second half of our cascaded STST system involves mapping from English text to English speech. For this, we’ll use
the pre-trained <a href="https://huggingface.co/microsoft/speecht5_tts" rel="nofollow">SpeechT5 TTS</a> model for English TTS. 🤗 Transformers currently doesn’t
have a TTS <code>pipeline</code>, so we’ll have to use the model directly ourselves. This is no biggie, you’re all experts on using
the model for inference following Unit 6!`,st,te,Pt="First, let’s load the SpeechT5 processor, model and vocoder from the pre-trained checkpoint:",at,se,nt,Z,lt,ae,At="As with the Whisper model, we’ll place the SpeechT5 model and vocoder on our GPU accelerator device if we have one:",it,ne,ot,le,Kt="Great! Let’s load up the speaker embeddings:",pt,ie,rt,oe,Dt=`We can now write a function that takes a text prompt as input, and generates the corresponding speech. We’ll first pre-process
the text input using the SpeechT5 processor, tokenizing the text to get our input ids. We’ll then pass the input ids and
speaker embeddings to the SpeechT5 model, placing each on the accelerator device if available. Finally, we’ll return the
generated speech, bringing it back to the CPU so that we can play it back in our ipynb notebook:`,ct,pe,ht,re,Ot="Let’s check it works with a dummy text input:",ut,ce,dt,he,es="Sounds good! Now for the exciting part - piecing it all together.",mt,ue,ft,de,ts=`Before we create a <a href="https://gradio.app" rel="nofollow">Gradio</a> demo to showcase our STST system, let’s first do a quick sanity check
to make sure we can concatenate the two models, putting an audio sample in and getting an audio sample out. We’ll do
this by concatenating the two functions we defined in the previous two sub-sections, such that we input the source audio
and retrieve the translated text, then synthesise the translated text to get the translated speech. Finally, we’ll convert
the synthesised speech to an <code>int16</code> array, which is the output audio file format expected by Gradio. To do this, we
first have to normalise the audio array by the dynamic range of the target dtype (<code>int16</code>), and then convert from the
default NumPy dtype (<code>float64</code>) to the target dtype (<code>int16</code>):`,yt,me,gt,fe,ss="Let’s check this concatenated function gives the expected result:",wt,ye,Tt,ge,as=`Perfect! Now we’ll wrap this up into a nice Gradio demo so that we can record our source speech using a microphone input
or file input and playback the system’s prediction:`,Mt,we,Jt,Te,ns="This will launch a Gradio demo similar to the one running on the Hugging Face Space:",bt,T,ls,Ut,Me,is=`You can <a href="https://huggingface.co/spaces/course-demos/speech-to-speech-translation?duplicate=true" rel="nofollow">duplicate</a> this demo and adapt
it to use a different Whisper checkpoint, a different TTS checkpoint, or relax the constraint of outputting English
speech and follow the tips provide for translating into a langauge of your choice!`,jt,Je,vt,be,os=`While the cascaded system is a compute and data efficient way of building a STST system, it suffers from the issues of
error propagation and additive latency described above. Recent works have explored a <em>direct</em> approach to STST, one that
does not predict an intermediate text output and instead maps directly from source speech to target speech. These systems
are also capable of retaining the speaking characteristics of the source speaker in the target speech (such a prosody,
pitch and intonation). If you’re interested in finding out more about these systems, check-out the resources listed in
the section on <a href="supplemental_reading">supplemental reading</a>.`,$t,Ue,kt,ve,Zt;return j=new $e({props:{title:"Speech-to-speech translation",local:"speech-to-speech-translation",headingTag:"h1"}}),N=new $e({props:{title:"Speech translation",local:"speech-translation",headingTag:"h2"}}),B=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTNBMCUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1iYXNlJTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = <span class="hljs-string">&quot;cuda:0&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
pipe = pipeline(
    <span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-base&quot;</span>, device=device
)`,wrap:!1}}),H=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmYWNlYm9vayUyRnZveHBvcHVsaSUyMiUyQyUyMCUyMml0JTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;it&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

Audio(sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], rate=sample[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Q=new y({props:{code:"ZGVmJTIwdHJhbnNsYXRlKGF1ZGlvKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBwaXBlKGF1ZGlvJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYlMkMlMjBnZW5lcmF0ZV9rd2FyZ3MlM0QlN0IlMjJ0YXNrJTIyJTNBJTIwJTIydHJhbnNsYXRlJTIyJTdEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHMlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">translate</span>(<span class="hljs-params">audio</span>):
    outputs = pipe(audio, max_new_tokens=<span class="hljs-number">256</span>, generate_kwargs={<span class="hljs-string">&quot;task&quot;</span>: <span class="hljs-string">&quot;translate&quot;</span>})
    <span class="hljs-keyword">return</span> outputs[<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),k=new cs({props:{$$slots:{default:[bs]},$$scope:{ctx:je}}}),E=new y({props:{code:"dHJhbnNsYXRlKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:'translate(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())',wrap:!1}}),z=new y({props:{code:"JyUyMHBzeWNob2xvZ2ljYWwlMjBhbmQlMjBzb2NpYWwuJTIwSSUyMHRoaW5rJTIwdGhhdCUyMGl0JTIwaXMlMjBhJTIwdmVyeSUyMGltcG9ydGFudCUyMHN0ZXAlMjBpbiUyMHRoZSUyMGNvbnN0cnVjdGlvbiUyMG9mJTIwYSUyMGp1cmlkaWNhbCUyMHNwYWNlJTIwb2YlMjBmcmVlZG9tJTJDJTIwY2lyY3VsYXRpb24lMjBhbmQlMjBwcm90ZWN0aW9uJTIwb2YlMjByaWdodHMuJw==",highlighted:'<span class="hljs-comment">&#x27; psychological and social. I think that it is a very important step in the construction of a juridical space of freedom, circulation and protection of rights.&#x27;</span>',wrap:!1}}),P=new y({props:{code:"c2FtcGxlJTVCJTIycmF3X3RleHQlMjIlNUQ=",highlighted:'sample[<span class="hljs-string">&quot;raw_text&quot;</span>]',wrap:!1}}),A=new y({props:{code:"J1BlbnNvJTIwY2hlJTIwcXVlc3RvJTIwc2lhJTIwdW4lMjBwYXNzbyUyMGluJTIwYXZhbnRpJTIwaW1wb3J0YW50ZSUyMG5lbGxhJTIwY29zdHJ1emlvbmUlMjBkaSUyMHVubyUyMHNwYXppbyUyMGdpdXJpZGljbyUyMGRpJTIwbGliZXJ0JUMzJUEwJTIwZGklMjBjaXJjb2xhemlvbmUlMjBlJTIwZGklMjBwcm90ZXppb25lJTIwZGVpJTIwZGlyaXR0aSUyMHBlciUyMGxlJTIwcGVyc29uZSUyMGluJTIwRXVyb3BhLic=",highlighted:'<span class="hljs-comment">&#x27;Penso che questo sia un passo in avanti importante nella costruzione di uno spazio giuridico di libertà di circolazione e di protezione dei diritti per le persone in Europa.&#x27;</span>',wrap:!1}}),O=new $e({props:{title:"Text-to-speech",local:"text-to-speech",headingTag:"h2"}}),se=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTJDJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2glMkMlMjBTcGVlY2hUNUhpZmlHYW4lMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBTcGVlY2hUNVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3BlZWNodDVfdHRzJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwU3BlZWNoVDVGb3JUZXh0VG9TcGVlY2guZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiklMEF2b2NvZGVyJTIwJTNEJTIwU3BlZWNoVDVIaWZpR2FuLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzcGVlY2h0NV9oaWZpZ2FuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor, SpeechT5ForTextToSpeech, SpeechT5HifiGan

processor = SpeechT5Processor.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)

model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>)
vocoder = SpeechT5HifiGan.from_pretrained(<span class="hljs-string">&quot;microsoft/speecht5_hifigan&quot;</span>)`,wrap:!1}}),Z=new cs({props:{$$slots:{default:[Us]},$$scope:{ctx:je}}}),ne=new y({props:{code:"bW9kZWwudG8oZGV2aWNlKSUwQXZvY29kZXIudG8oZGV2aWNlKQ==",highlighted:`model.to(device)
vocoder.to(device)`,wrap:!1}}),ie=new y({props:{code:"ZW1iZWRkaW5nc19kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMk1hdHRoaWpzJTJGY211LWFyY3RpYy14dmVjdG9ycyUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC50ZW5zb3IoZW1iZWRkaW5nc19kYXRhc2V0JTVCNzMwNiU1RCU1QiUyMnh2ZWN0b3IlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`embeddings_dataset = load_dataset(<span class="hljs-string">&quot;Matthijs/cmu-arctic-xvectors&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
speaker_embeddings = torch.tensor(embeddings_dataset[<span class="hljs-number">7306</span>][<span class="hljs-string">&quot;xvector&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),pe=new y({props:{code:"ZGVmJTIwc3ludGhlc2lzZSh0ZXh0KSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwc3BlZWNoJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGVfc3BlZWNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RC50byhkZXZpY2UpJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzLnRvKGRldmljZSklMkMlMjB2b2NvZGVyJTNEdm9jb2RlciUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVlY2guY3B1KCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">synthesise</span>(<span class="hljs-params">text</span>):
    inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    speech = model.generate_speech(
        inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(device), speaker_embeddings.to(device), vocoder=vocoder
    )
    <span class="hljs-keyword">return</span> speech.cpu()`,wrap:!1}}),ce=new y({props:{code:"c3BlZWNoJTIwJTNEJTIwc3ludGhlc2lzZSglMjJIZXklMjB0aGVyZSElMjBUaGlzJTIwaXMlMjBhJTIwdGVzdCElMjIpJTBBJTBBQXVkaW8oc3BlZWNoJTJDJTIwcmF0ZSUzRDE2MDAwKQ==",highlighted:`speech = synthesise(<span class="hljs-string">&quot;Hey there! This is a test!&quot;</span>)

Audio(speech, rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),ue=new $e({props:{title:"Creating a STST demo",local:"creating-a-stst-demo",headingTag:"h2"}}),me=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBdGFyZ2V0X2R0eXBlJTIwJTNEJTIwbnAuaW50MTYlMEFtYXhfcmFuZ2UlMjAlM0QlMjBucC5paW5mbyh0YXJnZXRfZHR5cGUpLm1heCUwQSUwQSUwQWRlZiUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oYXVkaW8pJTNBJTBBJTIwJTIwJTIwJTIwdHJhbnNsYXRlZF90ZXh0JTIwJTNEJTIwdHJhbnNsYXRlKGF1ZGlvKSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHN5bnRoZXNpc2UodHJhbnNsYXRlZF90ZXh0KSUwQSUyMCUyMCUyMCUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMChzeW50aGVzaXNlZF9zcGVlY2gubnVtcHkoKSUyMColMjBtYXhfcmFuZ2UpLmFzdHlwZShucC5pbnQxNiklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxNjAwMCUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

target_dtype = np.int16
max_range = np.iinfo(target_dtype).<span class="hljs-built_in">max</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">speech_to_speech_translation</span>(<span class="hljs-params">audio</span>):
    translated_text = translate(audio)
    synthesised_speech = synthesise(translated_text)
    synthesised_speech = (synthesised_speech.numpy() * max_range).astype(np.int16)
    <span class="hljs-keyword">return</span> <span class="hljs-number">16000</span>, synthesised_speech`,wrap:!1}}),ye=new y({props:{code:"c2FtcGxpbmdfcmF0ZSUyQyUyMHN5bnRoZXNpc2VkX3NwZWVjaCUyMCUzRCUyMHNwZWVjaF90b19zcGVlY2hfdHJhbnNsYXRpb24oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQpJTBBJTBBQXVkaW8oc3ludGhlc2lzZWRfc3BlZWNoJTJDJTIwcmF0ZSUzRHNhbXBsaW5nX3JhdGUp",highlighted:`sampling_rate, synthesised_speech = speech_to_speech_translation(sample[<span class="hljs-string">&quot;audio&quot;</span>])

Audio(synthesised_speech, rate=sampling_rate)`,wrap:!1}}),we=new y({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQWRlbW8lMjAlM0QlMjBnci5CbG9ja3MoKSUwQSUwQW1pY190cmFuc2xhdGUlMjAlM0QlMjBnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RzcGVlY2hfdG9fc3BlZWNoX3RyYW5zbGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTNEZ3IuQXVkaW8oc291cmNlJTNEJTIybWljcm9waG9uZSUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQWZpbGVfdHJhbnNsYXRlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEc3BlZWNoX3RvX3NwZWVjaF90cmFuc2xhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRGdyLkF1ZGlvKHNvdXJjZSUzRCUyMnVwbG9hZCUyMiUyQyUyMHR5cGUlM0QlMjJmaWxlcGF0aCUyMiklMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTNEZ3IuQXVkaW8obGFiZWwlM0QlMjJHZW5lcmF0ZWQlMjBTcGVlY2glMjIlMkMlMjB0eXBlJTNEJTIybnVtcHklMjIpJTJDJTBBKSUwQSUwQXdpdGglMjBkZW1vJTNBJTBBJTIwJTIwJTIwJTIwZ3IuVGFiYmVkSW50ZXJmYWNlKCU1Qm1pY190cmFuc2xhdGUlMkMlMjBmaWxlX3RyYW5zbGF0ZSU1RCUyQyUyMCU1QiUyMk1pY3JvcGhvbmUlMjIlMkMlMjAlMjJBdWRpbyUyMEZpbGUlMjIlNUQpJTBBJTBBZGVtby5sYXVuY2goZGVidWclM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

demo = gr.Blocks()

mic_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;microphone&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

file_translate = gr.Interface(
    fn=speech_to_speech_translation,
    inputs=gr.Audio(source=<span class="hljs-string">&quot;upload&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;filepath&quot;</span>),
    outputs=gr.Audio(label=<span class="hljs-string">&quot;Generated Speech&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;numpy&quot;</span>),
)

<span class="hljs-keyword">with</span> demo:
    gr.TabbedInterface([mic_translate, file_translate], [<span class="hljs-string">&quot;Microphone&quot;</span>, <span class="hljs-string">&quot;Audio File&quot;</span>])

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),Je=new $e({props:{title:"Going forwards",local:"going-forwards",headingTag:"h2"}}),Ue=new Js({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/en/chapter7/speech-to-speech.mdx"}}),{c(){f=i("meta"),w=n(),M=i("p"),J=n(),r(j.$$.fragment),g=n(),b=i("p"),b.innerHTML=xt,ke=n(),v=i("div"),v.innerHTML=St,Ze=n(),G=i("p"),G.innerHTML=Ct,Ge=n(),x=i("p"),x.textContent=It,xe=n(),S=i("p"),S.innerHTML=Wt,Se=n(),$=i("div"),$.innerHTML=Nt,Ce=n(),C=i("p"),C.innerHTML=_t,Ie=n(),I=i("p"),I.innerHTML=Bt,We=n(),W=i("p"),W.textContent=Vt,Ne=n(),r(N.$$.fragment),_e=n(),_=i("p"),_.innerHTML=Ht,Be=n(),r(B.$$.fragment),Ve=n(),V=i("p"),V.innerHTML=Xt,He=n(),r(H.$$.fragment),Xe=n(),X=i("p"),X.innerHTML=qt,qe=n(),q=i("p"),q.textContent=Rt,Re=n(),r(R.$$.fragment),Ye=n(),Y=i("p"),Y.innerHTML=Yt,Qe=n(),r(Q.$$.fragment),Fe=n(),r(k.$$.fragment),Ee=n(),F=i("p"),F.textContent=Qt,ze=n(),r(E.$$.fragment),Le=n(),r(z.$$.fragment),Pe=n(),L=i("p"),L.textContent=Ft,Ae=n(),r(P.$$.fragment),Ke=n(),r(A.$$.fragment),De=n(),K=i("p"),K.textContent=Et,Oe=n(),D=i("p"),D.innerHTML=zt,et=n(),r(O.$$.fragment),tt=n(),ee=i("p"),ee.innerHTML=Lt,st=n(),te=i("p"),te.textContent=Pt,at=n(),r(se.$$.fragment),nt=n(),r(Z.$$.fragment),lt=n(),ae=i("p"),ae.textContent=At,it=n(),r(ne.$$.fragment),ot=n(),le=i("p"),le.textContent=Kt,pt=n(),r(ie.$$.fragment),rt=n(),oe=i("p"),oe.textContent=Dt,ct=n(),r(pe.$$.fragment),ht=n(),re=i("p"),re.textContent=Ot,ut=n(),r(ce.$$.fragment),dt=n(),he=i("p"),he.textContent=es,mt=n(),r(ue.$$.fragment),ft=n(),de=i("p"),de.innerHTML=ts,yt=n(),r(me.$$.fragment),gt=n(),fe=i("p"),fe.textContent=ss,wt=n(),r(ye.$$.fragment),Tt=n(),ge=i("p"),ge.textContent=as,Mt=n(),r(we.$$.fragment),Jt=n(),Te=i("p"),Te.textContent=ns,bt=n(),T=i("iframe"),Ut=n(),Me=i("p"),Me.innerHTML=is,jt=n(),r(Je.$$.fragment),vt=n(),be=i("p"),be.innerHTML=os,$t=n(),r(Ue.$$.fragment),kt=n(),ve=i("p"),this.h()},l(e){const t=gs("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(s),w=l(e),M=o(e,"P",{}),Gt(M).forEach(s),J=l(e),c(j.$$.fragment,e),g=l(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-xrl39y"&&(b.innerHTML=xt),ke=l(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(v)!=="svelte-1q8w6r1"&&(v.innerHTML=St),Ze=l(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1r1gucv"&&(G.innerHTML=Ct),Ge=l(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-1g3p1ee"&&(x.textContent=It),xe=l(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-16kqqhy"&&(S.innerHTML=Wt),Se=l(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p($)!=="svelte-55g36w"&&($.innerHTML=Nt),Ce=l(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-17ui3zo"&&(C.innerHTML=_t),Ie=l(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-oqffa8"&&(I.innerHTML=Bt),We=l(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1jnkkhd"&&(W.textContent=Vt),Ne=l(e),c(N.$$.fragment,e),_e=l(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1d2no8a"&&(_.innerHTML=Ht),Be=l(e),c(B.$$.fragment,e),Ve=l(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1s7hzub"&&(V.innerHTML=Xt),He=l(e),c(H.$$.fragment,e),Xe=l(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-veyz1i"&&(X.innerHTML=qt),qe=l(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-txz4z7"&&(q.textContent=Rt),Re=l(e),c(R.$$.fragment,e),Ye=l(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-uzvw8l"&&(Y.innerHTML=Yt),Qe=l(e),c(Q.$$.fragment,e),Fe=l(e),c(k.$$.fragment,e),Ee=l(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-dz3cev"&&(F.textContent=Qt),ze=l(e),c(E.$$.fragment,e),Le=l(e),c(z.$$.fragment,e),Pe=l(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1j8a6ju"&&(L.textContent=Ft),Ae=l(e),c(P.$$.fragment,e),Ke=l(e),c(A.$$.fragment,e),De=l(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-wp88n3"&&(K.textContent=Et),Oe=l(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-k7dh1z"&&(D.innerHTML=zt),et=l(e),c(O.$$.fragment,e),tt=l(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1xzib0a"&&(ee.innerHTML=Lt),st=l(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-d9cpp9"&&(te.textContent=Pt),at=l(e),c(se.$$.fragment,e),nt=l(e),c(Z.$$.fragment,e),lt=l(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-2glor5"&&(ae.textContent=At),it=l(e),c(ne.$$.fragment,e),ot=l(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-f6jrhm"&&(le.textContent=Kt),pt=l(e),c(ie.$$.fragment,e),rt=l(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1hvsx4q"&&(oe.textContent=Dt),ct=l(e),c(pe.$$.fragment,e),ht=l(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-i24jqg"&&(re.textContent=Ot),ut=l(e),c(ce.$$.fragment,e),dt=l(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-e3hzpi"&&(he.textContent=es),mt=l(e),c(ue.$$.fragment,e),ft=l(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-17w2mjs"&&(de.innerHTML=ts),yt=l(e),c(me.$$.fragment,e),gt=l(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1a1frzk"&&(fe.textContent=ss),wt=l(e),c(ye.$$.fragment,e),Tt=l(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1f76kv1"&&(ge.textContent=as),Mt=l(e),c(we.$$.fragment,e),Jt=l(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-10sf4ix"&&(Te.textContent=ns),bt=l(e),T=o(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),Gt(T).forEach(s),Ut=l(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1arc8ys"&&(Me.innerHTML=is),jt=l(e),c(Je.$$.fragment,e),vt=l(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-9tvm6n"&&(be.innerHTML=os),$t=l(e),c(Ue.$$.fragment,e),kt=l(e),ve=o(e,"P",{}),Gt(ve).forEach(s),this.h()},h(){U(f,"name","hf:doc:metadata"),U(f,"content",vs),U(v,"class","flex justify-center"),U($,"class","flex justify-center"),us(T.src,ls="https://course-demos-speech-to-speech-translation.hf.space")||U(T,"src",ls),U(T,"frameborder","0"),U(T,"height","450"),U(T,"title","Gradio app"),U(T,"class","container p-0 flex-grow space-iframe"),U(T,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),U(T,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,t){ws(document.head,f),a(e,w,t),a(e,M,t),a(e,J,t),h(j,e,t),a(e,g,t),a(e,b,t),a(e,ke,t),a(e,v,t),a(e,Ze,t),a(e,G,t),a(e,Ge,t),a(e,x,t),a(e,xe,t),a(e,S,t),a(e,Se,t),a(e,$,t),a(e,Ce,t),a(e,C,t),a(e,Ie,t),a(e,I,t),a(e,We,t),a(e,W,t),a(e,Ne,t),h(N,e,t),a(e,_e,t),a(e,_,t),a(e,Be,t),h(B,e,t),a(e,Ve,t),a(e,V,t),a(e,He,t),h(H,e,t),a(e,Xe,t),a(e,X,t),a(e,qe,t),a(e,q,t),a(e,Re,t),h(R,e,t),a(e,Ye,t),a(e,Y,t),a(e,Qe,t),h(Q,e,t),a(e,Fe,t),h(k,e,t),a(e,Ee,t),a(e,F,t),a(e,ze,t),h(E,e,t),a(e,Le,t),h(z,e,t),a(e,Pe,t),a(e,L,t),a(e,Ae,t),h(P,e,t),a(e,Ke,t),h(A,e,t),a(e,De,t),a(e,K,t),a(e,Oe,t),a(e,D,t),a(e,et,t),h(O,e,t),a(e,tt,t),a(e,ee,t),a(e,st,t),a(e,te,t),a(e,at,t),h(se,e,t),a(e,nt,t),h(Z,e,t),a(e,lt,t),a(e,ae,t),a(e,it,t),h(ne,e,t),a(e,ot,t),a(e,le,t),a(e,pt,t),h(ie,e,t),a(e,rt,t),a(e,oe,t),a(e,ct,t),h(pe,e,t),a(e,ht,t),a(e,re,t),a(e,ut,t),h(ce,e,t),a(e,dt,t),a(e,he,t),a(e,mt,t),h(ue,e,t),a(e,ft,t),a(e,de,t),a(e,yt,t),h(me,e,t),a(e,gt,t),a(e,fe,t),a(e,wt,t),h(ye,e,t),a(e,Tt,t),a(e,ge,t),a(e,Mt,t),h(we,e,t),a(e,Jt,t),a(e,Te,t),a(e,bt,t),a(e,T,t),a(e,Ut,t),a(e,Me,t),a(e,jt,t),h(Je,e,t),a(e,vt,t),a(e,be,t),a(e,$t,t),h(Ue,e,t),a(e,kt,t),a(e,ve,t),Zt=!0},p(e,[t]){const ps={};t&2&&(ps.$$scope={dirty:t,ctx:e}),k.$set(ps);const rs={};t&2&&(rs.$$scope={dirty:t,ctx:e}),Z.$set(rs)},i(e){Zt||(u(j.$$.fragment,e),u(N.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(k.$$.fragment,e),u(E.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(Z.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(Ue.$$.fragment,e),Zt=!0)},o(e){d(j.$$.fragment,e),d(N.$$.fragment,e),d(B.$$.fragment,e),d(H.$$.fragment,e),d(R.$$.fragment,e),d(Q.$$.fragment,e),d(k.$$.fragment,e),d(E.$$.fragment,e),d(z.$$.fragment,e),d(P.$$.fragment,e),d(A.$$.fragment,e),d(O.$$.fragment,e),d(se.$$.fragment,e),d(Z.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),d(Ue.$$.fragment,e),Zt=!1},d(e){e&&(s(w),s(M),s(J),s(g),s(b),s(ke),s(v),s(Ze),s(G),s(Ge),s(x),s(xe),s(S),s(Se),s($),s(Ce),s(C),s(Ie),s(I),s(We),s(W),s(Ne),s(_e),s(_),s(Be),s(Ve),s(V),s(He),s(Xe),s(X),s(qe),s(q),s(Re),s(Ye),s(Y),s(Qe),s(Fe),s(Ee),s(F),s(ze),s(Le),s(Pe),s(L),s(Ae),s(Ke),s(De),s(K),s(Oe),s(D),s(et),s(tt),s(ee),s(st),s(te),s(at),s(nt),s(lt),s(ae),s(it),s(ot),s(le),s(pt),s(rt),s(oe),s(ct),s(ht),s(re),s(ut),s(dt),s(he),s(mt),s(ft),s(de),s(yt),s(gt),s(fe),s(wt),s(Tt),s(ge),s(Mt),s(Jt),s(Te),s(bt),s(T),s(Ut),s(Me),s(jt),s(vt),s(be),s($t),s(kt),s(ve)),s(f),m(j,e),m(N,e),m(B,e),m(H,e),m(R,e),m(Q,e),m(k,e),m(E,e),m(z,e),m(P,e),m(A,e),m(O,e),m(se,e),m(Z,e),m(ne,e),m(ie,e),m(pe,e),m(ce,e),m(ue,e),m(me,e),m(ye,e),m(we,e),m(Je,e),m(Ue,e)}}}const vs='{"title":"Speech-to-speech translation","local":"speech-to-speech-translation","sections":[{"title":"Speech translation","local":"speech-translation","sections":[],"depth":2},{"title":"Text-to-speech","local":"text-to-speech","sections":[],"depth":2},{"title":"Creating a STST demo","local":"creating-a-stst-demo","sections":[],"depth":2},{"title":"Going forwards","local":"going-forwards","sections":[],"depth":2}],"depth":1}';function $s(je){return ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends fs{constructor(f){super(),ys(this,f,$s,js,hs,{})}}export{Cs as component};
