import{s as ae,n as te,o as ne}from"../chunks/scheduler.f6b352c8.js";import{S as Me,i as oe,g as M,s as t,r as p,A as ie,h as o,f as s,c as n,j as se,u as r,x as i,k as Zl,y as pe,a,v as u,d,t as c,w as j}from"../chunks/index.7f38e934.js";import{C as m}from"../chunks/CodeBlock.3ee8293b.js";import{H as re,E as ue}from"../chunks/getInferenceSnippets.b4820bde.js";function de(xl){let y,O,P,K,J,ll,T,Bl=`En este curso usaremos la libreria 🤗 Datasets para trabajar con bases de datos de audio. 🤗 Datasets es una libreria de
código abierto para descargar y preparar conjuntos de datos de todos los tipos, incluyendo audio. La libreria ofrece un
acceso fácil a una gran cantidad de conjuntos de datos públicos almacenados en el Hugging Face Hub. Además, 🤗 Datasets incluye
multiples funcionalidades pensadas para simplificar el trabajo con conjuntos de datos de audio para investigadores y desarrolladores.`,el,w,_l="Para empezar a trabajar con bases de datos de audio, asegurate de tener la librería 🤗 Datasets instalada:",sl,h,al,b,Ql=`Una de las principales características de 🤗 Datasets es la posibilidad de descargar y preparar un conjunto de datos
en una sola linea de código usando la función <code>load_dataset()</code>`,tl,f,Wl=`Carguemos y exploremos un conjunto de audios llamado <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a>, el cual contiene
grabaciones de personas haciendo preguntas sobre sistemas electrónicos bancarios en diferentes lenguajes y dialectos.`,nl,A,Rl=`Para cargar MINDS-14, necesitamos copiar el identificador de la base de datos que aparece en el Hub (<code>PolyAI/minds14</code>) y pasarlo
como argumento a la función <code>load_dataset</code>. Tambien especificaremos que solo estamos interesados en el subconjunto de inglés Australiano(<code>en-AU</code>)
y la partición de entrenamiento(“train”):`,Ml,C,ol,I,Fl="<strong>Output:</strong>",il,g,pl,$,Hl=`El conjunto de datos contiene 654 audios, cada uno acompañado de su transcripción, una transcripción en inglés, y una etiqueta
que indica la intención de la pregunta de la persona. La columna de audio, contiene la información en bruto del audio. Examinemos
ahora uno de los ejemplos:`,rl,G,ul,v,Yl="<strong>Output:</strong>",dl,k,cl,q,Sl="Puedes ver que la columna de audio se compone de las siguiente información:",jl,E,Nl="<li><code>path</code>: La ruta al archivo de audio (<code>*.wav</code> en este caso).</li> <li><code>array</code>: Los datos decodificados de audios, representedos como un NumPy array de 1 dimensión.</li> <li><code>sampling_rate</code>. La frecuencia de muestreo del archivo (8,000 Hz en este ejemplo).</li>",ml,Z,zl=`La columna <code>intent_class</code> es de tipo categórico codificado en enteros. Para convertir este número en una texto con significado
podemos usar el método <code>int2str()</code>:`,yl,x,Ul,B,Xl="<strong>Output:</strong>",Jl,_,Tl,Q,Ll=`Si miras la columna de <code>transcription</code>, puedes ver que en efecto la persona ha grabado un audio haciendo una pregunta sobre
pagar una cuenta.`,wl,W,Vl=`Si planeas entrenar un clasificador de audio en este subconjunto de datos, no necesitas toda la información contenida en las
columnas del conjunto de datos. Por ejemplo, la información en <code>lang_id</code> sera igual para todos los ejemplos y no nos será útil.
La columna <code>english_transcription&#39; seguramente sera un duplicado de la columna </code>transcription\` en este subconjunto, por lo que
podemos removerla tambien.`,hl,R,Pl="Puedes eliminar características irrelevantes usando el método `<code>remove_columns</code>de 🤗 Datasets",bl,F,fl,H,Dl="<strong>Output:</strong>",Al,Y,Cl,S,Ol=`Ahora que hemos cargado e inspeccionado los contenidos del conjunto de datos, ¡escuchemos algunos ejemplos! Usaremos <code>Blocks</code>
y <code>Audio</code> de <code>Gradio</code> para cargar algunos ejemplos del dataset.`,Il,N,gl,z,Kl="Podemos visulizar tambien algunos de los ejemplos. Grafiquemos ahora la forma de onda del primer ejemplo.",$l,X,Gl,U,le='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_unit1.png" alt="Waveform plot"/>',vl,L,ee=`¡Pruebalo! Decarga otro dialecto o lenguaje del conjunto MINDS-14, escucha y visualiza ajgunos ejemplos para tener un
sentido de la variación de toda la base de datos. Puedes ver una lista de todos los lenguajes <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">aqui</a>.`,kl,V,ql,D,El;return J=new re({props:{title:"Cargar y explorar una base de datos de audio",local:"cargar-y-explorar-una-base-de-datos-de-audio",headingTag:"h1"}}),h=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTVCYXVkaW8lNUQ=",highlighted:"pip install datasets[audio]",wrap:!1}}),C=new m({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBbWluZHM=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
minds`,wrap:!1}}),g=new m({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmdsaXNoX3RyYW5zY3JpcHRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYW5nX2lkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Jvd3MlM0ElMjA2NTQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [
            <span class="hljs-string">&quot;path&quot;</span>,
            <span class="hljs-string">&quot;audio&quot;</span>,
            <span class="hljs-string">&quot;transcription&quot;</span>,
            <span class="hljs-string">&quot;english_transcription&quot;</span>,
            <span class="hljs-string">&quot;intent_class&quot;</span>,
            <span class="hljs-string">&quot;lang_id&quot;</span>,
        ],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">654</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),G=new m({props:{code:"ZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWV4YW1wbGU=",highlighted:`example = minds[<span class="hljs-number">0</span>]
example`,wrap:!1}}),k=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIwLjAlMkMlMjAwLjAwMDI0NDE0JTJDJTIwLTAuMDAwMjQ0MTQlMkMlMjAuLi4lMkMlMjAtMC4wMDAyNDQxNCUyQyUyMDAuMDAwMjQ0MTQlMkMlMjAwLjAwMTIyMDclNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDgwMDAlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2NyaXB0aW9uJTIyJTNBJTIwJTIySSUyMHdvdWxkJTIwbGlrZSUyMHRvJTIwcGF5JTIwbXklMjBlbGVjdHJpY2l0eSUyMGJpbGwlMjB1c2luZyUyMG15JTIwY2FyZCUyMGNhbiUyMHlvdSUyMHBsZWFzZSUyMGFzc2lzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVuZ2xpc2hfdHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhbmdfaWQlMjIlM0ElMjAyJTJDJTBBJTdE",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [<span class="hljs-number">0.0</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">-0.00024414</span>, ..., <span class="hljs-number">-0.00024414</span>, <span class="hljs-number">0.00024414</span>, <span class="hljs-number">0.0012207</span>],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">8000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;english_transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
    <span class="hljs-comment">&quot;lang_id&quot;</span>: <span class="hljs-number">2</span>,
}`,wrap:!1}}),x=new m({props:{code:"aWQybGFiZWwlMjAlM0QlMjBtaW5kcy5mZWF0dXJlcyU1QiUyMmludGVudF9jbGFzcyUyMiU1RC5pbnQyc3RyJTBBaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCk=",highlighted:`id2label = minds.features[<span class="hljs-string">&quot;intent_class&quot;</span>].int2str
id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])`,wrap:!1}}),_=new m({props:{code:"JTIycGF5X2JpbGwlMjI=",highlighted:'<span class="hljs-string">&quot;pay_bill&quot;</span>',wrap:!1}}),F=new m({props:{code:"Y29sdW1uc190b19yZW1vdmUlMjAlM0QlMjAlNUIlMjJsYW5nX2lkJTIyJTJDJTIwJTIyZW5nbGlzaF90cmFuc2NyaXB0aW9uJTIyJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5yZW1vdmVfY29sdW1ucyhjb2x1bW5zX3RvX3JlbW92ZSklMEFtaW5kcw==",highlighted:`columns_to_remove = [<span class="hljs-string">&quot;lang_id&quot;</span>, <span class="hljs-string">&quot;english_transcription&quot;</span>]
minds = minds.remove_columns(columns_to_remove)
minds`,wrap:!1}}),Y=new m({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDY1NCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 654})</span>',wrap:!1}}),N=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGdlbmVyYXRlX2F1ZGlvKCklM0ElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwbWluZHMuc2h1ZmZsZSgpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmF1ZGlvJTIyJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjApJTJDJTIwaWQybGFiZWwoZXhhbXBsZSU1QiUyMmludGVudF9jbGFzcyUyMiU1RCklMEElMEElMEF3aXRoJTIwZ3IuQmxvY2tzKCklMjBhcyUyMGRlbW8lM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwZ3IuQ29sdW1uKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBfJTIwaW4lMjByYW5nZSg0KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTJDJTIwbGFiZWwlMjAlM0QlMjBnZW5lcmF0ZV9hdWRpbygpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwZ3IuQXVkaW8oYXVkaW8lMkMlMjBsYWJlbCUzRGxhYmVsKSUwQSUwQWRlbW8ubGF1bmNoKGRlYnVnJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_audio</span>():
    example = minds.shuffle()[<span class="hljs-number">0</span>]
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    <span class="hljs-keyword">return</span> (
        audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
        audio[<span class="hljs-string">&quot;array&quot;</span>],
    ), id2label(example[<span class="hljs-string">&quot;intent_class&quot;</span>])


<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> demo:
    <span class="hljs-keyword">with</span> gr.Column():
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">4</span>):
            audio, label = generate_audio()
            output = gr.Audio(audio, label=label)

demo.launch(debug=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new m({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBsaWJyb3NhLmRpc3BsYXklMEElMEFhcnJheSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGV4YW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQWxpYnJvc2EuZGlzcGxheS53YXZlc2hvdyhhcnJheSUyQyUyMHNyJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">import</span> librosa
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

array = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
sampling_rate = example[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),V=new ue({props:{source:"https://github.com/huggingface/audio-transformers-course/blob/main/chapters/es/chapter1/load_and_explore.mdx"}}),{c(){y=M("meta"),O=t(),P=M("p"),K=t(),p(J.$$.fragment),ll=t(),T=M("p"),T.textContent=Bl,el=t(),w=M("p"),w.textContent=_l,sl=t(),p(h.$$.fragment),al=t(),b=M("p"),b.innerHTML=Ql,tl=t(),f=M("p"),f.innerHTML=Wl,nl=t(),A=M("p"),A.innerHTML=Rl,Ml=t(),p(C.$$.fragment),ol=t(),I=M("p"),I.innerHTML=Fl,il=t(),p(g.$$.fragment),pl=t(),$=M("p"),$.textContent=Hl,rl=t(),p(G.$$.fragment),ul=t(),v=M("p"),v.innerHTML=Yl,dl=t(),p(k.$$.fragment),cl=t(),q=M("p"),q.textContent=Sl,jl=t(),E=M("ul"),E.innerHTML=Nl,ml=t(),Z=M("p"),Z.innerHTML=zl,yl=t(),p(x.$$.fragment),Ul=t(),B=M("p"),B.innerHTML=Xl,Jl=t(),p(_.$$.fragment),Tl=t(),Q=M("p"),Q.innerHTML=Ll,wl=t(),W=M("p"),W.innerHTML=Vl,hl=t(),R=M("p"),R.innerHTML=Pl,bl=t(),p(F.$$.fragment),fl=t(),H=M("p"),H.innerHTML=Dl,Al=t(),p(Y.$$.fragment),Cl=t(),S=M("p"),S.innerHTML=Ol,Il=t(),p(N.$$.fragment),gl=t(),z=M("p"),z.textContent=Kl,$l=t(),p(X.$$.fragment),Gl=t(),U=M("div"),U.innerHTML=le,vl=t(),L=M("p"),L.innerHTML=ee,kl=t(),p(V.$$.fragment),ql=t(),D=M("p"),this.h()},l(l){const e=ie("svelte-u9bgzb",document.head);y=o(e,"META",{name:!0,content:!0}),e.forEach(s),O=n(l),P=o(l,"P",{}),se(P).forEach(s),K=n(l),r(J.$$.fragment,l),ll=n(l),T=o(l,"P",{"data-svelte-h":!0}),i(T)!=="svelte-fms3f9"&&(T.textContent=Bl),el=n(l),w=o(l,"P",{"data-svelte-h":!0}),i(w)!=="svelte-1o8p9et"&&(w.textContent=_l),sl=n(l),r(h.$$.fragment,l),al=n(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-1kcnm3r"&&(b.innerHTML=Ql),tl=n(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1yiem8x"&&(f.innerHTML=Wl),nl=n(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1ir28gq"&&(A.innerHTML=Rl),Ml=n(l),r(C.$$.fragment,l),ol=n(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1mvdyro"&&(I.innerHTML=Fl),il=n(l),r(g.$$.fragment,l),pl=n(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-ivyj94"&&($.textContent=Hl),rl=n(l),r(G.$$.fragment,l),ul=n(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1mvdyro"&&(v.innerHTML=Yl),dl=n(l),r(k.$$.fragment,l),cl=n(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-hxz5rj"&&(q.textContent=Sl),jl=n(l),E=o(l,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-op7a9q"&&(E.innerHTML=Nl),ml=n(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ybdd87"&&(Z.innerHTML=zl),yl=n(l),r(x.$$.fragment,l),Ul=n(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1mvdyro"&&(B.innerHTML=Xl),Jl=n(l),r(_.$$.fragment,l),Tl=n(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1v4lcjp"&&(Q.innerHTML=Ll),wl=n(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1ufbi3q"&&(W.innerHTML=Vl),hl=n(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-18j6r1l"&&(R.innerHTML=Pl),bl=n(l),r(F.$$.fragment,l),fl=n(l),H=o(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1mvdyro"&&(H.innerHTML=Dl),Al=n(l),r(Y.$$.fragment,l),Cl=n(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-ymdrwo"&&(S.innerHTML=Ol),Il=n(l),r(N.$$.fragment,l),gl=n(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1jx33x4"&&(z.textContent=Kl),$l=n(l),r(X.$$.fragment,l),Gl=n(l),U=o(l,"DIV",{class:!0,"data-svelte-h":!0}),i(U)!=="svelte-1ym6zda"&&(U.innerHTML=le),vl=n(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1wmw5cx"&&(L.innerHTML=ee),kl=n(l),r(V.$$.fragment,l),ql=n(l),D=o(l,"P",{}),se(D).forEach(s),this.h()},h(){Zl(y,"name","hf:doc:metadata"),Zl(y,"content",ce),Zl(U,"class","flex justify-center")},m(l,e){pe(document.head,y),a(l,O,e),a(l,P,e),a(l,K,e),u(J,l,e),a(l,ll,e),a(l,T,e),a(l,el,e),a(l,w,e),a(l,sl,e),u(h,l,e),a(l,al,e),a(l,b,e),a(l,tl,e),a(l,f,e),a(l,nl,e),a(l,A,e),a(l,Ml,e),u(C,l,e),a(l,ol,e),a(l,I,e),a(l,il,e),u(g,l,e),a(l,pl,e),a(l,$,e),a(l,rl,e),u(G,l,e),a(l,ul,e),a(l,v,e),a(l,dl,e),u(k,l,e),a(l,cl,e),a(l,q,e),a(l,jl,e),a(l,E,e),a(l,ml,e),a(l,Z,e),a(l,yl,e),u(x,l,e),a(l,Ul,e),a(l,B,e),a(l,Jl,e),u(_,l,e),a(l,Tl,e),a(l,Q,e),a(l,wl,e),a(l,W,e),a(l,hl,e),a(l,R,e),a(l,bl,e),u(F,l,e),a(l,fl,e),a(l,H,e),a(l,Al,e),u(Y,l,e),a(l,Cl,e),a(l,S,e),a(l,Il,e),u(N,l,e),a(l,gl,e),a(l,z,e),a(l,$l,e),u(X,l,e),a(l,Gl,e),a(l,U,e),a(l,vl,e),a(l,L,e),a(l,kl,e),u(V,l,e),a(l,ql,e),a(l,D,e),El=!0},p:te,i(l){El||(d(J.$$.fragment,l),d(h.$$.fragment,l),d(C.$$.fragment,l),d(g.$$.fragment,l),d(G.$$.fragment,l),d(k.$$.fragment,l),d(x.$$.fragment,l),d(_.$$.fragment,l),d(F.$$.fragment,l),d(Y.$$.fragment,l),d(N.$$.fragment,l),d(X.$$.fragment,l),d(V.$$.fragment,l),El=!0)},o(l){c(J.$$.fragment,l),c(h.$$.fragment,l),c(C.$$.fragment,l),c(g.$$.fragment,l),c(G.$$.fragment,l),c(k.$$.fragment,l),c(x.$$.fragment,l),c(_.$$.fragment,l),c(F.$$.fragment,l),c(Y.$$.fragment,l),c(N.$$.fragment,l),c(X.$$.fragment,l),c(V.$$.fragment,l),El=!1},d(l){l&&(s(O),s(P),s(K),s(ll),s(T),s(el),s(w),s(sl),s(al),s(b),s(tl),s(f),s(nl),s(A),s(Ml),s(ol),s(I),s(il),s(pl),s($),s(rl),s(ul),s(v),s(dl),s(cl),s(q),s(jl),s(E),s(ml),s(Z),s(yl),s(Ul),s(B),s(Jl),s(Tl),s(Q),s(wl),s(W),s(hl),s(R),s(bl),s(fl),s(H),s(Al),s(Cl),s(S),s(Il),s(gl),s(z),s($l),s(Gl),s(U),s(vl),s(L),s(kl),s(ql),s(D)),s(y),j(J,l),j(h,l),j(C,l),j(g,l),j(G,l),j(k,l),j(x,l),j(_,l),j(F,l),j(Y,l),j(N,l),j(X,l),j(V,l)}}}const ce='{"title":"Cargar y explorar una base de datos de audio","local":"cargar-y-explorar-una-base-de-datos-de-audio","sections":[],"depth":1}';function je(xl){return ne(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Te extends Me{constructor(y){super(),oe(this,y,je,de,ae,{})}}export{Te as component};
