import{s as Gt,o as Ct,n as _t}from"../chunks/scheduler.37c15a92.js";import{S as Zt,i as Rt,g as o,s as l,r as p,A as zt,h as r,f as n,c as a,j as qt,u as c,x as u,k as kt,y as Ht,a as s,v as d,d as m,t as f,w as M}from"../chunks/index.2bf4358c.js";import{T as Ut}from"../chunks/Tip.363c041f.js";import{Y as Wt}from"../chunks/Youtube.1e50a667.js";import{C as v}from"../chunks/CodeBlock.4e987730.js";import{C as Et}from"../chunks/CourseFloatingBanner.6add7356.js";import{F as Ft}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as tt,E as It}from"../chunks/getInferenceSnippets.1837c472.js";function xt(J){let i,h='💡 Si vous voulez télécharger automatiquement votre modèle sur le <em>Hub</em> pendant l’entraînement, passez <code>push_to_hub=True</code> dans le <code>TrainingArguments</code>. Nous en apprendrons plus à ce sujet au <a href="/course/fr/chapter4/3">chapitre 4</a>.';return{c(){i=o("p"),i.innerHTML=h},l(b){i=r(b,"P",{"data-svelte-h":!0}),u(i)!=="svelte-pjt16k"&&(i.innerHTML=h)},m(b,$){s(b,i,$)},p:_t,d(b){b&&n(i)}}}function Xt(J){let i,h="✏️ <strong>Essayez !</strong> <em>Finetunez</em> un modèle sur le jeu de données GLUE SST-2, en utilisant le traitement des données que vous avez fait dans la section 2.";return{c(){i=o("p"),i.innerHTML=h},l(b){i=r(b,"P",{"data-svelte-h":!0}),u(i)!=="svelte-8jszuf"&&(i.innerHTML=h)},m(b,$){s(b,i,$)},p:_t,d(b){b&&n(i)}}}function Vt(J){let i,h,b,$,T,ce,g,de,w,me,q,fe,k,nt='La bibliothèque 🤗 <em>Transformers</em> fournit une classe <code>Trainer</code> pour vous aider à <em>finetuner</em> n’importe lequel des modèles pré-entraînés qu’elle met à disposition sur votre jeu de données. Une fois que vous avez fait tout le travail de prétraitement des données dans la dernière section, il ne vous reste que quelques étapes pour définir le <code>Trainer</code>. La partie la plus difficile sera probablement de préparer l’environnement pour exécuter <code>Trainer.train()</code>, car elle fonctionnera très lentement sur un CPU. Si vous n’avez pas de GPU, vous pouvez avoir accès à des GPUs ou TPUs gratuits sur <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',Me,U,st="Les exemples de code ci-dessous supposent que vous avez déjà exécuté les exemples de la section précédente. Voici un bref résumé de ce dont vous avez besoin :",be,_,ve,G,he,C,lt="La première étape avant de pouvoir définir notre <code>Trainer</code> est de définir une classe <code>TrainingArguments</code> qui contiendra tous les hyperparamètres que le <code>Trainer</code> utilisera pour l’entraînement et l’évaluation. Le seul argument que vous devez fournir est un répertoire où le modèle entraîné sera sauvegardé, ainsi que les <em>checkpoints</em>. Pour tout le reste, vous pouvez laisser les valeurs par défaut, qui devraient fonctionner assez bien pour un <em>finetuning</em> de base.",$e,Z,Te,j,je,R,at='La deuxième étape consiste à définir notre modèle. Comme dans le <a href="/course/fr/chapter2">chapitre précédent</a>, nous utiliserons la classe <code>AutoModelForSequenceClassification</code>, avec deux labels :',ye,z,Je,H,ot='Vous remarquerez que contrairement au <a href="/course/fr/chapter2">chapitre 2</a>, vous obtenez un message d’avertissement après l’instanciation de ce modèle pré-entraîné. C’est parce que BERT n’a pas été pré-entraîné à la classification de paires de phrases, donc la tête du modèle pré-entraîné a été supprimée et une nouvelle tête adaptée à la classification de séquences a été ajoutée à la place. Les messages d’avertissement indiquent que certains poids n’ont pas été utilisés (ceux correspondant à la tête de pré-entraînement abandonnée) et que d’autres ont été initialisés de manière aléatoire (ceux pour la nouvelle tête). Il conclut en vous encourageant à entraîner le modèle, ce qui est exactement ce que nous allons faire maintenant.',ge,W,rt="Une fois que nous avons notre modèle, nous pouvons définir un <code>Trainer</code> en lui passant tous les objets construits jusqu’à présent : le <code>model</code>, le <code>training_args</code>, les jeux de données d’entraînement et de validation, notre <code>data_collator</code>, et notre <code>tokenizer</code> :",we,E,qe,F,it="Notez que lorsque vous passez le <code>tokenizer</code> comme nous l’avons fait ici, le <code>data_collator</code> par défaut utilisé par le <code>Trainer</code> sera un <code>DataCollatorWithPadding</code> comme défini précédemment. Ainsi, vous pouvez sauter la ligne <code>data_collator=data_collator</code> dans cet appel. Il était quand même important de vous montrer cette partie du traitement dans la section 2 !",ke,I,ut="Pour <em>finetuner</em> le modèle sur notre jeu de données, il suffit d’appeler la méthode <code>train()</code> de notre <code>Trainer</code> :",Ue,x,_e,X,pt="Cela lancera le <em>finetuning</em> (qui devrait prendre quelques minutes sur un GPU) et indiquera la perte d’entraînement tous les 500 pas. Cependant, elle ne vous dira pas si votre modèle fonctionne bien (ou mal). Ceci est dû au fait que :",Ge,V,ct="<li>nous n’avons pas dit au <code>Trainer</code> d’évaluer pendant l’entraînement en réglant <code>evaluation_strategy</code> à soit <code>&quot;steps&quot;</code> (évaluer chaque <code>eval_steps</code>) ou <code>&quot;epoch&quot;</code> (évaluer à la fin de chaque <em>epoch</em>).</li> <li>nous n’avons pas fourni au <code>Trainer</code> une fonction <code>compute_metrics()</code> pour calculer une métrique pendant ladite évaluation (sinon l’évaluation aurait juste affiché la perte, qui n’est pas un nombre très intuitif).</li>",Ce,B,Ze,L,dt="Voyons comment nous pouvons construire une fonction <code>compute_metrics()</code> utile et l’utiliser la prochaine fois que nous entraînons. La fonction doit prendre un objet <code>EvalPrediction</code> (qui est un <em>tuple</em> nommé avec un champ <code>predictions</code> et un champ <code>label_ids</code>) et retournera un dictionnaire de chaînes de caractères vers des flottants (les chaînes de caractères étant les noms des métriques retournées, et les flottants leurs valeurs). Pour obtenir des prédictions de notre modèle, nous pouvons utiliser la commande <code>Trainer.predict()</code> :",Re,Y,ze,A,He,N,mt="La sortie de la méthode <code>predict()</code> est un autre <em>tuple</em> nommé avec trois champs : <code>predictions</code>, <code>label_ids</code>, et <code>metrics</code>. Le champ <code>metrics</code> contiendra juste la perte sur le jeu de données passé, ainsi que quelques mesures de temps (combien de temps il a fallu pour prédire, au total et en moyenne). Une fois que nous aurons complété notre fonction <code>compute_metrics()</code> et que nous l’aurons passé au <code>Trainer</code>, ce champ contiendra également les métriques retournées par <code>compute_metrics()</code>.",We,Q,ft='Comme vous pouvez le voir, <code>predictions</code> est un tableau bidimensionnel de forme 408 x 2 (408 étant le nombre d’éléments dans le jeu de données que nous avons utilisé). Ce sont les logits pour chaque élément du jeu de données que nous avons passé à <code>predict()</code> (comme vous l’avez vu dans le <a href="/course/fr/chapter2">chapitre précédent</a>, tous les <em>transformers</em> retournent des logits). Pour les transformer en prédictions que nous pouvons comparer à nos étiquettes, nous devons prendre l’indice avec la valeur maximale sur le second axe :',Ee,P,Fe,S,Mt='Nous pouvons maintenant comparer ces <code>preds</code> aux étiquettes. Pour construire notre fonction <code>compute_metric()</code>, nous allons nous appuyer sur les métriques de la bibliothèque 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow"><em>Evaluate</em></a>. Nous pouvons charger les métriques associées au jeu de données MRPC aussi facilement que nous avons chargé le jeu de données, cette fois avec la fonction <code>evaluate.load()</code>. L’objet retourné possède une méthode <code>compute()</code> que nous pouvons utiliser pour effectuer le calcul de la métrique :',Ie,K,xe,D,Xe,O,bt='Les résultats exacts que vous obtiendrez peuvent varier, car l’initialisation aléatoire de la tête du modèle peut modifier les métriques obtenues. Ici, nous pouvons voir que notre modèle a une précision de 85,78% sur l’ensemble de validation et un score F1 de 89,97. Ce sont les deux métriques utilisées pour évaluer les résultats sur le jeu de données MRPC pour le benchmark GLUE. Le tableau du papier de <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT</a> indique un score F1 de 88,9 pour le modèle de base. Il s’agissait du modèle <code>uncased</code> alors que nous utilisons actuellement le modèle <code>cased</code>, ce qui explique le meilleur résultat.',Ve,ee,vt="En regroupant le tout, nous obtenons notre fonction <code>compute_metrics()</code> :",Be,te,Le,ne,ht="Et pour le voir utilisé en action pour rapporter les métriques à la fin de chaque époque, voici comment nous définissons un nouveau <code>Trainer</code> avec cette fonction <code>compute_metrics()</code> :",Ye,se,Ae,le,$t="Notez que nous créons un nouveau <code>TrainingArguments</code> avec sa <code>evaluation_strategy</code> définie sur <code>&quot;epoch&quot;</code> et un nouveau modèle. Sinon, nous ne ferions que continuer l’entraînement du modèle que nous avons déjà entraîné. Pour lancer un nouveau cycle d’entraînement, nous exécutons :",Ne,ae,Qe,oe,Tt="Cette fois, il indiquera la perte et les mesures de validation à la fin de chaque époque, en plus de la perte d’entraînement. Encore une fois, le score exact de précision/F1 que vous atteignez peut être un peu différent de ce que nous avons trouvé, en raison de l’initialisation aléatoire de la tête du modèle, mais il devrait être dans la même fourchette.",Pe,re,jt="Le <code>Trainer</code> fonctionnera sur plusieurs GPUs ou TPUs et fournit beaucoup d’options, comme l’entraînement en précision mixte (utilisez <code>fp16 = True</code> dans vos arguments d’entraînement). Nous passerons en revue tout ce qu’il supporte dans le chapitre 10.",Se,ie,yt='Ceci conclut l’introduction au <em>fine-tuning</em> en utilisant l’API <code>Trainer</code>. Un exemple d’utilisation pour les tâches de NLP les plus communes es donné dans le <a href="/course/fr/chapter7">chapitre 7</a>, mais pour l’instant regardons comment faire la même chose en PyTorch pur.',Ke,y,De,ue,Oe,pe,et;return T=new Ft({props:{fw:J[0]}}),g=new tt({props:{title:"<i> Finetuner </i> un modèle avec l’API Trainer",local:"i-finetuner-i-un-modèle-avec-lapi-trainer",headingTag:"h1"}}),w=new Et({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter3/section3.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter3/section3.ipynb"}]}}),q=new Wt({props:{id:"nvBXf7s7vTI"}}),_=new v({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),G=new tt({props:{title:"Entraînement",local:"entraînement",headingTag:"h3"}}),Z=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),j=new Ut({props:{$$slots:{default:[xt]},$$scope:{ctx:J}}}),z=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),x=new v({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),B=new tt({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),Y=new v({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),A=new v({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new v({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new v({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new v({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new v({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),se=new v({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),ae=new v({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),y=new Ut({props:{$$slots:{default:[Xt]},$$scope:{ctx:J}}}),ue=new It({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter3/3.mdx"}}),{c(){i=o("meta"),h=l(),b=o("p"),$=l(),p(T.$$.fragment),ce=l(),p(g.$$.fragment),de=l(),p(w.$$.fragment),me=l(),p(q.$$.fragment),fe=l(),k=o("p"),k.innerHTML=nt,Me=l(),U=o("p"),U.textContent=st,be=l(),p(_.$$.fragment),ve=l(),p(G.$$.fragment),he=l(),C=o("p"),C.innerHTML=lt,$e=l(),p(Z.$$.fragment),Te=l(),p(j.$$.fragment),je=l(),R=o("p"),R.innerHTML=at,ye=l(),p(z.$$.fragment),Je=l(),H=o("p"),H.innerHTML=ot,ge=l(),W=o("p"),W.innerHTML=rt,we=l(),p(E.$$.fragment),qe=l(),F=o("p"),F.innerHTML=it,ke=l(),I=o("p"),I.innerHTML=ut,Ue=l(),p(x.$$.fragment),_e=l(),X=o("p"),X.innerHTML=pt,Ge=l(),V=o("ol"),V.innerHTML=ct,Ce=l(),p(B.$$.fragment),Ze=l(),L=o("p"),L.innerHTML=dt,Re=l(),p(Y.$$.fragment),ze=l(),p(A.$$.fragment),He=l(),N=o("p"),N.innerHTML=mt,We=l(),Q=o("p"),Q.innerHTML=ft,Ee=l(),p(P.$$.fragment),Fe=l(),S=o("p"),S.innerHTML=Mt,Ie=l(),p(K.$$.fragment),xe=l(),p(D.$$.fragment),Xe=l(),O=o("p"),O.innerHTML=bt,Ve=l(),ee=o("p"),ee.innerHTML=vt,Be=l(),p(te.$$.fragment),Le=l(),ne=o("p"),ne.innerHTML=ht,Ye=l(),p(se.$$.fragment),Ae=l(),le=o("p"),le.innerHTML=$t,Ne=l(),p(ae.$$.fragment),Qe=l(),oe=o("p"),oe.textContent=Tt,Pe=l(),re=o("p"),re.innerHTML=jt,Se=l(),ie=o("p"),ie.innerHTML=yt,Ke=l(),p(y.$$.fragment),De=l(),p(ue.$$.fragment),Oe=l(),pe=o("p"),this.h()},l(e){const t=zt("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(n),h=a(e),b=r(e,"P",{}),qt(b).forEach(n),$=a(e),c(T.$$.fragment,e),ce=a(e),c(g.$$.fragment,e),de=a(e),c(w.$$.fragment,e),me=a(e),c(q.$$.fragment,e),fe=a(e),k=r(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-pje9qd"&&(k.innerHTML=nt),Me=a(e),U=r(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-14eako"&&(U.textContent=st),be=a(e),c(_.$$.fragment,e),ve=a(e),c(G.$$.fragment,e),he=a(e),C=r(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-3f38pc"&&(C.innerHTML=lt),$e=a(e),c(Z.$$.fragment,e),Te=a(e),c(j.$$.fragment,e),je=a(e),R=r(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-y5v80"&&(R.innerHTML=at),ye=a(e),c(z.$$.fragment,e),Je=a(e),H=r(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1mjubu3"&&(H.innerHTML=ot),ge=a(e),W=r(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1osogjj"&&(W.innerHTML=rt),we=a(e),c(E.$$.fragment,e),qe=a(e),F=r(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-auwxcq"&&(F.innerHTML=it),ke=a(e),I=r(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1rwh0g0"&&(I.innerHTML=ut),Ue=a(e),c(x.$$.fragment,e),_e=a(e),X=r(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-155zod"&&(X.innerHTML=pt),Ge=a(e),V=r(e,"OL",{"data-svelte-h":!0}),u(V)!=="svelte-13ssqmi"&&(V.innerHTML=ct),Ce=a(e),c(B.$$.fragment,e),Ze=a(e),L=r(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-md0pgp"&&(L.innerHTML=dt),Re=a(e),c(Y.$$.fragment,e),ze=a(e),c(A.$$.fragment,e),He=a(e),N=r(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-16549h0"&&(N.innerHTML=mt),We=a(e),Q=r(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-trb3vz"&&(Q.innerHTML=ft),Ee=a(e),c(P.$$.fragment,e),Fe=a(e),S=r(e,"P",{"data-svelte-h":!0}),u(S)!=="svelte-ijdw5p"&&(S.innerHTML=Mt),Ie=a(e),c(K.$$.fragment,e),xe=a(e),c(D.$$.fragment,e),Xe=a(e),O=r(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1l4etp7"&&(O.innerHTML=bt),Ve=a(e),ee=r(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-ql1ucp"&&(ee.innerHTML=vt),Be=a(e),c(te.$$.fragment,e),Le=a(e),ne=r(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-9vjx55"&&(ne.innerHTML=ht),Ye=a(e),c(se.$$.fragment,e),Ae=a(e),le=r(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-5sabrn"&&(le.innerHTML=$t),Ne=a(e),c(ae.$$.fragment,e),Qe=a(e),oe=r(e,"P",{"data-svelte-h":!0}),u(oe)!=="svelte-u2e3sn"&&(oe.textContent=Tt),Pe=a(e),re=r(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-139u89k"&&(re.innerHTML=jt),Se=a(e),ie=r(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-17e3730"&&(ie.innerHTML=yt),Ke=a(e),c(y.$$.fragment,e),De=a(e),c(ue.$$.fragment,e),Oe=a(e),pe=r(e,"P",{}),qt(pe).forEach(n),this.h()},h(){kt(i,"name","hf:doc:metadata"),kt(i,"content",Bt)},m(e,t){Ht(document.head,i),s(e,h,t),s(e,b,t),s(e,$,t),d(T,e,t),s(e,ce,t),d(g,e,t),s(e,de,t),d(w,e,t),s(e,me,t),d(q,e,t),s(e,fe,t),s(e,k,t),s(e,Me,t),s(e,U,t),s(e,be,t),d(_,e,t),s(e,ve,t),d(G,e,t),s(e,he,t),s(e,C,t),s(e,$e,t),d(Z,e,t),s(e,Te,t),d(j,e,t),s(e,je,t),s(e,R,t),s(e,ye,t),d(z,e,t),s(e,Je,t),s(e,H,t),s(e,ge,t),s(e,W,t),s(e,we,t),d(E,e,t),s(e,qe,t),s(e,F,t),s(e,ke,t),s(e,I,t),s(e,Ue,t),d(x,e,t),s(e,_e,t),s(e,X,t),s(e,Ge,t),s(e,V,t),s(e,Ce,t),d(B,e,t),s(e,Ze,t),s(e,L,t),s(e,Re,t),d(Y,e,t),s(e,ze,t),d(A,e,t),s(e,He,t),s(e,N,t),s(e,We,t),s(e,Q,t),s(e,Ee,t),d(P,e,t),s(e,Fe,t),s(e,S,t),s(e,Ie,t),d(K,e,t),s(e,xe,t),d(D,e,t),s(e,Xe,t),s(e,O,t),s(e,Ve,t),s(e,ee,t),s(e,Be,t),d(te,e,t),s(e,Le,t),s(e,ne,t),s(e,Ye,t),d(se,e,t),s(e,Ae,t),s(e,le,t),s(e,Ne,t),d(ae,e,t),s(e,Qe,t),s(e,oe,t),s(e,Pe,t),s(e,re,t),s(e,Se,t),s(e,ie,t),s(e,Ke,t),d(y,e,t),s(e,De,t),d(ue,e,t),s(e,Oe,t),s(e,pe,t),et=!0},p(e,[t]){const Jt={};t&1&&(Jt.fw=e[0]),T.$set(Jt);const gt={};t&2&&(gt.$$scope={dirty:t,ctx:e}),j.$set(gt);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),y.$set(wt)},i(e){et||(m(T.$$.fragment,e),m(g.$$.fragment,e),m(w.$$.fragment,e),m(q.$$.fragment,e),m(_.$$.fragment,e),m(G.$$.fragment,e),m(Z.$$.fragment,e),m(j.$$.fragment,e),m(z.$$.fragment,e),m(E.$$.fragment,e),m(x.$$.fragment,e),m(B.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(y.$$.fragment,e),m(ue.$$.fragment,e),et=!0)},o(e){f(T.$$.fragment,e),f(g.$$.fragment,e),f(w.$$.fragment,e),f(q.$$.fragment,e),f(_.$$.fragment,e),f(G.$$.fragment,e),f(Z.$$.fragment,e),f(j.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(x.$$.fragment,e),f(B.$$.fragment,e),f(Y.$$.fragment,e),f(A.$$.fragment,e),f(P.$$.fragment,e),f(K.$$.fragment,e),f(D.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(y.$$.fragment,e),f(ue.$$.fragment,e),et=!1},d(e){e&&(n(h),n(b),n($),n(ce),n(de),n(me),n(fe),n(k),n(Me),n(U),n(be),n(ve),n(he),n(C),n($e),n(Te),n(je),n(R),n(ye),n(Je),n(H),n(ge),n(W),n(we),n(qe),n(F),n(ke),n(I),n(Ue),n(_e),n(X),n(Ge),n(V),n(Ce),n(Ze),n(L),n(Re),n(ze),n(He),n(N),n(We),n(Q),n(Ee),n(Fe),n(S),n(Ie),n(xe),n(Xe),n(O),n(Ve),n(ee),n(Be),n(Le),n(ne),n(Ye),n(Ae),n(le),n(Ne),n(Qe),n(oe),n(Pe),n(re),n(Se),n(ie),n(Ke),n(De),n(Oe),n(pe)),n(i),M(T,e),M(g,e),M(w,e),M(q,e),M(_,e),M(G,e),M(Z,e),M(j,e),M(z,e),M(E,e),M(x,e),M(B,e),M(Y,e),M(A,e),M(P,e),M(K,e),M(D,e),M(te,e),M(se,e),M(ae,e),M(y,e),M(ue,e)}}}const Bt='{"title":"<i> Finetuner </i> un modèle avec l’API Trainer","local":"i-finetuner-i-un-modèle-avec-lapi-trainer","sections":[{"title":"Entraînement","local":"entraînement","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3}],"depth":1}';function Lt(J,i,h){let b="pt";return Ct(()=>{const $=new URLSearchParams(window.location.search);h(0,b=$.get("fw")||"pt")}),[b]}class Ot extends Zt{constructor(i){super(),Rt(this,i,Lt,Vt,Gt,{})}}export{Ot as component};
