import{s as qs,b as Ds,n as Ps,o as Ks}from"../chunks/scheduler.aec39e6a.js";import{S as Os,i as el,e as i,s as a,c as p,h as tl,a as r,d as s,b as n,f as as,g as M,j as o,k as u,l as sl,m as l,n as J,t as c,o as y,p as T}from"../chunks/index.4ee0a2d0.js";import{C as ll,H as w,E as al}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.a8ba3e21.js";import{C as d}from"../chunks/CodeBlock.2757cde6.js";function nl(ns){let h,Ne,$e,Ae,U,Se,g,Re,m,is,Ee,I,rs="This guide will show you how to train a 🤗 Transformers model with the <code>HuggingFace</code> SageMaker Python SDK. Learn how to:",Xe,f,os='<li><a href="#installation-and-setup">Install and setup your training environment</a>.</li> <li><a href="#prepare-a-transformers-fine-tuning-script">Prepare a training script</a>.</li> <li><a href="#create-a-hugging-face-estimator">Create a Hugging Face Estimator</a>.</li> <li><a href="#execute-training">Run training with the <code>fit</code> method</a>.</li> <li><a href="#access-trained-model">Access your trained model</a>.</li> <li><a href="#distributed-training">Perform distributed training</a>.</li> <li><a href="#spot-instances">Create a spot instance</a>.</li> <li><a href="#git-repository">Load a training script from a GitHub repository</a>.</li> <li><a href="#sagemaker-metrics">Collect training metrics</a>.</li>',Ve,j,Ye,C,ps='Before you can train a 🤗 Transformers model with SageMaker, you need to sign up for an AWS account. If you don’t have an AWS account yet, learn more <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-set-up.html" rel="nofollow">here</a>.',Qe,b,Ms="Once you have an AWS account, get started using one of the following:",Fe,_,Js='<li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-studio-onboard.html" rel="nofollow">SageMaker Studio</a></li> <li><a href="https://docs.aws.amazon.com/sagemaker/latest/dg/gs-console.html" rel="nofollow">SageMaker notebook instance</a></li> <li>Local environment</li>',Le,Z,cs='To start training locally, you need to setup an appropriate <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM role</a>.',qe,x,ys="Upgrade to the latest <code>sagemaker</code> version:",De,B,Pe,v,Ts="<strong>SageMaker environment</strong>",Ke,k,ms="Setup your SageMaker environment as shown below:",Oe,W,et,G,ws="<em>Note: The execution role is only available when running a notebook within SageMaker. If you run <code>get_execution_role</code> in a notebook not on SageMaker, expect a <code>region</code> error.</em>",tt,z,ds="<strong>Local environment</strong>",st,$,hs="Setup your local environment as shown below:",lt,H,at,N,nt,A,us='Our training script is very similar to a training script you might run outside of SageMaker. However, you can access useful properties about the training environment through various environment variables (see <a href="https://github.com/aws/sagemaker-training-toolkit/blob/master/ENVIRONMENT_VARIABLES.md" rel="nofollow">here</a> for a complete list), such as:',it,S,Us="<li><p><code>SM_MODEL_DIR</code>: A string representing the path to which the training job writes the model artifacts. After training, artifacts in this directory are uploaded to S3 for model hosting. <code>SM_MODEL_DIR</code> is always set to <code>/opt/ml/model</code>.</p></li> <li><p><code>SM_NUM_GPUS</code>: An integer representing the number of GPUs available to the host.</p></li> <li><p><code>SM_CHANNEL_XXXX:</code> A string representing the path to the directory that contains the input data for the specified channel. For example, when you specify <code>train</code> and <code>test</code> in the Hugging Face Estimator <code>fit</code> method, the environment variables are set to <code>SM_CHANNEL_TRAIN</code> and <code>SM_CHANNEL_TEST</code>.</p></li>",rt,R,gs='The <code>hyperparameters</code> defined in the <a href="#create-an-huggingface-estimator">Hugging Face Estimator</a> are passed as named arguments and processed by <code>ArgumentParser()</code>.',ot,E,pt,X,Is="<em>Note that SageMaker doesn’t support argparse actions. For example, if you want to use a boolean hyperparameter, specify <code>type</code> as <code>bool</code> in your script and provide an explicit <code>True</code> or <code>False</code> value.</em>",Mt,V,fs='Look <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a> for a complete example of a 🤗 Transformers training script.',Jt,Y,ct,Q,js=`If <code>output_dir</code> in the <code>TrainingArguments</code> is set to ‘/opt/ml/model’ the Trainer saves all training artifacts, including logs, checkpoints, and models. Amazon SageMaker archives the whole ‘/opt/ml/model’ directory as <code>model.tar.gz</code> and uploads it at the end of the training job to Amazon S3. Depending on your Hyperparameters and <code>TrainingArguments</code> this could lead to a large artifact (&gt; 5GB), which can slow down deployment for Amazon SageMaker Inference.
You can control how checkpoints, logs, and artifacts are saved by customization the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>. For example by providing <code>save_total_limit</code> as <code>TrainingArgument</code> you can control the limit of the total amount of checkpoints. Deletes the older checkpoints in <code>output_dir</code> if new ones are saved and the maximum limit is reached.`,yt,F,Cs=`In addition to the options already mentioned above, there is another option to save the training artifacts during the training session. Amazon SageMaker supports <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">Checkpointing</a>, which allows you to continuously save your artifacts during training to Amazon S3 rather than at the end of your training. To enable <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">Checkpointing</a> you need to provide the <code>checkpoint_s3_uri</code> parameter pointing to an Amazon S3 location in the <code>HuggingFace</code> estimator and set <code>output_dir</code> to <code>/opt/ml/checkpoints</code>.
<em>Note: If you set <code>output_dir</code> to <code>/opt/ml/checkpoints</code> make sure to call <code>trainer.save_model(&quot;/opt/ml/model&quot;)</code> or model.save_pretrained(“/opt/ml/model”)/<code>tokenizer.save_pretrained(&quot;/opt/ml/model&quot;)</code> at the end of your training to be able to deploy your model seamlessly to Amazon SageMaker for Inference.</em>`,Tt,L,mt,q,bs='Run 🤗 Transformers training scripts on SageMaker by creating a <a href="https://sagemaker.readthedocs.io/en/stable/frameworks/huggingface/sagemaker.huggingface.html#huggingface-estimator" rel="nofollow">Hugging Face Estimator</a>. The Estimator handles end-to-end SageMaker training. There are several parameters you should define in the Estimator:',wt,D,_s='<li><code>entry_point</code> specifies which fine-tuning script to use.</li> <li><code>instance_type</code> specifies an Amazon instance to launch. Refer <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> specifies training hyperparameters. View additional available hyperparameters in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li>',dt,P,Zs="The following code sample shows how to train with a custom script <code>train.py</code> with three hyperparameters (<code>epochs</code>, <code>per_device_train_batch_size</code>, and <code>model_name_or_path</code>):",ht,K,ut,O,xs="If you are running a <code>TrainingJob</code> locally, define <code>instance_type=&#39;local&#39;</code> or <code>instance_type=&#39;local_gpu&#39;</code> for GPU usage. Note that this will not work with SageMaker Studio.",Ut,ee,gt,te,Bs="Start your <code>TrainingJob</code> by calling <code>fit</code> on a Hugging Face Estimator. Specify your input training data in <code>fit</code>. The input training data can be a:",It,se,vs='<li>S3 URI such as <code>s3://my-bucket/my-training-data</code>.</li> <li><code>FileSystemInput</code> for Amazon Elastic File System or FSx for Lustre. See <a href="https://sagemaker.readthedocs.io/en/stable/overview.html?highlight=FileSystemInput#use-file-systems-as-training-inputs" rel="nofollow">here</a> for more details about using these file systems as input.</li>',ft,le,ks="Call <code>fit</code> to begin training:",jt,ae,Ct,ne,Ws="SageMaker starts and manages all the required EC2 instances and initiates the <code>TrainingJob</code> by running:",bt,ie,_t,re,Zt,oe,Gs='Once training is complete, you can access your model through the <a href="https://console.aws.amazon.com/console/home?nc2=h_ct&amp;src=header-signin" rel="nofollow">AWS console</a> or download it directly from S3.',xt,pe,Bt,Me,vt,Je,zs="SageMaker provides two strategies for distributed training: data parallelism and model parallelism. Data parallelism splits a training set across several GPUs, while model parallelism splits a model across several GPUs.",kt,ce,Wt,ye,$s='The Hugging Face <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a> supports SageMaker’s data parallelism library. If your training script uses the Trainer API, you only need to define the distribution parameter in the Hugging Face Estimator:',Gt,Te,zt,me,Hs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/07_tensorflow_distributed_training_data_parallelism/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run the data parallelism library with TensorFlow.',$t,we,Ht,de,Ns='The Hugging Face [Trainer] also supports SageMaker’s model parallelism library. If your training script uses the Trainer API, you only need to define the distribution parameter in the Hugging Face Estimator (see <a href="https://sagemaker.readthedocs.io/en/stable/api/training/smd_model_parallel_general.html?highlight=modelparallel#required-sagemaker-python-sdk-parameters" rel="nofollow">here</a> for more detailed information about using model parallelism):',Nt,he,At,ue,As='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/04_distributed_training_model_parallelism/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to run the model parallelism library.',St,Ue,Rt,ge,Ss='The Hugging Face extension for the SageMaker Python SDK means we can benefit from <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html" rel="nofollow">fully-managed EC2 spot instances</a>. This can help you save up to 90% of training costs!',Et,Ie,Rs='<em>Note: Unless your training job completes quickly, we recommend you use <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-checkpoints.html" rel="nofollow">checkpointing</a> with managed spot training. In this case, you need to define the <code>checkpoint_s3_uri</code>.</em>',Xt,fe,Es="Set <code>use_spot_instances=True</code> and define your <code>max_wait</code> and <code>max_run</code> time in the Estimator to use spot instances:",Vt,je,Yt,Ce,Xs='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/05_spot_instances/sagemaker-notebook.ipynb" rel="nofollow">sagemaker-notebook.ipynb notebook</a> for an example of how to use spot instances.',Qt,be,Ft,_e,Vs='The Hugging Face Estimator can load a training script <a href="https://sagemaker.readthedocs.io/en/stable/overview.html#use-scripts-stored-in-a-git-repository" rel="nofollow">stored in a GitHub repository</a>. Provide the relative path to the training script in <code>entry_point</code> and the relative path to the directory in <code>source_dir</code>.',Lt,Ze,Ys='If you are using <code>git_config</code> to run the <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers example scripts</a>, you need to configure the correct <code>&#39;branch&#39;</code> in <code>transformers_version</code> (e.g. if you use <code>transformers_version=&#39;4.4.2</code> you have to use <code>&#39;branch&#39;:&#39;v4.4.2&#39;</code>).',qt,xe,Qs="<em>Tip: Save your model to S3 by setting <code>output_dir=/opt/ml/model</code> in the hyperparameter of your training script.</em>",Dt,Be,Pt,ve,Kt,ke,Fs='<a href="https://docs.aws.amazon.com/sagemaker/latest/dg/training-metrics.html#define-train-metrics" rel="nofollow">SageMaker metrics</a> automatically parses training job logs for metrics and sends them to CloudWatch. If you want SageMaker to parse the logs, you must specify the metric’s name and a regular expression for SageMaker to use to find the metric.',Ot,We,es,Ge,Ls='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/06_sagemaker_metrics/sagemaker-notebook.ipynb" rel="nofollow">notebook</a> for an example of how to capture metrics in SageMaker.',ts,ze,ss,He,ls;return U=new ll({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),g=new w({props:{title:"Run training on Amazon SageMaker",local:"run-training-on-amazon-sagemaker",headingTag:"h1"}}),j=new w({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),B=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNhZ2VtYWtlciUyMC0tdXBncmFkZQ==",highlighted:"pip install sagemaker --upgrade",wrap:!1}}),W=new d({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFyb2xlJTIwJTNEJTIwc2FnZW1ha2VyLmdldF9leGVjdXRpb25fcm9sZSgp",highlighted:`<span class="hljs-keyword">import</span> sagemaker
sess = sagemaker.Session()
role = sagemaker.get_execution_role()`,wrap:!1}}),H=new d({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFpYW1fY2xpZW50JTIwJTNEJTIwYm90bzMuY2xpZW50KCdpYW0nKSUwQXJvbGUlMjAlM0QlMjBpYW1fY2xpZW50LmdldF9yb2xlKFJvbGVOYW1lJTNEJ3JvbGUtbmFtZS1vZi15b3VyLWlhbS1yb2xlLXdpdGgtcmlnaHQtcGVybWlzc2lvbnMnKSU1QidSb2xlJyU1RCU1QidBcm4nJTVEJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

iam_client = boto3.client(<span class="hljs-string">&#x27;iam&#x27;</span>)
role = iam_client.get_role(RoleName=<span class="hljs-string">&#x27;role-name-of-your-iam-role-with-right-permissions&#x27;</span>)[<span class="hljs-string">&#x27;Role&#x27;</span>][<span class="hljs-string">&#x27;Arn&#x27;</span>]
sess = sagemaker.Session()`,wrap:!1}}),N=new w({props:{title:"Prepare a 🤗 Transformers fine-tuning script",local:"prepare-a--transformers-fine-tuning-script",headingTag:"h2"}}),E=new d({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBaW1wb3J0JTIwZGF0YXNldHMlMEFpbXBvcnQlMjBhcmdwYXJzZSUwQWltcG9ydCUyMG9zJTBBJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTBBJTIwJTIwJTIwJTIwcGFyc2VyJTIwJTNEJTIwYXJncGFyc2UuQXJndW1lbnRQYXJzZXIoKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGh5cGVycGFyYW1ldGVycyUyMHNlbnQlMjBieSUyMHRoZSUyMGNsaWVudCUyMGFyZSUyMHBhc3NlZCUyMGFzJTIwY29tbWFuZC1saW5lJTIwYXJndW1lbnRzJTIwdG8lMjB0aGUlMjBzY3JpcHQlMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tZXBvY2hzJTIyJTJDJTIwdHlwZSUzRGludCUyQyUyMGRlZmF1bHQlM0QzKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjIlMkMlMjB0eXBlJTNEaW50JTJDJTIwZGVmYXVsdCUzRDMyKSUwQSUyMCUyMCUyMCUyMHBhcnNlci5hZGRfYXJndW1lbnQoJTIyLS1tb2RlbF9uYW1lX29yX3BhdGglMjIlMkMlMjB0eXBlJTNEc3RyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGRhdGElMkMlMjBtb2RlbCUyQyUyMGFuZCUyMG91dHB1dCUyMGRpcmVjdG9yaWVzJTBBJTIwJTIwJTIwJTIwcGFyc2VyLmFkZF9hcmd1bWVudCglMjItLW1vZGVsLWRpciUyMiUyQyUyMHR5cGUlM0RzdHIlMkMlMjBkZWZhdWx0JTNEb3MuZW52aXJvbiU1QiUyMlNNX01PREVMX0RJUiUyMiU1RCklMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tdHJhaW5pbmdfZGlyJTIyJTJDJTIwdHlwZSUzRHN0ciUyQyUyMGRlZmF1bHQlM0Rvcy5lbnZpcm9uJTVCJTIyU01fQ0hBTk5FTF9UUkFJTiUyMiU1RCklMEElMjAlMjAlMjAlMjBwYXJzZXIuYWRkX2FyZ3VtZW50KCUyMi0tdGVzdF9kaXIlMjIlMkMlMjB0eXBlJTNEc3RyJTJDJTIwZGVmYXVsdCUzRG9zLmVudmlyb24lNUIlMjJTTV9DSEFOTkVMX1RFU1QlMjIlNUQp",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">import</span> argparse
<span class="hljs-keyword">import</span> os

<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:

    parser = argparse.ArgumentParser()

    <span class="hljs-comment"># hyperparameters sent by the client are passed as command-line arguments to the script</span>
    parser.add_argument(<span class="hljs-string">&quot;--epochs&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">3</span>)
    parser.add_argument(<span class="hljs-string">&quot;--per_device_train_batch_size&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">int</span>, default=<span class="hljs-number">32</span>)
    parser.add_argument(<span class="hljs-string">&quot;--model_name_or_path&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>)

    <span class="hljs-comment"># data, model, and output directories</span>
    parser.add_argument(<span class="hljs-string">&quot;--model-dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_MODEL_DIR&quot;</span>])
    parser.add_argument(<span class="hljs-string">&quot;--training_dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_CHANNEL_TRAIN&quot;</span>])
    parser.add_argument(<span class="hljs-string">&quot;--test_dir&quot;</span>, <span class="hljs-built_in">type</span>=<span class="hljs-built_in">str</span>, default=os.environ[<span class="hljs-string">&quot;SM_CHANNEL_TEST&quot;</span>])`,wrap:!1}}),Y=new w({props:{title:"Training Output Management",local:"training-output-management",headingTag:"h2"}}),L=new w({props:{title:"Create a Hugging Face Estimator",local:"create-a-hugging-face-estimator",headingTag:"h2"}}),K=new d({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBJTBBJTIzJTIwaHlwZXJwYXJhbWV0ZXJzJTIwd2hpY2glMjBhcmUlMjBwYXNzZWQlMjB0byUyMHRoZSUyMHRyYWluaW5nJTIwam9iJTBBaHlwZXJwYXJhbWV0ZXJzJTNEJTdCJ2Vwb2NocyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJ3Blcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSclM0ElMjAzMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdtb2RlbF9uYW1lX29yX3BhdGgnJTNBJTIwJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5nNi4xMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyc192ZXJzaW9uJTNEJzQuMjYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJzEuMTMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace


<span class="hljs-comment"># hyperparameters which are passed to the training job</span>
hyperparameters={<span class="hljs-string">&#x27;epochs&#x27;</span>: <span class="hljs-number">1</span>,
                 <span class="hljs-string">&#x27;per_device_train_batch_size&#x27;</span>: <span class="hljs-number">32</span>,
                 <span class="hljs-string">&#x27;model_name_or_path&#x27;</span>: <span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>
                 }

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters
)`,wrap:!1}}),ee=new w({props:{title:"Execute training",local:"execute-training",headingTag:"h2"}}),ae=new d({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglMEElMjAlMjAlN0IndHJhaW4nJTNBJTIwJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXVzLWVhc3QtMS01NTgxMDUxNDE3MjElMkZzYW1wbGVzJTJGZGF0YXNldHMlMkZpbWRiJTJGdHJhaW4nJTJDJTBBJTIwJTIwJTIwJ3Rlc3QnJTNBJTIwJ3MzJTNBJTJGJTJGc2FnZW1ha2VyLXVzLWVhc3QtMS01NTgxMDUxNDE3MjElMkZzYW1wbGVzJTJGZGF0YXNldHMlMkZpbWRiJTJGdGVzdCclN0QlMEEp",highlighted:`huggingface_estimator.fit(
  {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;s3://sagemaker-us-east-1-558105141721/samples/datasets/imdb/train&#x27;</span>,
   <span class="hljs-string">&#x27;test&#x27;</span>: <span class="hljs-string">&#x27;s3://sagemaker-us-east-1-558105141721/samples/datasets/imdb/test&#x27;</span>}
)`,wrap:!1}}),ie=new d({props:{code:"JTJGb3B0JTJGY29uZGElMkZiaW4lMkZweXRob24lMjB0cmFpbi5weSUyMC0tZXBvY2hzJTIwMSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDMy",highlighted:"/opt/conda/bin/python train.py --epochs 1 --model_name_or_path distilbert-base-uncased --per_device_train_batch_size 32",wrap:!1}}),re=new w({props:{title:"Access trained model",local:"access-trained-model",headingTag:"h2"}}),pe=new d({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5zMyUyMGltcG9ydCUyMFMzRG93bmxvYWRlciUwQSUwQVMzRG93bmxvYWRlci5kb3dubG9hZCglMEElMjAlMjAlMjAlMjBzM191cmklM0RodWdnaW5nZmFjZV9lc3RpbWF0b3IubW9kZWxfZGF0YSUyQyUyMCUyMyUyMFMzJTIwVVJJJTIwd2hlcmUlMjB0aGUlMjB0cmFpbmVkJTIwbW9kZWwlMjBpcyUyMGxvY2F0ZWQlMEElMjAlMjAlMjAlMjBsb2NhbF9wYXRoJTNEJy4nJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwd2hlcmUlMjAqLnRhcmcuZ3olMjBpcyUyMHNhdmVkJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb24lM0RzZXNzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2FnZU1ha2VyJTIwc2Vzc2lvbiUyMHVzZWQlMjBmb3IlMjB0cmFpbmluZyUyMHRoZSUyMG1vZGVsJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> sagemaker.s3 <span class="hljs-keyword">import</span> S3Downloader

S3Downloader.download(
    s3_uri=huggingface_estimator.model_data, <span class="hljs-comment"># S3 URI where the trained model is located</span>
    local_path=<span class="hljs-string">&#x27;.&#x27;</span>,                          <span class="hljs-comment"># local path where *.targ.gz is saved</span>
    sagemaker_session=sess                   <span class="hljs-comment"># SageMaker session used for training the model</span>
)`,wrap:!1}}),Me=new w({props:{title:"Distributed training",local:"distributed-training",headingTag:"h2"}}),ce=new w({props:{title:"Data parallelism",local:"data-parallelism",headingTag:"h3"}}),Te=new d({props:{code:"JTIzJTIwY29uZmlndXJhdGlvbiUyMGZvciUyMHJ1bm5pbmclMjB0cmFpbmluZyUyMG9uJTIwc21kaXN0cmlidXRlZCUyMGRhdGElMjBwYXJhbGxlbCUwQWRpc3RyaWJ1dGlvbiUyMCUzRCUyMCU3QidzbWRpc3RyaWJ1dGVkJyUzQSU3QidkYXRhcGFyYWxsZWwnJTNBJTdCJTIwJ2VuYWJsZWQnJTNBJTIwVHJ1ZSUyMCU3RCU3RCU3RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5wM2RuLjI0eGxhcmdlJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvbGUlM0Ryb2xlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QnNC4yNi4wJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dG9yY2hfdmVyc2lvbiUzRCcxLjEzLjEnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RyaWJ1dGlvbiUyMCUzRCUyMGRpc3RyaWJ1dGlvbiUwQSk=",highlighted:`<span class="hljs-comment"># configuration for running training on smdistributed data parallel</span>
distribution = {<span class="hljs-string">&#x27;smdistributed&#x27;</span>:{<span class="hljs-string">&#x27;dataparallel&#x27;</span>:{ <span class="hljs-string">&#x27;enabled&#x27;</span>: <span class="hljs-literal">True</span> }}}

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3dn.24xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">2</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26.0&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13.1&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters,
        distribution = distribution
)`,wrap:!1}}),we=new w({props:{title:"Model parallelism",local:"model-parallelism",headingTag:"h3"}}),he=new d({props:{code:"JTIzJTIwY29uZmlndXJhdGlvbiUyMGZvciUyMHJ1bm5pbmclMjB0cmFpbmluZyUyMG9uJTIwc21kaXN0cmlidXRlZCUyMG1vZGVsJTIwcGFyYWxsZWwlMEFtcGlfb3B0aW9ucyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmVuYWJsZWQlMjIlMjAlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIycHJvY2Vzc2VzX3Blcl9ob3N0JTIyJTIwJTNBJTIwOCUwQSU3RCUwQSUwQXNtcF9vcHRpb25zJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZW5hYmxlZCUyMiUzQVRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWljcm9iYXRjaGVzJTIyJTNBJTIwNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBsYWNlbWVudF9zdHJhdGVneSUyMiUzQSUyMCUyMnNwcmVhZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpcGVsaW5lJTIyJTNBJTIwJTIyaW50ZXJsZWF2ZWQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvcHRpbWl6ZSUyMiUzQSUyMCUyMnNwZWVkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFydGl0aW9ucyUyMiUzQSUyMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkZHAlMjIlM0ElMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTdEJTBBJTBBZGlzdHJpYnV0aW9uJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIyc21kaXN0cmlidXRlZCUyMiUzQSUyMCU3QiUyMm1vZGVscGFyYWxsZWwlMjIlM0ElMjBzbXBfb3B0aW9ucyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm1waSUyMiUzQSUyMG1waV9vcHRpb25zJTBBJTdEJTBBJTBBJTIwJTIzJTIwY3JlYXRlJTIwdGhlJTIwRXN0aW1hdG9yJTBBaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yJTIwJTNEJTIwSHVnZ2luZ0ZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW50cnlfcG9pbnQlM0QndHJhaW4ucHknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291cmNlX2RpciUzRCcuJTJGc2NyaXB0cyclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJ21sLnAzZG4uMjR4bGFyZ2UnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzRHJvbGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lcnNfdmVyc2lvbiUzRCc0LjI2LjAnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJzEuMTMuMSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBweV92ZXJzaW9uJTNEJ3B5MzknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaHlwZXJwYXJhbWV0ZXJzJTIwJTNEJTIwaHlwZXJwYXJhbWV0ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGlzdHJpYnV0aW9uJTIwJTNEJTIwZGlzdHJpYnV0aW9uJTBBKQ==",highlighted:`<span class="hljs-comment"># configuration for running training on smdistributed model parallel</span>
mpi_options = {
    <span class="hljs-string">&quot;enabled&quot;</span> : <span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;processes_per_host&quot;</span> : <span class="hljs-number">8</span>
}

smp_options = {
    <span class="hljs-string">&quot;enabled&quot;</span>:<span class="hljs-literal">True</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;microbatches&quot;</span>: <span class="hljs-number">4</span>,
        <span class="hljs-string">&quot;placement_strategy&quot;</span>: <span class="hljs-string">&quot;spread&quot;</span>,
        <span class="hljs-string">&quot;pipeline&quot;</span>: <span class="hljs-string">&quot;interleaved&quot;</span>,
        <span class="hljs-string">&quot;optimize&quot;</span>: <span class="hljs-string">&quot;speed&quot;</span>,
        <span class="hljs-string">&quot;partitions&quot;</span>: <span class="hljs-number">4</span>,
        <span class="hljs-string">&quot;ddp&quot;</span>: <span class="hljs-literal">True</span>,
    }
}

distribution={
    <span class="hljs-string">&quot;smdistributed&quot;</span>: {<span class="hljs-string">&quot;modelparallel&quot;</span>: smp_options},
    <span class="hljs-string">&quot;mpi&quot;</span>: mpi_options
}

 <span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.p3dn.24xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">2</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26.0&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13.1&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters,
        distribution = distribution
)`,wrap:!1}}),Ue=new w({props:{title:"Spot instances",local:"spot-instances",headingTag:"h2"}}),je=new d({props:{code:"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",highlighted:`<span class="hljs-comment"># hyperparameters which are passed to the training job</span>
hyperparameters={<span class="hljs-string">&#x27;epochs&#x27;</span>: <span class="hljs-number">1</span>,
                 <span class="hljs-string">&#x27;train_batch_size&#x27;</span>: <span class="hljs-number">32</span>,
                 <span class="hljs-string">&#x27;model_name&#x27;</span>:<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>,
                 <span class="hljs-string">&#x27;output_dir&#x27;</span>:<span class="hljs-string">&#x27;/opt/ml/checkpoints&#x27;</span>
                 }

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
	    checkpoint_s3_uri=<span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/checkpoints&#x27;</span>
        use_spot_instances=<span class="hljs-literal">True</span>,
        <span class="hljs-comment"># max_wait should be equal to or greater than max_run in seconds</span>
        max_wait=<span class="hljs-number">3600</span>,
        max_run=<span class="hljs-number">1000</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters = hyperparameters
)

<span class="hljs-comment"># Training seconds: 874</span>
<span class="hljs-comment"># Billable seconds: 262</span>
<span class="hljs-comment"># Managed Spot Training savings: 70.0%</span>`,wrap:!1}}),be=new w({props:{title:"Git repository",local:"git-repository",headingTag:"h2"}}),Be=new d({props:{code:"JTIzJTIwY29uZmlndXJlJTIwZ2l0JTIwc2V0dGluZ3MlMEFnaXRfY29uZmlnJTIwJTNEJTIwJTdCJ3JlcG8nJTNBJTIwJ2h0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdCclMkMnYnJhbmNoJyUzQSUyMCd2NC40LjInJTdEJTIwJTIzJTIwdjQuNC4yJTIwcmVmZXJzJTIwdG8lMjB0aGUlMjB0cmFuc2Zvcm1lcnNfdmVyc2lvbiUyMHlvdSUyMHVzZSUyMGluJTIwdGhlJTIwZXN0aW1hdG9yJTBBJTBBJTIwJTIzJTIwY3JlYXRlJTIwdGhlJTIwRXN0aW1hdG9yJTBBaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yJTIwJTNEJTIwSHVnZ2luZ0ZhY2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZW50cnlfcG9pbnQlM0QncnVuX2dsdWUucHknJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc291cmNlX2RpciUzRCcuJTJGZXhhbXBsZXMlMkZweXRvcmNoJTJGdGV4dC1jbGFzc2lmaWNhdGlvbiclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnaXRfY29uZmlnJTNEZ2l0X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0QnbWwuZzYuMTJ4bGFyZ2UnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfY291bnQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm9sZSUzRHJvbGUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1lcnNfdmVyc2lvbiUzRCc0LjI2JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5dG9yY2hfdmVyc2lvbiUzRCcxLjEzJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHB5X3ZlcnNpb24lM0QncHkzOSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoeXBlcnBhcmFtZXRlcnMlM0RoeXBlcnBhcmFtZXRlcnMlMEEp",highlighted:`<span class="hljs-comment"># configure git settings</span>
git_config = {<span class="hljs-string">&#x27;repo&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/transformers.git&#x27;</span>,<span class="hljs-string">&#x27;branch&#x27;</span>: <span class="hljs-string">&#x27;v4.4.2&#x27;</span>} <span class="hljs-comment"># v4.4.2 refers to the transformers_version you use in the estimator</span>

 <span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;run_glue.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./examples/pytorch/text-classification&#x27;</span>,
        git_config=git_config,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        hyperparameters=hyperparameters
)`,wrap:!1}}),ve=new w({props:{title:"SageMaker metrics",local:"sagemaker-metrics",headingTag:"h2"}}),We=new d({props:{code:"JTIzJTIwZGVmaW5lJTIwbWV0cmljcyUyMGRlZmluaXRpb25zJTBBbWV0cmljX2RlZmluaXRpb25zJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyTmFtZSUyMiUzQSUyMCUyMnRyYWluX3J1bnRpbWUlMjIlMkMlMjAlMjJSZWdleCUyMiUzQSUyMCUyMnRyYWluX3J1bnRpbWUuKiUzRCU1Q0QqKC4qJTNGKSUyNCUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMk5hbWUlMjIlM0ElMjAlMjJldmFsX2FjY3VyYWN5JTIyJTJDJTIwJTIyUmVnZXglMjIlM0ElMjAlMjJldmFsX2FjY3VyYWN5LiolM0QlNUNEKiguKiUzRiklMjQlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJOYW1lJTIyJTNBJTIwJTIyZXZhbF9sb3NzJTIyJTJDJTIwJTIyUmVnZXglMjIlM0ElMjAlMjJldmFsX2xvc3MuKiUzRCU1Q0QqKC4qJTNGKSUyNCUyMiU3RCUyQyUwQSU1RCUwQSUwQSUyMyUyMGNyZWF0ZSUyMHRoZSUyMEVzdGltYXRvciUwQWh1Z2dpbmdmYWNlX2VzdGltYXRvciUyMCUzRCUyMEh1Z2dpbmdGYWNlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5X3BvaW50JTNEJ3RyYWluLnB5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNvdXJjZV9kaXIlM0QnLiUyRnNjcmlwdHMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5zdGFuY2VfdHlwZSUzRCdtbC5nNi4xMnhsYXJnZSclMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnN0YW5jZV9jb3VudCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2xlJTNEcm9sZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyc192ZXJzaW9uJTNEJzQuMjYnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0b3JjaF92ZXJzaW9uJTNEJzEuMTMnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHlfdmVyc2lvbiUzRCdweTM5JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1ldHJpY19kZWZpbml0aW9ucyUzRG1ldHJpY19kZWZpbml0aW9ucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUyMCUzRCUyMGh5cGVycGFyYW1ldGVycyk=",highlighted:`<span class="hljs-comment"># define metrics definitions</span>
metric_definitions = [
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;train_runtime&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;train_runtime.*=\\D*(.*?)$&quot;</span>},
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;eval_accuracy&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;eval_accuracy.*=\\D*(.*?)$&quot;</span>},
    {<span class="hljs-string">&quot;Name&quot;</span>: <span class="hljs-string">&quot;eval_loss&quot;</span>, <span class="hljs-string">&quot;Regex&quot;</span>: <span class="hljs-string">&quot;eval_loss.*=\\D*(.*?)$&quot;</span>},
]

<span class="hljs-comment"># create the Estimator</span>
huggingface_estimator = HuggingFace(
        entry_point=<span class="hljs-string">&#x27;train.py&#x27;</span>,
        source_dir=<span class="hljs-string">&#x27;./scripts&#x27;</span>,
        instance_type=<span class="hljs-string">&#x27;ml.g6.12xlarge&#x27;</span>,
        instance_count=<span class="hljs-number">1</span>,
        role=role,
        transformers_version=<span class="hljs-string">&#x27;4.26&#x27;</span>,
        pytorch_version=<span class="hljs-string">&#x27;1.13&#x27;</span>,
        py_version=<span class="hljs-string">&#x27;py39&#x27;</span>,
        metric_definitions=metric_definitions,
        hyperparameters = hyperparameters)`,wrap:!1}}),ze=new al({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/tutorials/sagemaker-sdk/training-sagemaker-sdk.md"}}),{c(){h=i("meta"),Ne=a(),$e=i("p"),Ae=a(),p(U.$$.fragment),Se=a(),p(g.$$.fragment),Re=a(),m=i("iframe"),Ee=a(),I=i("p"),I.innerHTML=rs,Xe=a(),f=i("ul"),f.innerHTML=os,Ve=a(),p(j.$$.fragment),Ye=a(),C=i("p"),C.innerHTML=ps,Qe=a(),b=i("p"),b.textContent=Ms,Fe=a(),_=i("ul"),_.innerHTML=Js,Le=a(),Z=i("p"),Z.innerHTML=cs,qe=a(),x=i("p"),x.innerHTML=ys,De=a(),p(B.$$.fragment),Pe=a(),v=i("p"),v.innerHTML=Ts,Ke=a(),k=i("p"),k.textContent=ms,Oe=a(),p(W.$$.fragment),et=a(),G=i("p"),G.innerHTML=ws,tt=a(),z=i("p"),z.innerHTML=ds,st=a(),$=i("p"),$.textContent=hs,lt=a(),p(H.$$.fragment),at=a(),p(N.$$.fragment),nt=a(),A=i("p"),A.innerHTML=us,it=a(),S=i("ul"),S.innerHTML=Us,rt=a(),R=i("p"),R.innerHTML=gs,ot=a(),p(E.$$.fragment),pt=a(),X=i("p"),X.innerHTML=Is,Mt=a(),V=i("p"),V.innerHTML=fs,Jt=a(),p(Y.$$.fragment),ct=a(),Q=i("p"),Q.innerHTML=js,yt=a(),F=i("p"),F.innerHTML=Cs,Tt=a(),p(L.$$.fragment),mt=a(),q=i("p"),q.innerHTML=bs,wt=a(),D=i("ol"),D.innerHTML=_s,dt=a(),P=i("p"),P.innerHTML=Zs,ht=a(),p(K.$$.fragment),ut=a(),O=i("p"),O.innerHTML=xs,Ut=a(),p(ee.$$.fragment),gt=a(),te=i("p"),te.innerHTML=Bs,It=a(),se=i("ul"),se.innerHTML=vs,ft=a(),le=i("p"),le.innerHTML=ks,jt=a(),p(ae.$$.fragment),Ct=a(),ne=i("p"),ne.innerHTML=Ws,bt=a(),p(ie.$$.fragment),_t=a(),p(re.$$.fragment),Zt=a(),oe=i("p"),oe.innerHTML=Gs,xt=a(),p(pe.$$.fragment),Bt=a(),p(Me.$$.fragment),vt=a(),Je=i("p"),Je.textContent=zs,kt=a(),p(ce.$$.fragment),Wt=a(),ye=i("p"),ye.innerHTML=$s,Gt=a(),p(Te.$$.fragment),zt=a(),me=i("p"),me.innerHTML=Hs,$t=a(),p(we.$$.fragment),Ht=a(),de=i("p"),de.innerHTML=Ns,Nt=a(),p(he.$$.fragment),At=a(),ue=i("p"),ue.innerHTML=As,St=a(),p(Ue.$$.fragment),Rt=a(),ge=i("p"),ge.innerHTML=Ss,Et=a(),Ie=i("p"),Ie.innerHTML=Rs,Xt=a(),fe=i("p"),fe.innerHTML=Es,Vt=a(),p(je.$$.fragment),Yt=a(),Ce=i("p"),Ce.innerHTML=Xs,Qt=a(),p(be.$$.fragment),Ft=a(),_e=i("p"),_e.innerHTML=Vs,Lt=a(),Ze=i("p"),Ze.innerHTML=Ys,qt=a(),xe=i("p"),xe.innerHTML=Qs,Dt=a(),p(Be.$$.fragment),Pt=a(),p(ve.$$.fragment),Kt=a(),ke=i("p"),ke.innerHTML=Fs,Ot=a(),p(We.$$.fragment),es=a(),Ge=i("p"),Ge.innerHTML=Ls,ts=a(),p(ze.$$.fragment),ss=a(),He=i("p"),this.h()},l(e){const t=tl("svelte-u9bgzb",document.head);h=r(t,"META",{name:!0,content:!0}),t.forEach(s),Ne=n(e),$e=r(e,"P",{}),as($e).forEach(s),Ae=n(e),M(U.$$.fragment,e),Se=n(e),M(g.$$.fragment,e),Re=n(e),m=r(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),as(m).forEach(s),Ee=n(e),I=r(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-zhmf4d"&&(I.innerHTML=rs),Xe=n(e),f=r(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-d99lsl"&&(f.innerHTML=os),Ve=n(e),M(j.$$.fragment,e),Ye=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-9mb7jq"&&(C.innerHTML=ps),Qe=n(e),b=r(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-14pz1nf"&&(b.textContent=Ms),Fe=n(e),_=r(e,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-nu9uzs"&&(_.innerHTML=Js),Le=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-10vylvb"&&(Z.innerHTML=cs),qe=n(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1q1gn32"&&(x.innerHTML=ys),De=n(e),M(B.$$.fragment,e),Pe=n(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-aqpf90"&&(v.innerHTML=Ts),Ke=n(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-1n86nit"&&(k.textContent=ms),Oe=n(e),M(W.$$.fragment,e),et=n(e),G=r(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-bmcgfj"&&(G.innerHTML=ws),tt=n(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-12o7543"&&(z.innerHTML=ds),st=n(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-qjt50s"&&($.textContent=hs),lt=n(e),M(H.$$.fragment,e),at=n(e),M(N.$$.fragment,e),nt=n(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1u3xeug"&&(A.innerHTML=us),it=n(e),S=r(e,"UL",{"data-svelte-h":!0}),o(S)!=="svelte-1owy1vd"&&(S.innerHTML=Us),rt=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1djq75m"&&(R.innerHTML=gs),ot=n(e),M(E.$$.fragment,e),pt=n(e),X=r(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-x146s4"&&(X.innerHTML=Is),Mt=n(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1v5ow9s"&&(V.innerHTML=fs),Jt=n(e),M(Y.$$.fragment,e),ct=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1iromrn"&&(Q.innerHTML=js),yt=n(e),F=r(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-17anpad"&&(F.innerHTML=Cs),Tt=n(e),M(L.$$.fragment,e),mt=n(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-w7qkuf"&&(q.innerHTML=bs),wt=n(e),D=r(e,"OL",{"data-svelte-h":!0}),o(D)!=="svelte-17zgu79"&&(D.innerHTML=_s),dt=n(e),P=r(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-129am2x"&&(P.innerHTML=Zs),ht=n(e),M(K.$$.fragment,e),ut=n(e),O=r(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1dwzx5g"&&(O.innerHTML=xs),Ut=n(e),M(ee.$$.fragment,e),gt=n(e),te=r(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-1rykzxi"&&(te.innerHTML=Bs),It=n(e),se=r(e,"UL",{"data-svelte-h":!0}),o(se)!=="svelte-n55cqy"&&(se.innerHTML=vs),ft=n(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1v0hjve"&&(le.innerHTML=ks),jt=n(e),M(ae.$$.fragment,e),Ct=n(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-pdxcpx"&&(ne.innerHTML=Ws),bt=n(e),M(ie.$$.fragment,e),_t=n(e),M(re.$$.fragment,e),Zt=n(e),oe=r(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-l786pq"&&(oe.innerHTML=Gs),xt=n(e),M(pe.$$.fragment,e),Bt=n(e),M(Me.$$.fragment,e),vt=n(e),Je=r(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-8hyjxi"&&(Je.textContent=zs),kt=n(e),M(ce.$$.fragment,e),Wt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-170csdj"&&(ye.innerHTML=$s),Gt=n(e),M(Te.$$.fragment,e),zt=n(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-oj7kbb"&&(me.innerHTML=Hs),$t=n(e),M(we.$$.fragment,e),Ht=n(e),de=r(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-o081ci"&&(de.innerHTML=Ns),Nt=n(e),M(he.$$.fragment,e),At=n(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-16yf61l"&&(ue.innerHTML=As),St=n(e),M(Ue.$$.fragment,e),Rt=n(e),ge=r(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1yk874x"&&(ge.innerHTML=Ss),Et=n(e),Ie=r(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-11t96qn"&&(Ie.innerHTML=Rs),Xt=n(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1d0l8c6"&&(fe.innerHTML=Es),Vt=n(e),M(je.$$.fragment,e),Yt=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1384417"&&(Ce.innerHTML=Xs),Qt=n(e),M(be.$$.fragment,e),Ft=n(e),_e=r(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1rsnmrd"&&(_e.innerHTML=Vs),Lt=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1mokhnw"&&(Ze.innerHTML=Ys),qt=n(e),xe=r(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-hhyk3e"&&(xe.innerHTML=Qs),Dt=n(e),M(Be.$$.fragment,e),Pt=n(e),M(ve.$$.fragment,e),Kt=n(e),ke=r(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-xro6kp"&&(ke.innerHTML=Fs),Ot=n(e),M(We.$$.fragment,e),es=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1y5r5uo"&&(Ge.innerHTML=Ls),ts=n(e),M(ze.$$.fragment,e),ss=n(e),He=r(e,"P",{}),as(He).forEach(s),this.h()},h(){u(h,"name","hf:doc:metadata"),u(h,"content",il),u(m,"width","700"),u(m,"height","394"),Ds(m.src,is="https://www.youtube.com/embed/ok3hetb42gU")||u(m,"src",is),u(m,"title","YouTube video player"),u(m,"frameborder","0"),u(m,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),m.allowFullscreen=""},m(e,t){sl(document.head,h),l(e,Ne,t),l(e,$e,t),l(e,Ae,t),J(U,e,t),l(e,Se,t),J(g,e,t),l(e,Re,t),l(e,m,t),l(e,Ee,t),l(e,I,t),l(e,Xe,t),l(e,f,t),l(e,Ve,t),J(j,e,t),l(e,Ye,t),l(e,C,t),l(e,Qe,t),l(e,b,t),l(e,Fe,t),l(e,_,t),l(e,Le,t),l(e,Z,t),l(e,qe,t),l(e,x,t),l(e,De,t),J(B,e,t),l(e,Pe,t),l(e,v,t),l(e,Ke,t),l(e,k,t),l(e,Oe,t),J(W,e,t),l(e,et,t),l(e,G,t),l(e,tt,t),l(e,z,t),l(e,st,t),l(e,$,t),l(e,lt,t),J(H,e,t),l(e,at,t),J(N,e,t),l(e,nt,t),l(e,A,t),l(e,it,t),l(e,S,t),l(e,rt,t),l(e,R,t),l(e,ot,t),J(E,e,t),l(e,pt,t),l(e,X,t),l(e,Mt,t),l(e,V,t),l(e,Jt,t),J(Y,e,t),l(e,ct,t),l(e,Q,t),l(e,yt,t),l(e,F,t),l(e,Tt,t),J(L,e,t),l(e,mt,t),l(e,q,t),l(e,wt,t),l(e,D,t),l(e,dt,t),l(e,P,t),l(e,ht,t),J(K,e,t),l(e,ut,t),l(e,O,t),l(e,Ut,t),J(ee,e,t),l(e,gt,t),l(e,te,t),l(e,It,t),l(e,se,t),l(e,ft,t),l(e,le,t),l(e,jt,t),J(ae,e,t),l(e,Ct,t),l(e,ne,t),l(e,bt,t),J(ie,e,t),l(e,_t,t),J(re,e,t),l(e,Zt,t),l(e,oe,t),l(e,xt,t),J(pe,e,t),l(e,Bt,t),J(Me,e,t),l(e,vt,t),l(e,Je,t),l(e,kt,t),J(ce,e,t),l(e,Wt,t),l(e,ye,t),l(e,Gt,t),J(Te,e,t),l(e,zt,t),l(e,me,t),l(e,$t,t),J(we,e,t),l(e,Ht,t),l(e,de,t),l(e,Nt,t),J(he,e,t),l(e,At,t),l(e,ue,t),l(e,St,t),J(Ue,e,t),l(e,Rt,t),l(e,ge,t),l(e,Et,t),l(e,Ie,t),l(e,Xt,t),l(e,fe,t),l(e,Vt,t),J(je,e,t),l(e,Yt,t),l(e,Ce,t),l(e,Qt,t),J(be,e,t),l(e,Ft,t),l(e,_e,t),l(e,Lt,t),l(e,Ze,t),l(e,qt,t),l(e,xe,t),l(e,Dt,t),J(Be,e,t),l(e,Pt,t),J(ve,e,t),l(e,Kt,t),l(e,ke,t),l(e,Ot,t),J(We,e,t),l(e,es,t),l(e,Ge,t),l(e,ts,t),J(ze,e,t),l(e,ss,t),l(e,He,t),ls=!0},p:Ps,i(e){ls||(c(U.$$.fragment,e),c(g.$$.fragment,e),c(j.$$.fragment,e),c(B.$$.fragment,e),c(W.$$.fragment,e),c(H.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(he.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(be.$$.fragment,e),c(Be.$$.fragment,e),c(ve.$$.fragment,e),c(We.$$.fragment,e),c(ze.$$.fragment,e),ls=!0)},o(e){y(U.$$.fragment,e),y(g.$$.fragment,e),y(j.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(H.$$.fragment,e),y(N.$$.fragment,e),y(E.$$.fragment,e),y(Y.$$.fragment,e),y(L.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(Te.$$.fragment,e),y(we.$$.fragment,e),y(he.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(be.$$.fragment,e),y(Be.$$.fragment,e),y(ve.$$.fragment,e),y(We.$$.fragment,e),y(ze.$$.fragment,e),ls=!1},d(e){e&&(s(Ne),s($e),s(Ae),s(Se),s(Re),s(m),s(Ee),s(I),s(Xe),s(f),s(Ve),s(Ye),s(C),s(Qe),s(b),s(Fe),s(_),s(Le),s(Z),s(qe),s(x),s(De),s(Pe),s(v),s(Ke),s(k),s(Oe),s(et),s(G),s(tt),s(z),s(st),s($),s(lt),s(at),s(nt),s(A),s(it),s(S),s(rt),s(R),s(ot),s(pt),s(X),s(Mt),s(V),s(Jt),s(ct),s(Q),s(yt),s(F),s(Tt),s(mt),s(q),s(wt),s(D),s(dt),s(P),s(ht),s(ut),s(O),s(Ut),s(gt),s(te),s(It),s(se),s(ft),s(le),s(jt),s(Ct),s(ne),s(bt),s(_t),s(Zt),s(oe),s(xt),s(Bt),s(vt),s(Je),s(kt),s(Wt),s(ye),s(Gt),s(zt),s(me),s($t),s(Ht),s(de),s(Nt),s(At),s(ue),s(St),s(Rt),s(ge),s(Et),s(Ie),s(Xt),s(fe),s(Vt),s(Yt),s(Ce),s(Qt),s(Ft),s(_e),s(Lt),s(Ze),s(qt),s(xe),s(Dt),s(Pt),s(Kt),s(ke),s(Ot),s(es),s(Ge),s(ts),s(ss),s(He)),s(h),T(U,e),T(g,e),T(j,e),T(B,e),T(W,e),T(H,e),T(N,e),T(E,e),T(Y,e),T(L,e),T(K,e),T(ee,e),T(ae,e),T(ie,e),T(re,e),T(pe,e),T(Me,e),T(ce,e),T(Te,e),T(we,e),T(he,e),T(Ue,e),T(je,e),T(be,e),T(Be,e),T(ve,e),T(We,e),T(ze,e)}}}const il='{"title":"Run training on Amazon SageMaker","local":"run-training-on-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Prepare a 🤗 Transformers fine-tuning script","local":"prepare-a--transformers-fine-tuning-script","sections":[],"depth":2},{"title":"Training Output Management","local":"training-output-management","sections":[],"depth":2},{"title":"Create a Hugging Face Estimator","local":"create-a-hugging-face-estimator","sections":[],"depth":2},{"title":"Execute training","local":"execute-training","sections":[],"depth":2},{"title":"Access trained model","local":"access-trained-model","sections":[],"depth":2},{"title":"Distributed training","local":"distributed-training","sections":[{"title":"Data parallelism","local":"data-parallelism","sections":[],"depth":3},{"title":"Model parallelism","local":"model-parallelism","sections":[],"depth":3}],"depth":2},{"title":"Spot instances","local":"spot-instances","sections":[],"depth":2},{"title":"Git repository","local":"git-repository","sections":[],"depth":2},{"title":"SageMaker metrics","local":"sagemaker-metrics","sections":[],"depth":2}],"depth":1}';function rl(ns){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends Os{constructor(h){super(),el(this,h,rl,nl,qs,{})}}export{cl as component};
